/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<asnStream.h>	2004-07-03,11:39

*/

#ifndef __2004_07_03__11_39__ASNSTREAM_H__
#define __2004_07_03__11_39__ASNSTREAM_H__


#include "H323Define.h"



typedef enum
{
	e_alignLeft,
	e_alignRight
} AlignDirection;






/*******************/
/* AsnStream Class */
#ifdef HS_CPLUSPLUS
class AsnStream
#else
typedef struct
#endif
{

#ifdef HS_CPLUSPLUS
public:
	AsnStream( unsigned pMaxSize, BOOL pAlign = TRUE );
	~AsnStream();

	HS_RESULT Reset();
	HS_RESULT Clear();
	HS_RESULT Aligning();
	unsigned  GetOffset();
	unsigned char *GetData();

	HS_RESULT PlusBit( unsigned pPlus );
	HS_RESULT BitEncoding( BOOL pBit );
	HS_RESULT BitsEncoding( unsigned char *pBits, unsigned pCounts, AlignDirection pDirection );
	HS_RESULT BytesEncoding( unsigned char *pBytes, unsigned pCounts );
	HS_RESULT BitDecoding( BOOL *pBit );
	HS_RESULT BitsDecoding( unsigned char *pBits, unsigned pCounts, AlignDirection pDirection );
	HS_RESULT BytesDecoding( unsigned char *pBytes, unsigned pCounts );
#endif

#ifdef HS_CPLUSPLUS
public:
#endif
	BOOL			isAlign;
	unsigned char	*datas;
	unsigned		size;
	unsigned		byteOffset;
	unsigned		bitOffset;

#ifdef HS_CPLUSPLUS
};
#else
} AsnStream;
#endif

#ifndef HS_CPLUSPLUS
HS_RESULT new_AsnStream( void *pObject, unsigned pMaxSize, BOOL pAlign );
HS_RESULT delete_AsnStream( void *pObject );

HS_RESULT AsnStream_Reset( void *pObject );
HS_RESULT AsnStream_Clear( void *pObject );
HS_RESULT AsnStream_Aligning( void *pObject );
unsigned  AsnStream_GetOffset( void *pObject );
unsigned char *AsnStream_GetData( void *pObject );

HS_RESULT AsnStream_PlusBit( void *pObject, unsigned pPlus );
HS_RESULT AsnStream_BitEncoding( void *pObject, BOOL pBit );
HS_RESULT AsnStream_BitsEncoding( void *pObject, unsigned char *pBits, unsigned pCounts, AlignDirection pDirection );
HS_RESULT AsnStream_BytesEncoding( void *pObject, unsigned char *pBytes, unsigned pCounts );
HS_RESULT AsnStream_BitDecoding( void *pObject, BOOL *pBit );
HS_RESULT AsnStream_BitsDecoding( void *pObject, unsigned char *pBits, unsigned pCounts, AlignDirection pDirection );
HS_RESULT AsnStream_BytesDecoding( void *pObject, unsigned char *pBytes, unsigned pCounts );
#endif

#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT AsnStream_Print( void *pObject );
#endif



HS_RESULT CheckBitsOverflow( AsnStream *pStrm, unsigned pAddingOffset );
HS_RESULT CheckBytesOverflow( AsnStream *pStrm, unsigned pAddingOffset );



#endif/*__2004_07_03__11_39__ASNSTREAM_H__*/




