/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<Q931Message.h>		2005-03-13,02:59

*/

#ifndef __2005_03_13__02_59__Q931MESSAGE_H__
#define __2005_03_13__02_59__Q931MESSAGE_H__

#include "H323Define.h"
#include "H225.h"


typedef enum
{
	e_Q931ElementType_BearerCapability		= 0x04,
	e_Q931ElementType_Cause					= 0x08,
	e_Q931ElementType_ExtendedFacility		= 0x0D,
	e_Q931ElementType_CallIdentity			= 0x10,
	e_Q931ElementType_CallState				= 0x14,
	e_Q931ElementType_ChannelIdentification	= 0x18,
	e_Q931ElementType_Facility				= 0x1C,
	e_Q931ElementType_ProgressIndicator		= 0x1E,
	e_Q931ElementType_NotificationIndicator	= 0x27,
	e_Q931ElementType_Display				= 0x28,
	e_Q931ElementType_DateTime				= 0x29,
	e_Q931ElementType_KeypadFacility		= 0x2C,
	e_Q931ElementType_Signal				= 0x34,
	e_Q931ElementType_ConnectedNumber		= 0x4C,
	e_Q931ElementType_ConnectedSubAddress	= 0x4D,
	e_Q931ElementType_CallingPartyNumber	= 0x6C,
	e_Q931ElementType_CallingPartySubaddress= 0x6D,
	e_Q931ElementType_CalledPartyNumber		= 0x70,
	e_Q931ElementType_CalledPartySubaddress	= 0x71,
	e_Q931ElementType_UserToUser			= 0x7E,
	e_Q931ElementType_SendingComplete		= 0xA1
} Q931ElementType;

typedef enum
{
      e_Q931MessageType_NationalEscape  = 0x00,
      e_Q931MessageType_Alerting        = 0x01,
      e_Q931MessageType_CallProceeding  = 0x02,
      e_Q931MessageType_Connect         = 0x07,
      e_Q931MessageType_ConnectAck      = 0x0f,
      e_Q931MessageType_Progress        = 0x03,
      e_Q931MessageType_Setup           = 0x05,
      e_Q931MessageType_SetupAck        = 0x0d,
      e_Q931MessageType_Resume          = 0x26,
      e_Q931MessageType_ResumeAck       = 0x2e,
      e_Q931MessageType_ResumeReject    = 0x22,
      e_Q931MessageType_Suspend         = 0x25,
      e_Q931MessageType_SuspendAck      = 0x2d,
      e_Q931MessageType_SuspendReject   = 0x21,
      e_Q931MessageType_UserInformation = 0x20,
      e_Q931MessageType_Disconnect      = 0x45,
      e_Q931MessageType_Release         = 0x4d,
      e_Q931MessageType_ReleaseComplete = 0x5a,
      e_Q931MessageType_Restart         = 0x46,
      e_Q931MessageType_RestartAck      = 0x4e,
      e_Q931MessageType_Segment         = 0x60,
      e_Q931MessageType_CongestionCtrl  = 0x79,
      e_Q931MessageType_Information     = 0x7b,
      e_Q931MessageType_Notify          = 0x6e,
      e_Q931MessageType_Status          = 0x7d,
      e_Q931MessageType_StatusEnquiry   = 0x75,
      e_Q931MessageType_Facility        = 0x62
} Q931MessageType;

typedef enum
{
	e_Q931CauseType_UnknownCauseIE               =  0,
	e_Q931CauseType_UnallocatedNumber            =  1,
	e_Q931CauseType_NoRouteToNetwork             =  2,
	e_Q931CauseType_NoRouteToDestination         =  3,
	e_Q931CauseType_SendSpecialTone              =  4,
	e_Q931CauseType_MisdialledTrunkPrefix        =  5,
	e_Q931CauseType_ChannelUnacceptable          =  6,
	e_Q931CauseType_NormalCallClearing           = 16,
	e_Q931CauseType_UserBusy                     = 17,
	e_Q931CauseType_NoResponse                   = 18,
	e_Q931CauseType_NoAnswer                     = 19,
	e_Q931CauseType_SubscriberAbsent             = 20,
	e_Q931CauseType_CallRejected                 = 21,
	e_Q931CauseType_NumberChanged                = 22,
	e_Q931CauseType_Redirection                  = 23,
	e_Q931CauseType_ExchangeRoutingError         = 25,
	e_Q931CauseType_NonSelectedUserClearing      = 26,
	e_Q931CauseType_DestinationOutOfOrder        = 27,
	e_Q931CauseType_InvalidNumberFormat          = 28,
	e_Q931CauseType_FacilityRejected             = 29,
	e_Q931CauseType_StatusEnquiryResponse        = 30,
	e_Q931CauseType_NormalUnspecified            = 31,
	e_Q931CauseType_NoCircuitChannelAvailable    = 34,
	e_Q931CauseType_NetworkOutOfOrder            = 38,
	e_Q931CauseType_TemporaryFailure             = 41,
	e_Q931CauseType_Congestion                   = 42,
	e_Q931CauseType_RequestedCircuitNotAvailable = 44,
	e_Q931CauseType_ResourceUnavailable          = 47,
	e_Q931CauseType_ServiceOptionNotAvailable    = 63,
	e_Q931CauseType_InvalidCallReference         = 81,
	e_Q931CauseType_ClearedRequestedCallIdentity = 86,
	e_Q931CauseType_IncompatibleDestination      = 88,
	e_Q931CauseType_IENonExistantOrNotImplemented= 99,
	e_Q931CauseType_TimerExpiry                  = 102,
	e_Q931CauseType_ProtocolErrorUnspecified     = 111,
	e_Q931CauseType_InterworkingUnspecified      = 127,
	e_Q931CauseType_ErrorInCauseIE               = 0x100
} Q931CauseType;


typedef struct
{
	Q931ElementType discriminator;
	unsigned char nlen;
	unsigned short ilen;
	unsigned char *value;
} Q931Element;
HS_RESULT new_Q931Element( void *pObject );
HS_RESULT delete_Q931Element( void *pObject );
HS_RESULT Q931Element_SetValue( void *pObject, Q931ElementType pType, unsigned char *pValue, unsigned pLen );
HS_RESULT Q931Element_SetValueInVisible( void *pObject, Q931ElementType pType, char *pValue );
HS_RESULT Q931Element_SetCauseValue( void *pObject, Q931CauseType pCause );
Q931CauseType Q931Element_GetCauseValue( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT Q931Element_Print( void *pObject );
#endif

typedef struct
{
	HS_UCHAR		wholeDiscriminator;
	BOOL			origin;
	HS_USHORT		crv;
	Q931MessageType	type;

	UnitOf	units;
	HS_UINT	size;
	ASNH225H323_UserInformation	*uuie;
} Q931Message;
HS_RESULT new_Q931Message( void *pObject );
HS_RESULT delete_Q931Message( void *pObject );
HS_RESULT Q931Message_Clear( void *pObject );

HS_RESULT Q931Message_AddElement( void *pObject, Q931Element *pElement );
HS_RESULT Q931Message_AddElementEx( Q931Message *pMsg, Q931ElementType pType, unsigned char *pValue, unsigned pLen );
HS_RESULT Q931Message_AddElementInVisible( Q931Message *pMsg, Q931ElementType pType, char *pValue );
HS_RESULT Q931Message_AddElementCauseValue( Q931Message *pMsg, Q931CauseType pCause );
Q931Element *Q931Message_GetElement( void *pObject, Q931ElementType pType );
HS_RESULT Q931Message_DeleteElement( void *pObject, Q931ElementType pType );

HS_RESULT Q931Message_Decode( void *pObject, AsnStream *pStrm );
HS_RESULT Q931Message_Encode( void *pObject, AsnStream *pStrm );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT Q931Message_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif


#endif/*__2005_03_13__02_59__Q931MESSAGE_H__*/


