/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<TcpConnect.h>		2005-03-27,16:19

*/

#ifndef __TCPCONNECT_H__
#define __TCPCONNECT_H__

#include "HSDefine.h"
#include "HSThread.h"





#if defined(_LINUX)
#define SOCKADDR struct sockaddr
#endif





/* TcpConnected : response of connection result.
*/
typedef struct
{
	SOCKET			mSocket;
	HS_TR_HANDLE	mHandle;
} TcpConnected;

TcpConnected *newm_TcpConnected(SOCKET pSocket,HS_TR_HANDLE pHandle);
HS_RESULT delete_TcpConnected(void *pObject);
HS_RESULT deletem_TcpConnected(void *pObject);





/* TcpConnect : request of connection
*/
typedef struct
_thread_struct
(
	HS_UINT		mIp;
	HS_USHORT	mPort;

	HS_QID			mTarget;
	HS_TR_HANDLE	mHandle;
) TcpConnect;

TcpConnect *newm_TcpConnect(HS_UINT pIp,HS_USHORT pPort,HS_QID pQid,HS_TR_HANDLE pHandle);
TcpConnect *newm_TcpConnectEx(HS_UCHAR *pIp,HS_USHORT pPort,HS_QID pQid,HS_TR_HANDLE pHandle);
TcpConnect *newm_TcpConnectEx1(char *pDest,HS_USHORT pPort,HS_QID pQid,HS_TR_HANDLE pHandle);
HS_RESULT delete_TcpConnect(void *pObject);
HS_RESULT deletem_TcpConnect(void *pObject);





/* API functions
*/
HS_RESULT HSConnect(HS_UINT pIp,HS_USHORT pPort,HS_QID pQid,HS_TR_HANDLE pHandle);
HS_RESULT HSConnectEx(HS_UCHAR *pIp,HS_USHORT pPort,HS_QID pQid,HS_TR_HANDLE pHandle);
HS_RESULT HSConnectEx1(char *pDest,HS_USHORT pPort,HS_QID pQid,HS_TR_HANDLE pHandle);
HS_RESULT HSConnectEx2(TcpConnect *pObj);





#endif/*__TCPCONNECT_H__*/
