/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<HSSocketList.c>	2006-04-28,16:46,hskim

*/

#include "HSSocketList.h"





/* HSSocketUnit member functions
*/
HS_RESULT new_HSSocketUnit(void *pObject,BOOL pIsTcp,HS_RESULT (*pCallbackFdEvent)(void*,void*))
{
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mId = HS_INVALID_SOCKET_ID;
	pObj->mIsTcp = pIsTcp;
	pObj->mIsConnected = FALSE;

	pObj->mSocket = INVALID_SOCKET;

	memset(&(pObj->mLocalIn),0,sizeof(pObj->mLocalIn));
	memset(&(pObj->mRemoteIn),0,sizeof(pObj->mRemoteIn));
	pObj->mLocalIn.sin_family = AF_MAX;
	pObj->mRemoteIn.sin_family = AF_MAX;

	pObj->CallbackFdEvent = pCallbackFdEvent;
	return HS_OK;
}


HSSocketUnit *newm_HSSocketUnit(BOOL pIsTcp,HS_RESULT (*pCallbackFdEvent)(void*,void*))
{
	HSSocketUnit *tResult = NULL;

	if( (tResult=(HSSocketUnit*)HSMalloc(sizeof(HSSocketUnit)))==NULL )
		return NULL;

	if( new_HSSocketUnit(tResult,pIsTcp,pCallbackFdEvent) != HS_OK )
	{
		HSFree(tResult);
		return NULL;
	}

	return tResult;
}


HS_RESULT delete_HSSocketUnit(void *pObject)
{
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mSocket != INVALID_SOCKET )
	{
		closesocket(pObj->mSocket);
		pObj->mSocket = INVALID_SOCKET;
	}

	memset(&(pObj->mLocalIn),0,sizeof(pObj->mLocalIn));
	memset(&(pObj->mRemoteIn),0,sizeof(pObj->mRemoteIn));
	pObj->mLocalIn.sin_family = AF_MAX;
	pObj->mRemoteIn.sin_family = AF_MAX;
	return HS_OK;
}


HS_RESULT deletem_HSSocketUnit(void *pObject)
{
	HS_RESULT tRet = HS_OK;
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( (tRet=delete_HSSocketUnit(pObj)) != HS_OK )
		return tRet;

	HSFree(pObj);
	return HS_OK;
}



HS_RESULT HSSocketUnit_Socket(void *pObject)
{
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mIsTcp==TRUE )
		pObj->mSocket = socket(AF_INET,SOCK_STREAM,0);
	else
		pObj->mSocket = socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP);

	if( pObj->mSocket==INVALID_SOCKET )
		return HS_ERR;
	return HS_OK;
}


HS_RESULT HSSocketUnit_Bind(void *pObject,HS_UINT pIp,HS_USHORT pPort)
{
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket==INVALID_SOCKET )
		return HS_ERR;

	pObj->mLocalIn.sin_family = AF_INET;
	pObj->mLocalIn.sin_addr.s_addr = pIp;
	pObj->mLocalIn.sin_port = pPort;

	if( bind(pObj->mSocket,(SOCKADDR*)&(pObj->mLocalIn),sizeof(pObj->mLocalIn)) != 0 )
		return HS_ERR;
	return HS_OK;
}


HS_RESULT HSSocketUnit_BindEx(void *pObject,HS_UCHAR *pIp,HS_USHORT pPort)
{
	HS_UINT tIp = 0;
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL || pIp==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket==INVALID_SOCKET )
		return HS_ERR;

	Uchar2Uint(&tIp,pIp);
	return HSSocketUnit_Bind(pObj,htonl(tIp),pPort);
}


HS_RESULT HSSocketUnit_Listen(void *pObject)
{
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mIsTcp==FALSE || pObj->mSocket==INVALID_SOCKET || pObj->mLocalIn.sin_family==AF_MAX )
		return HS_ERR;

	if( listen(pObj->mSocket,3) != 0 )
		return HS_ERR;
	return HS_OK;
}


HS_RESULT HSSocketUnit_Connect(void *pObject,HS_UINT pIp,HS_USHORT pPort,HS_QID pQid)
{
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket!=INVALID_SOCKET || pObj->mId==HS_INVALID_SOCKET_ID ) return HS_ERR;

	pObj->mRemoteIn.sin_family = AF_INET;
	pObj->mRemoteIn.sin_addr.s_addr = pIp;
	pObj->mRemoteIn.sin_port = pPort;

	return HSSocketUnit_ConnectEx(pObj,pQid);
}


HS_RESULT HSSocketUnit_ConnectEx(void *pObject,HS_QID pQid)
{
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket!=INVALID_SOCKET || pObj->mId==HS_INVALID_SOCKET_ID || pObj->mRemoteIn.sin_family==AF_MAX ) return HS_ERR;

	return HSConnect(pObj->mRemoteIn.sin_addr.s_addr,pObj->mRemoteIn.sin_port,pQid,pObj->mId);
}


HS_RESULT HSSocketUnit_ConnectBlock(void *pObject)
{
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket==INVALID_SOCKET ) return HS_ERR;

	if( connect(pObj->mSocket,(SOCKADDR*)&(pObj->mRemoteIn),sizeof(pObj->mRemoteIn)) != 0 )
		return HS_ERR;

	pObj->mIsConnected = TRUE;
	return HS_OK;
}


HSSocketUnit *HSSocketUnit_Accept(void *pObject,HS_RESULT (*pCallbackFdEvent)(void*,void*))
{
	HS_RESULT tRet = HS_OK;
	HSSocketUnit *tObj = NULL;
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL ) return NULL;
	if( pObj->mIsTcp==FALSE || pObj->mSocket==INVALID_SOCKET || pObj->mLocalIn.sin_family==AF_MAX )
		return NULL;

	if( (tObj=newm_HSSocketUnit(TRUE,pCallbackFdEvent))==NULL )
		return NULL;
	if( (HSSocketUnit_AcceptEx(pObj,tObj)) != HS_OK )
	{
		deletem_HSSocketUnit(tObj);
		return NULL;
	}

	tObj->mLocalIn = pObj->mLocalIn;
	return tObj;
}


HS_RESULT HSSocketUnit_AcceptEx(void *pObject,HSSocketUnit *pUnit)
{
	int tInLen;
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL || pUnit==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mIsTcp==FALSE || pObj->mSocket==INVALID_SOCKET || pObj->mLocalIn.sin_family==AF_MAX )
		return HS_ERR;

	tInLen = sizeof(pUnit->mRemoteIn);
	if( (pUnit->mSocket=accept(pObj->mSocket,(SOCKADDR*)&(pUnit->mRemoteIn),&tInLen))==INVALID_SOCKET )
		return HS_ERR;
	return HS_OK;
}


HS_RESULT HSSocketUnit_Receive(void *pObject,unsigned char *pData,int *pLen)
{
	int tLen;
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL || pData==NULL || pLen==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket==INVALID_SOCKET )
		return HS_ERR;

	if( (tLen=recv(pObj->mSocket,(char*)pData,*pLen,0)) > 0 )
	{
		*pLen = tLen;
		return HS_OK;
	}

	return HS_ERR;
}


HS_RESULT HSSocketUnit_ReceiveFrom(void *pObject,unsigned char *pData,int *pLen)
{
	int tLen, tInLen;
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL || pData==NULL || pLen==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket==INVALID_SOCKET )
		return HS_ERR;

	tInLen = sizeof(pObj->mRemoteIn);
	if( (tLen=recvfrom(pObj->mSocket,(char*)pData,*pLen,0,(SOCKADDR*)&(pObj->mRemoteIn),&tInLen)) > 0 )
	{
		*pLen = tLen;
		return HS_OK;
	}

	return HS_ERR;
}


HS_RESULT HSSocketUnit_ReceiveFromEx(void *pObject,unsigned char *pData,int *pLen,struct sockaddr_in *pRemoteIn)
{
	int tLen, tInLen;
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL || pData==NULL || pLen==NULL || pRemoteIn==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket==INVALID_SOCKET )
		return HS_ERR;

	tInLen = sizeof(*pRemoteIn);
	if( (tLen=recvfrom(pObj->mSocket,(char*)pData,*pLen,0,(SOCKADDR*)pRemoteIn,&tInLen)) > 0 )
	{
		*pLen = tLen;
		return HS_OK;
	}

	return HS_ERR;
}


HS_RESULT HSSocketUnit_Send(void *pObject,unsigned char *pData,int pLen)
{
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL || pData==NULL || pLen==0 ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket==INVALID_SOCKET )
		return HS_ERR;

	if( send(pObj->mSocket,pData,pLen,0) > 0 )
		return HS_OK;
	return HS_ERR;
}


HS_RESULT HSSocketUnit_SendTo(void *pObject,unsigned char *pData,int pLen)
{
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL || pData==NULL || pLen==0 ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket==INVALID_SOCKET )
		return HS_ERR;

	if( sendto(pObj->mSocket,pData,pLen,0,(SOCKADDR*)&(pObj->mRemoteIn),sizeof(pObj->mRemoteIn)) > 0 )
		return HS_OK;
	return HS_ERR;
}


HS_RESULT HSSocketUnit_SendToEx(void *pObject,unsigned char *pData,int pLen,struct sockaddr_in pRemoteIn)
{
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL || pData==NULL || pLen==0 ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket==INVALID_SOCKET )
		return HS_ERR;

	if( sendto(pObj->mSocket,pData,pLen,0,(SOCKADDR*)&(pRemoteIn),sizeof(pRemoteIn)) > 0 )
		return HS_OK;
	return HS_ERR;
}


HS_RESULT HSSocketUnit_SendToEx1(void *pObject,unsigned char *pData,int pLen,HS_UINT pIp,HS_USHORT pPort)
{
	struct sockaddr_in tAddrIn;
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL || pData==NULL || pLen==0 ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket==INVALID_SOCKET )
		return HS_ERR;

	memset(&tAddrIn,0,sizeof(tAddrIn));
	tAddrIn.sin_family = AF_INET;
	tAddrIn.sin_addr.s_addr = pIp;
	tAddrIn.sin_port = pPort;

	if( sendto(pObj->mSocket,pData,pLen,0,(SOCKADDR*)&(tAddrIn),sizeof(tAddrIn)) > 0 )
		return HS_OK;
	return HS_ERR;
}


HS_RESULT HSSocketUnit_SendToEx2(void *pObject,unsigned char *pData,int pLen,HS_UCHAR *pIp,HS_USHORT pPort)
{
	HS_UINT tIp = 0;
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL || pData==NULL || pLen==0 || pIp==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket==INVALID_SOCKET )
		return HS_ERR;

	Uchar2Uint(&tIp,pIp);
	return HSSocketUnit_SendToEx1(pObj,pData,pLen,htonl(tIp),pPort);
}


HS_RESULT HSSocketUnit_Close(void *pObject)
{
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket != INVALID_SOCKET )
	{
		closesocket(pObj->mSocket);
		pObj->mSocket = INVALID_SOCKET;
	}

	pObj->mIsConnected = FALSE;
	return HS_OK;
}


HS_RESULT HSSocketUnit_FdSet(void *pObject,fd_set *pFdSet,int *pFdMax)
{
	int tFdMax;
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL || pFdSet==NULL || pFdMax==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket==INVALID_SOCKET )
		return HS_ERR;

	FD_SET(pObj->mSocket,pFdSet);

	tFdMax = *pFdMax;
	if( pObj->mSocket > (SOCKET)tFdMax )
		tFdMax = pObj->mSocket;
	*pFdMax = tFdMax;

	return HS_OK;
}


HS_RESULT HSSocketUnit_FdIsSet(void *pObject,fd_set *pFdSet,void *pArg)
{
	HSSocketUnit *pObj = (HSSocketUnit*)pObject;

	if( pObj==NULL || pFdSet==NULL )
		return HS_ERR_NULL_PARAM;
	if( pObj->mSocket==INVALID_SOCKET )
		return HS_ERR_CONFLICT;
	if( pObj->CallbackFdEvent==NULL )
		return HS_OK;

	if( FD_ISSET(pObj->mSocket,pFdSet) )
		return pObj->CallbackFdEvent(pObj,pArg);
	return HS_OK;
}





/* HSSocketList member functions
*/
HS_RESULT new_HSSocketList(void *pObject)
{
	HSSocketList *pObj = (HSSocketList*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mSeed = 0;
	new_NoLockList(&(pObj->mList),delete_HSSocketUnit);
	return HS_OK;
}


HSSocketList *newm_HSSocketList()
{
	HSSocketList *tResult = NULL;

	if( (tResult=(HSSocketList*)HSMalloc(sizeof(HSSocketList)))==NULL )
		return NULL;

	if( new_HSSocketList(tResult) != HS_OK )
	{
		HSFree(tResult);
		return NULL;
	}

	return tResult;
}


HS_RESULT delete_HSSocketList(void *pObject)
{
	HSSocketList *pObj = (HSSocketList*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	delete_NoLockList(&(pObj->mList));
	return HS_OK;
}


HS_RESULT deletem_HSSocketList(void *pObject)
{
	HS_RESULT tRet = HS_OK;
	HSSocketList *pObj = (HSSocketList*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( (tRet=delete_HSSocketList(pObj)) != HS_OK )
		return tRet;

	HSFree(pObj);
	return HS_OK;
}


HS_RESULT HSSocketList_AttachData(void *pObject,HSSocketUnit *pUnit)
{
	HSSocketList *pObj = (HSSocketList*)pObject;

	if( pObj==NULL || pUnit==NULL ) return HS_ERR_NULL_PARAM;

	return NoLockList_AttachData(&(pObj->mList),pUnit);
}


HS_RESULT HSSocketList_MakeId(void *pObject,HSSocketUnit *pUnit)
{
	HSSocketList *pObj = (HSSocketList*)pObject;

	if( pObj==NULL || pUnit==NULL ) return HS_ERR_NULL_PARAM;

	pUnit->mId = pObj->mSeed++;

	if( pObj->mSeed==HS_SPECIAL_SOCKET_ID )
		pObj->mSeed = 0;
	return HS_OK;
}


HS_RESULT HSSocketList_FdSet(void *pObject,fd_set *pFdSet,int *pFdMax)
{
	HS_UINT i;
	ChainUnit *rounder = NULL;
	HSSocketList *pObj = (HSSocketList*)pObject;

	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mList.size == 0 ) return HS_OK;

	rounder = pObj->mList.units;
	for(i=0; i<pObj->mList.size; i++)
	{
		if( rounder==NULL ) return HS_ERR_CONFLICT;
		if( rounder->data==NULL ) return HS_ERR_CONFLICT;

		HSSocketUnit_FdSet(rounder->data,pFdSet,pFdMax);
		rounder = rounder->next;
	}

	return HS_OK;
}


HS_RESULT HSSocketList_FdIsSet(void *pObject,fd_set *pFdSet,void *pArg)
{
	HS_UINT i;
	ChainUnit *deleter = NULL;
	ChainUnit *rounder = NULL;
	HSSocketList *pObj = (HSSocketList*)pObject;

	if( pObj==NULL || pFdSet==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mList.size==0 ) return HS_OK;

	rounder = pObj->mList.units;
	for( i=0; i<pObj->mList.size; i++ )
	{
		if( rounder==NULL ) return HS_ERR_CONFLICT;
		if( rounder->data==NULL ) return HS_ERR_CONFLICT;

		if( HSSocketUnit_FdIsSet(rounder->data,pFdSet,pArg)==HS_NOK )
		{/*HS_NOK means that delete this chain unit*/
			deleter = rounder;
			rounder = (ChainUnit*)(deleter->next);
			NoLockList_DeleteChain(&(pObj->mList),deleter);
		}
		else
			rounder = (ChainUnit*)(rounder->next);
	}

	return HS_OK;
}


HS_RESULT HSSocketList_Select(void *pObject,fd_set *pFdSet,int pFdMax,HS_UINT pSec,HS_UINT pUSec)
{
#ifdef _VXWORKS
	int tSysClkRate;
#endif
	struct timeval tTimeVal;
	HSSocketList *pObj = (HSSocketList*)pObject;

	if( pObj==NULL || pFdSet==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mList.size==0 ) return HS_ERR;
#ifdef _VXWORKS
	tSysClkRate = sysClkRateGet();
	if( tSysClkRate>0 )
	{
		if( ((pSec*1000)+(pUSec/1000)) < (1000/tSysClkRate) )
			return HS_ERR_INVALID_PARAM;
	}
#endif

	tTimeVal.tv_sec = pSec;
	tTimeVal.tv_usec = pUSec;

	if( select(pFdMax,pFdSet,NULL,NULL,&tTimeVal) < 1 )
		return HS_ERR;
	return HS_OK;
}


HSSocketUnit *HSSocketList_GetUnitById(void *pObject,HS_UINT pId)
{
	HS_UINT i;
	ChainUnit *rounder = NULL;
	HSSocketUnit *tUnit = NULL;
	HSSocketList *pObj = (HSSocketList*)pObject;

	if( pObj==NULL ) return NULL;

	rounder = pObj->mList.units;
	for(i=0;i<pObj->mList.size;i++)
	{
		if( rounder==NULL ) return NULL;
		if( (tUnit=(HSSocketUnit*)(rounder->data))==NULL ) return NULL;

		if( tUnit->mId==pId )
			return tUnit;

		rounder = (ChainUnit*)(rounder->next);
	}

	return NULL;
}


ChainUnit *HSSocketList_GetChainByRemoteIp(void *pObject,HS_UINT pIp)
{
	HS_UINT i;
	ChainUnit *rounder = NULL;
	HSSocketUnit *tUnit = NULL;
	HSSocketList *pObj = (HSSocketList*)pObject;

	if( pObj==NULL ) return NULL;

	rounder = pObj->mList.units;
	for(i=0;i<pObj->mList.size;i++)
	{
		if( rounder==NULL ) return NULL;
		if( (tUnit=(HSSocketUnit*)(rounder->data))==NULL ) return NULL;

		if( tUnit->mRemoteIn.sin_family!=AF_MAX )
		{
			if( tUnit->mRemoteIn.sin_addr.s_addr==pIp )
				return rounder;
		}

		rounder = (ChainUnit*)(rounder->next);
	}

	return NULL;
}



