/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<HSPrint.c>		2006-03-17,21:58

*/

#include "HSPrint.h"





BOOL gStdOut = FALSE;
FILE *gFile = NULL;
SOCKET gSocket = HS_INVALID_SOCKET;
struct sockaddr_in gAddrIn;





HS_RESULT HSPrint(char *pLog, ...)
{
	va_list varg;
	char buffer[2048];

	if( pLog==NULL )
		return HS_ERR_NULL_PARAM;

	if( gStdOut==FALSE &&
		gFile==NULL &&
		gAddrIn.sin_family==AF_MAX )
		return HS_OK;

	buffer[0] = 0x00;
	va_start(varg, pLog);
	vsprintf(buffer, pLog, varg);
	va_end(varg);

	if( gStdOut==TRUE )
		printf(buffer);

	if( gFile != NULL )
		fprintf(gFile,buffer);

	if( gSocket != HS_INVALID_SOCKET && gAddrIn.sin_family != AF_MAX )
		sendto(gSocket,buffer,strlen(buffer),0,(struct sockaddr*)(&gAddrIn),sizeof(gAddrIn));

	return HS_OK;
}


HS_RESULT OpenHSPrint()
{
	gStdOut = FALSE;
	gFile = NULL;
	gAddrIn.sin_family = AF_MAX;

	if( gSocket != HS_INVALID_SOCKET )
		return HS_OK;

	if( (gSocket=socket(AF_INET,SOCK_DGRAM,0))==HS_INVALID_SOCKET )
		return HS_ERR;

	return HS_OK;
}


HS_RESULT CloseHSPrint()
{
	gStdOut = FALSE;
	gAddrIn.sin_family = AF_MAX;

	if( gFile != NULL )
		fclose(gFile);

	closesocket(gSocket);
	return HS_OK;
}


HS_RESULT HSPrintToStdOutOn()
{
	gStdOut = TRUE;
	return HS_OK;
}


HS_RESULT HSPrintToStdOutOff()
{
	gStdOut = FALSE;
	return HS_OK;
}


HS_RESULT HSPrintToFileOn(FILE *pFile)
{
	if( pFile==NULL ) return HS_ERR_NULL_PARAM;

	if( gFile != NULL ) fclose(gFile);
	gFile = pFile;

	return HS_OK;
}


HS_RESULT HSPrintToFileOff()
{
	if( gFile != NULL ) fclose(gFile);
	gFile = NULL;

	return HS_OK;
}


HS_RESULT HSPrintToNetworkOn(char *pTargetIp,HS_USHORT pTargetPort)
{
	if( pTargetIp==NULL || pTargetPort==HS_INVALID_TSAP_PORT )
		return HS_ERR_NULL_PARAM;

	memset(&gAddrIn,0,sizeof(gAddrIn));
	gAddrIn.sin_family = AF_INET;
	gAddrIn.sin_addr.s_addr = inet_addr(pTargetIp);
	gAddrIn.sin_port = htons(pTargetPort);

	return HS_OK;
}


HS_RESULT HSPrintToNetworkOff()
{
	gAddrIn.sin_family = AF_MAX;
	return HS_OK;
}


