<?php

	/**
	 * Alternative SQL editing window
	 *
	 * $Id: sqledit.php,v 1.30.2.2 2007/07/09 14:55:22 xzilla Exp $
	 */

	// Include application functions
	include_once('./libraries/lib.inc.php');

	$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';

  function sqlmsg($css, $str)
  {
    echo "<div class='$css'><table><tr><td>";
    echo $str;
		echo "</td></tr></table></div>";
  }


	/**
	 * Allow execution of arbitrary SQL statements on a database
	 */
	function doDefault() {
		global $data, $misc, $db, $_server_info;
		global $lang, $conf;
		
		if (!isset($_REQUEST['query'])) $_REQUEST['query'] = '';
		
		$misc->printHeader($lang['strsql']);
		
		// Bring to the front always
		echo "<body onload=\"window.focus();\">\n";
		$misc->printTabs($misc->getNavTabs('popup'), 'sql');
		
    echo "<div class='trail'><table><tr><td class='crumb'>";
		echo $_server_info['id']."&gt;".$db."&gt;".$_server_info['login'][$db]."&gt;".
      $_server_info['sqlbroker']."(".$_server_info['sqlport'].")";
    echo "</td></tr></table></div>";

    include_once "waiting.php";
    
		echo "<form action=\"sqledit.php\" method=\"post\">\n";
		echo "<input type=\"hidden\" name=\"action\" value=\"gosql\" />\n";
		echo $misc->form;
		echo $lang['sqlrule']."<br>\n";
		echo "<textarea style=\"width: 100%;\" rows=\"7\" cols=\"50\" name=\"query\">",
			htmlspecialchars($_REQUEST['query']), "</textarea>\n";
		
    //@@@TODO 1.2 paging
    //@@@TODO 1.2 encoding
    
		echo "<input type=\"submit\" value=\"{$lang['strrun']}\" onclick=\"show_waiting();\"/>\n";
		echo "<input type=\"reset\" value=\"{$lang['strreset']}\" />\n";
		echo "</form>\n";
		
		// Default focus
		$misc->setFocus('forms[0].query');
	}


	function doSql() {
		global $data, $misc, $db, $_server_info;
		global $lang, $conf;

    //@@@TODO 1.2 script file run
  	if (isset($_FILES['script']) && $_FILES['script']['size'] > 0)
  		$data->executeScript('script', 'sqlCallback');
  	else {
  	  $con = $misc->SQLLogin($err);
  	  if ($con === false) {
        sqlmsg('sqlerror', $err);
      }
      else {
        $qrys = split(";[[:space:]]*\n[[:space:]]*", $_POST['query']);
        foreach ($qrys as $idx => $qry) {
          $qry = trim($qry);
          if (strlen($qry) <=0 || $qry == ";") continue;
          $qtype = strtoupper(substr($qry,0,7));
        	if (function_exists('microtime')) {
        		list($usec, $sec) = explode(' ', microtime());
        		$start_time = ((float)$usec + (float)$sec);
        	}
        	else $start_time = null;
          
          error_reporting(0);
        	if (($rst = cubrid_execute($con, $qry, CUBRID_INCLUDE_OID))) {
          	// May as well try to time the query
          	if ($start_time !== null) {
          		list($usec, $sec) = explode(' ', microtime());
          		$end_time = ((float)$usec + (float)$sec);	
          		// Get duration in milliseconds, round to 3dp's	
          		$duration = number_format(($end_time - $start_time) * 1000, 3);
          	}
          	else $duration = null;
          
          	// Display duration if we know it
          	if ($duration !== null)
          		$timestr = "<br>\n".sprintf($lang['strruntime'], $duration);
          	else
          	  $timestr = "";

        	  if ($qtype == "SELECT ") {
        	    sqlmsg('sqlok', "<font color=brown>$qry</font><br>\n".cubrid_num_rows($rst).
        	      $lang['strrows'].$timestr);
        	    
        	    if (cubrid_num_rows($rst)>0) {
          	    echo "<table>\n<tr><th class=\"data\">.</th>";
          	    $colnames = cubrid_column_names($rst);
          	    $coltypes = cubrid_column_types($rst);
        				foreach ($coltypes as $k => $v) {
        					$pos = strpos($v, "(");
        					if ($pos !== false) {
        					  $coltypes[$k] = substr($v, 0, $pos);
        					}
        				}
        				foreach ($colnames as $k => $v) {
        					echo "<th class=\"data\">", $misc->printVal($v), "</th>";
        				}
        				echo "</tr>\n";
        				
        				$i = 1;		
        				while ($row=cubrid_fetch($rst, CUBRID_NUM)) {
        					$id = (($i % 2) == 0 ? '1' : '2');
        					echo "<tr><td class=\"data{$id}\" nowrap=\"nowrap\">", $i, "</td>\n";
        					$j = 0;
        					foreach ($row as $k => $v) {
        						echo "<td class=\"data{$id}\" nowrap=\"nowrap\">", 
        						      $misc->printVal($v, $coltypes[$j], array('null' => true)), "</td>";
        						$j++;
        					}							
        					echo "</tr>\n";
        					$i++;
        				}
        				echo "</table>\n";
        			  cubrid_close_request ($rst);	
        			}
        	  }
        	  else {
        	    sqlmsg('sqlok', "<font color=brown>$qry</font><br>\nOK.<br>\n".cubrid_affected_rows($rst).
        	      $lang['strrowsaff'].$timestr);
        	  }
            cubrid_commit($con);
          }
          else {
            sqlmsg('sqlerror', "<font color=brown>$qry</font><br>\n".cubrid_error_msg());
          }
          error_reporting(E_ALL);
        } // end foreach
        cubrid_disconnect($con);
      }
  	}
  	echo "<p>{$lang['strsqlexecuted']}</p>\n";
  	//@@@TODO 1.2 report
  }

	doDefault();
	if ($action == 'gosql') {
		doSql();
	}
	
	// Set the name of the window
	$misc->setWindowName('sqledit');
	$misc->printFooter();
?>
