<?php

error_reporting(E_ALL);

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/constants.'.$phpEx);
//include($phpbb_root_path . 'includes/pbtb.'.$phpEx);


# define our tables here
# individual *backs
define('PBTB_TABLE', $table_prefix.'pbtb');
# trackback contents ( all or summary )
define('PBTB_TEXT', $table_prefix.'pbtb_text');
# overall config
define('PBTB_CONFIG', $table_prefix.'pbtb_config');
# per-forum settings
define('PBTB_FORUMS', $table_prefix.'pbtb_forums');
# per-topic settings
define('PBTB_TOPICS', $table_prefix.'pbtb_topics');



$userdata = session_pagestart($user_ip, PAGE_INDEX, $session_length);
init_userprefs($userdata);
//
// Start auth check
//


if ($userdata['user_level'] != ADMIN)
{
	message_die(GENERAL_MESSAGE, $lang['Not_admin']);
}

########################
$pbtb_user_id = ( isset($HTTP_POST_VARS['pbtb_user_id']) ) ? $HTTP_POST_VARS['pbtb_user_id'] : 0;
$trackback_allow_receipt = ( isset($HTTP_POST_VARS['trackback_allow_receipt']) ) ? $HTTP_POST_VARS['trackback_allow_receipt'] : 0;
$trackback_allow_send = ( isset($HTTP_POST_VARS['trackback_allow_send']) ) ? $HTTP_POST_VARS['trackback_allow_send'] : 0;
$trackback_default = ( isset($HTTP_POST_VARS['trackback_default']) ) ? $HTTP_POST_VARS['trackback_default'] : 0;
$trackback_admin_only = ( isset($HTTP_POST_VARS['trackback_admin_only']) ) ? $HTTP_POST_VARS['trackback_admin_only'] : 0;
$trackback_check = ( isset($HTTP_POST_VARS['trackback_check']) ) ? $HTTP_POST_VARS['trackback_check'] : 0;


if (! isset($HTTP_POST_VARS['submit']) ) {
	echo "<form action='pbtb_install.php' method='post'>Trackback UserID: <input type='text' size='3' name='pbtb_user_id' value='0'><br>";
	echo "<p>Receive Trackbacks?<br> &nbsp&nbsp <input type='radio' name='trackback_allow_receipt' value='1'>YES&nbsp;&nbsp;<input type='radio' name='trackback_allow_receipt' value='0' checked='checked'>NO</p>";
	echo "<p>Send Trackbacks?<br> &nbsp&nbsp <input type='radio' name='trackback_allow_send' value='1'>YES&nbsp;&nbsp;<input type='radio' name='trackback_allow_send' value='0' checked='checked'>NO</p>";
	echo "<p>Allow Trackbacks by Default?<br> &nbsp&nbsp <input type='radio' name='trackback_default' value='1'>YES&nbsp;&nbsp;<input type='radio' name='trackback_default' value='0' checked='checked'>NO</p>";
	echo "<p>Trackbacks for Admins only?<br> &nbsp&nbsp <input type='radio' name='trackback_admin_only' value='1' checked='checked'>YES&nbsp;&nbsp;<input type='radio' name='trackback_admin_only' value='0'>NO</p>";
	echo "<p>Check Trackbacks?<br> &nbsp&nbsp <input type='radio' name='trackback_check' value='1' checked='checked'>YES&nbsp;&nbsp;<input type='radio' name='trackback_check' value='0'>NO</p>";
	echo "<p><input type='submit' name='submit' value='submit'></p></form>";
	die;
}

########################
if ($pbtb_user_id < 1) { die ("Trackback User ID is too low!"); }


echo "<p>Creating table " . PBTB_TABLE . " ... ";

$sql = "CREATE TABLE " . PBTB_TABLE . " (
	pbtb_id mediumint(8) unsigned NOT NULL auto_increment ,
	topic_id mediumint(8) unsigned NOT NULL default '0',
	post_id mediumint(8) unsigned NOT NULL default '0',
	pbtb_type tinyint(1) unsigned NOT NULL default '0',
	pbtb_title varchar(255) default NULL,
	pbtb_url varchar(255) default NULL,
	pbtb_blogname varchar(255) default NULL,
	PRIMARY KEY  (pbtb_id)
	) TYPE=MyISAM;";

if ( !$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Failed to create table " . PBTB_TABLE, "", __LINE__, __FILE__, $sql);
}
echo PBTB_TABLE . " created!</p>";


echo "<p>Creating table " . PBTB_TEXT . " ... ";

$sql = "CREATE TABLE " . PBTB_TEXT . " (
	pbtb_id mediumint(8) unsigned NOT NULL default '0',
	pbtb_text  text ,
	PRIMARY KEY  (pbtb_id)
	) TYPE=MyISAM;";

if ( !$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Failed to create table " . PBTB_TEXT, "", __LINE__, __FILE__, $sql);
}
echo PBTB_TEXT . " created!</p>";



echo "<p>Creating table " . PBTB_CONFIG . " ... ";

$sql = "CREATE TABLE " . PBTB_CONFIG . " (
	config_name varchar(255) NOT NULL default '',
	config_value varchar(255) NOT NULL default '',
	PRIMARY KEY  (config_name)
	) TYPE=MyISAM;";

if ( !$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Failed to create table " . PBTB_CONFIG, "", __LINE__, __FILE__, $sql);
}
echo PBTB_CONFIG . " created!</p>";

echo "Creating table " . PBTB_FORUMS . " ... ";

$sql = "CREATE TABLE " . PBTB_FORUMS . " (
	forum_id mediumint(8) unsigned NOT NULL default '0',
	pingback tinyint(1) unsigned NOT NULL default '0',
	trackback tinyint(1) unsigned NOT NULL default '0',
	PRIMARY KEY  (forum_id)
	) TYPE=MyISAM;";

if ( !$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Failed to create table " . PBTB_FORUMS, "", __LINE__, __FILE__, $sql);
}
echo PBTB_FORUMS . " created!</p>";

echo "<p>Creating table " . PBTB_TOPICS . " ... ";

$sql = "CREATE TABLE " . PBTB_TOPICS . " (
	topic_id mediumint(8) unsigned NOT NULL default '0',
	pingback tinyint(1) NOT NULL default '0',
	trackback tinyint(1) NOT NULL default '0',
	PRIMARY KEY  (topic_id)
	) TYPE=MyISAM;";
	
if ( !$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Failed to create table " . PBTB_TOPICS, "", __LINE__, __FILE__, $sql);
}
echo PBTB_TOPICS . " created!</p>";

echo "<p>Applying configuration ... <br>";
// pingback stuff -- incomplete, so disable it
echo "Inserting pingback defaults...";
$sql = "INSERT INTO " . PBTB_CONFIG . " (config_name, config_value) VALUES ('pingback_allow_receipt', '0')";
if ( !$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Failed to insert configuration ", "", __LINE__, __FILE__, $sql);
}

$sql = "INSERT INTO " . PBTB_CONFIG . " (config_name, config_value) VALUES ('pingback_allow_send', '0')";
if ( !$result = $db->sql_query($sql))
{
        message_die(GENERAL_ERROR, "Failed to insert configuration ", "", __LINE__, __FILE__, $sql);
}

$sql = "INSERT INTO " . PBTB_CONFIG . " (config_name, config_value) VALUES ('pingback_default', '0')";
if ( !$result = $db->sql_query($sql))
{
        message_die(GENERAL_ERROR, "Failed to insert configuration ", "", __LINE__, __FILE__, $sql);
}

$sql = "INSERT INTO " . PBTB_CONFIG . " (config_name, config_value) VALUES ('pingback_admin_only', '0')";
if ( !$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Failed to insert configuration ", "", __LINE__, __FILE__, $sql);
}
echo "Done.<br>";
// trackback configs
echo "Inserting Trackback defaults...<br>";
$sql = "INSERT INTO " . PBTB_CONFIG . " (config_name, config_value) VALUES ('trackback_allow_receipt', '" . $trackback_allow_receipt . "')";
if ( !$result = $db->sql_query($sql))
{
        message_die(GENERAL_ERROR, "Failed to insert configuration ", "", __LINE__, __FILE__, $sql);
}
echo "trackback_allow_receipt = $trackback_allow_receipt<br>";

$sql = "INSERT INTO " . PBTB_CONFIG . " (config_name, config_value) VALUES ('trackback_allow_send', '" . $trackback_allow_send ."')";
if ( !$result = $db->sql_query($sql))
{
        message_die(GENERAL_ERROR, "Failed to insert configuration ", "", __LINE__, __FILE__, $sql);
}
echo "trackback_allow_send = $trackback_allow_send<br>";

$sql = "INSERT INTO " . PBTB_CONFIG . " (config_name, config_value) VALUES ('pbtb_user_id', '" . $pbtb_user_id . "')";
if ( !$result = $db->sql_query($sql))
{
        message_die(GENERAL_ERROR, "Failed to insert configuration ", "", __LINE__, __FILE__, $sql);
}
echo "pbtb_user_id = $pbtb_user_id<br>";

$sql = "INSERT INTO " . PBTB_CONFIG . " (config_name, config_value) VALUES ('trackback_admin_only', '" . $trackback_admin_only . "')";
if ( !$result = $db->sql_query($sql))
{
        message_die(GENERAL_ERROR, "Failed to insert configuration ", "", __LINE__, __FILE__, $sql);
}
echo "trackback_admin_only = $trackback_admin_only<br>";

$sql = "INSERT INTO " . PBTB_CONFIG . " (config_name, config_value) VALUES ('trackback_default', '" . $trackback_default . "')";
if ( !$result = $db->sql_query($sql))
{
        message_die(GENERAL_ERROR, "Failed to insert configuration ", "", __LINE__, __FILE__, $sql);
}
echo "trackback_default = $trackback_default<br>";

$sql = "INSERT INTO " . PBTB_CONFIG . " (config_name, config_value) VALUES ('trackback_check', '" . $trackback_check . "')";
if ( !$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Failed to insert configuration ", "", __LINE__, __FILE__, $sql);
}
echo "trackback_check = $trackback_check<br>";
echo "Configuration created!</p>";

echo "<p>Please delete pbtb_install.php<br>Then log in to your Administration Panel and set per-forum permissions.</p>";

echo "<p><a href=\"./\">Go installed Sites</a></p>";


?>