<?php
/***************************************************************************
*                               pbtb.php
*                            -------------------
*   begin                : January 26, 2004
*   copyright            : (C) 2004 Scott Merrill
*   email                : skippy@skippy.net
*
*   $Id: pbtb.php
*
*
***************************************************************************/

/***************************************************************************
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License', or
*   ('at your option) any later version.
*
***************************************************************************/

if ( !defined('IN_PHPBB') )
{
	die("Hacking attempt");
}

///////////////////////////////////////////////////////////
// If you want to use different tables, configure them here
///////////////////////////////////////////////////////////
# define our tables here
# individual *backs
define('PBTB_TABLE', $table_prefix.'pbtb');
# trackback contents ( all or summary )
define('PBTB_TEXT', $table_prefix.'pbtb_text');
# overall config
define('PBTB_CONFIG', $table_prefix.'pbtb_config');
# per-forum settings
define('PBTB_FORUMS', $table_prefix.'pbtb_forums');
# per-topic settings
define('PBTB_TOPICS', $table_prefix.'pbtb_topics');

$sql = "SELECT * FROM " . PBTB_CONFIG;
if(!$result = $db->sql_query($sql))
{
	message_die(CRITICAL_ERROR, "Could not query config information in pbtb_config", "", __LINE__, __FILE__, $sql);
}
else
{
	while( $row = $db->sql_fetchrow($result) )
	{
		$pbtb[$row['config_name']] = $row['config_value'];
	}
}
///////////////////////////
// END CONFIGURATION ITEMS
///////////////////////////



/***************************************************************************
*
*   Functions
*
***************************************************************************/

function pbtb_trackback_url ( $post_id = 0 ) {
// given a trackback ID, return the originating URL
global $db, $board_config;
$sql = "SELECT pbtb_url FROM " . PBTB_TABLE . " WHERE post_id = '" . $post_id . "'";
if(!$result = $db->sql_query($sql))
{
        message_die(CRITICAL_ERROR, "Could not query config information in pbtb_config", "", __LINE__, __FILE__, $sql);
} else {
	$row = $db->sql_fetchrow($result);
	$url = $row['pbtb_url'];
}
return $url;
} // function pbtb_trackback_url


function pbtb_trackback_blogname ( $post_id = 0) {
// given a trackback ID, return the blog's name
global $db, $board_config;
$sql = "SELECT pbtb_blogname FROM " . PBTB_TABLE . " WHERE post_id = '" . $post_id . "'";
if(!$result = $db->sql_query($sql))
{
        message_die(CRITICAL_ERROR, "Could not query config information in pbtb_config", "", __LINE__, __FILE__, $sql);
} else {
	$row = $db->sql_fetchrow($result);
	$blogname = $row['pbtb_blogname'];
}
return $blogname;
} // function pbtb_trackback_blogname



/***************************************************************************
*
*   Functions -  use trackback.php
*
***************************************************************************/


///////////////////////////
// function trackback_response
// - send a trackback response, with optional message
///////////////////////////
function trackback_response ($code = '0', $message = '') {
	@header('Content-Type: text/xml');
	echo '<?xml version="1.0" encoding="iso-8859-1"?'.">\n";
	echo "<response>\n";
	echo "<error>$code</error>\n";
	if ($message != "")
	{
		echo "<message>$message</message>\n";
	}
	echo "</response>";
} // end trackback_response


//////////////////////////////
// function check_trackback
// - checks the specified trackback to see if it really exists
//////////////////////////////
function check_trackback ($tb_url = '') {
// split the supplied trackback URL into host and path
$url = parse_url($tb_url);

// This is too restrictive!
/*
// Is the sending site the same as what the trackback claims?
// note: I'm using $_SERVER[] instead of the older $HTTP_SERVER_VARS[]
if ( gethostbyname($temp_url['host']) != $_SERVER['REMOTE_ADDR']) {
	// no?  Most likely a spoof, so reject it and log it.
	trackback_response (1, "Spoofing not welcome here.");
	error_log ("PHPBB Trackback Spoof Attempt from " . $_SERVER['REMOTE_ADDR'], 0);
	die;
}
*/

// if another ports : ex) 8080 , 8888 
if ( isset ($url['port']) )
  $send_tb_port = $url['port'];
else
  $send_tb_port = 80;

// Let's make sure the trackback exists
$fp = fsockopen($url['host'], $send_tb_port , $errno, $errstr, 30);

// we'll use this variable later
$response = '';
if (!$fp) {
	// can't open the connection to the server?
	// throw an error
	return '0';
} else {
	// We opened a connection
	// Let's request the URL and see what happens
	$out = "HEAD " . $url['path'] . " HTTP/1.1\r\n";
	$out .= "Host: " . $url['host'] . "\r\n";
	$out .= "Connection: Close\r\n\r\n";

	fputs($fp, $out);
	while (!feof($fp)) {
		$response .= fgets($fp, 128);
	}
	fclose($fp);
}

if ((substr ($response, 9, 3)) != '200') {
	// response code NOT 200, so it's probably an error
	// yes, this is extreme.  Twiddle for your tastes.
	return '0';
} else {
// response code is 200, so it should be okay
    return '1';
}

} // end function check_trackback



/***************************************************************************
*
*   Functions -  use  posting.php
*
***************************************************************************/
//////////////////////////////
// function sendping
// - send ping to trackback
//////////////////////////////
function sendping( $send_tb_url , $send_tb_encoding , $pbtb_blogname , $pbtb_title , $pbtb_excerpt , $pbtb_url , $topic_id ) {

	global $board_config, $lang, $db, $phpbb_root_path, $phpEx;
	global $userdata, $user_ip;
// phpBB configs


// thanks!! soojung .

// trackback_url
// encoding
// blogid
// sendping function. encoding??

	// base option ? pbtb_config ?
	$base_encoding = "EUC-KR" ;

	//$encoding = "UTF-8" ;
	if( !$send_tb_encoding ) 	$encoding = "EUC-KR" ;
	else $encoding = $send_tb_encoding ;

	$tb_title = rawurlencode(iconv($base_encoding, $encoding, $pbtb_title ));

	$tb_excerpt = $pbtb_excerpt ;

	if (strlen ($tb_excerpt) > 255) {
	  $tb_excerpt = substring($tb_excerpt,252);
	}
	$tb_excerpt = rawurlencode(iconv($base_encoding, $encoding, $tb_excerpt));

	$tb_blogname = rawurlencode(iconv($base_encoding, $encoding, $pbtb_blogname));

	// query string : POST
	$query_string = "title=$tb_title&url=$pbtb_url&excerpt=$tb_excerpt&blog_name=$tb_blogname";
	$query_string = iconv( $base_encoding , $encoding, $query_string);

	$response = send_http ( $send_tb_url , $query_string ) ;

	// error message return ? 
	if( $response['error'] == 0 ) {
		$meta = '<meta http-equiv="refresh" content="3;url=' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=" . $topic_id) . '">';

		$message = $lang['SendPing_Send_OK'] . '<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=" . $topic_id) . '">', '</a>') . '<br />' ;
	}else{
		$meta = '<meta http-equiv="refresh" content="5;url=' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=" . $topic_id) . '">';

		$message = $lang['SendPing_Send_ERR'] . ':' . $response['message'] . '<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=" . $topic_id) . '">', '</a>') . '<br />' ;
	}

	return array($meta , $message) ;

} // end func.


function send_http ( $send_tb_url , $query_string ) {

	$tb_url = parse_url($send_tb_url);
	if (isset ($tb_url['port']))
	  $tb_port = $tb_url['port'];
	else
	  $tb_port = 80;

	$http_request  = 'POST '.$send_tb_url." HTTP/1.0\r\n";
	$http_request .= 'Content-Type: application/x-www-form-urlencoded'."\r\n";
	$http_request .= 'Content-Length: '.strlen($query_string)."\r\n\r\n";
	$http_request .= $query_string;

	$response = array();
	if (!($fp = fsockopen($tb_url['host'], $tb_port))) {
	  // Cannot open trackback url
	  $response['error'] = 1;
	  $response['message'] = "Cannot connect to host \"".$tb_url['host']."\"";
	  return $response;
	} 

	if (!fputs($fp, $http_request)) {
	  echo "cannot send trackback ping<br />\n";
	}

	$line = "";
	while (!feof ($fp)) {
	  $line .= fgets ($fp, 1024);
	}

	// error
	if (ereg("<error>[^<0-9]*([0-9]*)[^<0-9]*</error>", $line, $regs)) {
	  $response['error'] = $regs[1];
	  if ($response == 0 && ereg("<message>([<]*)</message>", $line, $regs)) {
		$response['message'] = $regs[1];
	  }
	}

	fclose ($fp);

	return $response ;

}


/***************************************************************************
*
*   Functions -  get soojung project : http://soojung.kldp.net , libs/util.php
*
***************************************************************************/

function br2nl( $data ) {
  return preg_replace( '!<br.*>!iU', "", $data );
}

function pre_nl2br($string) {
  $s = $string;
  $pos = strpos($s, "<pre");
  if ($pos === false) {
    return nl2br($s);
  }

  $text = "";
  while (($pos = @strpos($s, "<pre")) !== FALSE) {
    $text .= nl2br(trim(substr($s, 0, $pos)));

    $s = substr($s, $pos);
    $endpos = strpos($s, "</pre>") + strlen("</pre>");

    $text .= substr($s, 0, $endpos);
    $s = substr($s, $endpos);
  }
  $text .= nl2br(trim($s));
  return $text;
}

function cmp_base_filename($a, $b) {
  $filename1 = basename($a);
  if ($filename1[0] == '.') {
    $filename1 = substr($filename1, 1);
  }
  $filename2 = basename($b);
  if ($filename2[0] == '.') {
    $filename2 = substr($filename2, 1);
  }
  return ($filename1 < $filename2) ? 1 : -1;
}

function rmdirr($dirname)
{
  if (file_exists($dirname) == false) {
    return 0;
  }

  if (is_file($dirname)) {
    return unlink($dirname);
  }
  
  $dir = dir($dirname);
  while (false !== $entry = $dir->read()) {
    if ($entry == '.' || $entry == '..') {
      continue;
    }

    if (is_dir("$dirname/$entry")) {
      rmdirr("$dirname/$entry");
    } else {
      unlink("$dirname/$entry");
    }
  }

  $dir->close();
  return rmdir($dirname);
}

/** Balances Tags of string using a modified stack.
 * @param text      Text to be balanced
 * @return          Returns balanced text
 * @notes           
 * import from Wordpress
 * add balance quot
 */
function balanceTags($text, $is_comment = 0) {
  /*	
  if (get_settings('use_balanceTags') == 0) {
    return $text;
  }
  */
  $tagstack = array(); 
  $stacksize = 0; 
  $tagqueue = ''; 
  $newtext = '';

# WP bug fix for comments - in case you REALLY meant to type '< !--'
  $text = str_replace('< !--', '<    !--', $text);
# WP bug fix for LOVE <3 (and other situations with '<' before a number)
  $text = preg_replace('#<([0-9]{1})#', '&lt;$1', $text);

  // close &quot; which isn't closed in MARKUP
  $text = ereg_replace("<([^=]*)=\"([^>\"]*)>", "<\\1=\"\\2\">", $text);
  // match MARKUP tag, $regex[1] is tagname.

  while (preg_match("/<(\/?\w*)\s*([^>]*)>/",$text,$regex)) {
    $newtext = $newtext . $tagqueue;

    $i = strpos($text,$regex[0]);
    $l = strlen($tagqueue) + strlen($regex[0]);

    // clear the shifter
    $tagqueue = '';
    // Pop or Push
    if ($regex[1][0] == "/") { // End Tag
      $tag = strtolower(substr($regex[1],1));
      // if too many closing tags
      if($stacksize <= 0) { 
	$tag = '';
	//or close to be safe $tag = '/' . $tag;
      }
      // if stacktop value = tag close value then pop
      else if ($tagstack[$stacksize - 1] == $tag) { // found closing tag
	$tag = '</' . $tag . '>'; // Close Tag
	// Pop
	array_pop ($tagstack);
	$stacksize--;
      } else { // closing tag not at top, search for it
	for ($j=$stacksize-1;$j>=0;$j--) {
	  if ($tagstack[$j] == $tag) {
	    // add tag to tagqueue
	    for ($k=$stacksize-1;$k>=$j;$k--){
	      $tagqueue .= '</' . array_pop ($tagstack) . '>';
	      $stacksize--;
	    }
	    break;
	  }
	}
	$tag = '';
      }
    } else { // Begin Tag
      $tag = strtolower($regex[1]);

      // Tag Cleaning

      // Push if not img or br or hr
      if($tag != 'br' && $tag != 'img' && $tag != 'hr' ) {
	$stacksize = array_push ($tagstack, $tag);
      }

      // Attributes
      // $attributes = $regex[2];
      $attributes = $regex[2];
      if($attributes) {
	$attributes = ' '.$attributes;
      }
      $tag = '<'.$tag.$attributes.'>';
    }
    $newtext .= substr($text,0,$i) . $tag;
    $text = substr($text,$i+$l);
  }  

  // Clear Tag Queue
  $newtext = $newtext . $tagqueue;

  // Add Remaining text
  $newtext .= $text;

  // Empty Stack
  while($x = array_pop($tagstack)) {
    $newtext = $newtext . '</' . $x . '>'; // Add remaining tags to close      
  }

  // WP fix for the bug with HTML comments
  $newtext = str_replace("< !--","<!--",$newtext);
  $newtext = str_replace("<    !--","< !--",$newtext);

  return $newtext;
}

function trim_slash($str) {
  return trim($str, "/");
}

/** convert any encoding string to utf8 string
 * @param string input string of unkown encoding
 * @return utf8 converted string or FALSE on failure.
 */

function convert_to_utf8 ($string) {
  $result = "";
  if (($result = iconv("UTF-8", "UTF-8", $string)) != FALSE) {
    return $result;
  } else if (($result = iconv("CP949", "UTF-8", $string)) != FALSE) {
    return $result;
  }
  return FALSE;
}

/** The function which matchs with regex query. This function using 
 *  ereg to match query string.
 */

function detect_encoding ($string) {
  if (iconv("UTF-8", "UTF-8", $string) != FALSE) {
    return "UTF-8";
  } else if (iconv("CP949", "UTF-8", $string) != FALSE) {
    return "CP949";
  }
  return FALSE;
}

function isutf8($str){
  $i=0;
  $len = strlen($str);
  for ($i=0;$i< $len;$i++) {
    $sbit = ord(substr($str,$i,1));
    if ($sbit < 128) {
    } else if($sbit > 191 && $sbit < 224) {
      $i++;
    } else if($sbit > 223 && $sbit < 240) {
      $i+=2;
    } else if($sbit > 239 && $sbit < 248) {
      $i+=3;
    } else {
      return 0;
    }
  }
  return 1;
}

function substring($str, $len){
  if(strlen($str)>$len) {
    if(!isutf8($str)) {
      $str = substr($str,0,$len) . "...";
    } else {
      $str = cut_utf8($str,$len) . "...";
    }
  }
  return $str;
}

function cut_utf8($str, $len) {
  if(strlen($str) <= $len) {
    return $str;
  }

  $str = substr($str, 0, $len);
  for($i=$len-1;$i>=0;$i--) {
    if(ord($str{$i}) >= 0xF0) {
      $next = 4;
      break;
    } elseif(ord($str{$i}) >= 0xE0) {
      $next = 3;
      break;
    } elseif(ord($str{$i}) >= 0xC0) {
      $next = 2;
      break;
    }
  }

  if(strlen($str) < $i+$next) {
    return substr($str, 0, $i);
  } else {
    return $str;
  }
}

function getFirstLine($str) {
  $array = split("\r\n", $str);
  return trim($array[0]);
}


?>
