<?php
/***************************************************************************
 *                              admin_pbtb.php
 *                            -------------------
 *   begin                : Saturday, Jan 24, 2004
 *   copyright            : (C) 2004 Scott Merrill
 *   email                : skippy@skippy.net
 *
 *   $Id: admin_pbtb.php,v 1.6 2005/01/29 05:30:31 offree Exp $
 *
 *   borrowed heavily from admin_board.php!
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['PBTB']['PBTB_General'] = $file . "?config=general";
	$module['PBTB']['PBTB_Forums'] = $file . "?config=forums";
	$module['PBTB']['PBTB_Topics'] = $file . "?config=topics";
	return;
}
// Let's set the root dir for phpBB
//
$phpbb_root_path = "./../";
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
include($phpbb_root_path . 'includes/functions_selects.'.$phpEx);
include($phpbb_root_path . 'includes/pbtb.'.$phpEx);

if( isset($HTTP_GET_VARS['config']) || isset($HTTP_POST_VARS['config']) )
{
	$config = ( isset($HTTP_GET_VARS['config']) ) ? $HTTP_GET_VARS['config'] : $HTTP_POST_VARS['config'];
} else {
	$config = "";
}
switch( $config )
{
	case "":
	case "general":
/////////////////////////////////////////////////////////////
// general config
////////////////////////////////////////////////////////////
//
// Pull all config data
//
$sql = "SELECT *
	FROM " . PBTB_CONFIG;
if(!$result = $db->sql_query($sql))
{
        message_die(CRITICAL_ERROR, "Could not query config information in admin_pbtb", "", __LINE__, __FILE__, $sql);
} else {
	while( $row = $db->sql_fetchrow($result) )
	{
		$config_name = $row['config_name'];
		$config_value = $row['config_value'];
		$default_config[$config_name] = $config_value;
		$new[$config_name] = ( isset($HTTP_POST_VARS[$config_name]) ) ? $HTTP_POST_VARS[$config_name] : $default_config[$config_name];
		if( isset($HTTP_POST_VARS['submit']) )
		{
			$sql = "UPDATE " . PBTB_CONFIG . " SET
			config_value = '" . str_replace("\'", "''", $new[$config_name]) . "'WHERE config_name = '$config_name'";
			if( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Failed to update general configuration for $config_name", "", __LINE__, __FILE__, $sql);
			}
		}
	}
	if( isset($HTTP_POST_VARS['submit']) )
	{
		$message = $lang['Config_updated'] . "<br /><br />" . sprintf($lang['Click_return_config'], "<a href=\"" . append_sid("admin_pbtb.$phpEx") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");

		message_die(GENERAL_MESSAGE, $message);
	}
}

$pb_rec_yes = ( $new['pingback_allow_receipt'] ) ? "checked=\"checked\"" : "";
$pb_rec_no = ( !$new['pingback_allow_receipt'] ) ? "checked=\"checked\"" : "";

$pb_send_yes = ( $new['pingback_allow_send'] ) ? "checked=\"checked\"" : "";
$pb_send_no = ( !$new['pingback_allow_send'] ) ? "checked=\"checked\"" : "";

$pb_default_yes = ( $new['pingback_default'] ) ? "checked=\"yes\"" : "";
$pb_default_no = ( !$new['pingback_default'] ) ? "checked=\"yes\"" : "";

$pb_admin_only_yes = ( $new['pingback_admin_only'] ) ? "checked=\"yes\"" : "";
$pb_admin_only_no = ( !$new['pingback_admin_only'] ) ? "checked=\"yes\"" : "";

$tb_rec_yes = ( $new['trackback_allow_receipt'] ) ? "checked=\"checked\"" : "";
$tb_rec_no = ( !$new['trackback_allow_receipt'] ) ? "checked=\"checked\"" : "";

$tb_send_yes = ( $new['trackback_allow_send'] ) ? "checked=\"checked\"" : "";
$tb_send_no = ( !$new['trackback_allow_send'] ) ? "checked=\"checked\"" : "";

$tb_default_yes = ( $new['trackback_default'] ) ? "checked=\"checked\"" : "";
$tb_default_no = ( !$new['trackback_default'] ) ? "checked=\"checked\"" : "";

$tb_admin_only_yes = ( $new['trackback_admin_only'] ) ? "checked=\"checked\"" : "";
$tb_admin_only_no = ( !$new['trackback_admin_only'] ) ? "checked=\"checked\"" : "";

$tb_check_yes = ( $new['trackback_check'] ) ? "checked=\"checked\"" : "";
$tb_check_no = ( !$new['trackback_check'] ) ? "checked=\"checked\"" : "";

$pbtb_user_id = $new['trackback_user_id'];

$hidden_fields = '<input type="hidden" name="config" value="'.$config.'" />';

$template->set_filenames(array(
        "body" => "admin/pbtb_config_body.tpl")
);

$template->assign_vars(array(
	"S_CONFIG_ACTION" => append_sid("admin_pbtb.$phpEx"),

	"L_YES" => $lang['Yes'],
	"L_NO" => $lang['No'],
	"L_PBTB_TITLE" => $lang['PBTB_Config'],
	"L_PBTB_EXPLAIN" => $lang['PBTB_General_Explain'],
	"L_PBTB_PINGBACK_SETTINGS" => $lang['PBTB_Pingback_settings'],
	"L_PBTB_TRACKBACK_SETTINGS" => $lang['PBTB_Trackback_settings'],
	"L_PBTB_OTHER_SETTINGS" => $lang['PBTB_Other_settings'],
	"L_PB_REC_ALLOW" => $lang['PBTB_pb_receive_allow'],
	"L_PB_REC_ALLOW_EXPLAIN" => $lang['PBTB_pb_receive_allow_explain'],
	"L_PB_SEND_ALLOW" => $lang['PBTB_pb_send_allow'],
	"L_PB_SEND_ALLOW_EXPLAIN" => $lang['PBTB_pb_send_allow_explain'],
	"L_PB_DEFAULT" => $lang['PBTB_pb_default'],
	"L_PB_DEFAULT_EXPLAIN" => $lang['PBTB_pb_default_explain'],
	"L_PB_ADMIN_ONLY" => $lang['PBTB_pb_admin_only'],
	"L_PB_ADMIN_ONLY_EXPLAIN" => $lang['PBTB_pb_admin_only_explain'],
	"L_TB_REC_ALLOW" => $lang['PBTB_tb_receive_allow'],
	"L_TB_REC_ALLOW_EXPLAIN" => $lang['PBTB_tb_receive_allow_explain'],
	"L_TB_SEND_ALLOW" => $lang['PBTB_tb_send_allow'],
	"L_TB_SEND_ALLOW_EXPLAIN" => $lang['PBTB_tb_send_allow_explain'],
	"L_TB_DEFAULT" => $lang['PBTB_tb_default'],
	"L_TB_DEFAULT_EXPLAIN" => $lang['PBTB_tb_default_explain'],
	"L_TB_ADMIN_ONLY" => $lang['PBTB_tb_admin_only'],
	"L_TB_ADMIN_ONLY_EXPLAIN" => $lang['PBTB_tb_admin_only_explain'],
	"L_TB_CHECK" => $lang['PBTB_tb_check'],
	"L_TB_CHECK_EXPLAIN" => $lang['PBTB_tb_check_explain'],
	"L_PBTB_USER_ID" => $lang['PBTB_user_id'],
	"L_PBTB_USER_ID_EXPLAIN" => $lang['PBTB_user_id_explain'],
	"L_SUBMIT" => $lang['Submit'],
	"L_RESET" => $lang['Reset'],

	"S_HIDDEN_FIELDS" => $hidden_fields,
	
	"PB_REC_ALLOW" => $new['pingback_allow_receipt'],
	"PB_SEND_ALLOW" => $new['pingback_allow_send'],
	"TB_REC_ALLOW" => $new['trackback_allow_receipt'],
	"TB_SEND_ALLOW" => $new['trackback_allow_send'],
	"PB_REC_YES" => $pb_rec_yes,
	"PB_REC_NO" => $pb_rec_no,
	"PB_SEND_YES" => $pb_send_yes,
	"PB_SEND_NO" => $pb_send_no,
	"PB_DEFAULT_YES" => $pb_default_yes,
	"PB_DEFAULT_NO" => $pb_default_no,
	"PB_ADMIN_ONLY_YES" => $pb_admin_only_yes,
	"PB_ADMIN_ONLY_NO" => $pb_admin_only_no,
	"TB_REC_YES" => $tb_rec_yes,
	"TB_REC_NO" => $tb_rec_no,
	"TB_SEND_YES" => $tb_send_yes,
	"TB_SEND_NO" => $tb_send_no,
	"TB_DEFAULT_YES" => $tb_default_yes,
	"TB_DEFAULT_NO" => $tb_default_no,
	"TB_ADMIN_ONLY_YES" => $tb_admin_only_yes,
	"TB_ADMIN_ONLY_NO" => $tb_admin_only_no,
	"TB_CHECK_YES" => $tb_check_yes,
	"TB_CHECK_NO" => $tb_check_no,
	"PBTB_USER_ID" => $new['pbtb_user_id'])
);

$template->pparse("body");
break;
////////////////////////////////////////////////////////////////
// end general config
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
// forums config
////////////////////////////////////////////////////////////////
case "forums":

if(  isset($HTTP_POST_VARS['submit']) )
{

	$total_forum_num = $_POST[total_forums] ;

	for( $fi=0; $fi < $total_forum_num ; $fi++ )
	{
		$c_forum_id_index = "forum_id" . $fi ;
		$c_forum_id = $_POST[$c_forum_id_index] ;

		$sql = 'SELECT * FROM ' . PBTB_FORUMS . ' where forum_id = ' . $c_forum_id . '' ;
		if(!$result = $db->sql_query($sql))
		{
			message_die(CRITICAL_ERROR, "Could not query config information in pbtb_forums", "", __LINE__, __FILE__, $sql);
		} else {
			if( $row = $db->sql_fetchrow($result) )
			{
				$forum_id = $row['forum_id'];
				$pingback = $row['pingback'];
				$trackback = $row['trackback'];
				$default_pingback[$forum_id] = $pingback;
				$default_trackback[$forum_id] = $trackback;
				$new_pingback[$forum_id] = ( isset($HTTP_POST_VARS["pingback$forum_id"]) ) ? $HTTP_POST_VARS["pingback$forum_id"] : $default_pingback[$forum_id];
				$new_trackback[$forum_id] = ( isset($HTTP_POST_VARS["trackback$forum_id"]) ) ? $HTTP_POST_VARS["trackback$forum_id"] : $default_trackback[$forum_id];
				if( isset($HTTP_POST_VARS['submit']) )
				{
					$sql = "UPDATE " . PBTB_FORUMS . " SET
					pingback = '" . $new_pingback[$forum_id] . "',
					trackback = '" . $new_trackback[$forum_id] . "'
					WHERE forum_id = '$forum_id'";
					if( !$db->sql_query($sql) )
					{
						message_die(GENERAL_ERROR, "Failed to update options for $forum_id", "", __LINE__, __FILE__, $sql);
					}
				}
			}
			else
			{

				$forum_id = $c_forum_id ;
				$new_pingback[$forum_id] = ( isset($HTTP_POST_VARS["pingback$forum_id"]) ) ? $HTTP_POST_VARS["pingback$forum_id"] : 0 ;
				$new_trackback[$forum_id] = ( isset($HTTP_POST_VARS["trackback$forum_id"]) ) ? $HTTP_POST_VARS["trackback$forum_id"] : 0 ;

				if( isset($HTTP_POST_VARS['submit']) )
				{
					$sql = "INSERT INTO " . PBTB_FORUMS . " SET
					pingback = '" . $new_pingback[$forum_id] . "' ,
					trackback = '" . $new_trackback[$forum_id] . "' ,
					forum_id = '$forum_id' ";
					if( !$db->sql_query($sql) )
					{
						message_die(GENERAL_ERROR, "Failed to insert options for $forum_id", "", __LINE__, __FILE__, $sql);
					}
				}

			}
		}

	}

	if( isset($HTTP_POST_VARS['submit']) )
	{
		$message = $lang['Config_updated'] . "<br /><br />" . sprintf($lang['Click_return_config'], "<a href=\"" . append_sid("admin_pbtb.$phpEx?config=$config") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");
		message_die(GENERAL_MESSAGE, $message);
	}


}
else
{

// initial value setting .
	$sql = 'SELECT * FROM ' . PBTB_FORUMS ;
	if(!$result = $db->sql_query($sql))
	{
		message_die(CRITICAL_ERROR, "Could not query config information in pbtb_forums", "", __LINE__, __FILE__, $sql);
	} else {
		while( $row = $db->sql_fetchrow($result) )
		{
			$forum_id = $row['forum_id'];
			$pingback = $row['pingback'];
			$trackback = $row['trackback'];
			$default_pingback[$forum_id] = $pingback;
			$default_trackback[$forum_id] = $trackback;

		}
	}

}

$sql = "SELECT cat_id, forum_order, forum_id, forum_name, forum_desc
	FROM " . FORUMS_TABLE . "
	ORDER BY cat_id, forum_order";
if(!$q_forums = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Could not query forums information", "", __LINE__, __FILE__, $sql);
}

if( $total_forums = $db->sql_numrows($q_forums) )
{
	$forum_rows = $db->sql_fetchrowset($q_forums);
}


$hidden_fields = '<input type="hidden" name="config" value="'.$config.'" /><input type="hidden" name="total_forums" value="'.$total_forums.'" />';

$template->set_filenames(array(
	"body" => "admin/pbtb_forums_body.tpl")
);

$template->assign_vars(array(
	'S_FORUM_ACTION' => append_sid("admin_pbtb.$phpEx"),
	'L_YES' => $lang['Yes'],
	'L_NO' => $lang['No'],
	'L_SUBMIT' => $lang['Submit'],
	'S_HIDDEN_FIELDS' => $hidden_fields,
	'L_PBTB_FORUMS' => $lang['PBTB_Forums'],
	'L_PBTB_FORUMS_EXPLAIN' => $lang['PBTB_Forums_Explain'],
	'L_PINGBACK' => $lang['PBTB_Pingback'],
	'L_TRACKBACK' => $lang['PBTB_Trackback'],
	'L_FORUM_NAME' => $lang['Forum_name'])
);

//
// Okay, let's build the index
//
for($j = 0; $j < $total_forums; $j++)
{
	$forum_id = $forum_rows[$j]['forum_id'];
	$pingback_allow_yes = ( $default_pingback[$forum_id] ) ? "checked=\"checked\"" : "";
	$pingback_allow_no = ( !$default_pingback[$forum_id] ) ? "checked=\"checked\"" : "";
	$trackback_allow_yes = ( $default_trackback[$forum_id] ) ? "checked=\"checked\"" : "";
	$trackback_allow_no = ( !$default_trackback[$forum_id] ) ? "checked=\"checked\"" : "";

	$template->assign_block_vars("forumrow", array(
	'FORUM_NAME' => $forum_rows[$j]['forum_name'],
	'FORUM_DESC' => $forum_rows[$j]['forum_desc'],
	'FORUM_ID' => $forum_rows[$j]['forum_id'],
	'FORUM_ID_SEQ' => $j ,
	'U_VIEWFORUM' => append_sid($phpbb_root_path."viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id"),
	'PINGBACK_ALLOW_YES' => $pingback_allow_yes,
	'PINGBACK_ALLOW_NO' => $pingback_allow_no,
	'TRACKBACK_ALLOW_YES' => $trackback_allow_yes,
	'TRACKBACK_ALLOW_NO' => $trackback_allow_no)
	);
} // for ... forums


$template->pparse("body");
break;
////////////////////////////////////////////////////////////////
// end forums config
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
// topics config
////////////////////////////////////////////////////////////////
case "topics":
$sql = 'SELECT * FROM ' . PBTB_TOPICS;
if(!$result = $db->sql_query($sql))
{
	message_die(CRITICAL_ERROR, "Could not query config information in pbtb_topics", "", __LINE__, __FILE__, $sql);
} else {
	while( $row = $db->sql_fetchrow($result) )
	{
		$forum_id = $row['topic_id'];
		$pingback = $row['pingback'];
		$trackback = $row['trackback'];
		$default_pingback[$topic_id] = $pingback;
		$default_trackback[$topic_id] = $trackback;
		$new_pingback[$topic_id] = ( isset($HTTP_POST_VARS["pingback$topic_id"]) ) ? $HTTP_POST_VARS["pingback$topic_id"] : $default_pingback[$topic_id];
		$new_trackback[$topic_id] = ( isset($HTTP_POST_VARS["trackback$topic_id"]) ) ? $HTTP_POST_VARS["trackback$topc_id"] : $default_trackback[$topic_id];
		if( isset($HTTP_POST_VARS['submit']) )
		{
			$sql = "UPDATE " . PBTB_TOPICS . " SET
			pingback = '" . $new_pingback[$topic_id] . "',
			trackback = '" . $new_trackback[$topic_id] . "'
			WHERE topic_id = '$topic_id'";
			if( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Failed to update options for $topic_id", "", __LINE__, __FILE__,$sql);
			}
		}
	}
	if( isset($HTTP_POST_VARS['submit']) )
	{
		$message = $lang['Config_updated'] . "<br /><br />" . sprintf($lang['Click_return_config'], "<a href=\"" . append_sid("admin_pbtb.$phpEx?config=$config") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");
		message_die(GENERAL_MESSAGE, $message);
	}
}
$hidden_fields = '<input type="hidden" name="config" value="'.$config.'" />';
$template->set_filenames(array(
	"body" => "admin/pbtb_topics_body.tpl")
);

$template->assign_vars(array(
	'S_TOPIC_ACTION' => append_sid("admin_pbtb.$phpEx"),
	'L_YES' => $lang['Yes'],
	'L_NO' => $lang['No'],
	'L_SUBMIT' => $lang['Submit'],
	'S_HIDDEN_FIELDS' => $hidden_fields,
	'L_PBTB_TOPICS' => $lang['PBTB_Topics'],
	'L_PBTB_TOPICS_EXPLAIN' => $lang['PBTB_Topics_Explain'],
	'L_PINGBACK' => $lang['PBTB_Pingback'],
	'L_TRACKBACK' => $lang['PBTB_Trackback'],
	'L_TOPIC_NAME' => $lang['Topic_name'])
);

$sql = "SELECT topic_id, forum_id, topic_title
	FROM " . TOPICS_TABLE . "
	ORDER BY topic_id DESC ";

if(!$q_topics = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Could not query topics information", "", __LINE__, __FILE__, $sql);
}

if( $total_topics = $db->sql_numrows($q_topics) )
{
	$topic_rows = $db->sql_fetchrowset($q_topics);
}

//
// Okay, let's build the index
//
for($j = 0; $j < $total_topics; $j++)
{
	$topic_id = $topic_rows[$j]['topic_id'];
	$pingback_allow_yes = ( $new_pingback[$topic_id] ) ? "checked=\"checked\"" : "";
	$pingback_allow_no = ( !$new_pingback[$topic_id] ) ? "checked=\"checked\"" : "";
	$trackback_allow_yes = ( $new_trackback[$topic_id] ) ? "checked=\"checked\"" : "";
	$trackback_allow_no = ( !$new_trackback[$topic_id] ) ? "checked=\"checked\"" : "";

	$template->assign_block_vars("topicrow", array(
	'TOPIC_TITLE' => $topic_rows[$j]['topic_title'],
	'TOPIC_ID' => $topic_rows[$j]['topic_id'],
	'U_VIEWTOPIC' => append_sid($phpbb_root_path."viewtopic.$phpEx?" . POST_TOPICS_URL . "=$topic_id"),
	'PINGBACK_ALLOW_YES' => $pingback_allow_yes,
	'PINGBACK_ALLOW_NO' => $pingback_allow_no,
	'TRACKBACK_ALLOW_YES' => $trackback_allow_yes,
	'TRACKBACK_ALLOW_NO' => $trackback_allow_no)
	);
} // for ... topics
$template->pparse("body");
break;
////////////////////////////////////////////////////////////////
// end topics config
////////////////////////////////////////////////////////////////
}

include('./page_footer_admin.'.$phpEx);

?>
