<?php
// trackback.php v 0.01
// copyright 2004 Scott Merrill (skippy @ skippy . net)
// trackback.php v 0.0.1.050109 by offree

$phpbb_root_path = './';

define ('IN_PHPBB', true);

if (!file_exists($phpbb_root_path . 'extension.inc'))
{
	// what ? 
	die ('<tt><b>phpBB Fetch All:</b>
	$phpbb_root_path is wrong and does not point to your forum.</tt>');
}

include_once($phpbb_root_path . 'extension.inc');
include_once($phpbb_root_path . 'common.' . $phpEx);
include_once($phpbb_root_path . 'includes/bbcode.' . $phpEx);

include_once($phpbb_root_path . 'mods/phpbb_fetch_all/common.' . $phpEx);
include_once($phpbb_root_path . 'mods/phpbb_fetch_all/editor.' . $phpEx);
include_once($phpbb_root_path . 'includes/pbtb.' . $phpEx);

///////////////////////////
// CONFIGURATION ITEMS
// these are pulled from includes/pbtb.php
// $pbtb['config_name'] = config_value
// $pbtb['pingback_allow_receipt']
// $pbtb['pingback_allow_send']
// $pbtb['trackback_allow_receipt']
// $pbtb['trackback_allow_send']
// $pbtb['pingback_default']
// $pbtb['pingback_admin_only']
// $pbtb['trackback_admin_only']
// $pbtb['trackback_default']
// $pbtb['trackback_check']
// $pbtb['pbtb_user_id']
// 
///////////////////////////




//////////////////////////////
// begin main program block
//////////////////////////////
// trackback is done by a POST

$pbtb_type = "1"; // it's a trackback
$request_array = 'HTTP_POST_VARS';

// choose one of the trackback URL formats below
// I personally prefer the ?tb= format

// *** 04-02-2004
// let's accept either format for trackbacks

// topic trackback
if ($HTTP_GET_VARS['tb']) {
	// TRACKBACK URL FORMAT OPTION 1
	// trackback URL format == http://www.example.com/trackback.php?tb=#
	// where # is the topic_id to trackback
	$topic_id = $HTTP_GET_VARS['tb'];

// forum trackback
}else if ($HTTP_GET_VARS['ftb']) {
	// TRACKBACK URL FORMAT OPTION 1
	// trackback URL format == http://www.example.com/trackback.php?ftb=#
	// where # is the topic_id to trackback
	$forum_id = $HTTP_GET_VARS['ftb'];

} else {
	// TRACKBACK URL FORMAT OPTION 2
	// trackback URL format == http://www.example.com/trackback.php/#
	// where # is the topic_id to trackback

	// trackback URL format == http://www.example.com/trackback.php/ftb/#
	// or # is forum_id 

	$uri_check_ex = explode('/', $HTTP_SERVER_VARS['REQUEST_URI']);

	// $PHP_SELF = trackback.php
	$uri_command = $uri_check_ex[count($uri_check_ex)-2] ;
	$uri_last_index_value = $uri_check_ex[count($uri_check_ex)-1] ;
	if( $uri_command == "trackback.php" )
		$topic_id = intval($uri_last_index_value);
	else if ( $uri_command == "ftb" ) 
		$forum_id = intval($uri_last_index_value);
}



$pbtb_url = $HTTP_POST_VARS['url'];
$pbtb_title = $HTTP_POST_VARS['title'];
$pbtb_excerpt = $HTTP_POST_VARS['excerpt'];
$pbtb_blogname = $HTTP_POST_VARS['blog_name'];

//////////////////////////////
// Sanity checking
//////////////////////////////

// is this topic locked?
$sql = "SELECT topic_status FROM " . TOPICS_TABLE . " WHERE topic_id=$topic_id";
if(!$result = $db->sql_query($sql))
{
	message_die(CRITICAL_ERROR, "Could not query config information in pbtb_config", "", __LINE__, __FILE__, $sql);
} else {
	$row = $db->sql_fetchrow($result);
	if ($row['topic_status'] == TOPIC_LOCKED)
	{
		trackback_response (1, "This topic is locked.");
		die;
	}
}

// is this a valid trackback?
// NOTE:  The official MovableType trackback spec only requires the url
// for our application, just a URL is insufficient.
if (empty($pbtb_title) || empty($pbtb_url) || empty($pbtb_blogname)) {
	trackback_response (1, "Not a valid trackback");
	exit;
}


// Are trackbacks enabled at all?
if ($pbtb['trackback_allow_receipt'] != '1')
{
	trackback_response (1, "Trackbacks not allowed here.");
	die;
}

// Are trackbacks enabled for this forum?
$sql = "SELECT trackback FROM " . PBTB_FORUMS . "," . TOPICS_TABLE . "
	WHERE " . TOPICS_TABLE . ".forum_id=" . PBTB_FORUMS . ".forum_id
	AND " . TOPICS_TABLE . ".topic_id='" . $topic_id . "'";
if(!$result = $db->sql_query($sql))
{
	message_die(CRITICAL_ERROR, "Could not query config information in pbtb_config", "", __LINE__, __FILE__, $sql);
} else {
	$row = $db->sql_fetchrow($result);
	$forum_trackback_allow = $row['trackback'];
}
if ( ($forum_trackback_allow != "1") && (! $pbtb['trackback_default']) )
// if there's no setting for this forum, check the overall default
{
	trackback_response (1, "Trackbacks not allowed in this forum.");
	die;
}

// Are trackbacks allowed on this topic?
$sql = "SELECT trackback from " . PBTB_TOPICS . " WHERE topic_id = '" . $topic_id . "'";
if(!$result = $db->sql_query($sql))
{
// 	message_die(CRITICAL_ERROR, "Could not query config information in pbtb_config", "", __LINE__, __FILE__, $sql);
// } else {
	$row = $db->sql_fetchrow($result);
	$topic_trackback_allow = $row['trackback'];
}
if ( ($topic_track_allow != "1") && (! $pbtb['trackback_default']) )
// if there's no setting for this topic, use the overall default
{
	trackback_response (1, "Trackbacks not allowed in this topic.");
	die;
}


// Security Checking
// Trackbacks are easily spoofed, and could clutter up your discussion.
if ( ( $pbtb['trackback_check'] ) && ( ! check_trackback($pbtb_url) ) ) {
	trackback_response (1, "Security check failed.");
	error_log ("PHPBB Trackback failed from " . $_SERVER['REMOTE_ADDR'] . ", sent " . $pbtb_url, 0);
	die;
}

$enable_encoding = 1 ;

if( $enable_encoding ) {
// base option ? pbtb_config ?
$base_encoding = "EUC-KR" ;

if( detect_encoding ($pbtb_title) == "UTF-8" )  $encoding = "UTF-8" ;
else  $encoding = "EUC-KR" ;
// encoding check !!
$pbtb_title = iconv( $encoding, $base_encoding, $pbtb_title ) ;

if( detect_encoding ($pbtb_excerpt) == "UTF-8" )  $encoding = "UTF-8" ;
else  $encoding = "EUC-KR" ;
$pbtb_excerpt = iconv( $encoding, $base_encoding, $pbtb_excerpt ) ;

if( detect_encoding ($pbtb_blogname) == "UTF-8" )  $encoding = "UTF-8" ;
else  $encoding = "EUC-KR" ;
$pbtb_blogname = iconv( $encoding, $base_encoding, $pbtb_blogname ) ;

}


$pbtb_url = addslashes($pbtb_url);

$pbtb_title = strip_tags($pbtb_title);
$pbtb_title = ( strlen($pbtb_title) > 255 ) ? substring($pbtb_title, 0, 252).'...' : $pbtb_title;

$pbtb_excerpt = strip_tags($pbtb_excerpt);
// I want the full excerpt for now
//$excerpt = (strlen($excerpt) > 255) ? substr($excerpt, 0, 252).'...' : $excerpt;

$pbtb_blogname = htmlspecialchars($pbtb_blogname);
$pbtb_blogname = (strlen($pbtb_blogname) > 255) ? substring($pbtb_blogname, 0, 252).'...' : $pbtb_blogname;


// update is necessary ? by offree
// Is this a new trackback, or an update?
/* disable by offree 
$sql = "SELECT pbtb_id from " . PBTB_TABLE . " WHERE pbtb_url='";
$sql .= $pbtb_url . "' AND topic_id=$topic_id";
if(!$result = $db->sql_query($sql))
{
	 message_die(CRITICAL_ERROR, "Could not query trackback information in pbtb", "", __LINE__, __FILE__, $sql);
} 
else
{
	$row = $db->sql_fetchrow($result);
	$pbtb_result = $row['pbtb_id'];
}

if ( $pbtb_result )
{
	// changing - no editable ?
	//  phpbb_fetch_all / editor.php -
	// this URL has trackbacked this topic already; update the record
	phpbb_edit_post($pbtb_result, $pbtb_title, $pbtb_excerpt);
}
...
*/

// new forum trackback

##     $result = phpbb_insert_post(1, 1, 'Test', 'Hello World');             ##
##     echo 'Topic ID: ' . $result[0];                                       ##
##     echo 'Post ID:'   . $result[1];                                       ##
/* new post - if trackback forum , 
function phpbb_insert_post($forum_id = null, $username = null,
	 $subject = null, $message = null)
*/

if( $forum_id ) 
{

	// if new trackback forum , new post.
	$pbtb_result = phpbb_insert_post($forum_id, $pbtb['pbtb_user_id'], $pbtb_title, $pbtb_excerpt);

	$topic_id = $pbtb_result[0] ;
	$post_id = $pbtb_result[1] ;

}

// topic_id check
if( $topic_id ) 
{
	// changing - no reply mode. 
	// return post_id -> phpbb_fetch_all / editor.php
	// this is a new URL, so insert it

/* disable by offree
	$pbtb_id = phpbb_insert_reply($topic_id, $pbtb['pbtb_user_id'], $pbtb_title, $pbtb_excerpt);

	if (!$pbtb_id) {
		trackback_response (1, "Error");
		die ("submission error");
	}

	{
		message_die(GENERAL_ERROR, 'Error in posting', '', __LINE__, __FILE__, $sql);
	}

*/

//		$post_id = $db->sql_nextid();

	$sql = 'INSERT INTO ' . PBTB_TABLE;
	$sql .= ' (	topic_id, 
		post_id, 
		pbtb_type,
		pbtb_title, 
		pbtb_url, 
		pbtb_blogname)
		VALUES (';
	$sql .= "'" . $topic_id . "', ";
	$sql .= "'" . $post_id . "', ";
	$sql .= "'" . $pbtb_type . "', ";
	$sql .= "'" . $pbtb_title . "', ";
	$sql .= "'" . $pbtb_url . "', ";
	$sql .= "'" . $pbtb_blogname . "');";
	$pbtb_result = $db->sql_query($sql);
	if (!$pbtb_result) {
		trackback_response (1, $pbtb_result);
		die ("pbtb insertion error");
	}

	$pbtb_id = $db->sql_nextid();


	// insert pbtb text
	$sql = 'INSERT INTO ' . PBTB_TEXT;
	$sql .= ' (pbtb_id, 
		pbtb_text) 
		VALUES (';
	$sql .= "'" . $pbtb_id . "', ";
	$sql .= "'" . $pbtb_excerpt . "');";
	$pbtb_result = $db->sql_query($sql);
	if (!$pbtb_result) {
		trackback_response (1, $pbtb_result);
		die ("pbtb_text insertion error");
	}


} // if...else new trackback checking
trackback_response (0);



?>