<?php

/*****************************************************************************
 * EasyMOD Version Changer - admin_emversionchanger.php
 * Version 1.3
 * Copyright 2003-2004 Gordon P. Hemsley (GPHemsley)
 * 
 * Written for EasyMOD, Copyright 2002-2004 Craig Nuttall (Nuttzy99)
 *****************************************************************************/

// Show entry in Admin Panel
if( !( empty( $setmodules ) ) )
{
	$file = basename( __FILE__ );
	$module['Modifications']['EM_Version_Changer'] = "$file";

	return;
}

define( 'IN_PHPBB', TRUE );

$phpbb_root_path = './../';

require( $phpbb_root_path . 'extension.inc' );
require( $phpbb_root_path . 'admin/pagestart.' . $phpEx );

$lang_file = $phpbb_root_path . 'language/lang_english/lang_easymod.' . $phpEx;
$function_file = $phpbb_root_path . 'admin/em_includes/em_functions.' . $phpEx;

if( @file_exists( $lang_file ) && @file_exists( $function_file ) )
{
	$use_EM_files = TRUE;

	include( $lang_file );
	require( $function_file );

	$password = ( isset( $HTTP_POST_VARS['password'] ) ) ? $HTTP_POST_VARS['password'] : NULL;

	if( md5( $password ) == get_em_pw() )
	{
		$get_password = FALSE;
	}
	else
	{
		$get_password = TRUE;

		if( isset( $HTTP_POST_VARS['password'] ) )
		{
			$pass_message = '<b>' . $lang['EM_err_pw_fail'] . '</b><br />' ;
		}
	}
}
else
{
	$use_EM_files = FALSE;
	$get_password = FALSE;
}

// Get current EM version
$sql = 'SELECT *
	FROM ' . CONFIG_TABLE . "
	WHERE config_name = 'EM_version'";

if( !( $result = $db->sql_query( $sql ) ) )
{
	message_die( CRITICAL_ERROR, "Could not query config information for EasyMOD version", '', __LINE__, __FILE__, $sql );
}
else
{
	if( $row = $db->sql_fetchrow( $result ) )
	{
		$old_version = $row['config_value'];
		$new_version = ( isset( $HTTP_POST_VARS['EM_Version'] ) ) ? $HTTP_POST_VARS['EM_Version'] : htmlspecialchars( $old_version );

		if( isset( $HTTP_POST_VARS['submit'] ) )
		{
			$sql = 'UPDATE ' . CONFIG_TABLE . "
				SET config_value = '$new_version'
				WHERE config_name = 'EM_version'";

			if( !( $db->sql_query( $sql ) ) )
			{
				message_die( GENERAL_ERROR, "Failed to update EasyMOD version", '', __LINE__, __FILE__, $sql );
			}
		}
	}

	if( isset( $HTTP_POST_VARS['submit'] ) )
	{
		$message = "EasyMOD version successfully changed.<br /><br />" .  sprintf( $lang['Click_return_config'], "<a href=\"" . append_sid( "admin_emversionchanger.$phpEx" ) . "\">", "</a>" ) . "<br /><br />" . sprintf( $lang['Click_return_admin_index'], "<a href=\"" . append_sid( "index.$phpEx?pane=right" ) . "\">", "</a>");

		message_die( GENERAL_MESSAGE, $message );
	}
}

if( $use_EM_files && $get_password )
{
	// load the password page template
	$template->set_filenames( array(
		'body' => 'admin/mod_login.tpl'
	) );

	$template->assign_vars( array(
		'L_TITLE' => $lang['EM_Title'],
		'L_EM_VERSION' => $new_version,
		'NUTTZY' => '<a href="http://www.blizzhackers.com/" target="_blank">Nuttzy</a>',
		'S_ACTION' => append_sid( "admin_emversionchanger.$phpEx" ),
		'L_ACCESS_WARNING' => $lang['EM_access_warning'],
		'L_MESSAGE' => $pass_message,
		'L_PASSWORD_TITLE' => $lang['EM_password_title'],
		'L_PASSWORD' => $lang['EM_password'],
		'L_ACCESS_EM' => $lang['EM_access_EM'],
		'MODE' => NULL
	) );

}
else
{
	$template->set_filenames( array(
		'body' => 'admin/mod_emversionchanger.tpl'
	) );

	$template->assign_vars( array(
		'S_CONFIG_ACTION' => append_sid( "admin_emversionchanger.$phpEx" ),
		'EM_VERSION' => $new_version,
		'L_SUBMIT' => $lang['Submit'], 
		'L_RESET' => $lang['Reset']
	) );
}

if( $use_EM_files )
{
	$template->set_filenames( array(
		'mod_header' => 'admin/mod_header.tpl'
	) );

	$template->assign_vars( array(
		'L_TITLE' => $lang['EM_Title'],
		'L_EM_VERSION' => $new_version,
		'NUTTZY' => '<a href="http://www.blizzhackers.com/" target="_blank">Nuttzy</a>'
	) );

	// Display the EasyMOD header
	$template->pparse( 'mod_header' );
}

// Show either the EasyMOD password screen or the Version Changer
$template->pparse( 'body' );

// Output the footer
print '<div align="center"><span class="copyright">Powered by <a href="http://www.music-hq.net/~gphemsley/phpBB/EasyMOD/" target="_new" class="copyright">EasyMOD Version Changer 1.3</a> &copy; 2003-2004 Gordon P. Hemsley</span></div>';

include( 'page_footer_admin.' . $phpEx );

?>