// Purpose: Socket ⺻ Ŭ 
// Author : ڱ
// Update : 2003-04-30
// Date   : 2003-04-24
// Comment:
//       ⺻ Ǵ Ŭ Socket API Wrapper Լ Ѵ.
//      UNIX Blocking, Non-blocking socket Ѵ.  

#if defined(_SOCKET)

#ifndef __SOCK_H_
#define __SOCK_H_

//
// Includes
//

#include <pesc.h>

#if defined(_WIN32)
    #include <winsock2.h>

    //  Winsock 
    #define WINSOCK_VER_MAJOR   2
    #define WINSOCK_VER_MINOR   2 
#else
    #include <sys/types.h>
	#include <sys/socket.h>
	#include <unistd.h>
	#include <netinet/in.h>
    #include <arpa/inet.h>
    #include <fcntl.h>

 	#define	SOCKET_ERROR			(-1)
	#define INVALID_SOCKET  		(-1)

	#define	SOCKADDR_IN				struct sockaddr_in
	#define	SOCKET					int
	
  	#define	WSAGetLastError()		errno
    #include closesocket(hSock)     close(hSock)
	#define	ioctlsocket(a,b,c)		ioctl(a,b,c)
#endif

//
// Class
//

class C_Sock
{
// Constants, Enumerations & Structures
private:
    // Socket ּ 
    struct SockAddrIn {
        SOCKADDR_IN SockAddr;    //  ּ
        bool        bIsValid;    // ּ ȿ 
    };

public:
    // Socket  带 Ÿ  
    enum Mode {
        Blocking,
        NonBlocking     // EWOULDBLOCKó ʿ 
    };

    // Socket ¸ Ÿ 
    enum Status {
        NotConnected,
        Connected,
        Connecting      // accept, connect EWOULDBLOCK 
    };
    
// Constructors & Destructors
public:
    C_Sock();
    virtual ~C_Sock();

// Operators
public:

// Attributes
private:
    SOCKET      m_hSock;    // Socket ڵ
    Mode        m_enMode;   // Socket  
    Status      m_enStatus; // Socket 
    UINT        m_fOption;  // Socket ɼ

    SockAddrIn  m_SockAddr; // Socket ּ 

// Overridables
public:

// Methods
protected:
    // Socketɼ  
    bool ApplyOption();

public:
    //
    //  Address  
    //
    
    bool SetAddress(short nFamily, unsigned short unPort, unsigned long ulAddr);
    bool SetAddress(short nFamily, unsigned short unPort, LPCSTR c_lpszAddr);

    void SetServer(SOCKET hSock, Mode enMode = Blocking,
        Status enStatus = Connected);
    
    //
    // API Wrapper inline Լ 
    //
    
    bool Socket(int iAF, int iType, int iProtocol = 0);
   	bool Ioctlsocket(long lCommand, DWORD* lpArgument);
    bool SetSockOpt(int iOptionName, const void* lpOptionValue,	int iOptionLen,
        int iLevel = SOL_SOCKET);
	bool GetSockOpt(int iOptionName, void* lpOptionValue, int* piOptionLen,
        int iLevel = SOL_SOCKET);
    bool Bind();
	bool Listen(int iBacklog = SOMAXCONN);
    bool Close();
    
    //
    //  Լ Non-blocking modeK 츦 ó  Ѵ.
    //

    SOCKET Accept();
    bool Connect();
    int Send(const void* lpBuf, int iBufLen, int nFlags = 0);
	int Recv(void* lpBuf, int iBufLen, int nFlags = 0);

};

#endif  // __SOCK_H_

#endif  // _SOCKET
