// Purpose: Win32 GUI application MDI frame Ŭ 
// Author : ڱ
// Update : 2003/05/20
// Date   : 2003/05/07

#if defined(_WIN32) && defined(_GUI)

//
// Headers
//

#include <pesc.h>

//
// Definitions 
//

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BEGIN_MESSAGE_MAP(C_FrameMDI, C_Frame)
    ON_MESSAGE(WM_CREATE, C_FrameMDI::OnCreate)
    ON_COMMAND(PESC_IDM_FILE_CLOSE, C_FrameMDI::CmdFileClose)
    ON_COMMAND(PESC_IDM_WINDOW_CLOSEALL, C_FrameMDI::CmdWindowCloseAll)
END_MESSAGE_MAP()

//
// Construction/Destruction
//

// Purpose: ڿ ʱȭѴ. 
C_FrameMDI::C_FrameMDI()
{
    m_hWnd = NULL;
    m_hWndClient = NULL;
    m_hMenu = NULL;
    m_hMenuList = NULL;
    m_edwp = edwpMDIFrame;
}

//
// Overridables
//

// Purpose: WM_CREATE޼ ϵ 츦 Ѵ.
LRESULT C_FrameMDI::OnCreate(WPARAM wParam, LPARAM lParam)
{
    CLIENTCREATESTRUCT  clientcreate;
    
    clientcreate.hWindowMenu = m_hMenuList;
    clientcreate.idFirstChild = ID_FIRSTCHILD;
    
    m_hWndClient = ::CreateWindow(MDICLIENT, NULL,
        WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE | WS_VSCROLL | WS_HSCROLL,
        0, 0, 0, 0, m_hWnd,
        (HMENU) 1, PescGetInstance(), (LPSTR) &clientcreate);
    WARNING_WIN32("C_FrameMDI", NULL != m_hWndClient);

    return 0;
}

// Purpose: PESC_IDM_FILE_CLOSE޼ ȰȭǾ ִ ϵ 츦
//          ҸŲ. 
LRESULT C_FrameMDI::CmdFileClose(WORD wNotify, HWND hwndCtrl)
{
    HWND hwndChild = (HWND) SendMessageClient(WM_MDIGETACTIVE);
    
    if (::SendMessage(hwndChild, WM_QUERYENDSESSION, 0, 0))
        SendMessageClient(WM_MDIDESTROY, (WPARAM) hwndChild);

    return 0;
}

// Purpose: PESC_IDM_WINDOW_CLOSEALL޼  ϵ 츦 ҸŲ. 
LRESULT C_FrameMDI::CmdWindowCloseAll(WORD wNotify, HWND hwndCtrl)
{
    bool bRet = EnumChildWindows(&C_FrameMDI::CloseEnumProc);
    WARNING("CmdWindowCloseAll", true == bRet);
    return 0;
}

//
// Methods
//

// Purpose: MDI Window Ѵ.
// Accepts: c_lpszClassName- Class ̸ 
//          c_lpszWindowName- Window ̸ 
//          nIDResource-  쿡  ҽ ID
//          nWindowListPos- Window List ġ 
//          dwDefaultStyle- Window Ÿ
//          dwExStyle- Ȯ Window Ÿ
//          hbrBackground-  
// Returns: true- , false-  
bool C_FrameMDI::Create(LPCSTR c_lpszClassName, LPCSTR c_lpszWindowName,
    UINT nIDResource, UINT nWindowListPos, DWORD dwDefaultStyle,
    DWORD dwExStyle, HBRUSH hbrBackground)
{
    ASSERT("Create", NULL != c_lpszClassName);
    ASSERT("Create", '\0' != *c_lpszClassName);
    ASSERT("Create", NULL != c_lpszWindowName);
    ASSERT("Create", '\0' != *c_lpszWindowName);

    return C_Frame::Create(c_lpszClassName, c_lpszWindowName, nIDResource,
        nWindowListPos, dwDefaultStyle | WS_CLIPCHILDREN, dwExStyle,
        hbrBackground);
}

//
// ???
//
BOOL CALLBACK C_FrameMDI::CloseEnumProc(HWND hWnd, LPARAM lParam)
{
    if (::GetWindow(hWnd, GW_OWNER)) return 1;
    
    ::SendMessage(GetParent(hWnd), WM_MDIRESTORE, (WPARAM) hWnd, 0);
    
    if (!::SendMessage(hWnd, WM_QUERYENDSESSION, 0, 0)) return 1;
    
    ::SendMessage(GetParent(hWnd), WM_MDIDESTROY, (WPARAM) hWnd, 0);
    return 1;        
}

#endif  // _WIN32, _GUI
