// Purpose: Win32 GUI application MDI child window Ŭ 
// Author : ڱ
// Update : 2003/05/20
// Date   : 2003/05/20

#if defined(_WIN32) && defined(_GUI)

//
// Headers
//

#include <pesc.h>

//
// Definitions 
//

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BEGIN_MESSAGE_MAP(C_FrameChild, C_Frame)
    ON_MESSAGE(WM_MDIACTIVATE, C_FrameChild::OnMDIActivate)
END_MESSAGE_MAP()

//
// Construction/Destruction
//

// Purpose: ڿ ʱȭѴ. 
C_FrameChild::C_FrameChild()
{
    m_hWnd = NULL;
    m_hWndClient = NULL;
    m_hMenu = NULL;
    m_hMenuList = NULL;
    m_edwp = edwpMDIChild;
    
    m_hWndParent = NULL;
    m_hWndFrame = NULL;
}

//
// Overridables
//

LRESULT C_FrameChild::OnMDIActivate(WPARAM wParam, LPARAM lParam)
{
    if (lParam == (LPARAM) m_hWnd)
        SendMessageParent(WM_MDISETMENU, (WPARAM) m_hMenu,
            (LPARAM) m_hMenuList);
    else
        SendMessageParent(WM_MDISETMENU,
            (WPARAM) PescGetMainFrame()->GetMenu(),
            (LPARAM) PescGetMainFrame()->GetMenuList());

    bool bRet = DrawMenuBar();
    WARNING("C_FrameChild", true == bRet);

    return 0;
}

//
// Methods
//

// Purpose: MDI child window Ѵ.
// Accepts: c_lpszClassName- Class ̸ 
//          c_lpszWindowName- Window ̸ 
//          nIDResource-  쿡  ҽ ID
//          nWindowListPos- Window List ġ 
//          dwDefaultStyle- Window Ÿ
//          dwExStyle- Ȯ Window Ÿ
//          hbrBackground-  
// Returns: true- , false-  
bool C_FrameChild::Create(HWND hWndFrame, HWND hWndParent,
    LPCSTR c_lpszClassName, LPCSTR c_lpszWindowName, UINT nIDResource,
    UINT nWindowListPos, DWORD dwDefaultStyle, DWORD dwExStyle,
    HBRUSH hbrBackground)
{
    ASSERT("Create", NULL != hWndParent);
    ASSERT("Create", NULL != hWndFrame);
    ASSERT("Create", NULL != c_lpszClassName);
    ASSERT("Create", '\0' != *c_lpszClassName);
    ASSERT("Create", NULL != c_lpszWindowName);
    ASSERT("Create", '\0' != *c_lpszWindowName);

    m_hWndFrame = hWndFrame;
    m_hWndParent = hWndParent;

    return C_Frame::Create(c_lpszClassName, c_lpszWindowName, nIDResource,
        nWindowListPos, dwDefaultStyle, dwExStyle | WS_EX_MDICHILD,
        hbrBackground, hWndParent);
}

inline bool C_FrameChild::DrawMenuBar()
{
    ASSERT("DrawMenuBar", NULL != m_hWndFrame);
    BOOL bRet = ::DrawMenuBar(m_hWndFrame);
    WARNING_WIN32("DrawMenuBar", TRUE == bRet);
    return (TRUE == bRet);
}

inline LRESULT C_FrameChild::SendMessageParent(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    ASSERT("SendMessageParent", m_hWndParent);
    return ::SendMessage(m_hWndParent, uMsg, wParam, lParam);
}

#endif  // _WIN32, _GUI
