// Purpose:	Assert
// Author : ڱ
// Update : 2003/04/30
// Date	  : 2003/04/18

#if defined(_DEBUG)

//
// Headers
//

#include <assert.h>
#include <pesc.h>

//
// Definitions
//

static char THIS_FILE[] = __FILE__;

LPCSTR      C_Assert::mc_lpszAssertFile = "ASSERT.TXT";
LPCSTR      C_Assert::mc_lpszTimeFormat = "%Y-%m-%d %H:%M:%S";
UINT        C_Assert::mc_uTimeBufferSize = 64;
UINT        C_Assert::mc_uTypeBufferSize = 32;
UINT        C_Assert::mc_uErrorBufferSize = 512;
FILE*       C_Assert::ms_phAssert = NULL;

// ASSERT  TRACE Applicationۺ 밡ؾ ϱ  ü
// ߴ. 
C_Assert    g_Assert;   

//
// Construction/Destruction
//

// Purpose:	Assert  Trace ϱ  ʱȭ Ѵ. 
C_Assert::C_Assert()
{
    //  νϽ ϱ  assert Ͽ.
    assert(NULL == ms_phAssert);
    //  . 
    ms_phAssert = ::fopen(mc_lpszAssertFile, "w");
    //   ȴ ȮѴ. 
    assert(NULL != ms_phAssert);
}

// Purpose:	 ü ҸŲ. 
C_Assert::~C_Assert()
{
    // Ҹ    ʱ      Ѵ. 
    WARNING("~C_Assert", NULL != ms_phAssert); 
    //  ݴ´. 
	int iRet = ::fclose(ms_phAssert);
	//    ȮѴ.
    assert(EOF != iRet); 
}

//////////////////////////////////////////////////////////////////////
// Methods
//////////////////////////////////////////////////////////////////////

// Purpose:	ASSERT, WARNING, TRACE Ѵ.
// Accepts:	c_lpszFile- ϸ
//          uLine- Trace
//          uType- ASSERT, WARNING, TRACE  ɼ 
//          c_lpszFunc- Լ
//          c_lpszFormat- printf parameters
// Comment:
//      c_lpszFile, uLine, uType ȿ ˻  
//      Warning, Assert, TraceԼ  parameter ũη ڵ
//      Է ޾ ׻ ȿ   ̴.
//      ȿ     compile  ߻Ѵ.
//      c_lpszFunc c_lpszFormat ߸    Ƿ ȿ
//      ˻縦 Ѵ.
//      WARNING ȿ˻ ̹ ũο ߱  TRACE Ȱ
//      óϸ ASSERT WARNING   ó ش. 
void C_Assert::Trace(LPCSTR c_lpszFile, UINT uLine, UINT uType, 
    LPCSTR c_lpszFunc, LPCSTR c_lpszFormat, ...)
{
    assert(NULL != ms_phAssert);
    assert(NULL != c_lpszFunc);
    assert('\0' != *c_lpszFunc);
    assert(NULL != c_lpszFormat);
    assert('\0' != *c_lpszFormat);
    
    char szTime[mc_uTimeBufferSize];
    GetCurrentTm(szTime);

    char szType[mc_uTypeBufferSize];
    switch(uType & TYPE_ASSERT_BIT)
    {
        case TYPE_ASSERT:   sprintf(szType, "%s", TEXT_ASSERT);     break;
        case TYPE_WARNING:  sprintf(szType, "%s", TEXT_WARNING);    break;
        case TYPE_TRACE:    sprintf(szType, "%s", TEXT_TRACE);      break;
        // TRACE, WARNING, ASSERT ƴϴ ½Ű 
        // ߸ parameter ȣ  ã  ֱ ̴. 
        default:
            sprintf(szType, "%s", TEXT_UNKNOWN); break;
    }

	::fprintf(ms_phAssert, "%s\t%s\t%s\t%s\t%d\t", szTime, szType,
        GetFileExceptPath(c_lpszFile), c_lpszFunc, uLine);

#if defined(_WIN32)
    #if defined(_SOCKET)
        if ((uType & TYPE_CHECK_SOCK) || (uType & TYPE_CHECK_WIN32))
        {
            int iErrorNo = (uType & TYPE_CHECK_SOCK) ?
                WSAGetLastError() : GetLastError();
    #else
        if (uType & TYPE_CHECK_WIN32)
        {
            int iErrorNo = GetLastError();
    #endif
#else
    #if defined(_SOCKET)
        if (uType & TYPE_CHECK_SOCK)
        {
            int iErrorNo = WSAGetLastError();
    #else
        // _UNIX ޼ ó   ̴. 
        if (false)
        {
            int iErrorNo = 0;
    #endif
#endif
        char    szError[mc_uErrorBufferSize];
        szError[0] = '\0';       

        #if defined(_WIN32)
            DWORD dwFormatMsg = FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM,
                NULL, iErrorNo, LANG_NEUTRAL, (LPTSTR) &szError,
                mc_uErrorBufferSize, NULL);
            if (0 == dwFormatMsg)
            {
                TRACE1("Trace", "Unknown error message! error number= %d", iErrorNo);
            }
        #endif
        
        ::fprintf(ms_phAssert, "%d\t%s\n", iErrorNo, szError);
    }
    else
    {
        ::fprintf(ms_phAssert, "0\t");
    
    	va_list	ap;
        va_start(ap, c_lpszFormat);
    	::vfprintf(ms_phAssert, c_lpszFormat, ap);
        va_end(ap);

        ::fprintf(ms_phAssert, "\n");
        ::fflush(ms_phAssert);
    }
    
    if (uType & TYPE_ASSERT)
    {
        ::exit(-1);
    }
}

// Purpose: ð  Ʈ ȯѴ.
// Accepts: szTime-  Ʈ ȯ Ʈ  
void C_Assert::GetCurrentTm(char* szTime)
{
    time_t  ltime = time(NULL);
	struct tm* ptmTemp = localtime(&ltime);
    assert(NULL != ptmTemp);
    size_t lsize = ::strftime(szTime, mc_uTimeBufferSize, mc_lpszTimeFormat,
        ptmTemp);
    assert(0 != lsize);
}

// Purpose: Path  ϸ Path  ϸ ȯѴ. 
// Accepts: Path  ϸ
// Returns: Path  ϸ
// Comment:
//      c_lpszPath ̹ ȿ ˻縦 ȣϴ Լ ߴ. 
LPCSTR C_Assert::GetFileExceptPath(LPCSTR c_lpszPath)
{
	for (int iStrPos = strlen(c_lpszPath) - 1;0 < iStrPos;iStrPos--)
		if ('/' == c_lpszPath[iStrPos]) return &c_lpszPath[iStrPos + 1];
	return c_lpszPath;
}

#endif  // _DEBUG
