// Purpose: Win32 Windows application  Ŭ 
// Author : ڱ
// Update : 2003/05/06
// Date   : 2003/04/28

#if defined(_WIN32) && defined(_GUI)

//
// Headers
//

#include <pesc.h>

//
// Definitions
//

// C_Wnd ޼ ޴  Ŭ  BEGIN_MESSAGE_MAP 
// ʾҴ. 
const C_Wnd::MSDM* C_Wnd::GetMessageMap() const
    { return &C_Wnd::messageMap; }
const C_Wnd::MSDM C_Wnd::messageMap =
    { NULL, C_Wnd::rgmsd };
const C_Wnd::MSD C_Wnd::rgmsd[] = {
    ON_MESSAGE(WM_DESTROY, C_Wnd::OnDestroy)
    ON_MESSAGE(WM_NCDESTROY, C_Wnd::OnNCDestroy)
END_MESSAGE_MAP()

HHOOK C_Wnd::m_hHook = NULL;

//
// Construction/Destruction
//

// Purpose: ڿ ʱȭѴ. 
C_Wnd::C_Wnd()
    : m_hWnd(NULL)
{
}

// Purpose: ڿ ȯѴ.
C_Wnd::~C_Wnd()
{
     if (NULL != m_hWnd)
    {
        WARNING(!"C_Wnd::~C_Wnd");
        bool bRet = DestroyWindow();
        WARNING(true == bRet);
        RemoveFromMap(m_hWnd);
    }
} 

//
// Overridables
//

//
// Methods
//

// Purpose: 찡 ҸǴ ޼ ó
// Comment:
//      WM_DESTROY޼ PostQuitMessage ̿Ͽ ޼ 
//       츦   ִ. 
LRESULT C_Wnd::OnDestroy(WPARAM wParam, LPARAM lParam)
{
    ::PostQuitMessage(0);
    return 0;
}

// Purpose: 찡 ҸǴ  ޼ó 
// Comment:
//      WM_NCDESTROY޼ 찡 ı   ޼ ̹Ƿ Ŭ
//        ڵ ϰ ʿ  ڵ Ŭ Ѵ.  
LRESULT C_Wnd::OnNCDestroy(WPARAM wParam, LPARAM lParam)
{
    RemoveFromMap(m_hWnd);
    return 0;
}


// Purpose: Window ޼ Call back Լ
// Comment:
//       Window ޼ ޾ ش  Ŭ ڵ .
//      Ϲ C API α׷    ϳ Call back
//      Լ  ǳ Ŭ ̺귯 ̿Ͽ ü   
//          ش  Ŭ ޼ Ų. 
LRESULT CALLBACK C_Wnd::WndProc(HWND hWnd, UINT uMessage, WPARAM wParam,
    LPARAM lParam)
{
    //  ڵ鿡 شϴ Ŭ ´. 
    C_Wnd*  pWnd = PescGetWndMap()->GetHandle(hWnd);
    ASSERT(NULL != pWnd);

    return pWnd->DispMessage(uMessage, wParam, lParam);
}

// Purpose: Window creation hooking Լ 
// Comment:
//       츦 hookϴ  찡 Ǳ  ڵ
//      Ŭ ʿ ؾ ϱ ̴. 
LRESULT CALLBACK C_Wnd::CBTProc(int iCode, WPARAM wParam, LPARAM lParam)
{
    ASSERT(NULL != PescGetApp().GetWnd());
    ASSERT(NULL != m_hHook);
    ASSERT(HCBT_CREATEWND == iCode);
    ASSERT(static_cast<WPARAM> (NULL) != wParam);
    
    //      ڸƮ óس. 
    //ASSERT(NULL != lParam);
    //LPCREATESTRUCT lpcs = ((LPCBT_CREATEWND)lParam)->lpcs;
	//ASSERT(NULL != lpcs);

    HWND    hWnd = (HWND)wParam;
    ASSERT(NULL == PescGetWndMap()->GetHandle(hWnd));
    PescGetWndMap()->AddHandle(hWnd, PescGetApp().GetWnd());
    PescGetWndMap()->GetHandle(hWnd)->Attach(hWnd);

    LONG oldWndProc = ::SetWindowLong(hWnd, GWL_WNDPROC, (DWORD)C_Wnd::WndProc);
    WARNING_WIN32(static_cast<LONG> (NULL) != oldWndProc);
    ASSERT(static_cast<LONG> (NULL) != oldWndProc);

    LRESULT lResult = CallNextHookEx(m_hHook, iCode, wParam, lParam);

    PescGetApp().SetWnd(NULL);
    BOOL bRetHook = ::UnhookWindowsHookEx(m_hHook);
    WARNING_WIN32(TRUE == bRetHook);
    m_hHook = NULL;

    return lResult;
}

// Purpose: ޼ شϴ Լ ȣѴ.
// Accepts: uMessage - ޼ 
//          wparam - ޼  data 
//          lparam - ޼  data
// Returns:  Լ ȯϴ 
// Comment: WndProc Ͽ ȣȴ. 
LRESULT C_Wnd::DispMessage(UINT uMessage, WPARAM wparam, LPARAM lparam)
{
    const MSDM* pMessageMap = GetMessageMap();
    for( ;NULL != pMessageMap;pMessageMap = pMessageMap->baseMsd)
    {
        // ޼ ޴  ޴ ɿ شϴ Լ Ѵ. 
        if (WM_COMMAND == uMessage)
        {
            WORD    wCommand = GET_WM_COMMAND_ID(wparam, lparam);
            int     icmd = 0;
            while(0 != pMessageMap->Msd[icmd].uMessage)
            {
                if (pMessageMap->Msd[icmd].wCommand == wCommand)
                {
                    PFNCMD pfncmd = pMessageMap->Msd[icmd].pfncmd;
                    return (this->*pfncmd)(GET_WM_COMMAND_CMD(wparam, lparam),
                                      GET_WM_COMMAND_HWND(wparam, lparam));
                }
                ++icmd;
            }
        }
        // ޼ شϴ Լ Ѵ. 
        else
        {
            int  imsd = 0;
            while(0 != pMessageMap->Msd[imsd].uMessage)
            {
                if (pMessageMap->Msd[imsd].uMessage == uMessage)
                {
                    PFNMSG pfnmsg = pMessageMap->Msd[imsd].pfnmsg;
                    return (this->*pfnmsg)(wparam, lparam);
                }
                ++imsd;
            }
        }
    }
    return DispDefault(edwpWindow, uMessage, wparam, lparam);
}

// Purpose: ⺻Լ ȣѴ.
// Accepts: edwp-  ⺻Լ 
//          uMessage - ޼ 
//          wparam - ޼  data 
//          lparam - ޼  data
// Returns:  Լ ȯϴ 
LRESULT C_Wnd::DispDefault(EDWP edwp, UINT uMessage, WPARAM wparam,
    LPARAM lparam)
{
    switch (edwp)
    {
        case edwpNone:
            return 0;
        case edwpWindow:
            return ::DefWindowProc(m_hWnd, uMessage, wparam, lparam);
        case edwpDialog:
            return ::DefDlgProc(m_hWnd, uMessage, wparam, lparam);
        case edwpMDIFrame:
            return ::DefFrameProc(m_hWnd, NULL, uMessage, wparam, lparam);
        case edwpMDIChild:
            return ::DefMDIChildProc(m_hWnd, uMessage, wparam, lparam);
    }
    return 0;
}

// Purpose: Window ϱ  Ѵ. 
// Accepts: cs- Ϸ Window  
// Returns: true- , false-  
bool C_Wnd::PreCreateWindow(CREATESTRUCT &cs)
{
    return true;
}

// Purpose: Window Ѵ.
// Returns: true-  
//          false-  
bool C_Wnd::CreateWindowEx(DWORD dwExStyle, LPCSTR c_lpszClassName, 
	LPCSTR c_lpszWindowName, DWORD dwStyle,
	int x, int y, int nWidth, int nHeight,
	HWND hWndParent, HMENU nIDorHMenu, LPVOID lpParam)
{
    ASSERT(NULL == m_hWnd);
    ASSERT(NULL != c_lpszClassName);
    ASSERT('\0' != *c_lpszClassName);
    ASSERT(NULL != c_lpszWindowName);
    ASSERT('\0' != *c_lpszWindowName);

    CREATESTRUCT    cs;
	cs.dwExStyle = dwExStyle;          // Ȯ  Ÿ 
	cs.lpszClass = c_lpszClassName;    // Window class name
	cs.lpszName = c_lpszWindowName;    // Window name
	cs.style = dwStyle;                // Window style
	cs.x = x;          // Window ġ 
	cs.y = y;          // Window ġ 
	cs.cx = nWidth;    // Window  
	cs.cy = nHeight;   // Window  
	cs.hwndParent = hWndParent;        // θ Ǵ  Window ڵ 
	cs.hMenu = nIDorHMenu;             // ޴ ڵ Ǵ Child Window ĺ 
	cs.hInstance = PescGetInstance();  // Application instance
	cs.lpCreateParams = lpParam;       // WM_CREATE޼ lParam ޵Ǵ  

    bool bRet = PreCreateWindow(cs);
	if (false == bRet) goto cleanup;

    // ʿ  ڵ Ŭ ϱ Ͽ hookingѴ. 
    ASSERT(NULL == m_hHook);
    m_hHook = ::SetWindowsHookEx(WH_CBT, C_Wnd::CBTProc, NULL,
        ::GetCurrentThreadId());
    WARNING_WIN32(NULL != m_hHook);
    if (NULL == m_hHook) goto cleanup;
    ASSERT(NULL == PescGetApp().GetWnd());
    PescGetApp().SetWnd(this);

	m_hWnd = ::CreateWindowEx(cs.dwExStyle, cs.lpszClass,
			cs.lpszName, cs.style, cs.x, cs.y, cs.cx, cs.cy,
			cs.hwndParent, cs.hMenu, cs.hInstance, cs.lpCreateParams);
    WARNING_WIN32(NULL != m_hWnd);

    if (NULL != m_hHook)
    {
        PescGetApp().SetWnd(NULL);
        BOOL bRetHook = ::UnhookWindowsHookEx(m_hHook);
        WARNING_WIN32(TRUE == bRetHook);
        m_hHook = NULL;
        if (FALSE == bRetHook) goto cleanup;
    }

    return (NULL != m_hWnd);

cleanup:
    WARNING(!"C_Wnd::CreateEx");
	return false;
}

// Purpose: Window class ü Ѵ.
// Accepts: c_lpszClassName- Ŭ̸ 
//          nClassStyle- Ŭ style
//          hCursor- Ŀ 
//          hbrBackground-  
//          hIcon-  
// Returns: true- 
//          false-  
bool C_Wnd::RegisterClass(LPCSTR c_lpszClassName, UINT nClassStyle,
    HCURSOR hCursor, HBRUSH hbrBackground, HICON hIcon)
{
    ASSERT(NULL != PescGetInstance());
    ASSERT(NULL != c_lpszClassName);
    ASSERT('\0' != *c_lpszClassName);

    WNDCLASSEX  wincl;
    int         iRet;

    wincl.cbSize = sizeof(WNDCLASSEX);
    wincl.style = nClassStyle;
    wincl.lpfnWndProc = DefWindowProc;      // Window message ޴ ݹԼ 
    wincl.cbClsExtra = 0;
    wincl.cbWndExtra = 0;
    wincl.hInstance = PescGetInstance();    // Application instance
    wincl.hIcon = hIcon;                    // Application icon
    wincl.hCursor = hCursor;                // Application default cursor
    wincl.hbrBackground = hbrBackground;    // Window background color
    wincl.lpszMenuName = NULL;              // Default menu
    wincl.lpszClassName = c_lpszClassName;  // Window class name
    wincl.hIconSm = hIcon;                  // Application small icon

    iRet = ::RegisterClassEx(&wincl);
    WARNING_WIN32(0 != iRet);
    return (0 != iRet);
}

// Purpose: Window class , Ŀ Բ Ѵ.
// Accepts: RegisterClass
// Returns: RegisterClass 
bool C_Wnd::RegisterClassWithIcon(LPCSTR c_lpszClassName, UINT nIDIcon,
    UINT nClassStyle, HBRUSH hbrBackground)
{
    ASSERT(NULL != PescGetInstance());

    HICON   hIcon;
    HCURSOR hCursor;
    
    if (0 == nIDIcon)
    {
        hIcon = ::LoadIcon(NULL, IDI_APPLICATION);
        hCursor = ::LoadCursor(NULL, IDC_ARROW);
    }
    else
    {
        hIcon = ::LoadIcon(PescGetInstance(), MAKEINTRESOURCE(nIDIcon));
        hCursor = ::LoadCursor(PescGetInstance(), MAKEINTRESOURCE(nIDIcon));
    }
    WARNING_WIN32(NULL != hIcon);
    WARNING_WIN32(NULL != hCursor);

    return RegisterClass(c_lpszClassName, nClassStyle, hCursor,
        hbrBackground, hIcon);
}
#endif  // _WIN32, _GUI
