// Purpose:  ʴ 츦  ޸ DC Ѵ.
// Author : ڱ
// Update : 2003/05/06
// Date   : 2002/01/22
// Comment:
//      찡 invalid϶  ߻Ѵ.
//       Ŭ  ´. 

#ifndef __MEMDC_H_
#define __MEMDC_H_

#include <pesc.h>

class CPKTMemDC : public CDC
{
// Constructors & Destructors
public:
	// Purpose:	Erases Windows, and creates memory device-context object.
	// Accepts:	pWnd- Windows client range
	//			pDC- Origin device-context object
	//			ctlBack- Background color for erasing
	//			pbmp- bitmap for memory device-context object
	CPKTMemDC(CWnd *pWnd, CDC* pDC, COLORREF ctlBack, CBitmap *pbmp)
	{
		ASSERT(pbmp);

		m_pDC = pDC;

		pWnd->GetClientRect(&m_rect);
		CreateCompatibleDC(m_pDC);
		m_pbmpOld = SelectObject(pbmp);

		if (ctlBack == CTL_WHITE)
			PatBlt(m_rect.left, m_rect.top, m_rect.Width(), m_rect.Height(), WHITENESS);
		else if (ctlBack == CTL_BLACK)
			PatBlt(m_rect.left, m_rect.top, m_rect.Width(), m_rect.Height(), BLACKNESS);
		else
			FillSolidRect(m_rect, ctlBack);
	}

public:
	// Purpose:	Copy memory device-context object to origin device-context object.
	~CPKTMemDC()
	{
		m_pDC->BitBlt(m_rect.left, m_rect.top, m_rect.Width(), m_rect.Height(),
			this, m_rect.left, m_rect.top, SRCCOPY);
		SelectObject(m_pbmpOld);
	}

// Attributes
private:
	CBitmap*	m_pbmpOld;	//	previos bitmap for origin device-context object
	CDC*		m_pDC;		//	origin device-context object
	CRect		m_rect;		//	Windows range

	CPKTMemDC* operator->()	{return this;}
	operator CPKTMemDC*()	{return this;}
};

#endif  // __MEMDC_H_
