// Purpose:	Assert
// Author : ڱ
// Update : 2003/04/30
// Date	  : 2003/04/18

#if defined(_DEBUG)

//
// Headers
//

#include <assert.h>
#include <pesc.h>

//
// Definitions
//

LPCSTR      C_Assert::mc_lpszAssertFile = "ASSERT.TXT";
LPCSTR      C_Assert::mc_lpszTimeFormat = "%Y-%m-%d %H:%M:%S";
UINT        C_Assert::mc_uTimeBufferSize = 64;
FILE*       C_Assert::ms_phAssert = NULL;
// ASSERT  TRACE Applicationۺ 밡ؾ ϱ  ü
// ߴ. 
C_Assert    g_Assert;   

//
// Construction/Destruction
//

// Purpose:	Assert  Trace ϱ  ʱȭ Ѵ. 
C_Assert::C_Assert()
{
    //  νϽ ϱ  assert Ͽ.
    assert(NULL == ms_phAssert);
    //  . 
    ms_phAssert = ::fopen(mc_lpszAssertFile, "w");
    //   ȴ ȮѴ. 
    assert(NULL != ms_phAssert);
}

// Purpose:	 ü ҸŲ. 
C_Assert::~C_Assert()
{
    // Ҹ    ʱ      Ѵ. 
    WARNING(NULL != ms_phAssert); 
    //  ݴ´. 
	int iRet = ::fclose(ms_phAssert);
	//    ȮѴ.
    assert(EOF != iRet); 
}

//////////////////////////////////////////////////////////////////////
// Methods
//////////////////////////////////////////////////////////////////////

// Purpose:	Trace Ѵ.
// Accepts:	c_lpszFile- ϸ
//          uLine- Trace
//          c_lpszText- WARNING, TRACE Text
//          c_lpszFunc- Լ
//          c_lpszFormat- printf parameters
// Comment:
//      parameter ȿ ˻   Warning, Assert, Trace
//      Լ  parameter ׻ ȿ   ̴.
//      ȿ     compile  ߻Ѵ.
//      c_lpszFunc c_lpszFormat ߸    Ƿ ȿ
//      ˻縦 Ѵ. 
void C_Assert::Trace(LPCSTR c_lpszFile, UINT uLine, LPCSTR c_lpszText, 
    LPCSTR c_lpszFunc, LPCSTR c_lpszFormat, ...)
{
    assert(NULL != ms_phAssert);
    assert(NULL != c_lpszFunc);
    assert('\0' != *c_lpszFunc);
    assert(NULL != c_lpszFormat);
    assert('\0' != *c_lpszFormat);
    
    char szTime[mc_uTimeBufferSize];
    GetCurrentTm(szTime);

	::fprintf(ms_phAssert,"%s\t%s\t%d\t%s\t%s\t", szTime,
        GetFileExceptPath(c_lpszFile), uLine, c_lpszText, c_lpszFunc);

	va_list	ap;
	va_start(ap, c_lpszFormat);
	::vfprintf(ms_phAssert, c_lpszFormat, ap);
	va_end(ap);

	::fprintf(ms_phAssert,"\n");
	::fflush(ms_phAssert);
}

// Purpose:	WARNING, ASSERT Ѵ.
// Accepts:	c_lpszFile- ϸ
//          uLine- ASSERT, WARNING ߻ 
//          c_lpszText- WARNING, ASSERT Text
//          c_lpszContent- ȿ ˻  
void C_Assert::Warning(LPCSTR c_lpszFile, UINT uLine, LPCSTR c_lpszText, 
    LPCSTR c_lpszContent)
{
    assert(NULL != ms_phAssert);

    char szTime[mc_uTimeBufferSize];
    GetCurrentTm(szTime);

    ::fprintf(ms_phAssert,"%s\t%s\t%d\t%s\t%s\n", szTime,
        GetFileExceptPath(c_lpszFile), uLine, c_lpszText, c_lpszContent);
}

// Purpose:	Assert Ѵ.
// Accepts:	c_lpszFile- ϸ
//          uLine- Assert 
//          c_lpszContent- ȿ ˻ 
// Comment:
//      Warning Assert α׷ ϴ θ Ʋ 
//      ȿ ˻  Warning Ѵ.
void C_Assert::Assert(LPCSTR c_lpszFile, UINT uLine, LPCSTR c_lpszContent)
{
    Warning(c_lpszFile, uLine, TEXT_ASSERT, c_lpszContent);
    ::exit(-1);
}

// Purpose: ð  Ʈ ȯѴ.
// Accepts: szTime-  Ʈ ȯ Ʈ  
void C_Assert::GetCurrentTm(char* szTime)
{
    time_t  ltime = time(NULL);
	struct tm* ptmTemp = localtime(&ltime);
    assert(NULL != ptmTemp);
    size_t lsize = ::strftime(szTime, mc_uTimeBufferSize, mc_lpszTimeFormat,
        ptmTemp);
    assert(0 != lsize);
}

// Purpose: Path  ϸ Path  ϸ ȯѴ. 
// Accepts: Path  ϸ
// Returns: Path  ϸ
// Comment:
//      c_lpszPath ̹ ȿ ˻縦 ȣϴ Լ ߴ. 
LPCSTR C_Assert::GetFileExceptPath(LPCSTR c_lpszPath)
{
	for (int iStrPos = strlen(c_lpszPath) - 1;0 < iStrPos;iStrPos--)
		if ('/' == c_lpszPath[iStrPos]) return &c_lpszPath[iStrPos + 1];
	return c_lpszPath;
}

#endif  // _DEBUG
