/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.GraphVisitor;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;

class CompoundBreakCycles
extends GraphVisitor {
    private NodeList graphNodes;
    private NodeList sL = new NodeList();

    CompoundBreakCycles() {
    }

    private boolean allFlagged(NodeList nodes) {
        int i = 0;
        while (i < nodes.size()) {
            if (!nodes.getNode((int)i).flag) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int buildNestingTreeIndices(NodeList nodes, int base) {
        int i = 0;
        while (i < nodes.size()) {
            Node node = (Node)nodes.get(i);
            if (node instanceof Subgraph) {
                Subgraph s = (Subgraph)node;
                s.nestingTreeMin = base;
                base = this.buildNestingTreeIndices(s.members, base);
            }
            node.nestingIndex = base++;
            ++i;
        }
        return base++;
    }

    private boolean canBeRemoved(Node n) {
        return !n.flag && this.getChildCount(n) == 0;
    }

    private boolean changeInDegree(Node n, int delta) {
        n.workingInts[1] = n.workingInts[1] + delta;
        return n.workingInts[1] == 0;
    }

    private boolean changeOutDegree(Node n, int delta) {
        n.workingInts[2] = n.workingInts[2] + delta;
        return n.workingInts[2] == 0;
    }

    private void cycleRemove(NodeList children) {
        NodeList sR = new NodeList();
        do {
            this.findSinks(children, sR);
            this.findSources(children);
            Node max = this.findNodeWithMaxDegree(children);
            if (max == null) continue;
            int i = 0;
            while (i < children.size()) {
                Node child = (Node)children.get(i);
                if (!child.flag) {
                    if (child == max) {
                        this.restoreSinks(max, sR);
                    } else {
                        this.restoreSources(child);
                    }
                }
                ++i;
            }
            this.remove(max);
        } while (!this.allFlagged(children));
        while (!sR.isEmpty()) {
            this.sL.add(sR.remove(sR.size() - 1));
        }
    }

    private void findInitialSinks(NodeList children, NodeList sinks) {
        int i = 0;
        while (i < children.size()) {
            Node node = children.getNode(i);
            if (!node.flag) {
                if (this.isSink(node) && this.canBeRemoved(node)) {
                    sinks.add(node);
                    node.flag = true;
                }
                if (node instanceof Subgraph) {
                    this.findInitialSinks(((Subgraph)node).members, sinks);
                }
            }
            ++i;
        }
    }

    private void findInitialSources(NodeList children, NodeList sources) {
        int i = 0;
        while (i < children.size()) {
            Node node = children.getNode(i);
            if (this.isSource(node) && this.canBeRemoved(node)) {
                sources.add(node);
                node.flag = true;
            }
            if (node instanceof Subgraph) {
                this.findInitialSources(((Subgraph)node).members, sources);
            }
            ++i;
        }
    }

    private Node findNodeWithMaxDegree(NodeList nodes) {
        int max = Integer.MIN_VALUE;
        Node maxNode = null;
        int i = 0;
        while (i < nodes.size()) {
            int degree;
            Node node = nodes.getNode(i);
            if (!node.flag && (degree = this.getNestedOutDegree(node) - this.getNestedInDegree(node)) >= max && !node.flag) {
                max = degree;
                maxNode = node;
            }
            ++i;
        }
        return maxNode;
    }

    private void findSinks(NodeList children, NodeList rightList) {
        NodeList sinks = new NodeList();
        this.findInitialSinks(children, sinks);
        while (!sinks.isEmpty()) {
            Node sink = sinks.getNode(sinks.size() - 1);
            rightList.add(sink);
            sinks.remove(sink);
            this.removeSink(sink, sinks);
            if (sink.getParent() == null) continue;
            Subgraph parent = sink.getParent();
            this.setChildCount(parent, this.getChildCount(parent) - 1);
            if (!this.isSink(parent) || !this.canBeRemoved(parent)) continue;
            sinks.add(parent);
            parent.flag = true;
        }
    }

    private void findSources(NodeList children) {
        NodeList sources = new NodeList();
        this.findInitialSources(children, sources);
        while (!sources.isEmpty()) {
            Node source = sources.getNode(sources.size() - 1);
            this.sL.add(source);
            sources.remove(source);
            this.removeSource(source, sources);
            if (source.getParent() == null) continue;
            Subgraph parent = source.getParent();
            this.setChildCount(parent, this.getChildCount(parent) - 1);
            if (!this.isSource(parent) || !this.canBeRemoved(parent)) continue;
            sources.add(parent);
            parent.flag = true;
        }
    }

    private int getChildCount(Node n) {
        return n.workingInts[3];
    }

    private int getInDegree(Node n) {
        return n.workingInts[1];
    }

    private int getNestedInDegree(Node n) {
        int result = this.getInDegree(n);
        if (n instanceof Subgraph) {
            Subgraph s = (Subgraph)n;
            int i = 0;
            while (i < s.members.size()) {
                if (!s.members.getNode((int)i).flag) {
                    result += this.getInDegree(s.members.getNode(i));
                }
                ++i;
            }
        }
        return result;
    }

    private int getNestedOutDegree(Node n) {
        int result = this.getOutDegree(n);
        if (n instanceof Subgraph) {
            Subgraph s = (Subgraph)n;
            int i = 0;
            while (i < s.members.size()) {
                if (!s.members.getNode((int)i).flag) {
                    result += this.getOutDegree(s.members.getNode(i));
                }
                ++i;
            }
        }
        return result;
    }

    private int getOrderIndex(Node n) {
        return n.workingInts[0];
    }

    private int getOutDegree(Node n) {
        return n.workingInts[2];
    }

    private void initializeDegrees(DirectedGraph g) {
        g.nodes.resetFlags();
        g.edges.resetFlags(false);
        int i = 0;
        while (i < g.nodes.size()) {
            Node n = g.nodes.getNode(i);
            this.setInDegree(n, n.incoming.size());
            this.setOutDegree(n, n.outgoing.size());
            if (n instanceof Subgraph) {
                this.setChildCount(n, ((Subgraph)n).members.size());
            } else {
                this.setChildCount(n, 0);
            }
            ++i;
        }
    }

    private void invertEdges(DirectedGraph g) {
        int orderIndex = 0;
        int i = 0;
        while (i < this.sL.size()) {
            this.setOrderIndex(this.sL.getNode(i), orderIndex++);
            ++i;
        }
        i = 0;
        while (i < g.edges.size()) {
            Edge e = g.edges.getEdge(i);
            if (this.getOrderIndex(e.source) > this.getOrderIndex(e.target) && !e.source.isNested(e.target) && !e.target.isNested(e.source)) {
                e.invert();
                e.isFeedback = true;
            }
            ++i;
        }
    }

    private void isolateSubgraph(Subgraph subgraph, Node member) {
        Edge edge = null;
        int i = 0;
        while (i < member.incoming.size()) {
            edge = member.incoming.getEdge(i);
            if (!subgraph.isNested(edge.source) && !edge.flag) {
                this.removeEdge(edge);
            }
            ++i;
        }
        i = 0;
        while (i < member.outgoing.size()) {
            edge = member.outgoing.getEdge(i);
            if (!subgraph.isNested(edge.target) && !edge.flag) {
                this.removeEdge(edge);
            }
            ++i;
        }
        if (member instanceof Subgraph) {
            NodeList members = ((Subgraph)member).members;
            int i2 = 0;
            while (i2 < members.size()) {
                this.isolateSubgraph(subgraph, members.getNode(i2));
                ++i2;
            }
        }
    }

    private boolean isSink(Node n) {
        return this.getOutDegree(n) == 0 && (n.getParent() == null || this.isSink(n.getParent()));
    }

    private boolean isSource(Node n) {
        return this.getInDegree(n) == 0 && (n.getParent() == null || this.isSource(n.getParent()));
    }

    private void remove(Node n) {
        n.flag = true;
        if (n.getParent() != null) {
            this.setChildCount(n.getParent(), this.getChildCount(n.getParent()) - 1);
        }
        this.removeSink(n, null);
        this.removeSource(n, null);
        this.sL.add(n);
        if (n instanceof Subgraph) {
            Subgraph s = (Subgraph)n;
            this.isolateSubgraph(s, s);
            this.cycleRemove(s.members);
        }
    }

    private boolean removeEdge(Edge e) {
        if (e.flag) {
            return false;
        }
        e.flag = true;
        this.changeOutDegree(e.source, -1);
        this.changeInDegree(e.target, -1);
        return true;
    }

    private void removeParentChildEdges(DirectedGraph g) {
        int i = 0;
        while (i < g.edges.size()) {
            Edge e = g.edges.getEdge(i);
            if (e.source.isNested(e.target) || e.target.isNested(e.source)) {
                this.removeEdge(e);
            }
            ++i;
        }
    }

    private void removeSink(Node sink, NodeList allSinks) {
        int i = 0;
        while (i < sink.incoming.size()) {
            Edge e = sink.incoming.getEdge(i);
            if (!e.flag) {
                this.removeEdge(e);
                Node source = e.source;
                if (allSinks != null && this.isSink(source) && this.canBeRemoved(source)) {
                    allSinks.add(source);
                    source.flag = true;
                }
            }
            ++i;
        }
    }

    private void removeSource(Node n, NodeList allSources) {
        int i = 0;
        while (i < n.outgoing.size()) {
            Edge e = n.outgoing.getEdge(i);
            if (!e.flag) {
                e.flag = true;
                this.changeInDegree(e.target, -1);
                this.changeOutDegree(e.source, -1);
                Node target = e.target;
                if (allSources != null && this.isSource(target) && this.canBeRemoved(target)) {
                    allSources.add(target);
                    target.flag = true;
                }
            }
            ++i;
        }
    }

    private boolean restoreEdge(Edge e) {
        if (!e.flag || e.source.flag || e.target.flag) {
            return false;
        }
        e.flag = false;
        this.changeOutDegree(e.source, 1);
        this.changeInDegree(e.target, 1);
        return true;
    }

    private void restoreSinks(Node node, NodeList sR) {
        if (node.flag && sR.contains(node)) {
            Edge e;
            node.flag = false;
            if (node.getParent() != null) {
                this.setChildCount(node.getParent(), this.getChildCount(node.getParent()) + 1);
            }
            sR.remove(node);
            int i = 0;
            while (i < node.incoming.size()) {
                e = node.incoming.getEdge(i);
                this.restoreEdge(e);
                ++i;
            }
            i = 0;
            while (i < node.outgoing.size()) {
                e = node.outgoing.getEdge(i);
                this.restoreEdge(e);
                ++i;
            }
        }
        if (node instanceof Subgraph) {
            Subgraph s = (Subgraph)node;
            int i = 0;
            while (i < s.members.size()) {
                Node member = s.members.getNode(i);
                this.restoreSinks(member, sR);
                ++i;
            }
        }
    }

    private void restoreSources(Node node) {
        if (node.flag && this.sL.contains(node)) {
            Edge e;
            node.flag = false;
            if (node.getParent() != null) {
                this.setChildCount(node.getParent(), this.getChildCount(node.getParent()) + 1);
            }
            this.sL.remove(node);
            int i = 0;
            while (i < node.incoming.size()) {
                e = node.incoming.getEdge(i);
                this.restoreEdge(e);
                ++i;
            }
            i = 0;
            while (i < node.outgoing.size()) {
                e = node.outgoing.getEdge(i);
                this.restoreEdge(e);
                ++i;
            }
        }
        if (node instanceof Subgraph) {
            Subgraph s = (Subgraph)node;
            int i = 0;
            while (i < s.members.size()) {
                Node member = s.members.getNode(i);
                this.restoreSources(member);
                ++i;
            }
        }
    }

    public void revisit(DirectedGraph g) {
        int i = 0;
        while (i < g.edges.size()) {
            Edge e = g.edges.getEdge(i);
            if (e.isFeedback) {
                e.invert();
            }
            ++i;
        }
    }

    private void setChildCount(Node n, int count) {
        n.workingInts[3] = count;
    }

    private void setInDegree(Node n, int deg) {
        n.workingInts[1] = deg;
    }

    private void setOrderIndex(Node n, int index) {
        n.workingInts[0] = index;
    }

    private void setOutDegree(Node n, int deg) {
        n.workingInts[2] = deg;
    }

    public void visit(DirectedGraph g) {
        this.initializeDegrees(g);
        this.graphNodes = g.nodes;
        NodeList roots = new NodeList();
        int i = 0;
        while (i < this.graphNodes.size()) {
            if (this.graphNodes.getNode(i).getParent() == null) {
                roots.add(this.graphNodes.getNode(i));
            }
            ++i;
        }
        this.buildNestingTreeIndices(roots, 0);
        this.removeParentChildEdges(g);
        this.cycleRemove(roots);
        this.invertEdges(g);
    }
}

