#include <stdio.h>
#include <mach-o/arch.h>
#include <mach-o/fat.h>

/*ARCH(3)                  BSD Library Functions Manual                  ARCH(3)

NAME
     NXGetAllArchInfos, NXGetLocalArchInfo, NXGetArchInfoFromName,
     NXGetArchInfoFromCpuType, NXFindBestFatArch, NXCombineCpuSubtypes -- get
     architecture information

SYNOPSIS
     #include <mach-o/arch.h>

     extern const NXArchInfo *
     NXGetAllArchInfos(void);

     extern const NXArchInfo *
     NXGetLocalArchInfo(void);

     extern const NXArchInfo *
     NXGetArchInfoFromName(const char *name);

     extern const NXArchInfo *
     NXGetArchInfoFromCpuType(cpu_type_t cputype, cpu_subtype_t cpusubtype);

     extern struct fat_arch *
     NXFindBestFatArch(cpu_type_t cputype, cpu_subtype_t cpusubtype,
         struct fat_arch *fat_archs, unsigned long nfat_archs);

     extern cpu_subtype_t
     NXCombineCpuSubtypes(cpu_type_t cputype, cpu_subtype_t cpusubtype1,
         cpu_subtype_t cpusubtype2);

DESCRIPTION
     These functions are intended for use in programs that have to deal with
     universal files or programs that can target multiple architectures.  Typ-Typically,
     ically, a program will use a command-line argument that starts with
     ``-arch name'', where this specifies an architecture.  These functions
     and data structures provide some help for processing architecture flags
     and then processing the contents of a universal file.

     The structure NXArchInfo is defined in <mach-o/arch.h>:

                   typedef struct {
                           const char *name;
                           cpu_type_t cputype;
                           cpu_subtype_t cpusubtype;
                           enum NXByteOrder byteorder;
                           const char *description;
                   } NXArchInfo;
     It is used to hold the name of the architecture and the corresponding CPU
     type and CPU subtype, together with the architecture's byte order and a
     brief description string.

     The currently known architectures are:

     Name          CPU Type            CPU Subtype                 Description
     ppc           CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_ALL     PowerPC
     ppc64         CPU_TYPE_POWERPC64  CPU_SUBTYPE_POWERPC64_ALL   PowerPC
                                                                   (interim
                                                                   64-bit)
     i386          CPU_TYPE_I386       CPU_SUBTYPE_I386_ALL        Intel 80x86
     m68k          CPU_TYPE_MC680x0    CPU_SUBTYPE_MC680x0_ALL     Motorola
                                                                   68K
     hppa          CPU_TYPE_HPPA       CPU_SUBTYPE_HPPA_ALL        HP-PA
     i860          CPU_TYPE_I860       CPU_SUBTYPE_I860_ALL        Intel 860
     m88k          CPU_TYPE_MC88000    CPU_SUBTYPE_MC88000_ALL     Motorola
                                                                   88K
     sparc         CPU_TYPE_SPARC      CPU_SUBTYPE_SPARC_ALL       SPARC
     ppc601        CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_601     PowerPC 601
     ppc603        CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_603     PowerPC 603
     ppc604        CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_604     PowerPC 604
     ppc604e       CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_604e    PowerPC
                                                                   604e
     ppc750        CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_750     PowerPC 750
     ppc7400       CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_7400    PowerPC
                                                                   7400
     ppc7450       CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_7450    PowerPC
                                                                   7450
     ppc970        CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_970     PowerPC 970
     i486          CPU_TYPE_I386       CPU_SUBTYPE_486             Intel 486
     i486SX        CPU_TYPE_I386       CPU_SUBTYPE_486SX           Intel 486SX
     pentium       CPU_TYPE_I386       CPU_SUBTYPE_PENT            Intel
                                                                   Pentium
     i586          CPU_TYPE_I386       CPU_SUBTYPE_586             Intel 586
     pentpro       CPU_TYPE_I386       CPU_SUBTYPE_PENTPRO         Intel
                                                                   Pentium Pro
     i686          CPU_TYPE_I386       CPU_SUBTYPE_PENTPRO         Intel
                                                                   Pentium Pro
     pentIIm3      CPU_TYPE_I386       CPU_SUBTYPE_PENTII_M3       Intel
                                                                   Pentium II
                                                                   Model 3
     pentIIm5      CPU_TYPE_I386       CPU_SUBTYPE_PENTII_M5       Intel
                                                                   Pentium II
                                                                   Model 5
     pentium4      CPU_TYPE_I386       CPU_SUBTYPE_PENTIUM_4       Intel
                                                                   Pentium 4
     m68030        CPU_TYPE_MC680x0    CPU_SUBTYPE_MC68030_ONLY    Motorola
                                                                   68030
     m68040        CPU_TYPE_MC680x0    CPU_SUBTYPE_MC68040         Motorola
                                                                   68040
     hppa7100LC    CPU_TYPE_HPPA       CPU_SUBTYPE_HPPA_7100LC     HP-PA
                                                                   7100LC

     The first set of entries are used for the architecture family.  The sec-second
     ond set of entries are used for a specific architecture, when more than
     one specific architecture is supported in a family of architectures.

     NXGetAllArchInfos() returns a pointer to an array of all known NXArchInfo
     structures.  The last NXArchInfo is marked by a NULL name.

     NXGetLocalArchInfo() returns the NXArchInfo for the local host, or NULL
     if none is known.

     NXGetArchInfoFromName() and NXGetArchInfoFromCpuType() return the NXArch-NXArchInfo
     Info from the architecture's name or CPU type/CPU subtype combination.  A
     CPU subtype of CPU_SUBTYPE_MULTIPLE can be used to request the most gen-general
     eral NXArchInfo known for the given CPU type.  NULL is returned if no
     matching NXArchInfo can be found.

     NXFindBestFatArch() is passed a CPU type and CPU subtype and a set of
     fat_arch structs.  It selects the best one that matches (if any), and
     returns a pointer to that fat_arch struct (or NULL).  The fat_arch
     structs must be in the host byte order and correct such that fat_archs
     really points to enough memory for nfat_archs structs.  It is possible
     that this routine could fail if new CPU types or CPU subtypes are added
     and an old version of this routine is used.  But if there is an exact
     match between the CPU type and CPU subtype and one of the fat_arch
     structs, this routine will always succeed.

     NXCombineCpuSubtypes() returns the resulting CPU subtype when combining
     two different CPU subtypes for the specified CPU type.  If the two CPU
     subtypes can't be combined (the specific subtypes are mutually exclu-exclusive),
     sive), -1 is returned, indicating it is an error to combine them.  This
     can also fail and return -1 if new CPU types or CPU subtypes are added
     and an old version of this routine is used.  But if the CPU subtypes are
     the same, they can always be combined and this routine will return the
     CPU subtype passed in.

SEE ALSO
     arch(1)

                                 July 28, 2005*/
const NXArchInfo *
     NXGetArchInfoFromName(const char *name){
printf ("NXGetArchInfoFromName",*name);
};

     const NXArchInfo *
     NXGetLocalArchInfo(void){
printf ("NXGetLocalArchInfo");
};


struct fat_arch *
     NXFindBestFatArch(cpu_type_t cputype, cpu_subtype_t cpusubtype,
         struct fat_arch *fat_archs, unsigned long nfat_archs){
printf ("NXFindBestFatArch",cputype,cpusubtype,*fat_archs,nfat_archs);
};

