#include <stdio.h>
#include <libkern/c++/OSMetaClass.h>

/*OSMetaClass(const char *, const OSMetaClass *, unsigned int)


Constructor for OSMetaClass objects. 
protected

OSMetaClass(
    const char *inClassName, 
    const OSMetaClass *inSuperClass, 
    unsigned int inClassSize); 
Parameters
inClassName
C string of the name of the class this metaclass represents.
inSuperClassName
C string of the name of the super class.
inClassSize
size of the class.
Discussion 

This constructor is protected and cannot be used to instantiate an OSMetaClass object, i.e. OSMetaClass is an abstract class. This function stores the currently constructing OSMetaClass instance away for later processing. See preModLoad and postModLoad.*/
OSMetaClass ::OSMetaClass(
    const char *inClassName, 
    const OSMetaClass *inSuperClass, 
    unsigned int inClassSize){
printf ("OSMetaClass",*inClassName,*inSuperClass,inClassSize);
}; 

/*instanceConstructed


Counts the instances of the class behind this metaclass. 
public

void instanceConstructed() const; 
Discussion 

Every non-abstract class that inherits from OSObject has a default constructor that calls its own metaclass's instanceConstructed function. This constructor is defined by the OSDefineMetaClassAndStructors macro (qv) that all OSObject subclasses must use. Also, if the instance count goes from 0 to 1, i.e. the first instance, then increment the instance count of the super class.*/
void OSMetaClass :: instanceConstructed() const{
printf ("instanceConstructed");
}; 

 static OSMetaClassBase::  OSMetaClassBase * 
    safeMetaCast(const OSMetaClassBase *me, const OSMetaClass *toType){
printf ("safeMetaCast",*me,*toType);
};
