#include <QuickTime/QuickTime.h>

//work

/*RTPMPFlush

Renamed RTPMPReset.

ComponentResult RTPMPFlush (
   RTPMediaPacketizer    rtpm,
   SInt32                inFlags,
   SInt32                *outFlags );
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPMPFlush (
   RTPMediaPacketizer    rtpm,
   SInt32                inFlags,
   SInt32                *outFlags ){};


/*RTPPBBeginPacketGroup

Tells a packet builder to create a new packet group.

ComponentResult RTPPBBeginPacketGroup (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   UInt32               inTimeStamp,
   RTPPacketGroupRef    *outPacketGroup );
Parameters
rtpb

The component instance of the packet builder component.
inFlags

A signed 32-bit integer containing any flags you are passing. There are currently no defined flags.
inTimeStamp

A unsigned 32-bit integer containing the time stamp for this packet group.
outPacketGroup

On return, contains a pointer to a reference to the packet group. Use this data reference when creating a new packet or inserting data into a packet that belongs to this group.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

A media packetizer creates a packet group using this function. The data reference returned by this function is then used to create a series of packets that belong to this group. The data reference is also required when inserting data into packets.
Special Considerations

When the packet group is complete, call RTPPBEndPacketGroup.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPPBBeginPacketGroup (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   UInt32               inTimeStamp,
   RTPPacketGroupRef    *outPacketGroup ){};


/*RTPRssmReset

Called to reset all packet reassembler and base reassembler variables for a new run of data.

ComponentResult RTPRssmReset (
   RTPReassembler    rtpr,
   SInt32            inFlags );
Parameters
rtpr

The component instance of your reassembler.
inFlags

A signed 32-bit integer containing any flags being passed. No flags are currently defined.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function differs from RTPRssmClearCachedPackets, which disposes of the packets but still retains the last sequence number and related information; this function resets all variables as if the reassembler were just opened.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmReset (
   RTPReassembler    rtpr,
   SInt32            inFlags ){};


/*RTPRssmGetInfo

Obtains information about your packet reassembler.

ComponentResult RTPRssmGetInfo (
   RTPReassembler    rtpr,
   OSType            inSelector,
   void              *ioParams );
Parameters
rtpr

The component instance of your packet reassembler.
inSelector

A selector (see below) for the information desired. See these constants: 
kQTSSourceTrackIDInfo
kQTSSourceLayerInfo
kQTSSourceLanguageInfo
kQTSSourceTrackFlagsInfo
kQTSSourceDimensionsInfo
kQTSSourceVolumesInfo
kQTSSourceMatrixInfo
kQTSSourceClipRectInfo
kQTSSourceGraphicsModeInfo
kQTSSourceScaleInfo
kQTSSourceBoundingRectInfo
kQTSSourceUserDataInfo
kQTSSourceInputMapInfo
ioParams

A pointer to a data structure appropriate for the type of data requested (see below) . If your component understands the selector, write the requested information into the data structure this parameter points to.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Implement this function only for the selectors you understand. Delegate this function to the base reassembler for any other selectors. The base reassembler will correctly return an error if it doesn't understand the selector either.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/

ComponentResult RTPRssmGetInfo (
   RTPReassembler    rtpr,
   OSType            inSelector,
   void              *ioParams ){};



/*RTPPBAddPacketLiteralData

Passes literal data directly to a packet builder component.

ComponentResult RTPPBAddPacketLiteralData (
   RTPPacketBuilder            rtpb,
   SInt32                      inFlags,
   RTPPacketGroupRef           inPacketGroup,
   RTPPacketRef                inPacket,
   UInt8                       *inData,
   UInt32                      inDataLength,
   RTPPacketRepeatedDataRef    *outDataRef );
Parameters
rtpb

The component instance of the packet builder component.
inFlags

A signed 32-bit integer containing any flags you are passing. There are currently no defined flags.
inPacketGroup

The packet group containing the packet into which the data will be placed. This is normally a reference returned by RTPPBBeginPacketGroup.
inPacket

The RTP packet into which the data will be placed. This is normally a reference returned by RTPPBBeginPacket.
inData

A pointer to the data you are passing.
inDataLength

An unsigned 32-bit integer containing the length, in bytes, of the data you are passing.
outDataRef

On return, contains a pointer to a data reference. Use this reference if you wish to later tell the packet builder to use this same data again, without having to literally pass the data again. Pass in NIL if you do not need the packet builder to repeat the data. If you do not pass in NIL, you must dispose of the data explicitly by calling RTPPBReleaseRepeatedData.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function will return a reference which can be used to specify the same data repeatedly without having to pass in the data again. This is done by calling RTPPBAddPacketRepeatedData with the reference which was returned by this function. For example, you can use this function to insert static header information into a packet prior to inserting media sample data. It will return a data reference you can use to insert the same static information into later packets.
Special Considerations

To specify media data to be placed in a packet, a media packetizer should call RTPPBAddPacketSampleData.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPPBAddPacketLiteralData (
   RTPPacketBuilder            rtpb,
   SInt32                      inFlags,
   RTPPacketGroupRef           inPacketGroup,
   RTPPacketRef                inPacket,
   UInt8                       *inData,
   UInt32                      inDataLength,
   RTPPacketRepeatedDataRef    *outDataRef ){};



/*RTPPBAddPacketSampleData

Commands a packet builder component to insert media sample data into a packet.

ComponentResult RTPPBAddPacketSampleData (
   RTPPacketBuilder            rtpb,
   SInt32                      inFlags,
   RTPPacketGroupRef           inPacketGroup,
   RTPPacketRef                inPacket,
   RTPMPSampleDataParams       *inSampleDataParams,
   UInt32                      inSampleOffset,
   UInt32                      inSampleDataLength,
   RTPPacketRepeatedDataRef    *outDataRef );
Parameters
rtpb

The component instance of the packet builder component.
inFlags

A signed 32-bit integer containing any flags you are passing. There are currently no defined flags.
inPacketGroup

The packet group containing the packet into which the data will be placed. This is normally a reference returned by RTPPBBeginPacketGroup.
inPacket

The RTP packet into which the data will be placed. This is normally a reference returned by RTPPBBeginPacket.
inSampleDataParams

A pointer to a RTPMPSampleDataParams structure for the sample data you are inserting.
inSampleOffset

A 32-bit unsigned integer containing the offset into the sample media, in bytes.
inSampleDataLength

A 32-bit unsigned integer specifying the number of bytes of media sample data to insert into the packet.
outDataRef

On return, contains a pointer to a data reference. Use this reference if you wish to later tell the packet builder to use this same sample data again, without having to literally pass the data again. Pass in NIL if you do not need the packet builder to repeat the data. If you do not pass in NIL , you must dispose of the data explicitly by calling RTPPBReleaseRepeatedData.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function will return a reference which can be used to specify the same data repeatedly without having to pass in the data again. The media packetizer specifies the offset into the media and the length of the sample to insert. You can insert data repeatedly by calling RTPPBAddPacketRepeatedData with the reference which was returned by RTPPBAddPacketLiteralData.
Special Considerations

When a reference is no longer needed, it should be disposed of by using the call RTPPBReleaseRepeatedData.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPPBAddPacketSampleData (
   RTPPacketBuilder            rtpb,
   SInt32                      inFlags,
   RTPPacketGroupRef           inPacketGroup,
   RTPPacketRef                inPacket,
   RTPMPSampleDataParams       *inSampleDataParams,
   UInt32                      inSampleOffset,
   UInt32                      inSampleDataLength,
   RTPPacketRepeatedDataRef    *outDataRef ){};


/*RTPRssmHasCharacteristic

Determines what features your reassembler supports.

ComponentResult RTPRssmHasCharacteristic (
   RTPReassembler    rtpr,
   OSType            inCharacteristic,
   Boolean           *outHasIt );
Parameters
rtpr

The component instance of your packet reassembler.
inCharacteristic

A constant that defines the characteristic being tested.
outHasIt

A pointer to a Boolean value that is TRUE if your packet reassembler has the characteristic, FALSE otherwise.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmHasCharacteristic (
   RTPReassembler    rtpr,
   OSType            inCharacteristic,
   Boolean           *outHasIt ){};


/*RTPRssmDecrChunkRefCount

Tells the base reassembler to dispose of a chunk that it has created or preserved for you.

ComponentResult RTPRssmDecrChunkRefCount (
   RTPReassembler    rtpr,
   SHChunkRecord     *inChunk );
Parameters
rtpr

The component instance of the base reassembler component.
inChunk

A pointer to the chunk record to dispose.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

If you have overridden RTPRssmSendPacketList behavior, and are instructing the base reassembler to construct chunks manually, your packet assembler must explicitly dispose of the chunks by calling either this function or RTPRssmSendChunkAndDecrRefCount. This function is also used to release a chunk you have preserved using RTPRssmIncrChunkRefCount.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmDecrChunkRefCount (
   RTPReassembler    rtpr,
   SHChunkRecord     *inChunk ){};



/*RTPRssmSendPacketList

Called when the base reassembler is ready to send a sample or chunk based on a list of packets.

ComponentResult RTPRssmSendPacketList (
   RTPReassembler       rtpr,
   RTPRssmPacket        *inPacketListHead,
   const TimeValue64    *inLastChunkPresentationTime,
   SInt32               inFlags );
Parameters
rtpr

The component instance of your packet reassembler.
inPacketListHead

A pointer to the packet list.
inLastChunkPresentationTime

A pointer to a time value which specifies when to present this chunk, in units of the stream's time scale.
inFlags

A signed 32-bit integer containing any flags being passed (see below). See these constants: 
kRTPRssmLostSomePackets
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Implement this call if your packet reassembler needs to modify the packet list, or if it overrides the default handling of packet loss. If you do not implement this call, the base reassembler will adjust the packet parameters on all packets in the list, compute the chunk size, and send the chunk. If packet loss has occurred, all the packets will be discarded and the stream handler will be informed that the chunk has been lost.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmSendPacketList (
   RTPReassembler       rtpr,
   RTPRssmPacket        *inPacketListHead,
   const TimeValue64    *inLastChunkPresentationTime,
   SInt32               inFlags ){};



/*RTPRssmSetSampleDescription

Changes the SampleDescription structure being used by the stream handler; all subsequent samples will be marked with this new structure.

ComponentResult RTPRssmSetSampleDescription (
   RTPReassembler             rtpr,
   SampleDescriptionHandle    inSampleDescription );
Parameters
rtpr

The component instance of the base reassembler.
inSampleDescription

The handle of a SampleDescription structure to use. You are responsible for keeping the handle and the data structure valid during subsequent operations.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The SampleDescription structure is not passed on a per-packet basis, but a per-sample basis, so the SampleDescription structure should not be changed until a complete sample (sometimes called a "frame" or "chunk") has been reassembled.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmSetSampleDescription (
   RTPReassembler             rtpr,
   SampleDescriptionHandle    inSampleDescription ){};



/*RTPRssmNewStreamHandler

Opens a new stream handler and closes any currently-open stream handler.

ComponentResult RTPRssmNewStreamHandler (
   RTPReassembler             rtpr,
   OSType                     inSHType,
   SampleDescriptionHandle    inSampleDescription,
   TimeScale                  inSHTimeScale,
   ComponentInstance          *outHandler );
Parameters
rtpr

The component instance of the base reassembler.
inSHType

The stream handler type.
inSampleDescription

A handle to a SampleDescription structure appropriate for this media type. Pass in NIL if you don't know the media type yet. This structure is passed by reference; the caller is responsible for maintaining it.
inSHTimeScale

The time scale for the stream handler to use. Pass in 0 if the time scale is not yet known.
outHandler

On return, contains a pointer to the component instance of the stream handler that has been opened.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You must pass in a valid SampleDescription structure and time scale before the stream handler can process packets. If you do not pass them as part of this function, do so using RTPRssmSetTimeScale and RTPRssmSetSampleDescription.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmNewStreamHandler (
   RTPReassembler             rtpr,
   OSType                     inSHType,
   SampleDescriptionHandle    inSampleDescription,
   TimeScale                  inSHTimeScale,
   ComponentInstance          *outHandler ){};

/*RTPRssmInitialize

Called when the base reassembler is ready to have your packet reassembler begin handling media packets.

ComponentResult RTPRssmInitialize (
   RTPReassembler       rtpr,
   RTPRssmInitParams    *inInitParams );
Parameters
rtpr

The component instance of your packet reassembler
inInitParams

A pointer to an RTPRssmInitParams structure. Use the information contained in this structure to initialize your component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is not called when the base reassembler opens your component for payload registration information.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/

ComponentResult RTPRssmInitialize (
   RTPReassembler       rtpr,
   RTPRssmInitParams    *inInitParams ){};


/*RTPRssmSetCapabilities

Sets the capabilities of a streaming packet reassembler.

ComponentResult RTPRssmSetCapabilities (
   RTPReassembler    rtpr,
   SInt32            inFlags,
   SInt32            inFlagsMask );
Parameters
rtpr

The component instance of the base reassembler.
inFlags

A signed 32-bit integer containing the logical OR of all the flags (see below) you are setting. See these constants: 
kRTPRssmEveryPacketAChunkFlag
kRTPRssmQueueAndUseMarkerBitFlag
kRTPRssmTrackLostPacketsFlag
kRTPRssmNoReorderingRequiredFlag
inFlagsMask

Use this field to preserve the state of any flags you do not wish to alter. If a flag (see below) is set in this field, and is not set in the inFlags field, it will not be changed from its current setting.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your packet reassembler can call this function at any time.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmSetCapabilities (
   RTPReassembler    rtpr,
   SInt32            inFlags,
   SInt32            inFlagsMask ){};


/*RTPRssmIncrChunkRefCount

Tells the base reassembler to keep a copy of the most recent chunk after it has been sent.

ComponentResult RTPRssmIncrChunkRefCount (
   RTPReassembler    rtpr,
   SHChunkRecord     *inChunk );
Parameters
rtpr

The component instance of the base reassembler.
inChunk

A pointer to the chunk record you want to preserve.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is used to assist in loss recovery, for example. You must call RTPRssmDecrChunkRefCount to release the chunk when you no longer need it.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmIncrChunkRefCount (
   RTPReassembler    rtpr,
   SHChunkRecord     *inChunk ){};

/*RTPMPHasCharacteristic

Determines whether a media packetizer has a particular characteristic, such as whether it supports a user settings dialog.

ComponentResult RTPMPHasCharacteristic (
   RTPMediaPacketizer    rtpm,
   OSType                inSelector,
   Boolean               *outHasIt );
Parameters
rtpm

The component instance of the media packetizer.
inSelector

A selector for the characteristic you want to know about. See these constants: 
kRTPMPNoSampleDataRequiredCharacteristic
kRTPMPHasUserSettingsDialogCharacteristic
kRTPMPPrefersReliableTransportCharacteristic
kRTPMPRequiresOutOfBandDimensionsCharacteristic
outHasIt

On return, contains a Boolean value that is TRUE if the media packetizer has this characteristic, FALSE otherwise.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/

ComponentResult RTPMPHasCharacteristic (
   RTPMediaPacketizer    rtpm,
   OSType                inSelector,
   Boolean               *outHasIt ){};

/*RTPMPGetInfo

Obtains information of various types from a media packetizer.

ComponentResult RTPMPGetInfo (
   RTPMediaPacketizer    rtpm,
   OSType                inSelector,
   void                  *ioParams );
Parameters
rtpm

The component instance of the media packetizer you want information from.
inSelector

The selector for the type information you want (see below). See these constants: 
kRTPMPPayloadTypeInfo
kRTPMPRTPTimeScaleInfo
kRTPMPRequiredSampleDescriptionInfo
kRTPMPMinPayloadSize
kRTPMPMinPacketDuration
kRTPMPSuggestedRepeatPktCountInfo
ioParams

A pointer to a data structure of the appropriate type to hold the information you are requesting. You need to allocate and dispose of this data structure.
Return Value

See Error Codes. Returns qtsBadSelectorErr if inSelector requests a selector you do not support. Returns noErr if there is no error.
Discussion

This function can be called at any time.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPMPGetInfo (
   RTPMediaPacketizer    rtpm,
   OSType                inSelector,
   void                  *ioParams ){};



/*RTPMPReset

Allows a media packetizer to stop packetizing its current input, set its state to idle, and flush its input buffer.

ComponentResult RTPMPReset (
   RTPMediaPacketizer    rtpm,
   SInt32                inFlags );
Parameters
rtpm

The component instance of the media packetizer.
inFlags

A signed 32-bit integer containing any flags you are passing to the media packetizer. There are currently no defined flags.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You can use this function to stop the media packetizer and flush its input buffer when you wish to stop transmitting immediately, when you are skipping forward or backward in the stream, or if the network data connection is interrupted.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPMPReset (
   RTPMediaPacketizer    rtpm,
   SInt32                inFlags ){};

/*RTPPBEndPacketGroup

Tells a packet builder component that a packet group is complete.

ComponentResult RTPPBEndPacketGroup (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   RTPPacketGroupRef    inPacketGroup );
Parameters
rtpb

The component instance of the packet builder component.
inFlags

A signed 32-bit integer containing any flags you are passing. There are currently no defined flags.
inPacketGroup

A data reference to the packet group being ended. This is normally a data reference returned by RTPPBBeginPacketGroup.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function should be called when all the packets in a group are complete and the media packetizer is ready either to create a new packet group or to terminate the stream.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPPBEndPacketGroup (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   RTPPacketGroupRef    inPacketGroup ){};



/*RTPMPInitialize

Initializes a media packetizer component.

ComponentResult RTPMPInitialize (
   RTPMediaPacketizer    rtpm,
   SInt32                inFlags );
Parameters
rtpm

The component instance of the media packetizer.
inFlags

A signed 32-bit integer containing the flags (see below) you wish to pass to the packetizer at start-up. See these constants: 
kRTPMPRealtimeModeFlag
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The calling component must call this function before sending any data to a media packetizer or making any RTPMPSet calls. The calling component then calls RTPMPSetSampleData and RTPMPIdle repeatedly. The calling component passes sample data (obtained, for example, from GetMediaSample), to the media packetizer by calling RTPMPSetSampleData. If RTPMPSetSampleData or RTPMPIdle return the flag kRTPMPStillProcessingData, then the calling component should call RTPMPIdle; if not, it is free to call RTPMPSetSampleData again.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/

ComponentResult RTPMPInitialize (
   RTPMediaPacketizer    rtpm,
   SInt32                inFlags ){};


/*RTPPBBeginPacket

Tells a packet builder to create a new packet.

ComponentResult RTPPBBeginPacket (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   RTPPacketGroupRef    inPacketGroup,
   UInt32               inPacketMediaDataLength,
   RTPPacketRef         *outPacket );
Parameters
rtpb

The component instance of the packet builder component.
inFlags

A signed 32-bit integer containing any flags you are passing. There are currently no defined flags.
inPacketGroup

The packet group containing the new packet. This is normally a reference returned by RTPPBBeginPacketGroup.
inPacketMediaDataLength

An unsigned 32-bit integer specifying the maximum length of data that will be inserted into this packet. This includes the data for all subsequent RTPPBAddPacketLiteralData, RTPPBAddPacketSampleData, and RTPPBAddPacketRepeatedData calls until the packet is closed. The value of this parameter may be larger, but must not be smaller, than the amount of data inserted in the packet.
outPacket

On return, contains a pointer to the packet. Use this reference to insert data into the packet.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The media packetizer uses this function to create each new packet, before inserting any literal, repeated, or sample data. A call to RTPPBBeginPacketGroup must be made before creating the first packet in a group. Data can be inserted into the packet using RTPPBAddPacketLiteralData, RTPPBAddPacketRepeatedData, or RTPPBAddPacketSampleData. When the packet is complete, call RTPPBEndPacket.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPPBBeginPacket (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   RTPPacketGroupRef    inPacketGroup,
   UInt32               inPacketMediaDataLength,
   RTPPacketRef         *outPacket ){};




/*RTPPBEndPacket

Tells a packet builder that a packet is complete.

ComponentResult RTPPBEndPacket (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   RTPPacketGroupRef    inPacketGroup,
   RTPPacketRef         inPacket,
   UInt32               inTransmissionTimeOffset,
   UInt32               inDuration );
Parameters
rtpb

The component instance of the packet builder component.
inFlags

A signed 32-bit integer containing any flags you are passing. There are currently no defined flags.
inPacketGroup

The packet group containing the new packet. This is normally a reference returned by RTPPBBeginPacketGroup.
inPacket

The RTP packet containing the data. This is normally a reference returned by RTPPBBeginPacket.
inTransmissionTimeOffset

The time offset at which the media sample data contained in this packet begins, in milliseconds. This offset is added to the RTP transmission time to determine when to send the packet.
inDuration

The duration of this packet, specified in milliseconds.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Call this function once when each packet is complete.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/

ComponentResult RTPPBEndPacket (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   RTPPacketGroupRef    inPacketGroup,
   RTPPacketRef         inPacket,
   UInt32               inTransmissionTimeOffset,
   UInt32               inDuration ){};












