#include <QD/PictUtils.h>


/*GetPictInfo

Gathers information about a single picture. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

OSErr GetPictInfo (
   PicHandle thePictHandle,
   PictInfo * thePictInfo,
   short verb,
   short colorsRequested,
   short colorPickMethod,
   short version
);
Parameters
thePictHandle

A handle to a picture. 
thePictInfo

On return, a pointer to a PictInfo structure, which holds information about the picture. Initially, all of the fields in the new PictInfo structure are set to NULL. Relevant fields are set to appropriate values depending on the information you request using the GetPictInfo function.

This function collects information from black-and-white pictures and bitmaps, and is supported in System 7 even by computers running only basic QuickDraw. However, when collecting color information on a computer running only basic QuickDraw, the function returns NULL instead of a handle to a Palette or ColorTable structure.

verb

A value indicating what type of information you want GetPictInfo to return in the PictInfo structure. See “Color Information Type” for a description of the values you can use in this parameter.

You can specify whether you want color information (in a ColorTable structure, a Palette structure, or both), whether you want picture comment information, and whether you want font information. If you want color information, be sure to use the colorPickMethod parameter to specify the method by which to select colors.

Because the Palette Manager adds black and white when creating a Palette structure, you can specify the number of colors you want minus 2 in the colorsRequested parameter and specify the suppressBlackAndWhite constant in the verb parameter when gathering colors destined for a Palette structure or a screen.

colorsRequested

From 1 to 256, the number of colors you want in the ColorTable or Palette structure returned via the PictInfo structure. If you are not requesting colors (that is, if you pass the recordComments or recordFontInfo constant in the verb parameter), specify 0 in this parameter.
colorPickMethod

The method by which colors are selected for the ColorTable or Palette structure returned via the PictInfo structure. See “Color Selection Method” for a description of the values you can use here.

You can also create your own color-picking method in a resource file of type 'cpmt' and pass its resource ID in the colorPickMethod parameter. The resource ID must be greater than 127.
version

Always set this parameter to 0.
Return Value

A result code. See “Picture Utilities Result Codes”.
Discussion

The Picture Utilities provide two color-picking methods: one (specified by the popularMethod constant) that gives you the most frequently used colors and one (specified by the medianMethod constant) that gives you the widest range of colors. Each has advantages in different situations. For example, suppose the picture of a forest image contains 400 colors, of which 300 are greens, 80 are browns, and the rest are a scattering of golden sunlight effects. If you ask for the 250 most used colors, you will probably receive all greens. If you ask for a range of 250 colors, you will receive an assortment stretching from the greens and golds to the browns, including colors in between that might not actually appear in the image. If you specify the systemMethod constant, the Picture Utilities choose the method; currently they always choose popularMethod. You can also supply a color-picking method of your own.

If your application uses more than one color-picking method, it should present the user with a choice of which method to use.

When you are finished with the information in the PictInfo structure, use the Memory Manager function DisposeHandle to dispose of the PictInfo, CommentSpec, and FontSpec structures. Dispose of the Palette structure by using the DisposePalette function. Dispose of the ColorTable structure by using the DisposeCTable function. 
Special Considerations

Because Quartz 2D uses an entirely different approach to graphics than used by QuickDraw, there is no one-to-one correlation between QuickDraw and Quartz 2D functions. However, because Quartz offers many new features and improved performance compared to QuickDraw, it is worthwhile making the effort to convert your graphics code to Quartz.

When you ask for color information, GetPictInfo takes into account only the version 2 and extended version 2 picture opcodes RGBFgCol, RGBBkCol, BkPixPat, PnPixPat, FillPixPat, HiliteColor and pixel map or bitmap data. Each occurrence of these opcodes is treated as 1 pixel, regardless of the number and sizes of the objects drawn with that color. If you need an accurate set of colors from a complex picture, create an image of the picture in an offscreen pixel map, and then call the GetPixMapInfo function to obtain color information about that pixel map.

The GetPictInfo function returns a bit depth of 1 on QuickTime-compressed 'PICT' files. However, when QuickTime is installed, QuickTime decompresses and displays the image correctly.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
PictUtils.h*/
OSErr GetPictInfo (
   PicHandle thePictHandle,
   PictInfo * thePictInfo,
   short verb,
   short colorsRequested,
   short colorPickMethod,
   short version
){};


