#import <PDFKit/PDFView.h>
//work
@implementation PDFView
/*drawPage:

For use by subclasses of PDFView for custom rendering of pages.

- (void)drawPage:(PDFPage *)page
Discussion

Do not invoke this method, except by invoking it on super from a subclass.

The PDFView class calls drawPage: as necessary for each visible page that requires rendering. In the PDFView class, this method erases page to white, calls [page drawInRect: pageRect withBox: [self displayBox]] , and then draws the selection, if any.

You can override this method to draw on top of a PDF page or to control how pages are drawn. In these cases, invoke this method on super and then perform custom drawing on top of the PDF page.
Availability
Available in Mac OS X v10.4 and later.*/
- (void)drawPage:(PDFPage *)page{}


/*displayBox

Returns the current style of display box.

- (PDFDisplayBox)displayBox
Discussion

The available values for display boxes are defined in the “Constants” section in the PDFPage class.
Availability
Available in Mac OS X v10.4 and later.
See Also
– setDisplayBox:*/
- (PDFDisplayBox)displayBox{}


/*setDocument:

Associates a document with a PDF View object.

- (void)setDocument:(PDFDocument *)document
Discussion

If a document was already associated with the view, it is released first and then document is associated with the view.
Availability
Available in Mac OS X v10.4 and later.
See Also
– document*/
- (void)setDocument:(PDFDocument *)document{}


/*setAutoScales:

Toggles whether or not the scaling factor applied to a view automatically responds to resizing.

- (void)setAutoScales:(BOOL)newAuto
Discussion

When set to autoscaling, the document scales to fill the PDFView as the user resizes it.

For the single-page and two-up continuous modes, autoscaling fits the page to the width of the view. For single-page and two-up noncontinuous modes, autoscaling provides best fit, in which the viewed pages are as large as possible while displaying in their entirety within the PDF view.
Availability
Available in Mac OS X v10.4 and later.
See Also
– autoScales*/
- (void)setAutoScales:(BOOL)newAuto{}


/*setDisplaysPageBreaks:

Toggles the display of page breaks.

- (void)setDisplaysPageBreaks:(BOOL)breaks
Availability
Available in Mac OS X v10.4 and later.
See Also
– displaysPageBreaks*/
- (void)setDisplaysPageBreaks:(BOOL)breaks{}

/*document

Gets the document associated with a PDF View object.

- (PDFDocument *)document
Availability
Available in Mac OS X v10.4 and later.
See Also
– setDocument:*/
- (PDFDocument *)document{}


/*convertRect:fromPage:

Converts a rectangle from page space to view space.

- (NSRect)convertRect:(NSRect)rect fromPage:(PDFPage *)page
Discussion

Page space is a 72 dpi coordinate system with the origin at the lower-left corner of the current page. View space is a coordinate system with the origin at the lower-left corner of the current PDF view.
Availability
Available in Mac OS X v10.4 and later.
See Also
– convertPoint:toPage:
– convertRect:toPage:
– convertPoint:fromPage:*/
- (NSRect)convertRect:(NSRect)rect fromPage:(PDFPage *)page{}


/*goToDestination:

Navigates to the specified destination.

- (void)goToDestination:(PDFDestination *)destination
Discussion

Destinations include a page and a point on the page specified in page space.

Page space is a 72 dpi coordinate system with the origin at the lower-left corner of the current page.
Availability
Available in Mac OS X v10.4 and later.
See Also
– currentDestination (PDFDestination)
– currentPage*/
- (void)goToDestination:(PDFDestination *)destination{}

/*currentSelection

Gets the current selection.

- (PDFSelection *)currentSelection
Discussion

Returns NULL if no selection exists. 
Availability
Available in Mac OS X v10.4 and later.
See Also
– setCurrentSelection:
– clearSelection*/
- (PDFSelection *)currentSelection{}

/*setCurrentSelection:

Sets the selection.

- (void)setCurrentSelection:(PDFSelection *)selection
Discussion

The view redraws as necessary but does not scroll. If you pass nil for the selection, this call is equivalent to calling clearSelection.
Availability
Available in Mac OS X v10.4 and later.
See Also
– currentSelection*/
- (void)setCurrentSelection:(PDFSelection *)selection{}


/*scrollSelectionToVisible:

Scrolls the selection until it is visible. 

- (void)scrollSelectionToVisible:(id)sender
Availability
Available in Mac OS X v10.4 and later.*/
- (void)scrollSelectionToVisible:(id)sender{}


/*displayMode

Returns the current display mode.

- (PDFDisplayMode)displayMode
Discussion

See “Constants” for possible values.
Availability
Available in Mac OS X v10.4 and later.
See Also
– setDisplayMode:*/
- (PDFDisplayMode)displayMode{}

/*currentPage

Returns the current page.

- (PDFPage *)currentPage
Discussion

When there are two pages in the view in a two-up mode, “current page” is the left page. For continuous modes, returns the page crossing a horizontal line halfway between the view’s top and bottom bounds.
Availability
Available in Mac OS X v10.4 and later.
See Also
– currentDestination
– goToDestination:*/
- (PDFPage *)currentPage{}


/*rowSizeForPage:

Returns the size needed to display a row of the current document page.

- (NSSize)rowSizeForPage:(PDFPage *)page
Discussion

The size is dependent on the current scale factor and display attributes. 
Availability
Available in Mac OS X v10.4 and later.*/
- (NSSize)rowSizeForPage:(PDFPage *)page{}


/*goBack:

Navigates back one step in the page history.

- (IBAction)goBack:(id)sender
Discussion

The page history gets built as your application calls navigation methods such as goToDestination: and goToLastPage:.
Availability
Available in Mac OS X v10.4 and later.
See Also
– canGoBack*/
- (IBAction)goBack:(id)sender{}

/*goToNextPage:

Navigates to the next page of the document.

- (IBAction)goToNextPage:(id)sender
Discussion

PDF Kit records the move in its page history.
Availability
Available in Mac OS X v10.4 and later.
See Also
– canGoToNextPage*/
- (IBAction)goToNextPage:(id)sender{}

/*goToPage:

Scrolls to the specified page.

- (void)goToPage:(PDFPage *)page
Discussion

PDF Kit records the move in its page history.
Availability
Available in Mac OS X v10.4 and later.*/

- (void)goToPage:(PDFPage *)page{}

/*canGoBack

Returns a logical value indicating whether or not the user can navigate to the previous page in the page history.

- (BOOL)canGoBack
Discussion

The page history gets built as your application calls navigation methods such as goToDestination: and goToLastPage:.
Availability
Available in Mac OS X v10.4 and later.
See Also
– goBack:*/
- (BOOL)canGoBack{}

/*convertPoint:toPage:

Converts a point from view space to page space.

- (NSPoint)convertPoint:(NSPoint)point toPage:(PDFPage *)page
Discussion

Page space is a 72 dpi coordinate system with the origin at the lower-left corner of the current page. View space is a coordinate system with the origin at the lower-left corner of the current PDF view.
Availability
Available in Mac OS X v10.4 and later.
See Also
– convertRect:toPage:
– convertPoint:fromPage:
– convertRect:fromPage:*/
- (NSPoint)convertPoint:(NSPoint)point toPage:(PDFPage *)page{}

/*goForward:

Navigates forward one step in the page history.

- (IBAction)goForward:(id)sender
Discussion

The page history gets built as your application calls navigation methods such as goToDestination: and goToLastPage:.
Availability
Available in Mac OS X v10.4 and later.
See Also
– canGoForward*/
- (IBAction)goForward:(id)sender{}

/*canGoForward

Returns a logical value indicating whether or not the user can navigate to the next page in the page history.

- (BOOL)canGoForward
Discussion

The page history gets built as your application calls navigation methods such as goToDestination: and goToLastPage:.
Availability
Available in Mac OS X v10.4 and later.
See Also
– goForward:*/
- (BOOL)canGoForward{}


/*setDisplayMode:

Sets the display mode for the view.

- (void)setDisplayMode:(PDFDisplayMode)mode
Discussion

Available display modes are single page, single-page continuous, two-up, and two-up continuous, as defined in “Constants”.
Availability
Available in Mac OS X v10.4 and later.
See Also
– displayMode*/
- (void)setDisplayMode:(PDFDisplayMode)mode{}


/*goToPreviousPage:

Navigates to the previous page of the document.

- (IBAction)goToPreviousPage:(id)sender
Discussion

PDF Kit records the move in its page history.
Availability
Available in Mac OS X v10.4 and later.
See Also
– canGoToPreviousPage*/
- (IBAction)goToPreviousPage:(id)sender{}


/*canGoToNextPage

Returns a logical value indicating whether or not the user can navigate to the next page of the document.

- (BOOL)canGoToNextPage
Discussion

The return value will be YES unless the view is displaying the last page.
Availability
Available in Mac OS X v10.4 and later.
See Also
– goToNextPage:*/
- (BOOL)canGoToNextPage{}

/*canGoToPreviousPage

Returns a logical value indicating whether or not the user can navigate to the previous page of the document.

- (BOOL)canGoToPreviousPage
Discussion

The return value will be YES unless the view is displaying the first page.
Availability
Available in Mac OS X v10.4 and later.
See Also
– canGoToPreviousPage*/
- (BOOL)canGoToPreviousPage{}

/*pageForPoint:nearest:

Returns the page containing a point specified in view coordinates.

- (PDFPage *)pageForPoint:(NSPoint)point nearest:(BOOL)nearest
Discussion

Returns NULL if there’s no page at the specified point and nearest is set to NO.
Availability
Available in Mac OS X v10.4 and later.*/
- (PDFPage *)pageForPoint:(NSPoint)point nearest:(BOOL)nearest{}


/*copy:

Copies the text in the selection, if any, to the Pasteboard.

- (void)copy:(id)sender
Availability
Available in Mac OS X v10.4 and later.
See Also
– currentSelection*/
- (void)copy:(id)sender{}

/*scaleFactor

Returns the current scale factor for the view.

- (float)scaleFactor
Availability
Available in Mac OS X v10.4 and later.
See Also
– setScaleFactor:*/

- (float)scaleFactor{}

/*setCursorForAreaOfInterest:

Sets the type of mouse cursor according to the type of area the mouse cursor is over.

- (void)setCursorForAreaOfInterest:(PDFAreaOfInterest)area
Discussion

This method is especially useful for custom subclasses of the PDFView class.
Availability
Available in Mac OS X v10.4 and later.
See Also
– areaOfInterestForMouse:*/
- (void)setCursorForAreaOfInterest:(PDFAreaOfInterest)area{}

/*documentView

Returns the innermost view used by PDFView or by your PDFView subclass.

- (id)documentView
Discussion

The innermost view is the one displaying the visible document pages. This method is useful when converting coordinates from one view to another.
Availability
Available in Mac OS X v10.4 and later.
See Also
– layoutDocumentView*/

- (id)documentView{}


/*printWithInfo:autoRotate:

Prints the document with the specified printer information.

- (void) printWithInfo: (NSPrintInfo *) printInfo autoRotate:(BOOL)doRotate
Discussion

If autoRotate is set to YES, then ths method ignores the orientation attribute in the NSPrintInfo object and instead chooses the orientation that best fits the page to the paper size. This orientation occurs on a page-by-page basis. 
Availability
Available in Mac OS X v10.4 and later.*/
- (void) printWithInfo: (NSPrintInfo *) printInfo autoRotate:(BOOL)doRotate{}

@end



@implementation NSObject(PDFViewDelegate)
@end



/*PDFViewChangedHistoryNotification

Posted when the page history changes.

The notification object is the PDFView itself. 

Availability
Available in Mac OS X v10.4 and later.*/
NSString *PDFViewChangedHistoryNotification;	


/*PDFViewPageChangedNotification

Posted when a new page becomes the current page.

The notification object is the PDFView itself. 

Availability
Available in Mac OS X v10.4 and later.*/
NSString *PDFViewPageChangedNotification;
