#import <PDFKit/PDFKit.h>

@implementation PDFSelection


/*pages

Gets the array of pages contained in the selection.

- (NSArray *)pages
Discussion

Pages are sorted by index number.
Availability
Available in Mac OS X v10.4 and later.*/
- (NSArray *)pages{}

/*string

Gets the text contained in the selection as a string.

- (NSString *)string
Availability
Available in Mac OS X v10.4 and later.*/

- (NSString *)string{}

/*extendSelectionAtEnd:

Extends the selection from its end toward the end of the document.

- (void)extendSelectionAtEnd:(int)chars
Discussion

The selection may be extended by any amount, up to and including the end of the document.
Availability
Available in Mac OS X v10.4 and later.
See Also
– extendSelectionAtStart:
– addSelection:*/
- (void)extendSelectionAtEnd:(int)chars{}

/*extendSelectionAtStart:

Extends the selection from its start toward the beginning of the document.

- (void)extendSelectionAtStart:(int)chars
Discussion

The selection may be extended by any amount, up to and including the beginning of the document.
Availability
Available in Mac OS X v10.4 and later.
See Also
– extendSelectionAtEnd:
– addSelection:*/

- (void)extendSelectionAtStart:(int)chars{}

/*boundsForPage:

Gets the bounds of the selection on the specified page.

- (NSRect)boundsForPage:(PDFPage *)page
Discussion

The selection rectangle is given in page space.

Page space is a 72 dpi coordinate system with the origin at the lower-left corner of the current page.
Availability
Available in Mac OS X v10.4 and later.*/
- (NSRect)boundsForPage:(PDFPage *)page{}

@end
