#include <LaunchServices/LaunchServices.h>

/*LSCopyDisplayNameForRef

Obtains the display name for an item designated by file-system reference.

OSStatus LSCopyDisplayNameForRef (
   const FSRef *inRef,
   CFStringRef *outDisplayName
);
Parameters
inRef

A pointer to a file-system reference designating the item whose display name is requested; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
outDisplayName

A pointer to a Core Foundation string object that, on return, will contain the items display name; see the CFString Reference in the Core Foundation Reference Documentation for a description of the CFStringRef data type. You are responsible for releasing this object.
Return Value

A result code; see Launch Services Result Codes.
Discussion

The items display name is returned in the form in which it will appear on the users screen; it may be localized (for applications and folders), and it excludes the filename extension if the extension is set to be hidden and the Finder preference to always show extensions is not enabled.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.1 and later.
Declared In
LSInfo.h*/
OSStatus LSCopyDisplayNameForRef (
   const FSRef *inRef,
   CFStringRef *outDisplayName
){
printf ("LSCopyDisplayNameForRef",*inRef,*outDisplayName);
};


/*LSCopyItemInfoForRef

Obtains requested information about an item designated by file-system reference.

OSStatus LSCopyItemInfoForRef (
   const FSRef *inItemRef,
   LSRequestedInfo inWhichInfo,
  OSStatus LSCopyItemInfoForRef (
   const FSRef *inItemRef,
   LSRequestedInfo inWhichInfo,
   LSItemInfoRecord *outItemInfo
); LSItemInfoRecord *outItemInfo
);
Parameters
inItemRef

A pointer to a file-system reference designating the item about which information is requested; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
inWhichInfo

Flags specifying what information to obtain; see “Requested-Information Flags” for a description of these flags.
outItemInfo

A pointer to an item-information record that, on return, will contain the requested information; see “LSItemInfoRecord” for a description of this structure.

If you request the item’s filename extension (field extension of the item-information record, requested by flag kLSRequestExtension), you are responsible for releasing the Core Foundation string object in which the extension is returned.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The information obtained about an item can include its filename extension, file type, creator signature, and various item-information flags (indicating, for example, whether the item is an application, or whether it has a hidden extension); see “Item-Information Flags” for a description of these flags.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSInfo.h*/
OSStatus LSCopyItemInfoForRef (
   const FSRef *inItemRef,
   LSRequestedInfo inWhichInfo,
   LSItemInfoRecord *outItemInfo
){
printf ("LSCopyItemInfoForRef",*inItemRef,inWhichInfo,*outItemInfo);
};

/*LSCanRefAcceptItem

Tests whether an application can accept (open) an item designated by file-system reference.

OSStatus LSCanRefAcceptItem (
   const FSRef *inItemFSRef,
   const FSRef *inTargetFSRef,
   LSRolesMask inRolesMask,
   LSAcceptanceFlags inFlags,
   Boolean *outAcceptsItem
);
Parameters
inItemFSRef

A pointer to a file-system reference designating the source item (the item to test for acceptance by the target application); see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
inTargetFSRef

A pointer to a file-system reference designating the target application; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
inRolesMask

A bit mask specifying the target application’s desired role or roles with respect to the source item; see “Roles Mask” for a description of this mask. If the role is unimportant, pass kLSRolesAll.
inFlags

Flags specifying behavior to observe during the acceptance test; see “Acceptance Flags” for a description of these flags.
outAcceptsItem

A pointer to a Boolean value that, on return, will indicate whether the target application can accept the source item with at least one of the specified roles.
Return Value

A result code; see “Launch Services Result Codes”.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSInfo.h*/
OSStatus LSCanRefAcceptItem (
   const FSRef *inItemFSRef,
   const FSRef *inTargetFSRef,
   LSRolesMask inRolesMask,
   LSAcceptanceFlags inFlags,
   Boolean *outAcceptsItem
){
printf ("LSCanRefAcceptItem",*inItemFSRef,*inTargetFSRef,inRolesMask,inFlags,*outAcceptsItem);
};

/*LSFindApplicationForInfo

Locates an application with a specified creator signature, bundle ID, filename, or any combination of these characteristics.

OSStatus LSFindApplicationForInfo (
   OSType inCreator,
   CFStringRef inBundleID,
   CFStringRef inName,
   FSRef *outAppRef,
   CFURLRef *outAppURL
);
Parameters
inCreator

The creator signature to consider. Comparison of creator signatures is case-sensitive. Pass kLSUnknownCreator if the application’s creator signature is unimportant.
inBundleID

A Core Foundation string object specifying the bundle ID to consider; see the CFString Reference in the Core Foundation Reference Documentation for a description of the CFStringRef data type. Comparison of bundle IDs is case-insensitive. Pass NULL if the application’s bundle ID is unimportant.
inName

A Core Foundation string object specifying the filename to consider; see the CFString Reference in the Core Foundation Reference Documentation for a description of the CFStringRef data type. The string must include any extension (such as '.app') that is part of the filename. Comparison of filenames is case-insensitive. Pass NULL if the application’s filename is unimportant.
outAppRef

A pointer to a file-system reference that, on return, will identify the requested application; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type. Pass NULL if you are not interested in identifying the application in this form; however, this parameter and outAppURL cannot both be NULL.
outAppURL

A pointer to a Core Foundation URL reference that, on return, will identify the requested application; see the CFURL Reference in the Core Foundation Reference Documentation for a description of the CFURLRef data type. Pass NULL if you are not interested in identifying the application in this form; however, this parameter and outAppRef cannot both be NULL.

Despite the absence of the word Copy in its name, this function retains the URL reference object on your behalf; you are responsible for releasing this object.
Return Value

A result code; see “Launch Services Result Codes”. If no suitable application is found in the Launch Services database, the function will return the result code kLSApplicationNotFoundErr.
Discussion

You can request any combination of one, two, or all three of the characteristics specified by the inCreator, inBundleID, and inName parameters; at least one of these characteristics must be supplied. If more than one application is found matching the specified characteristics, Launch Services chooses one in the same manner as when locating the preferred application for opening an item.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSInfo.h*/
OSStatus LSFindApplicationForInfo (
   OSType inCreator,
   CFStringRef inBundleID,
   CFStringRef inName,
   FSRef *outAppRef,
   CFURLRef *outAppURL
){
printf ("LSFindApplicationForInfo",inCreator,inBundleID,inName,*outAppRef,*outAppURL);
};

/*LSCopyItemInfoForURL

Obtains requested information about an item designated by URL.

OSStatus LSCopyItemInfoForURL (
   CFURLRef inFileURL,
   LSRequestedInfo inWhichInfo,
   LSItemInfoRecord *outItemInfo
);
Parameters
inFileURL

A Core Foundation URL reference designating the item about which information is requested; see the CFURL Reference in the Core Foundation Reference Documentation for a description of the CFURLRef data type. The URL must have scheme file and contain a valid path to either a file or a directory.
inWhichInfo

Flags specifying what information to obtain; see “Requested-Information Flags” for a description of these flags.
outItemInfo

A pointer to an item-information record that, on return, will contain the requested information; see “LSItemInfoRecord” for a description of this structure.

If you request the item’s filename extension (field extension of the item-information record, requested by flag kLSRequestExtension), you are responsible for releasing the Core Foundation string object in which the extension is returned.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The information obtained about an item can include its filename extension, file type, creator signature, and various item-information flags (indicating, for example, whether the item is an application, or whether it has a hidden extension); see “Item-Information Flags” for a description of these flags.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSInfo.h*/
OSStatus LSCopyItemInfoForURL (
   CFURLRef inFileURL,
   LSRequestedInfo inWhichInfo,
   LSItemInfoRecord *outItemInfo
){
printf ("LSCopyItemInfoForURL",inFileURL,inWhichInfo,*outItemInfo);
};

/*LSGetExtensionInfo

Obtains the starting index of the extension within a filename.

OSStatus LSGetExtensionInfo (
   UniCharCount inNameLen,
   const UniChar inNameBuffer[],
   UniCharCount *outExtStartIndex
);
Parameters
inNameLen

The number of characters in the filename specified by the inNameBuffer parameter.
inNameBuffer

The buffer containing the filename’s Unicode characters.
outExtStartIndex

A pointer to a value of type UniCharCount that, on return, will give the starting index of the extension within the filename. If the name does not contain a valid extension (one with no spaces in it), the value on return will be kLSInvalidExtensionIndex.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The starting index is the number of Unicode characters from the start of the filename buffer to the first character of the extension (not including the period).
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.1 and later.
Declared In
LSInfo.h*/

OSStatus LSGetExtensionInfo (
   UniCharCount inNameLen,
   const UniChar inNameBuffer[],
   UniCharCount *outExtStartIndex
){
printf ("LSGetExtensionInfo",inNameLen,inNameBuffer,*outExtStartIndex);
};

