#include <stdio.h>
#include <IOKit/storage/IOMedia.h>


/*getSize

public

virtual UInt64 getSize() const; 
Return Value

Media size, in bytes. 
Discussion 

Ask the media object for its total length in bytes.*/
UInt64 IOMedia::getSize() const{
printf ("getSize");
};

/*isEjectable

public

virtual bool isEjectable() const; 
Return Value

Returns true if the media is ejectable, false otherwise. 
Discussion 

Ask the media object whether it is ejectable.*/
bool IOMedia::isEjectable() const{
printf ("isEjectable");
}; 

/*isWritable

public

virtual bool isWritable() const; 
Return Value

Returns true if the media is writable, false otherwise. 
Discussion 

Ask the media object whether it is writable.*/
 bool IOMedia:: isWritable() const{
printf ("isWritable");
}; 

/*write

public

virtual void write(
    IOService *client, 
    UInt64 byteStart, 
    IOMemoryDescriptor *buffer, 
    IOStorageCompletion completion); 
Parameters
client
Client requesting the write.
byteStart
Starting byte offset for the data transfer.
buffer
Buffer for the data transfer. The size of the buffer implies the size of the data transfer.
completion
Completion routine to call once the data transfer is complete.
Discussion 

Write data into the storage object at the specified byte offset from the specified buffer, asynchronously. When the write completes, the caller will be notified via the specified completion action.
The buffer will be retained for the duration of the write.*/
 void IOMedia::write(
    IOService *client, 
    UInt64 byteStart, 
    IOMemoryDescriptor *buffer, 
    IOStorageCompletion completion){
printf ("write",*client,byteStart,*buffer,completion);
}; 

/*read

public

virtual void read(
    IOService *client, 
    UInt64 byteStart, 
    IOMemoryDescriptor *buffer, 
    IOStorageCompletion completion); 
Parameters
client
Client requesting the read.
byteStart
Starting byte offset for the data transfer.
buffer
Buffer for the data transfer. The size of the buffer implies the size of the data transfer.
completion
Completion routine to call once the data transfer is complete.
Discussion 

Read data from the storage object at the specified byte offset into the specified buffer, asynchronously. When the read completes, the caller will be notified via the specified completion action.
The buffer will be retained for the duration of the read.*/
 void IOMedia:: read(
    IOService *client, 
    UInt64 byteStart, 
    IOMemoryDescriptor *buffer, 
    IOStorageCompletion completion){
printf ("read",*client,byteStart,*buffer,completion);
}; 

/*synchronizeCache

public

virtual IOReturn synchronizeCache(
    IOService *client); 
Parameters
client
Client requesting the cache synchronization.
Return Value

Returns the status of the cache synchronization. 
Discussion 

Flush the cached data in the storage object, if any, synchronously.*/
IOReturn IOMedia:: synchronizeCache(
    IOService *client){
printf ("synchronizeCache",*client);
}; 

/*getPreferredBlockSize

public

virtual UInt64 getPreferredBlockSize() const; 
Return Value

Natural block size, in bytes. 
Discussion 

Ask the media object for its natural block size. This information is useful to clients that want to optimize access to the media.*/
 UInt64 IOMedia::getPreferredBlockSize() const{
printf ("getPreferredBlockSize");
}; 

/*init

public

virtual bool init(
    UInt64 base, 
    UInt64 size, 
    UInt64 preferredBlockSize, 
    IOMediaAttributeMask attributes, 
    bool isWhole, 
    bool isWritable, 
    const char *contentHint = 0, 
    OSDictionary *properties = 0); 
Parameters
base
Media offset, in bytes.
size
Media size, in bytes.
preferredBlockSize
Natural block size, in bytes.
attributes
Media attributes, such as ejectability and removability. See IOMediaAttributeMask.
isWhole
Indicates whether the media represents the whole disk.
isWritable
Indicates whether the media is writable.
contentHint
Hint of media's contents (optional). See getContentHint().
properties
Substitute property table for this object (optional).
Return Value

Returns true on success, false otherwise. 
Discussion 

Initialize this object's minimal state.*/
 bool IOMedia::   init(
    UInt64 base, 
    UInt64 size, 
    UInt64 preferredBlockSize, 
    IOMediaAttributeMask attributes, 
    bool isWhole, 
    bool isWritable, 
    const char *contentHint,
    OSDictionary *properties){
printf ("init",base,size,preferredBlockSize,attributes,isWhole,isWritable,*contentHint,*properties);
}; 
