#include <HIToolbox/HIToolbox.h>

//work


/*SendTextInputEvent

Sends Carbon text input events from a text service component to a client application.

OSStatus SendTextInputEvent (
   EventRef inEvent
);
Parameters
inEvent

A reference to the Carbon event to be sent. 
Return Value

A result code. See “Text Services Manager Result Codes”. The SendTextInputEvent function returns noErr if the event is successfully handled. If the event is not handled, the function may return a Carbon Event Manager error, as well as Apple event or Text Encoding Conversion Manager errors.
Discussion

The SendTextInputEvent function allows a Carbon text service component on Mac OS X to send a Carbon text input event to the Text Services Manager for dispatching to a client application. This function can be used for events of Carbon event class kEventClassTextInput as well as for events of class kEventClassTSMDocumentAccess.

If the client application does not handle a particular Carbon text input event, the Text Services Manager converts the event to the corresponding Apple event and sends it again. An exception to this is when the application is not Unicode-aware (that is, the active TSM document was not created with the kUnicodeDocument interface type). In this case, a kEventUnicodeForKeyEvent Carbon event would not be converted to the corresponding Apple event (kUnicodeNotFromInputMethod). In every case, if the application handles neither the Unicode Carbon text input event nor the corresponding Apple event, the Text Services Manager converts the component’s text input event into a stream of “classic” key events for delivery to WaitNextEvent clients.

If the application has no active TSM documents or has called the function UseInputWindow to request input via the Text Services Manager’s floating input window—that is, if the application does not handle the event at all—the Text Services Manager routes the component’s text input event to the floating input window to allow bottom-line input. 
Availability
Not available in CarbonLib.
Available in Mac OS X v 10.0 and later.
Carbon Porting Notes

Note that this function replaces the function SendAEFromTSMComponent on Mac OS X only. With Mac OS X, text service components must be Carbon clients. This is in contrast to Mac OS 8 and 9, where text service components must not be Carbon clients. (This restriction is due to the fact that it is potentially destabilizing for a Carbon-based component to load Carbon in the context of a non-Carbon application.) Therefore, text service components use Carbon text input events and the SendTextInputEvent function only on Mac OS X. The function SendAEFromTSMComponent must be used by components running on Mac OS 8 and 9.

On any system, the Text Services Manager automatically converts component-originated text input events to the proper form for client applications. On Mac OS X, the Text Services Manager automatically converts component-originated Carbon events to Apple events, if a client application does not provide handlers for Carbon events. Conversely, on Mac OS 8 and 9, the Text Services Manager automatically converts component-originated Apple events to Carbon events and provides these Carbon events to applications, so they have the option of handling them.
Declared In
TextServices.h*/

OSStatus SendTextInputEvent (
   EventRef inEvent
){};


