#include <HIToolbox/HIToolbox.h>



/*ZeroScrap

Clears the contents of the scrap.

Unsupported

OSStatus ZeroScrap ();
Return Value

A result code. See “Scrap Manager Result Codes”.
Discussion

If the scrap does not already exist (in memory or on the disk), the function initializes the scrap in memory. Whenever your application needs to write data to the scrap as a result of a cut or copy operation by the user, you should call this function before calling the PutScrap function. If your application needs to write data in one or more formats to the scrap, you should call this function before the first time you call PutScrap.

If your application uses the TEToScrap function to write TextEdit’s scrap to the scrap, your application should call this function to clear the contents of the scrap first. However, note that your application does not have to call this function before calling the TECut function or the TECopy function. 
Special Considerations

Because this function may move or purge memory blocks or access handles, your application should not call it at interrupt time.
Availability
Not available in CarbonLib. Not available in Mac OS X.
Carbon Porting Notes

Use the function ClearCurrentScrap instead.
Declared In
Scrap.h*/
OSStatus ZeroScrap (){
printf ("ZeroScrap");
};



/*InfoScrap

Obtains information about the scrap.

Unsupported

ScrapStuffPtr InfoScrap ();
Return Value

A pointer to the scrap information structure, ScrapStuff.
Special Considerations

Because this function may move or purge memory blocks or access handles, your application should not call it at interrupt time.
Availability
Not available in CarbonLib. Not available in Mac OS X.
Carbon Porting Notes

The InfoScrap function is not supported in Carbon. You should use the function GetCurrentScrap instead. Your application can determine if the scrap contents have changed by storing the scrap reference returned by GetCurrentScrap and comparing it against the scrap reference returned by GetCurrentScrap at a later time. If the two scrap references are different, the scrap has changed.
Declared In
Scrap.h*/
ScrapStuffPtr InfoScrap (){
printf ("InfoScrap");
};


/*ClearCurrentScrap

Clears the current scrap.

OSStatus ClearCurrentScrap ();
Return Value

A result code. See “Scrap Manager Result Codes”.
Discussion

Call ClearCurrentScrap immediately when the user requests a Copy or Cut operation, even if you maintain a private scrap. You should not wait until receiving a suspend event to call ClearCurrentScrap. You don't need to put any data on the scrap immediately, although it's perfectly fine to do so. You do need to call GetCurrentScrap after ClearCurrentScrap so you'll have a valid scrap reference to pass to other functions. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Scrap.h*/
OSStatus ClearCurrentScrap (){
printf ("ClearCurrentScrap");
};


/*PutScrap

Writes data to the current location of the scrap.

Unsupported

OSStatus PutScrap (
   SInt32 length,
   ResType theType,
   const void *source
);
Parameters
length

The amount (in bytes) of data to write to the scrap.
theType

The scrap format type of the data you wish to write to the scrap. The scrap format type is a four-character sequence that refers to the particular data format, such as 'TEXT', 'PICT', 'styl', 'snd ', or 'movv'.
source

A pointer to the data that the function should write to the scrap.
Return Value

A result code. See “Scrap Manager Result Codes”. Returns noScrapErr if the scrap at source does not already exist (in memory or on the disk).
Discussion

If your application uses a private scrap, it should copy data from its private scrap to the scrap using this function whenever it receives a suspend event. 

Your application can use this function multiple times to write different formats of the same data to the scrap. Whenever your application needs to write data in one or more formats to the scrap, you should call the ZeroScrap function before the first time you call this function. If your application writes multiple formats to the scrap, you should write your application’s preferred scrap format type first. For example, if the SurfWriter application’s preferred scrap format type is a private scrap format type called 'SURF' and SurfWriter also supports the scrap format types 'TEXT' and 'PICT', then SurfWriter should write the data to the scrap using the 'SURF' scrap format type first, and then write any other scrap format types that it supports in subsequent order of preference.

Do not write data to the scrap that has the same scrap format type as any data already in the scrap. If you do so, the new data is appended to the scrap. Note that when you request data from the scrap using the GetScrap function, GetScrap returns the first data that it finds with the requested scrap format type; thus you cannot retrieve any appended data of the same format type using GetScrap.

If your application uses TextEdit to handle text in its documents, use TextEdit functions to implement cut and copy operations and to write the TextEdit scrap to the scrap. If your application uses the Dialog Manager to handle editable text in your application’s dialog boxes and a dialog box is the frontmost window, use the Dialog Manager function DialogCut or DialogCopy to copy the data from the current editable text item to the scrap. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Not available in CarbonLib. Not available in Mac OS X.
Carbon Porting Notes

Use the function PutScrapFlavor instead.
Declared In
Scrap.h*/

OSStatus PutScrap (
   SInt32 length,
   ResType theType,
   const void *source
){
printf ("PutScrap",length,theType,source);
};


/*GetCurrentScrap

Obtains a reference to the current scrap.

OSStatus GetCurrentScrap (
   ScrapRef * scrap
);
Parameters
scrap

A pointer to a scrap reference. On return, this scrap reference refers to the current scrap. 
Return Value

A result code. See “Scrap Manager Result Codes”.
Discussion

Your application can determine if the scrap contents have changed by storing the scrap reference returned by GetCurrentScrap and comparing it against the scrap reference returned by GetCurrentScrap at a later time. If the two scrap references are different, the scrap has changed.

Carbon applications should use GetCurrentScrap instead of checking the convertClipboardFlag in the EventRecord.

The ScrapRef obtained via GetCurrentScrap becomes invalid and unusable after the scrap is cleared. That is, the scrap reference is valid until a Carbon client calls ClearCurrentScrap, a Classic client calls ZeroScrap , or a Cocoa client calls declareTypes:owner:. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Scrap.h*/
OSStatus GetCurrentScrap (
   ScrapRef * scrap
){
printf ("GetCurrentScrap",*scrap);
};


//work

/*UnloadScrap

Writes the scrap from memory to the scrap file.

Not recommended

OSStatus UnloadScrap ();
Return Value

A result code. See “Scrap Manager Result Codes”.
Discussion

This function releases the memory occupied by the scrap in your application’s heap. The scrap file is located in the System Folder of the startup volume and has the filename as indicated by the scrapName field of the scrap information structure (usually "Clipboard"). If the scrap is already on the disk, this function does nothing. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Carbon applications may continue calling this function on Mac OS 8; however, on Mac OS X it does nothing and is no longer necessary.
Declared In
Scrap.h*/
OSStatus UnloadScrap (){};




/*GetScrap

Reads data from the scrap.

Unsupported

SInt32 GetScrap (
   Handle hDest,
   ResType theType,
   SInt32 *offset
);
Parameters
hDest

A handle to the memory location where the function should place the data from the scrap. The function makes a copy of the data in memory and sets the handle specified by the hDest parameter to refer to this copy, resizing the handle if necessary. If you specify NULL in this parameter, the function does not read in the data but does return the offset of the data in the scrap and the number of bytes of the requested scrap data type if the requested type exists in the scrap.
theType

The scrap format type of the data you wish to read from the scrap.
offset

On return, a pointer to the location of the data in the scrap. This value is expressed as an offset (in bytes) from the beginning of the scrap. The returned value for the offset parameter is valid only if the Translation Manager isn’t available if the Translation Manager is available, then the value of offset is undefined.
Return Value

The length (in bytes) of the data or a negative function result that indicates the error. If the function returns noTypeErr, then the data in the scrap isn’t available in the scrap format type requested by your application. 
Discussion

Your application can use this function multiple times to read different formats of the same data from the scrap. If more than one format of the same scrap format type exists in the scrap, the function returns the first occurrence of that format type that it finds. For example, if data of type 'TEXT', 'PICT', and 'TEXT' exist on the scrap, and your application requests the data in the scrap with scrap format type 'TEXT', the function returns the first data of type 'TEXT' that it finds.

If your application supports more than one scrap format type, your application should attempt to read its preferred scrap format type first. If your application doesn’t prefer one scrap format type over any other type, it should try reading each of the scrap format types that it supports and use the type that returns the lowest offset. The scrap format type with the lowest offset indicates that this format type was written before any of the others and therefore was preferred by the application that wrote it. 

If you request a scrap format type that isn’t in the scrap and the Translation Manager is available, the Scrap Manager uses the Translation Manager to convert the data of a scrap format type that does exist in the scrap into the scrap format type requested by your application. For example, if the SurfWriter application requests data from the scrap in the 'SURF' scrap format type, and the data in the scrap is available in the format types 'TEXT', 'PICT', and 'SDBS' (SurfDB’s private scrap format type), the Scrap Manager uses the Translation Manager to convert any one of the scrap format types 'TEXT', 'PICT', or 'SDBS' into the 'SURF' scrap format type. The Translation Manager looks for a translator that can perform one of these translations. If such a translator is available (for example, a translator that can translate the 'SDBS' scrap format type into the 'SURF' scrap format type), the Translation Manager uses the translator to translate the data in the scrap into the requested scrap format type. If the translation is successful, the Scrap Manager returns to your application the data from the scrap in the requested scrap format type.

The scrap format type is a four-character sequence that defines the type of data.typedef FourCharCode ResType;


The standard scrap format types are
'TEXT': a series of ASCII characters 
'PICT': a QuickDraw picture, which is a saved sequence of QuickDraw commands that can be displayed using the DrawPicture function 

Optional scrap format types include
'styl': a series of bytes that have the same format as a TextEdit 'styl' resource and that describe styled text data 
'snd ': a series of bytes that have the same format as an 'snd ' resource and that define a sound 
'movv': a series of bytes that have the same format as an 'movv' resource and that define a movie 

Your application should support the 'TEXT' and 'PICT' scrap format types and should optionally support any other scrap format types (such as 'snd ') that are appropriate to your application.

In general, when your application writes data to the scrap, the Scrap Manager appends the data to the scrap in the following format: the first 4 bytes are the scrap type format; the next 4 bytes are the length of the following data in bytes; and the remaining n bytes (where n is an even number) are the data.

If your application uses TextEdit to handle text in its documents, use TextEdit functions to implement the paste operation and to copy data from the scrap to the TextEdit scrap. If your application uses the Dialog Manager to handle editable text items in your application’s dialog boxes and a dialog box is the frontmost window, use the Dialog Manager function DialogPaste to copy data from the scrap to the current editable text item. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Not available in CarbonLib. Not available in Mac OS X.
Carbon Porting Notes

You should instead use the functions GetScrapFlavorSize and GetScrapFlavorData.
Declared In
Scrap.h*/
SInt32 GetScrap (
   Handle hDest,
   ResType theType,
   SInt32 *offset
){};




/*PutScrapFlavor

Puts data on or promises data to the specified scrap.

OSStatus PutScrapFlavor (
   ScrapRef scrap,
   ScrapFlavorType flavorType,
   ScrapFlavorFlags flavorFlags,
   Size flavorSize,
   const void * flavorData
);
Parameters
scrap

A reference to the scrap to supply data or promises to. 
flavorType

The flavor type to supply or promise the data for. Some flavor types are described in “Scrap Flavor Types”.
flavorFlags

A variable of type ScrapFlavorFlags that you use to supply information about the flavor specified by the flavorType parameter. See “Scrap Flavor Flags” for a description of the values you can use in this parameter.
flavorSize

The size of the data you are supplying or promising, in bytes. If you don't know the size, pass kScrapFlavorSizeUnknown to place a promise for data of undetermined size on the scrap. If you pass 0 in this parameter, a flavor with no expected data—not a promise—is placed on the scrap, and the value of the flavorData parameter is ignored.
flavorData

A pointer to a buffer, local variable, or other storage location, created and disposed of by your application. Before calling PutScrapFlavor to put flavor data on the scrap, store the data in this buffer. For information on the number of bytes of data, see the description of the flavorSize parameter.

Pass NULL for this parameter to indicate you will provide data through a subsequent call to PutScrapFlavor, either later in the same code flow or during execution of your ScrapPromiseKeeperProcPtr callback.

The last time you can provide scrap flavor data is when your scrap promise-keeper function gets called. It is not possible to call PutScrapFlavor while handling a suspend event; suspend events under Carbon don't work the way they do under Mac OS 8 and 9.
Return Value

A result code. See “Scrap Manager Result Codes”.
Discussion

PutScrapFlavor is different than PutScrap in that it includes a ScrapRef parameter and it supports promising a flavor for later delivery, rather than supplying it immediately. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Scrap.h*/

OSStatus PutScrapFlavor (
   ScrapRef scrap,
   ScrapFlavorType flavorType,
   ScrapFlavorFlags flavorFlags,
   Size flavorSize,
   const void * flavorData
){};

