#include <HIToolbox/HIToolbox.h>



 void InitMenus(void){
printf ("InitMenus");
};


 void 
EnableItem(
  MenuRef   theMenu,
  short     item){
printf ("EnableItem",theMenu,item);;
};


 Boolean SystemEdit(short editCmd){
printf ("SystemEdit",editCmd);
};

/*EnableMenuCommand

Enables the menu item with a specified command ID.

void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);
Parameters
inMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID of the menu item to be enabled. If more than one item has this command ID, only the first will be enabled. 
Discussion

If you have access to the menu item index, in most cases you should use EnableMenuItem instead, as that function is faster and requires no searching. For example, when receiving a kEventCommandUpdateStatus event, the HICommand structure contains both the menu item’s command ID and index. If you wanted to enable the menu item, you should call EnableMenuItem.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID){
printf ("EnableMenuCommand",inMenu,inCommandID);
};

/*DeleteMenuItem

Deletes an item from a menu. 

void DeleteMenuItem (
   MenuRef theMenu,
   short item
);
Parameters
theMenu

The menu from which you want to delete the menu item. 
item

The item number of the menu item to delete. If you specify 0 or a number greater than the last item in the menu, DeleteMenuItem does not delete any item from the menu. 
Discussion

The DeleteMenuItem function deletes a specified menu item from a menu. You should not delete items from an existing menu unless the user expects the menu (such as a menu that lists open documents) to change. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DeleteMenuItem (
   MenuRef theMenu,
   short item){
printf ("DeleteMenuItem",inMenu,item);
};


/*AppendMenuItemTextWithCFString

Appends a new menu item with text from a CFString.

OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem
);
Parameters
menu

The menu to which to append the new item. 
inString

The text of the new item. 
inAttributes

The attributes of the new item. 
inCommandID

The command ID of the new item. 
outNewItem

On exit, the index of the new item. May be NULL if the caller does not need this information. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The Menu Manager will make its own copy of the CFString before returning from this function. Modifying the string after calling AppendMenuItemTextWithCFString will have no effect on the menu item's actual text. The caller may release the string after the call.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem){
printf ("AppendMenuItemTextWithCFString",inMenu,inString,inAttributes,inCommandID,*outNewItem);
};

/*CopyMenuItemTextAsCFString

Returns a CFString containing the text of a menu item.

OSStatus CopyMenuItemTextAsCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef * outString
);
Parameters
menu

The menu containing the item. 
item

The item whose text you want to copy. 
outString

On exit, a CFString containing the item's text. The caller must release this string when it is no longer needed. 
Return Value

A result code. See “Menu Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CopyMenuItemTextAsCFString (MenuRef inMenu,MenuItemIndex inItem,CFStringRef * outString){
printf ("CopyMenuItemTextAsCFString",inMenu,inItem,*outString);
};

/*SetItemCmd

Sets the value of the keyboard equivalent field of a menu item.

Not recommended

void SetItemCmd (
   MenuRef theMenu,
   short item,
   CharParameter cmdChar
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
cmdChar

The value to set for the item’s keyboard equivalent field. The Menu Manager uses this value to map keyboard equivalents to menu s or to define special characteristics of the menu item. 

To indicate that the menu item has a submenu, specify 0x1B in the cmdChar parameter; specify a value of 0x1C to indicate that the item has a special text encoding; specify a value of 0x1D to indicate that the Menu Manager should reduce the item’s 'ICON' resource to the size of a small icon; and specify a value of 0x1E to indicate that the item has an 'SICN' resource.

The values 0x01 through 0x1A, as well as 0x1F and 0x21, are reserved for use by Apple. You should not use any of these reserved values in the cmdChar parameter.
Discussion

You should call SetMenuItemCommandKey , SetMenuItemHierarchicalID , and SetMenuItemTextEncoding instead of SetItemCmd to set a menu item’s keyboard equivalent and text encoding and to indicate that a menu item has a submenu.

You usually define the keyboard equivalents and other characteristics of your menu items in the 'MENU' resource rather than using the SetItemCmd function. The SetItemCmd function sets the value in the keyboard equivalent field of the specified menu item to the value specified by the cmdChar parameter (you can specify 0 if the item doesn’t have a keyboard equivalent, submenu, text encoding, reduced icon, or small icon). If you specify that the item has a submenu, you should provide the menu ID of the submenu as the item’s marking character. If you specify that the item has a special text encoding, you must provide the text encoding in the icon field of the menu item. If you specify that the item has an 'SICN' or a reduced 'ICON' resource, you must provide the icon number in the icon field of the item. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void SetItemCmd (
   MenuRef theMenu,
   short item,
   CharParameter cmdChar
){
printf ("SetItemCmd",theMenu,item,cmdChar);
};


/*SetMenuItemModifiers

Sets the modifier key(s) that must be pressed with a character key to select a particular menu item.

OSErr SetMenuItemModifiers (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inModifiers
);
Parameters
inMenu

The menu that contains the menu item for which you wish to set the modifier key(s). 
inItem

The menu index of the item. 
inModifiers

A value representing the modifier key(s) to be used in selecting the menu item; see “Modifier Key Mask Constants”. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can call the SetMenuItemModifiers function to change the modifier key(s) you can include with a character key to create your keyboard equivalent. For example, you can change Command-x to Command-Option-Shift-x. By default, the Command key is always specified; you can remove it by calling SetMenuItemModifiers with the kMenuNoCommandModifier mask constant, or (if you are using a nib file) by unchecking the appropriate command checkbox in the Interface Builder menu item inspector. 

See also the function GetMenuItemModifiers. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSErr SetMenuItemModifiers (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inModifiers
){
printf ("SetMenuItemModifiers",inMenu,inItem,inModifiers);
};

/*GetMenuWidth

Obtains the width of the menu, in pixels. 

SInt16 GetMenuWidth (
   MenuRef menu
);
Parameters
menu

The menu whose width you want to obtain. 
Return Value

The width of the menu, in pixels. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

SInt16 GetMenuWidth (
   MenuRef menu
){
printf ("GetMenuWidth",menu);
};

/*SetItemMark

Sets the mark of a menu item.

void SetItemMark (
   MenuRef theMenu,
   short item,
   CharParameter markChar
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
markChar

The mark of the menu item or its submenu (if the item has a submenu). To set the submenu associated with this menu item, specify the menu ID of the submenu in the markChar parameter. You can pass the character marking constants defined in the Font Manager. Pass 0 (noMark)if the menu item has neither mark nor submenu. 
Discussion

You should call SetMenuItemHierarchicalID instead of SetItemMark to set the menu ID of a menu item’s submenu. However, you can still use SetItemMark to set the mark of a menu item. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void SetItemMark (
   MenuRef theMenu,
   short item,
   CharParameter markChar){
printf ("SetItemMark",theMenu,item,markChar);
};

/*DeleteMenuItems

Deletes multiple menu items.

OSStatus DeleteMenuItems (
   MenuRef inMenu,
   MenuItemIndex inFirstItem,
   ItemCount inNumItems
);
Parameters
inMenu

The menu from which to delete items. 
inFirstItem

The first item to delete. 
inNumItems

The number of items to delete. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can call this function rather than calling DeleteMenuItem multiple times.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus DeleteMenuItems (
   MenuRef inMenu,
   MenuItemIndex inFirstItem,
   ItemCount inNumItems
){
printf ("DeleteMenuItem",inMenu,inFirstItem,inNumItems);
};


/*SetMenuItemTextWithCFString

Sets the text of a menu item to the text contained in a CFString.

OSStatus SetMenuItemTextWithCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef inString
);
Parameters
inMenu

The menu containing the item. 
inItem

The item whose text you want to set. 
inString

The CFString containing the new menu item text. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

If the CFString is mutable, the Menu Manager will make its own copy of the CFString before returning from SetMenuItemTextWithCFString. Modifying the string after calling SetMenuItemTextWithCFString will have no effect on the item's actual text. 

If the CFString is immutable, the Menu Manager increments the reference count of the string before returning. 

The caller may release the string after calling SetMenuItemTextWithCFString.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus SetMenuItemTextWithCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef inString
){
printf ("SetMenuItemTextWithCFString",inMenu,inItem,inString);
};


/*GetMenuItemHierarchicalMenu

Returns the submenu attached to a menu item.

OSStatus GetMenuItemHierarchicalMenu (
   MenuRef inMenu,
   MenuItemIndex inItem,
   MenuRef * outHierMenu
);
Parameters
inMenu

The parent menu. 
inItem

The parent item. 
outHierMenu

On exit, the item's submenu, or NULL if it does not have one.
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

GetMenuItemHierarchicalMenu will return the submenu attached to a menu item regardless of how the submenu was specified. If the submenu was specified by menu ID (using SetItemCmd or SetMenuItemHierarchicalID), GetMenuItemHierarchicalMenu will return the currently installed menu with that ID, if any. The only case where GetMenuItemHierarchicalMenu will fail to return the item's submenu is when the submenu is specified by menu ID, but the submenu is not currently inserted in the menu bar.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetMenuItemHierarchicalMenu (
   MenuRef inMenu,
   MenuItemIndex inItem,
   MenuRef * outHierMenu
){
printf ("GetMenuItemHierarchicalMenu",inMenu,inItem,*outHierMenu);
};

/*DisableMenuCommand

Disables the menu item with a specified command ID.

void DisableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);
Parameters
theMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
commandID

The command ID of the menu item to be disabled. If more than one item has this command ID, only the first will be disabled. 
Discussion

If you have access to the menu item index, in most cases you should use DisableMenuItem instead, as that function is faster and requires no searching. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DisableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
){
printf ("DisableMenuCommand",inMenu,inCommandID);
};

/*HiliteMenu

Highlights or unhighlights menu titles.

void HiliteMenu (
   MenuID menuID
);
Parameters
menuID

The menu ID of the menu whose title should be highlighted. If the menu title of the specified menu is already highlighted, HiliteMenu does nothing. If the menu ID is 0 or the specified menu ID isn’t in the current menu list, HiliteMenu unhighlights whichever menu title is currently highlighted (if any). 
Discussion

The IsMenuKeyEvent, MenuSelect, MenuEvent, and MenuKey functions highlight the title of the menu containing the item chosen by the user. After performing the chosen task, your application should unhighlight the menu title by calling HiliteMenu and passing 0 in the menuID parameter. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void HiliteMenu (
   MenuID menuID
){
printf ("HiliteMenu",menuID);
};

/*GetNewMBar

Reads in the definition of a menu bar from an 'MBAR' resource. 

Not recommended

MenuBarHandle GetNewMBar (
   short menuBarID
);
Parameters
menuBarID

The resource ID of an 'MBAR' resource that specifies the menus for a menu bar. 
Return Value

A handle to the menu list. (If the resource isn’t already in memory, GetNewMBar reads it into memory.) If GetNewMBar can’t read the resource, GetNewMBar returns NULL. See the description of the MenuBarHandle data type.
Discussion

Unless you must support legacy code, you should not use functions like GetNewMBar that rely on menus and menu bars stored as resources. Instead, you should define menus in Interface Builder, store them as nib files, and then call the Interface Builder Services functions CreateMenuFromNib , CreateMenuBarFromNib, or SetMenuBarFromNibto create them. 

The GetNewMBar function reads in the definition of a menu bar and its associated menus from an ' MBAR ' resource. The ' MBAR ' resource identifies the order of menus contained in its menu bar. For each menu, it also specifies the menu’s resource ID. The GetNewMBar function reads in each menu from the ' MENU ' resource with the resource ID specified in the ' MBAR ' resource.

The GetNewMBar function creates a menu list for the menu bar defined by the ' MBAR ' resource and returns a handle to the menu list. GetNewMBar uses GetMenu to read in each individual menu.

After reading in menus from an ' MBAR ' resource, use SetMenuBar to make the menu list created by GetNewMBar the current menu list. Then use DrawMenuBar to update the menu bar.

To release the memory occupied by a menu list, use the function DisposeMenuBar 
Special Considerations

The GetNewMBar function first saves the current menu list and then clears the current menu list and your application’s menu color information table. It then creates a new menu list. Before returning a handle to the new menu list, the GetNewMBar function restores the current menu list to the previously saved menu list, but GetNewMBar does not restore the previous menu color information table. To save and then restore your application’s current menu color information table, call the function GetMCInfo before GetNewMBar and call SetMCInfo afterward.

While you supply only the resource ID of an 'MBAR' resource to the GetNewMBar function, your application often needs to use the menu IDs defined in each of your menus’ 'MENU' resources. Most Menu Manager functions require either a menu ID or a handle to a menu structure to perform operations on a specific menu. For menus in the current menu list, you can use the GetMenuHandle function to get the handle to a menu structure for a menu with a given menu ID.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuBarHandle GetNewMBar (
   short menuBarID
){
printf ("GetNewMBar",menuBarID);
};

/*PopUpMenuSelect

Displays a pop-up menu without using the standard pop-up control definition function.

long PopUpMenuSelect (
   MenuRef menu,
   short top,
   short left,
   short popUpItem
);
Parameters
menu

The pop-up menu to be displayed. 
top

The y-coordinate of the top-left corner of the selected menu item when the menu opens. This value should be in global coordinates. 
left

The x-coordinate of the top-left corner of the selected menu item when the menu opens. This value should be in global coordinates.
popUpItem

The index of the menu item to display at the global point (top, left). If you pass zero, the first menu item is positioned at the indicated point. 
Return Value

The menu ID of the chosen menu in the high 16-bit word of the function result and the chosen menu item index value in the low 16-bit word. If no item was selected, the result is zero. 
Discussion

If your application uses the standard pop-up control definition function, your application does not need to use the PopUpMenuSelect function. PopUpMenuSelect uses the location specified by the top and left parameters to determine where to display the specified item of the pop-up menu. PopUpMenuSelect displays the pop-up menu so that the menu item specified in the popUpItem parameter appears highlighted at the specified location. 

The PopUpMenuSelect function highlights and unhighlights menu items and handles all user interaction until the user releases the mouse button. 

Note that PopUpMenuSelect sends a number of Carbon events during menu tracking (these are the same as those sent for MenuSelect):
kEventMenuBeginTracking when tracking begins, before displaying any menus. An event handler for this event may return userCanceledErr to prevent menu tracking from occurring. 
kEventMenuEndTracking after tracking was completed. 
kEventMenuChangeTrackingMode when the user switches from the mouse to the keyboard to navigate through menus, or vice versa. 
kÉventMenuOpening is sent to each menu that the user opens, just before it opens. An event handler for this event may return userCanceledErr to prevent menu tracking from occurring.
kEventMenuClosed is sent to each menu that the user closes.
kEventMenuPopulate is sent to a menu just before it is opened in a menu tracking session. This event is sent only once per menu tracking session.
kEventMenuEnableItems is sent to a menu just before it is opened in a menu tracking session. This event is sent only once per menu tracking session.
kEventCommandUpdateStatus is sent to a menu just before it is opened in a menu tracking session. This event is sent only once per menu tracking session.
kEventMenuTargetItem is sent to a menu when the mouse passes over a menu item or if the keyboard is used to select a menu item. This event is sent for both enabled and disabled menu items, and is also sent when the mouse is over a menu title. 
kEventCommandProcess is sent to a menu when the user chooses one of its menu items. 

For more details about these Carbon events, see the Carbon Event Manager Programming Guide. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
long PopUpMenuSelect (
   MenuRef menu,
   short top,
   short left,
   short popUpItem
){
printf ("PopUpMenuSelect",menu,top,left,popUpItem);
};

/*ScrollMenuImage

Scrolls a portion of the menu image.

OSStatus ScrollMenuImage (
   MenuRef inMenu,
   const Rect * inScrollRect,
   int inHScroll,
   int inVScroll,
   CGContextRef inContext
);
Parameters
inMenu

The menu to scroll. 
inScrollRect

The bounds of the area to scroll. 
inHScroll

The distance to scroll horizontally, in pixels. 
inVScroll

The distance to scroll vertically, in pixels. 
inContext

The Core Graphics context to scroll. If you pass NULL, the function creates a context based on the current port. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Scrolling menus on Mac OS X using ScrollRect or other QuickDraw functions destroys the alpha channel data, so you should use ScrollMenuImage instead. 
Availability
Available in CarbonLib 1.5 and later.
Available in Mac OS X 10.1 and later.
Declared In
Menus.h*/
OSStatus ScrollMenuImage (
   MenuRef inMenu,
   const Rect * inScrollRect,
   int inHScroll,
   int inVScroll,
   CGContextRef inContext
){
printf ("ScrollMenuImage",inMenu,*inScrollRect,inHScroll,inVScroll,inContext);
};

/*EraseMenuBackground

Erases the menu background to prepare for additional drawing.

OSStatus EraseMenuBackground (
   MenuRef inMenu,
   const Rect * inEraseRect,
   CGContextRef inContext
);
Parameters
inMenu

The menu whose background you want to erase. 
inEraseRect

The bounds of the area to erase, in the local coordinates of the current port. 
inContext

The Core Graphics context to erase. If set to NULL, this function creates a new context based on the current port. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Typically you use this function only if you are implementing message-based custom menu definition functions. HIView-based custom menus and normal application code do not need to call EraseMenuBackground. 

Before calling the Appearance Manager function DrawThemeMenuBackground, you must erase the current menu background. Themes such as Aqua draw the menu background using an alpha channel, so if the old background is not erased, portions of the old image will show through the menu background.
Availability
Available in CarbonLib 1.5 and later.
Available in Mac OS X 10.1 and later.
Declared In
Menus.h*/
OSStatus EraseMenuBackground (
   MenuRef inMenu,
   const Rect * inEraseRect,
   CGContextRef inContext
){
printf ("EraseMenuBackground",inMenu,*inEraseRect,inContext);
};


/*GetMenuAttributes

Gets the attributes of a menu.

OSStatus GetMenuAttributes (
   MenuRef menu,
   MenuAttributes * outAttributes
);
Parameters
menu

The menu. 
outAttributes

On exit, contains the attributes of the menu. See “Menu Attribute Constants” for a list of possible values. 
Return Value

A result code. See “Menu Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetMenuAttributes (
   MenuRef menu,
   MenuAttributes * outAttributes
){
printf ("GetMenuAttributes",menu,*outAttributes);
};

/*IsMenuSizeInvalid

Determines if a menu's size is invalid and should be recalculated.

Boolean IsMenuSizeInvalid (
   MenuRef inMenu
);
Parameters
inMenu

The menu whose size you want to examine. 
Return Value

Set to true if the menu size is invalid, false otherwise.
Discussion

Prior to Carbon, the technique for determining if a menu's size is invalid was to check if the width or height was -1. This technique is not always reliable in Carbon due to implementation changes in the Menu Manager, so you should use IsMenuSizeInvalid instead.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

Boolean IsMenuSizeInvalid (
   MenuRef inMenu
){
printf ("IsMenuSizeInvalid",inMenu);
};

/*SetMenuItemHierarchicalID

Attaches a submenu to a menu item. 

OSErr SetMenuItemHierarchicalID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuID inHierID
);
Parameters
inMenu

The menu that contains the menu item to which you wish to attach a submenu. 
inItem

The menu index of the item. 
inHierID

An integer representing the menu ID of the submenu you wish to attach. This menu should be inserted into the menu list by calling InsertMenu with the kInsertHierarchicalMenu constant. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The SetMenuItemHierarchicalID function should be called instead of setting the keyboard equivalent to 0x1B. You should call SetMenuItemHierarchicalID instead of SetItemMark to set the menu ID of a menu item’s submenu. However, you can still use SetItemMark to set the mark of a menu item. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSErr SetMenuItemHierarchicalID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuID inHierID
){
printf ("SetMenuItemHierarchicalID",inMenu,inItem,inHierID);
};


/*SetMenuItemIndent

Sets the indent level of a menu item.

OSStatus SetMenuItemIndent (
   MenuRef inMenu,
   MenuItemIndex inItem,
   UInt32 inIndent
);
Parameters
inMenu

The menu containing the item. 
inItem

The item whose indent level you want to set. 
inIndent

The new indent level of the item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The indent level of an item is an amount of extra space added to the left of the item's icon or checkmark. The level is simply a number, starting at zero, which the Menu Manager multiplies by a constant to get the indent in pixels. The default indent level is zero.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus SetMenuItemIndent (
   MenuRef inMenu,
   MenuItemIndex inItem,
   UInt32 inIndent
){
printf ("SetMenuItemIndent",inMenu,inItem,inIndent);
};

/*SetMenuTitleWithCFString

Sets the title of a menu to the text contained in a CFString.

OSStatus SetMenuTitleWithCFString (
   MenuRef inMenu,
   CFStringRef inString
);
Parameters
inMenu

The menu whose title you want to set. 
inString

The string containing the new menu title text. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

If the string is mutable, the Menu Manager will make its own copy of the CFString before returning from SetMenuTitleWithCFString. Modifying the string after calling SetMenuTitleWithCFString will then have no effect on the menu's actual title. 

If the string is immutable, the Menu Manager simply increments the string’s reference count. 

The caller may release the string after calling SetMenuTitleWithCFString.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus SetMenuTitleWithCFString (
   MenuRef inMenu,
   CFStringRef inString
){
printf ("SetMenuTitleWithCFString",inMenu,inString);
};


/*CreateCustomMenu

Creates a new, untitled, empty menu using a custom menu definition function.

OSStatus CreateCustomMenu (
   const MenuDefSpec * inDefSpec,
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
);
Parameters
inDefSpec

A data structure that specifies a custom menu definition function. 
inMenuID

The menu ID to use for the new menu. 
inMenuAttributes

The menu attributes to use for the new menu. See “Menu Attribute Constants” for a list of possible values. 
outMenuRef

On exit, contains the new menu. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Similar to CreateNewMenu, but also allows you to create a menu from a custom menu definition function This definition can be procedure pointer–based or HIView-based, which you specify in the MenuDefSpec structure. (Note that HIView–based menus are available only in Mac OS X v10.3 and later.)
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus CreateCustomMenu (
   const MenuDefSpec * inDefSpec,
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
){
printf ("CreateCustomMenu",*inDefSpec,inMenuID,inMenuAttributes,*outMenuRef);
};

/*NewMenuDefUPP

Creates a new univeral procedure pointer to your custom menu definition. 

Not recommended

MenuDefUPP NewMenuDefUPP (
   MenuDefProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the MenuDefUPP data type.
Availability
Not recommended. Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Apple discourages you from writing and using your own menu definition functions and encourages you to use the system-supplied menu definition function instead. New features that have previously been missing are now available in the system-supplied menu definition function. Since Appearance Manager 1.0 (in Mac OS 8.0), for example, the system-supplied menu definition function has supported extended menu item command key modifiers and glyphs. And in Carbon, the system-supplied menu definition function supports dynamic items, which allow the contents of a menu item to be redrawn while the menu is displayed in response to the user pressing a modifier key on the keyboard.
Declared In
Menus.h*/
MenuDefUPP NewMenuDefUPP (
   MenuDefProcPtr userRoutine
){
printf ("NewMenuDefUPP",userRoutine);
};


/*InsertMenuItemTextWithCFString

Inserts a new menu item with text from a CFString.

OSStatus InsertMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemIndex inAfterItem,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID
);
Parameters
menu

The menu in which to insert the new item. 
inString

The text of the new item. 
inAfterItem

The item after which to insert the new item. Pass zero to insert the item at the beginning of the menu. If the index value is greater than the number of items in the menu, the item is inserted at the end of the menu. 
inAttributes

The attributes of the new item. 
inCommandID

The command ID of the new item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

If the CFString is mutable, the Menu Manager will make its own copy of the CFString before returning from InsertMenuItemWithCFString. Modifying the string after calling InsertMenuItemTextWithCFString will have no effect on the menu item's actual text. 

If the CFString is immutable, the Menu Manager increments the reference count of the string before returning. 

The caller may release the string after calling InsertMenuItemTextWithCFString.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus InsertMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemIndex inAfterItem,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID
){
printf ("InsertMenuItemTextWithCFString",inMenu,inString,inAfterItem,inAttributes,inCommandID);
};


/*DisableMenuItem

Disables a menu item or a menu.

void DisableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the item to be disabled. 
item

The index of the menu item that you wish to disable. Pass 0 to specify the menu title (disabling the entire menu). 
Discussion

The DisableMenuItem function disables a menu item (and any associated icon) so that the user cannot choose the item from the menu. 

Note that EnableMenuItem calls the InvalMenuBar function to update the menu bar the next time through the event loop.

See also the EnableMenuItem and IsMenuItemEnabled functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Note that the implementation of Carbon on Mac OS 8.1 only supports disabling menu items less than or equal to 31.
Declared In
Menus.h*/
void DisableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item){
printf ("DisableMenuItem",theMenu,item);
};



/*EnableMenuItem

Enables a menu item or a menu.

void EnableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the item to be enabled. 
item

The item number of the menu item that you wish to enable. If you pass 0, EnableMenuItem enables the menu title and all items in the menu that were not previously individually disabled. 
Discussion

The EnableMenuItem function enables a menu item so that the user can choose the item from the menu. If the menu item has an associated icon, that icon is also enabled, unless the icon was previously individually disabled with the function DisableMenuItemIcon.

Note that EnableMenuItem calls the InvalMenuBar function to update the menu bar the next time through the event loop.

See also the DisableMenuItem and IsMenuItemEnabled functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item){
printf ("EnableItem",theMenu,item);
};


/*DisposeMenu

Decrements the retain count of a menu.

void DisposeMenu (
   MenuRef theMenu
);
Parameters
theMenu

The menu whose retain count to decrement. If the retain count falls to zero, the menu is destroyed. 
Discussion

The reference that you pass in the theMenu parameter is not valid after DisposeMenu returns. This function is identical to ReleaseMenu.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void DisposeMenu (
   MenuRef theMenu
){
printf ("DisposeMenu",theMenu);
};


/*DeleteMenu

Deletes an existing menu from the current menu list. 

void DeleteMenu (
   MenuID menuID
);
Parameters
menuID

The menu ID of the menu to delete from the current menu list. If the menu list does not contain a menu with the specified menu ID, DeleteMenu does nothing. 
Discussion

The DeleteMenu function deletes the menu identified by the specified menu ID from the current menu list. DeleteMenu decrements the reference count of the menu, and if the reference count reaches zero, the memory occupied by the menu is released. To explicitly release the memory occupied by the menu, use DisposeMenu.

The DeleteMenu function first checks the submenu portion of the current menu list for a menu ID with the specified ID. If it finds such a menu, it deletes that menu and returns. If DeleteMenu doesn’t find the menu in the submenu portion, it checks the regular portion of the current menu list. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void DeleteMenu (
   MenuID menuID
){
printf ("DeleteMenu",menuID);
};


/*AcquireRootMenu

Get the menu whose contents are displayed in the menubar.

MenuRef AcquireRootMenu ();
Return Value

The current root menu. See page for a description of the MenuRef data type. If no root menu currently exists, the Menu Manager creates one and returns its menu reference.
Discussion

This function increments the reference count of the root menu. The caller should call ReleaseMenu when done with the menu. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuRef AcquireRootMenu (){
printf ("AcquireRootMenu");
};


/*SetMenuItemCommandKey

Sets the keyboard equivalent of a menu item.

OSStatus SetMenuItemCommandKey (
   MenuRef inMenu,
   MenuItemIndex inItem,
   Boolean inSetVirtualKey,
   UInt16 inKey
);
Parameters
inMenu

The menu containing the item. 
inItem

The item whose keyboard equivalent you want to set. 
inSetVirtualKey

Indicates whether to set the item's character code (false) or virtual keycode equivalent. (true).
inKey

The character code or virtual keycode equivalent to set. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

A menu item's keyboard equivalent may be either a character code or a virtual keycode. The character code is always used to draw the item's keyboard equivalent in the menu, but either may be used for keyboard equivalent matching by MenuEvent and IsMenuKeyEvent, depending on whether the kMenuItemAttrUseVirtualKey item attribute is set. If SetMenuItemCommandKey is used to set the virtual keycode equivalent for a menu item, it also automatically sets the kMenuItemAttrUseVirtualKey item attribute. To make the menu item stop using the virtual keycode equivalent and use the character code equivalent instead, use ChangeMenuItemAttributes to clear the kMenuItemAttrUseVirtualKey item attribute.
Version Notes

Prior to Mac OS X v10.3, passing a character code in the range 0x1A to 0x21 (the range of command key metacharacters such as hMenuCmd) returned an error. In Mac OS X v10.3 and later, the Menu Manager interprets codes in this range as the ASCII character for that value, and displays the appropriate command key glyph. For example, passing hMenuCmd would set the keyboard equivalent to be command-Escape, because the value of hMenuCmd (0x1B) is the character code for the Escape character. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus SetMenuItemCommandKey (
   MenuRef inMenu,
   MenuItemIndex inItem,
   Boolean inSetVirtualKey,
   UInt16 inKey
){
printf ("SetMenuItemCommandKey",inMenu,inItem,inSetVirtualKey,inKey);
};


/*DisableAllMenuItems

Disables all items in a menu.

void DisableAllMenuItems (
   MenuRef theMenu
);
Parameters
theMenu

The menu whose items you want to disable. 
Discussion

This function is equivalent to older code that masked the enableFlags field of the MenuInfo structure (now opaque in Carbon) with 0x01. It disables all items (including items past item 31) but does not affect the state of the menu title.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DisableAllMenuItems (
   MenuRef theMenu
){
printf ("DisableAllMenuItems",theMenu);
};


/*DisableMenuItemIcon

Disables the icon associated with a menu item.

void DisableMenuItemIcon (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the icon to be disabled. 
item

The index of the menu item containing the icon. 
Discussion

Your application can use the DisableMenuItemIcon function to dim individual menu item icons. The menu item that contains the icon is unaffected by calling DisableMenuItemIcon. That is, if DisableMenuItemIcon disables an enabled menu item’s icon, the menu item itself will remain enabled. Calling DisableMenuItemIcon on the icon of a menu item that is currently disabled will cause the icon to be disabled once the menu item is re-enabled.

See also the functions EnableMenuItemIcon and IsMenuItemIconEnabled. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DisableMenuItemIcon (
   MenuRef theMenu,
   MenuItemIndex item
){
printf ("DisableMenuItemIcon",theMenu,item);
};


/*NewMenu

Creates an empty menu with a specified title and menu ID. 

Not recommended

MenuRef NewMenu (
   MenuID menuID,
   ConstStr255Param menuTitle
);
Parameters
menuID

The ID for the menu. The menu ID is a number that identifies the menu. Menu IDs in Carbon can be any value, but Apple recommends that the ID be either zero or positive. A menu ID of zero is a valid ID. IDs of submenus should similarly be zero or a positive value. 
menuTitle

The title of the new menu. Note that in most cases you should store the titles of menus in resources, so that your menu titles can be more easily localized. 
Return Value

A menu reference. If the NewMenu function is unable to create the menu structure, it returns NULL. See the description of the MenuRef data type.
Discussion

Unless you must support legacy code, you should not use functions like NewMenu. If you need to create menus programmatically, you can call CreateNewMenu; otherwise you should define menus in Interface Builder, store them as nib files, and then call the Interface Builder Services function CreateMenuFromNib to create them. 

The NewMenu function creates a menu with the specified title, assigns it the specified menu ID, and returns a handle to the menu structure. It sets up the menu structure to use the standard menu definition function (and it reads the standard menu definition function into memory if it isn’t already there). NewMenu does not insert the newly created menu into the current menu list.

After creating a menu with NewMenu, use AppendMenu , InsertMenuItem , AppendResMenu , or InsertResMenu to add menu items to the menu. To add a menu created by NewMenu to the current menu list, use InsertMenu. In Carbon, you do not need to call DrawMenuBar to update the menu bar, as the Menu Manager automatically invalidates andredraws the menu bar.

Menus in a resource must not be purgeable nor should the resource lock bit be set. Do not define a “circular” hierarchical menu—that is, a hierarchical menu in which a submenu has a submenu whose submenu is a hierarchical menu higher in the chain. 
Special Considerations

To release the memory associated with a menu that you created using NewMenu, first call DeleteMenu to remove the menu from the current menu list and to remove any entries for this menu in your application’s menu color information table then call DisposeMenu to dispose of the menu structure. Note that in Carbon, the Menu Manager automatically invalidates and redraws the menu bar after disposing of a menu. 
Version Notes

Note that if you are running on Mac OS 8.1 and earlier, the menu ID of a submenu must be within the range 0 to 255. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuRef NewMenu (
   MenuID menuID,
   ConstStr255Param menuTitle
){
printf ("NewMenu",menuID,menuTitle);
};


/*MenuSelect

Allows the user to choose a menu item from a menu in the menu bar.

long MenuSelect (
   Point startPt
);
Parameters
startPt

The location of the cursor at the time the mouse button was first pressed, in global coordinates. Your application retrieves this point from the kEventParamMouseLocation parameter of a Carbon event, or the where field of the EventRecord structure. 
Return Value

If the user chooses an enabled menu item (including any item from a submenu), the MenuSelect function returns a value as its function result that indicates which menu and menu item the user chose. The high-order word of the function result contains the menu ID of the menu, and the low-order word contains the item number of the menu item chosen by the user. 
Discussion

If your application uses Carbon events, you probably don’t need to use this function. The standard event handler installed by the Carbon Event Manager function RunApplicationEventLoop calls MenuSelect for you to begin tracking when the user clicks in a menu. If you do not call RunApplicationEventLoop, however, you will need to use this function to initiate menu tracking. 

When the user presses the mouse button while the cursor is in the menu bar, your application receives a mouse-down event. To handle mouse-down events in the menu bar, pass the location of the cursor at the time of the mouse-down event as the startPt parameter to MenuSelect. The MenuSelect function displays and removes menus as the user moves the cursor over menu titles in the menu bar, and it handles all user interaction until the user dismisses the menu.

As the user drags the cursor through the menu bar, the MenuSelect function highlights the title of the menu the cursor is currently over and displays all items in that menu. If the user moves the cursor so that it is over a different menu, the MenuSelect function removes the previous menu and unhighlights its menu title.

The MenuSelect function highlights and unhighlights menu items as the user drags the cursor over the items in a menu. The MenuSelect function highlights a menu item if the item is enabled and the cursor is currently over it; it removes such highlighting when the user moves the cursor to another menu item. The MenuSelect function does not highlight disabled menu items.

If the user chooses an enabled menu item (including any item from a submenu), the MenuSelect function returns a value as its function result that indicates which menu and menu item the user chose. The high-order word of the function result contains the menu ID of the menu, and the low-order word contains the item number of the menu item chosen by the user.The MenuSelect function leaves the menu title highlighted; after performing the chosen task your application should unhighlight the menu title using the HiliteMenu function.

If the user chooses an item from a submenu, MenuSelect returns the menu ID of the submenu in the high-order word and the item chosen by the user in the low-order word of its function result. The MenuSelect function also highlights the title of the menu in the menu bar that the user originally displayed in order to begin traversing to the submenu. After performing the chosen task, your application should unhighlight the menu title.

If the user releases the mouse button while the cursor is over a disabled item, in the menu bar, or outside of any menu, the MenuSelect function returns 0 in the high-order word of its function result and the low-order word is undefined. If it is necessary for your application to find the item number of the disabled item, your application can call MenuChoice to return the menu ID and menu item.

Note that MenuSelect sends a number of Carbon events during menu tracking:
kEventMenuBeginTracking when tracking begins, before displaying any menus. An event handler for this event may return userCanceledErr to prevent menu tracking from occurring. 
kEventMenuEndTracking after tracking was completed. 
kEventMenuChangeTrackingMode when the user switches from the mouse to the keyboard to navigate through menus, or vice versa. 
kÉventMenuOpening is sent to each menu that the user opens, just before it opens. An event handler for this event may return userCanceledErr to prevent menu tracking from occurring.
kEventMenuClosed is sent to each menu that the user closes.
kEventMenuPopulate is sent to a menu just before it is opened in a menu tracking session. This event is sent only once per menu tracking session.
kEventMenuEnableItems is sent to a menu just before it is opened in a menu tracking session. This event is sent only once per menu tracking session.
kEventCommandUpdateStatus is sent to a menu just before it is opened in a menu tracking session. This event is sent only once per menu tracking session.
kEventMenuTargetItem is sent to a menu when the mouse passes over a menu item or if the keyboard is used to select a menu item. This event is sent for both enabled and disabled menu items, and is also sent when the mouse is over a menu title. 
kEventCommandProcess is sent to a menu when the user chooses one of its menu items. 

For more details about these Carbon events, see the Carbon Event Manager Reference. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Carbon does not support desk accessories, so MenuSelect cannot be used in Mac OS X to pass keyboard equivalents to desk accessories.
Declared In
Menus.h */

long MenuSelect (
   Point startPt
){
printf ("MenuSelect",startPt);
};


/*MenuKey

Maps a character key with the command key to determine the keyboard equivalent of a menu item in a menu in the current menu list. 

Not recommended

long MenuKey (
   CharParameter ch
);
Parameters
ch

The 1-byte character that represents the key pressed by the user in combination with the Command key. 
Return Value

A value containing the menu ID and menu item that corresponds to the given character.If the given character does not map to an enabled menu item in the current menu list, MenuKey returns 0 in its high-order word and the low-order word is undefined. 
Discussion

Note that unless your application uses the WaitNextEvent event model, you should use the Carbon event–based IsMenuKeyEvent instead. Even when using the WaitNextEvent model, you should probably use MenuEvent, as that function supports the Shift, Option, and Control modifier keys in addition to the Command key

The MenuKey function determines whether the key combination maps to a current menu item when the user presses another key while holding down the Command key.

MenuKey does not distinguish between uppercase and lowercase letters. This allows a user to invoke a keyboard equivalent command, such as the Copy command, by pressing the Command key and “c” or “C”. For consistency between applications, you should define the keyboard equivalents of your commands so that they appear in uppercase in your menus.

You should not define menu items with identical keyboard equivalents. The MenuKey function scans the menus from right to left and the items from top to bottom. If you have defined more than one menu item with identical keyboard equivalents, MenuKey returns the first one it finds.

If the given character maps to an enabled menu item in the current menu list, MenuKey highlights the menu title of the chosen menu, returns the menu ID in the high-order word of its function result, and returns the chosen menu item in the low-order word of its function result. After performing the chosen task, your application should unhighlight the menu title using the HiliteMenu function.

The MenuKey function first searches the regular portion of the current menu list for a menu item with a keyboard equivalent matching the given key. If it doesn’t find one there, it searches the submenu portion of the current menu list. If the given key maps to a menu item in a submenu, MenuKey highlights the menu title in the menu bar that the user would normally pull down to begin traversing to the submenu. Your application should perform the desired command and then unhighlight the menu title.

You shouldn’t assign a Command–Shift–number key sequence to a menu item as its keyboard equivalent Command–Shift–number key sequences are reserved for use as ' FKEY ' resources. Command–Shift–number key sequences are not returned to your application, but instead are processed by the Event Manager. The Event Manager invokes the ' FKEY ' resource with a resource ID that corresponds to the number that activates it.

Apple reserves the Command-key codes 0x1B through 0x20 to indicate meanings other than keyboard equivalents. MenuKey ignores these character codes and returns a function result of 0 if you specify any of these values in the ch parameter. Your application should not use these character codes for its own use 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Carbon does not support desk accessories, so MenuKey cannot be used in OS X to pass keyboard equivalents to desk accessories.
Declared In
Menus.h*/
long MenuKey (
   CharParameter ch
){
printf ("MenuKey",ch);
};



/*GetMenuHandle

Obtains a menu reference corresponding to a menu ID. 

MenuRef GetMenuHandle (
   MenuID menuID
);
Parameters
menuID

The menu ID of the menu whose reference you want to obtain. (Note that this is not the resource ID, although you often assign the menu ID so that it matches the resource ID.) You assign a menu ID in a nib file or in the 'MENU' resource of a menu. If you do not define your menus in nib files or in ‘MENU’' resources, you can assign a menu ID using NewMenu or SetMenuID. 
Return Value

The menu corresponding to the specified ID. If the specified menu is not in the current menu list, GetMenuHandle returns NULL. See the description of the MenuRef data type.
Discussion

You can also call this function as GetMenuRef (menuID);.

Use the GetMenuHandle function to obtain the menu reference for any of your application’s pull-down menus or submenus in the current menu list, other than the Help menu. You can also use the Help Manager function HMGetHelpMenuHandle to get a handle for your application’s Help menu. 
Special Considerations

To get a menu reference for a pop-up menu that you create using the pop-up control definition function, call the Control Manager functions GetControlData and GetControlDataSize, passing the tag constant kControlPopupButtonMenuRefTag in the tagName parameter to specify the menu reference.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuRef GetMenuHandle (
   MenuID menuID
){
printf ("GetMenuHandle",menuID);
};

/*SetMenuItemCommandID

Sets a menu item’s command ID. 

OSErr SetMenuItemCommandID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuCommand inCommandID
);
Parameters
inMenu

The menu that contains the menu item whose command ID you want to set. 
inItem

The menu index of the item. 
inCommandID

An integer representing the command ID that you wish to set. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can use a menu item’s command ID as a position-independent method of signalling a specific action in an application. See Carbon Event Manager Programming Guide for more information about command IDs. 

Note that Apple reserves all command IDs that contain all lowercase letters; your application is free to use any command ID containing uppercase characters.

See also the function GetMenuItemCommandID. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSErr SetMenuItemCommandID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuCommand inCommandID
){
printf ("SetMenuItemCommandID",inMenu,inItem,inCommandID);
};

/*InsertMenu

Inserts an existing menu into the current menu list. 

void InsertMenu (
   MenuRef theMenu,
   MenuID beforeID
);
Parameters
theMenu

The menu to insert. 
beforeID

An integer that indicates where in the current menu list the menu should be inserted. InsertMenu inserts the menu into the current menu list before the menu whose menu ID is specified in the beforeID parameter. If the number in the beforeID parameter is 0 (or it isn’t the ID of any menu in the menu list), InsertMenu adds the new menu after all others (except before the Help menu). If the menu is already in the current menu list or the menu list is already full, InsertMenu does nothing. 

To insert a submenu into the current menu list, specify –1 or the equivalent constant kInsertHierarchicalMenu for the beforeID parameter. The submenus in the submenu portion of the menu list do not have to be currently associated with a hierarchical menu item; you can store submenus in the menu list and later specify that a menu item has a submenu if needed. However, note that during command key matching the Menu Manager scans all menus in the menu list for modifiers, including submenus that are not associated with any menu item. 

You can also specify –1 for the beforeID parameter to insert a pop-up menu into the current menu list. However, if you use the standard pop-up control definition function, the pop-up control automatically inserts the menu into the current menu list according to the needs of the pop-up control.

Discussion

Menus inserted using this function are added to a menu list attached to the current root menu. To obtain or set this root menu, call AcquireRootMenu and SetRootMenu respectively. 

Inserting a menu in the root menu (menu bar) increments its reference count; removing the menu decrements its reference count. 


To change a menu title, call SetMenuItemTextWithCFString. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void InsertMenu (
   MenuRef theMenu,
   MenuID beforeID
){
printf ("InsertMenu",theMenu,beforeID);
};





/*ContextualMenuSelect

Displays a contextual menu.

OSStatus ContextualMenuSelect (
   MenuRef inMenu,
   Point inGlobalLocation,
   Boolean inReserved,
   UInt32 inHelpType,
   ConstStr255Param inHelpItemString,
   const AEDesc * inSelection,
   UInt32 * outUserSelectionType,
   SInt16 * outMenuID,
   MenuItemIndex * outMenuItem
);
Parameters
inMenu

The menu containing application commands to display. The caller creates this menu based on the current context, the mouse location, and the current selection (if it was the target of the mouse). If you pass NULL, only system commands are displayed. 
inGlobalLocation

The location (in global coordinates) of the mouse near which the menu is to be displayed. 
inReserved

Reserved for future use. Pass false for this parameter. 
inHelpType

An identifier specifying the type of help provided by the application; see “Contextual Menu Help Type Constants”. 
inHelpItemString

The string containing the text to be displayed for the help menu item. This string is unused unless you also pass the constant kCMOtherHelp in the inHelpType parameter. 
inSelection

A pointer to an object specifier for the current selection. This allows the system to examine the selection and add special system commands accordingly. Passing a value of NULL indicates that no selection should be examined, and most likely, no special system actions will be included. 
outUserSelectionType

A pointer to an unsigned 32-bit value. On return, the value indicates what the user selected from the contextual menu; see “Contextual Menu Selection Type Constants” for a list of possible values.
outMenuID

A pointer to a signed 16-bit value. On return, if outUserSelectionType is set to kCMMenuItemSelected, the value is set to the menu ID of the chosen item. 
outMenuItem

A pointer to an unsigned 16-bit value. On return, if outUserSelectionType is set to kCMMenuItemSelected, the value is set to the index of the menu item chosen. 
Return Value

A result code. See “Menu Manager Result Codes”. Returns userCanceledErr and sets outUserSelectionType to kCMNothingSelected if the user selects an item that requires no additional actions on your part.
Discussion

If your application uses the standard window handler, you may want to install handlers for the kEventWindowContextualMenuSelect or kEventControlContextualMenuClick events and call ContextualMenuSelect from within your handler. The standard window handler automatically detects contextual menu clicks and sends the kEventWindowContextualMenuSelect and kEventControlContextualMenuClick events. 

If the IsShowContextualMenuEvent function returns true or you receive the appropriate contextual menu Carbon event, you should call the ContextualMenuSelect function after generating your own menu and preparing an Apple Event descriptor ( AEDesc) that describes the item for which your application is displaying a contextual menu. This descriptor may contain an object specifier or raw data and will be passed to all contextual menu plug-ins.

The system will add other items before displaying the contextual menu, and it will remove those items before returning, leaving the menu in its original state.

After all the system commands are added, the contextual menu is displayed and tracked. If the user selects one of the system items, it is handled by the system and the call returns as though the user didn’t select anything from the menu. If the user selects any other item (or no item at all), the Menu Manager passes back appropriate values in the parameters outUserSelectionType, outMenuID, and outMenuItem.

Your application should provide visual feedback indicating the item that was clicked upon. For example, a click on an icon should highlight the icon, while a click on editable text should not eliminate the current selection. 

If the outUserSelectionType parameter contains kCMMenuItemSelected, you should look at the outMenuID and outMenuItem parameters to determine what menu item the user chose and handle it appropriately. If the outUserSelectionType parameter contains kCMShowHelpSelected, you should open the proper help sequence.
Availability
Available in CarbonLib 1.0 and later when Contextual Menus 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus ContextualMenuSelect (
   MenuRef inMenu,
   Point inGlobalLocation,
   Boolean inReserved,
   UInt32 inHelpType,
   ConstStr255Param inHelpItemString,
   const AEDesc * inSelection,
   UInt32 * outUserSelectionType,
   SInt16 * outMenuID,
   MenuItemIndex * outMenuItem
){
printf ("ContextualMenuSelect",inMenu,inGlobalLocation,inReserved,inHelpType,inHelpItemString,*inSelection,*outUserSelectionType,*outMenuID,*outMenuItem);
};


/*SetMenuCommandMark

Locates the menu item with a specified command ID and sets its mark character.

OSStatus SetMenuCommandMark (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UniChar inMark
);
Parameters
inMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID of the menu item to be modified. If more than one item has this command ID, only the first will be modified. 
inMark

The new mark character. While this is a Unicode character, only the low byte is currently used as the mark character, and it is interpreted using the application text encoding. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

If you have access to the menu item index, in most cases you should use SetItemMark instead, as that function is faster and requires no searching.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus SetMenuCommandMark (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UniChar inMark
){
printf ("SetMenuCommandMark",inMenu,inCommandID,inMark);
};


/*GetMenuItemProperty

Obtains a piece of data that has been previously associated with a menu item.

OSStatus GetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
);
Parameters
menu

The menu containing the item to be examined for associated data. 
item

The index number of the menu item or 0 if the data is associated with the menu as a whole. 
propertyCreator

A four-character code. Pass your program’s signature (also called a creator), as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The 'macs' property signature is reserved for the system and may not be used. 
propertyTag

A four-character code. Pass the application-defined code identifying the data.
bufferSize

The size of the data to be obtained. If this is unknown, use the function GetMenuItemPropertySize to get the data’s size. If the size specified in the bufferSize parameter does not match the actual size of the property, GetMenuItemProperty only retrieves data up to the size specified or up to the actual size of the property, whichever is smaller, and an error is returned. 
actualSize

On input, a pointer to an unsigned 32-bit integer. On return, this value is set to the actual size of the associated data. You may pass NULL for the actualSize parameter if you are not interested in this information.
propertyBuffer

On input, a pointer to a buffer. On return, this buffer contains a copy of the data that is associated with the specified menu item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You may use the function GetMenuItemProperty to obtain a copy of data previously set with the function SetMenuItemProperty.

See also the RemoveMenuItemProperty function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
){
printf ("GetMenuItemProperty",menu,item,propertyCreator,propertyTag,bufferSize,*actualSize,propertyBuffer);
};

/*GetIndMenuItemWithCommandID

Finds a menu item with a specified command ID.

OSStatus GetIndMenuItemWithCommandID (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UInt32 inItemIndex,
   MenuRef * outMenu,
   MenuItemIndex * outIndex
);
Parameters
inMenu

The menu in which to begin searching for items with the specified command ID. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID for which to search. 
inItemIndex

The 1-based index of the menu item to retrieve. In CarbonLib 1.0.x, this parameter must be 1. In CarbonLib 1.1 and Mac OS X 1.0, this parameter may vary from 1 to the number of menu items with the specified command ID. 
outMenu

On exit, the menu containing the menu item with the specified command ID.
outIndex

On exit, the item index of the menu item with the specified command ID. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

This API searches the specified menu and its submenus for the n'th menu item with the specified command ID. You often want to use this function in conjunction with CountMenuItemsWithCommandID.
Version Notes

In CarbonLib 1.1 and earlier, only the first menu item will be returned. In CarbonLib 1.2 and Mac OS X v10.0 and later, this API will iterate over all menu items with the specified command ID and return the itemIndex’th one. 

In Mac OS X v10.0 and CarbonLib 1.0 through 1.4, this function searches only top-level menus (that is, those that are visible in the menu bar) and submenus of top-level menus. It does not search hierarchical menus that are in the menu bar but are not submenus of a top-level menu. For example, it does not search menus that are inserted for use in a popup menu. In Mac OS X v10.1 and later, and CarbonLib 1.5 and later, this function also searches hierarchical menus. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus GetIndMenuItemWithCommandID (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UInt32 inItemIndex,
   MenuRef * outMenu,
   MenuItemIndex * outIndex
){
printf ("GetIndMenuItemWithCommandID",inMenu,inCommandID,inItemIndex,*outMenu,*outIndex);
};


/*AppendMenu

Appends one or more items to a menu previously created.

Not recommended

void AppendMenu (
   MenuRef menu,
   ConstStr255Param data
);
Parameters
menu

The menu to which you wish to append the menu item or items. 
data

A Pascal string that defines the characteristics of the new menu item or items. Note that in most cases you should store the text of a menu item in a resource, so that your menu items can be more easily localized. The AppendMenu function appends the menu items in the order in which they are listed in the data parameter. 
Discussion

Note that unless you are supporting legacy code, you should use the AppendMenuItemTextWithCFString function instead. 

The AppendMenu function appends any defined menu items to a previously-created menu. The menu items are added to the end of the menu. You specify the text of any menu items and their characteristics in the data parameter. You can embed metacharacters in the string to define various characteristics of a menu item. 

Table 1 lists the metacharacters that you can specify in the data parameter:
Table 1  Metacharacters available to pass in AppendMenu
Metacharacter	
Description

; or Return	
Separates menu items.

^	
When followed by an icon number, defines the icon for the item. If the keyboard equivalent field contains 0x1C, this number is interpreted as a text encoding.

!	
When followed by a character, defines the mark for the item. If the keyboard equivalent field contains 0x1B or the equivalent constant hMenuCmd, this value is interpreted as the menu ID of a submenu of this menu item. 

<	
When followed by one or more of the characters B, I, U, O, and S, defines the character style of the item to Bold, Italic, Underline, Outline, or Shadow, respectively.

/	
When followed by a character, defines the keyboard equivalent for the item. When followed by 0x1B or the equivalent constant hMenuCmd, specifies that this menu item has a submenu. To specify that the menu item has a text encoding, small icon, or reduced icon, use the SetItemCmd function to set the keyboard equivalent field to 0x1C, 0x1D, or 0x1E, respectively. 

(	
Defines the menu item as disabled. 


You can specify any, all, or none of these metacharacters in the text string. The metacharacters that you specify aren’t displayed in the menu item. (To use any of these metacharacters in the text of a menu item, first use AppendMenu, specifying at least one character as the item’s text, and then use the function SetMenuItemText to set the item’s text to the desired string.)

If you add menu items using the AppendMenu function, you should define the text and any marks or keyboard equivalents in resources for easier localization. 

You can specify the first character that defines the text of a menu item as a hyphen to create a divider line. The string in the data parameter can be blank (containing one or more spaces), but it should not be an empty string. 

If you do not define a specific characteristic of a menu item, the AppendMenu function assigns the default characteristic to the menu item. If you do not define any characteristic other than the text for a menu item, the AppendMenu function inserts the menu item so that it appears in the menu as an enabled item, without an icon or a mark, in the plain character style, and without a keyboard equivalent.

You can use AppendMenu to append items to a menu regardless of whether the menu is in the current menu list. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void AppendMenu (
   MenuRef menu,
   ConstStr255Param data
){
printf ("AppendMenu",menu,data);
};

/*DrawMenuBar

Draws the menu bar based on the current menu list.

void DrawMenuBar ();
Discussion

The DrawMenuBar function draws (or redraws) the menu bar according to the current menu list. Note that most Menu Manager calls that affect the menu bar call InvalMenuBar so that the menu bar is redrawn the next time through the event loop; however, you can call DrawMenuBar if you want the changes to appear immediately. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DrawMenuBar (){
printf ("DrawMenuBar");
};




/*SetMenuBar

Sets the current menu list to a specified menu list.

void SetMenuBar (
   MenuBarHandle mbar
);
Parameters
mbar

A handle to a menu list that specifies the menus for a menu bar. You should specify a handle returned by GetMenuBar or GetNewMBar. 
Discussion

The SetMenuBar function copies the given menu list to the current menu list. As with GetMenuBar , SetMenuBar doesn’t copy the menu structures, just the menu list (which contains handles to the menu structures).

You can use SetMenuBar to restore a menu list that you previously saved using GetMenuBar or to set the current menu list to a menu list created from a nib file or from GetNewMBar. 

The SetMenuBar function sets the current menu list and calls InvalMenuBar so the menu bar can be updated the next time through the event loop; if you want to redraw the menu bar immediately, call the DrawMenuBar function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void SetMenuBar (
   MenuBarHandle mbar){
printf ("SetMenuBar",mbar);
};


//work



/*ReleaseMenu

Decrements the retain count of a menu.

OSStatus ReleaseMenu (
   MenuRef inMenu
);
Parameters
inMenu

The menu whose retain count to decrement. If the retain count falls to zero, the menu is destroyed. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The reference that you pass in the theMenu parameter is not valid after DisposeMenu returns. This function is identical to DisposeMenu.
Version Notes

In Mac OS X v10.2 and later, all menus are Core Foundation CFTypes, so you can optionally call CFRelease instead of ReleaseMenu.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus ReleaseMenu (
   MenuRef inMenu
){};

/*GetMenuID

Obtains the ID of a menu.

MenuID GetMenuID (
   MenuRef menu
);
Parameters
menu
Return Value

The menu ID of the menu. See the description of the MenuID data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuID GetMenuID (
   MenuRef menu
){};

/*ShowMenuBar

Displays the menu bar.

void ShowMenuBar ();
Discussion

The ShowMenuBar function makes the menu bar visible and selectable by the user. 

Note that calling this function also causes a kEventMenuBarShown event to be sent to the application target (if your application has registered for the event). 

See also the HideMenuBar and IsMenuBarVisible functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void ShowMenuBar (){};


/*HideMenuBar

Conceals the menu bar.

void HideMenuBar ();
Discussion

The HideMenuBar function makes the menu bar invisible and unselectable by the user. You can use this function to enable full-screen display; however, in Mac OS X v10.2 and later, you should call the SetSystemUIMode function (available in MacApplication.h) instead. 

Note that calling this function causes the kEventMenuBarHidden event to be sent to the application target (if your application has registered for the event).

Also see the ShowMenuBar and IsMenuBarVisible functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void HideMenuBar (){};


/*GetMBarHeight

Determines the current height of the menu bar.

short GetMBarHeight ();
Return Value

The current height, in pixels, of the menu bar. 
Discussion

The GetMBarHeight function determines the menu bar height based on factors such as the current script system and theme. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
short GetMBarHeight (){};


/*GetItemMark

Returns a menu item’s mark.

void GetItemMark (
   MenuRef theMenu,
   short item,
   CharParameter * markChar
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
markChar

On output, an integer representing the mark of the menu item or its submenu (item has a submenu). See the Font Manager for a list of character marking constants that this function can obtain. This parameter is set to 0 if the menu item has neither mark nor submenu. 
Discussion

You should call GetMenuItemHierarchicalID instead of GetItemMark to obtain the menu ID of a menu item’s submenu. However, you can still use GetItemMark to obtain the mark of a menu item.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void GetItemMark (
   MenuRef theMenu,
   short item,
   CharParameter * markChar
){};

/*CheckMenuItem

Adds or removes a check mark from a menu item.

void CheckMenuItem (
   MenuRef theMenu,
   short item,
   Boolean checked
);
Parameters
theMenu

The menu containing the menu item to check or uncheck. 
item

The menu index of the item to check or uncheck. 
checked

Pass true to add a check, false to remove it. 
Discussion

You can also add or remove a check mark using the SetItemMark function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void CheckMenuItem (
   MenuRef theMenu,
   short item,
   Boolean checked
){};




/*GetFontFamilyFromMenuSelection

Gets the font family reference and style from the menu identifier and menu item number returned by the function MenuSelect.

OSStatus GetFontFamilyFromMenuSelection (
   MenuRef menu,
   MenuItemIndex item,
   FMFontFamily * outFontFamily,
   FMFontStyle * outStyle
);
Parameters
menu

A menu handle. 
item

A menu item index. 
outFontFamily

A pointer to the font family reference associated with the menu item. 
outStyle

A pointer to the font style associated with the menu item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You use this function to obtain information from a font menu created using CreateStandardFontMenu, AppendResMenu, InsertFontResMenu, InsertIntlResMenu, or InsertResMenu.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetFontFamilyFromMenuSelection (
   MenuRef menu,
   MenuItemIndex item,
   FMFontFamily * outFontFamily,
   FMFontStyle * outStyle
){};



/*GetMenuItemText

Obtains the text of a menu item. 

Not recommended

void GetMenuItemText (
   MenuRef theMenu,
   short item,
   Str255 itemString
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
itemString

On output, the menu item’s text string. 
Discussion

Unless you need to support legacy code, you should use the CopyMenuItemTextAsCFString instead. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void GetMenuItemText (
   MenuRef theMenu,
   short item,
   Str255 itemString
){};


/*CreateStandardFontMenu

Creates a standard font menu.

OSStatus CreateStandardFontMenu (
   MenuRef menu,
   MenuItemIndex afterItem,
   MenuID firstHierMenuID,
   OptionBits options,
   ItemCount * outHierMenuCount
);
Parameters
menu

The menu to which you want to add the font items. 
afterItem

The item number of the menu item after which the new menu items are to be added. If you want to insert the new items before the first menu items, specify 0. If you want to insert the items after the last item in the menu, specify a number greater than or equal to the last item in the menu. Otherwise, specify the item number for the menu item after which you want to insert new items. 
firstHierMenuID

The first menu ID to use if any hierarchical menus are created. This ID is incremented for each additional hierarchical menu. 
options

An option bits structure that specifies the behavior for the Font menu. Specify the Hierarchical Font Menu Option Constant if you want to construct a hierarchical font menu. 
outHierMenuCount

On return, this parameter contains the number of hierarchical menus attached to the standard font menu. This value may be NULL if the hierarchical menus count is not useful. For example, if the only submenus in your application are those created by CreateStandardFontMenu, then you don’t need to worry about the hierarchical menu count, as any existing submenu must be a font menu. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You should use this function instead of the functions AppendResMenu or InsertResMenu to designate objects in the font database as menu items in the Font menu. The fonts objects will appear by name. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CreateStandardFontMenu (
   MenuRef menu,
   MenuItemIndex afterItem,
   MenuID firstHierMenuID,
   OptionBits options,
   ItemCount * outHierMenuCount
){};


/*SetMenuItemProperty

Associates data with a menu item.

OSStatus SetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
);
Parameters
menu

The menu containing the item with which you wish to associate data. 
item

The index number of the menu item or 0 if the data is to be associated with the menu as a whole. 
propertyCreator

A four-character code. Pass your program’s signature, as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The 'macs' property signature is reserved for the system and may not be used. 
propertyTag

A four-character code that identifies the property to set. You define the tag your application uses to identify the data; this code is not to be confused with the file type for the data, but may coincide if you wish.
propertySize

The size of the data. 
propertyData

A pointer to the data. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You may use the SetMenuItemProperty function to associate arbitrary data, tagged with an identifying code, with a menu item.

See also the GetMenuItemProperty and RemoveMenuItemProperty functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus SetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
){};


/*SetMenuItemIconHandle

Sets a menu item’s icon.

OSErr SetMenuItemIconHandle (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inIconType,
   Handle inIconHandle
);
Parameters
inMenu

The menu that contains the menu item for which you wish to set an icon. 
inItem

The menu index of the item. 
inIconType

Pass a value representing the type of icon ('ICON', 'cicn', 'SICN', icon suite, or IconRef) you wish to attach; see “Menu Item Icon Type Constants” for descriptions of possible values. 
inIconHandle

Pass a handle to the icon you wish to attach to a menu item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The SetMenuItemIconHandle function sets the icon of a menu item with an icon handle instead of a resource ID. SetMenuItemIconHandle allows you to set icons of type 'ICON', 'cicn', 'SICN', IconRef, CGImageRef, as well as icon suites. To set resource-based icons for a menu item, call SetItemIcon. 

With the exception of types IconRef and CGImageRef,disposing of the menu will not dispose of the icon handles set by this function. The Menu Manager retains IconRef, CGImageRef icons and releases them when the menu is disposed or the menu item is removed. For all other icon types, your application should dispose of the icons when you dispose of the menu, to prevent memory leaks.

See also the function GetMenuItemIconHandle. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSErr SetMenuItemIconHandle (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inIconType,
   Handle inIconHandle
){};

/*RetainMenu

Increments the reference count of a menu.

OSStatus RetainMenu (
   MenuRef inMenu
);
Parameters
inMenu

The menu whose reference count you want to increment. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

RetainMenu does not create a new menu. It simply adds one to the reference count. 
Version Notes

In Mac OS X v10.2 and later, all menus are Core Foundation CFTypes, so you can optionally call CFRetain instead of RetainMenu.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus RetainMenu (
   MenuRef inMenu
){};



/*CreateNewMenu

Creates a new, untitled, empty menu.

OSStatus CreateNewMenu (
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
);
Parameters
inMenuID

The menu ID to use for the new menu. Note that zero is a valid ID in Carbon. 
inMenuAttributes

The menu attributes to use for the new menu. See “Menu Attribute Constants” for a list of possible values. 
outMenuRef

On exit, contains the new menu. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Unless you need to create new menus on-the-fly, you should not use functions like CreateNewMenu that create menus programmatically. Instead, you should define menus in Interface Builder, store them as nib files, and then call the Interface Builder Services function CreateMenuFromNib to create them.

CreateNewMenu is preferred over NewMenu because it allows you to specify the menu's attributes and it does not require you to specify a Str255-based menu title. To set the menu title, you should use SetMenuTitleWithCFString.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CreateNewMenu (
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
){};



/*SetMenuWidth

Sets the width of a menu.

void SetMenuWidth (
   MenuRef menu,
   SInt16 width
);
Parameters
menu

The menu whose width you want to set.
width

The width of the menu, in pixels. 
Discussion

Calling CalcMenuSize on the menu overwrites the menu width you set with this function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void SetMenuWidth (
   MenuRef menu,
   SInt16 width
){};




/*SetMenuItemText

Sets menu item text to a specified string.

Not recommended

void SetMenuItemText (
   MenuRef theMenu,
   short item,
   ConstStr255Param itemString
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
itemString

The menu item’s text string. This parameter must not be NULL or an empty (zero-length) string. Do not use meta–font characters in this parameter. 

Your menu item text string must be limited to 250 bytes. 251 or more bytes will cause the Menu Manager to crash.
Discussion

The SetMenuItemText function does not recognize any metacharacters used by AppendMenu and InsertMenuItem. 

If you set the text of a menu item using the SetMenuItemText function, you should store the text in a string resource so that your application can be more easily localized. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

n Carbon, you should use the SetMenuItemTextWithCFString function instead.
Declared In
Menus.h*/

void SetMenuItemText (
   MenuRef theMenu,
   short item,
   ConstStr255Param itemString
){};




/*CopyMenuItemData

Obtains multiple menu item attributes at once. 

OSStatus CopyMenuItemData (
   MenuRef inMenu,
   MenuItemID inItem,
   Boolean inIsCommandID,
   MenuItemDataPtr ioData
);
Parameters
menu

The menu whose attributes you want to get. Note that if you pass true for the inIsCommandID parameter, you can pass NULL here, in which case the Menu Manager searches the root menu for the first menu that matches the specified command ID. 
item

The menu item index or the command ID of the menu item. 
isCommandID

A Boolean value indicating whether the value passed for the inItem parameter is a command ID or a menu item index. Pass true to indicate a command ID, false to indicate that it is a menu item index. If you pass true, the Menu Manager returns the data for the first menu item that matches the specified command ID. 
outData

A pointer to a MenuItemDataRec structure. Before calling, you should set the whichData field to indicate what data you want to obtain. (Individual fields may also require initialization before calling.) On return, the structure contains the data you requested. For more details on the types of data you can obtain, see “Menu Item Data Flags”. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can use this function to obtain multiple menu item attributes simultaneously, which is often more efficient than making several different calls. For example, a menu definition function could use CopyMenuItemData to obtain all the individual attributes necessary for drawing a menu all at once. 

This function returns copies of the data in the menu, so you should release any data in the MenuItemDataRec structure that was allocated dynamically (such as the CFString item text). 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CopyMenuItemData (
   MenuRef inMenu,
   MenuItemID inItem,
   Boolean inIsCommandID,
   MenuItemDataPtr ioData
){};

/*GetMenuType

Gets the display type (pulldown, hierarchical, or popup) of a menu.

OSStatus GetMenuType (
   MenuRef theMenu,
   UInt16 * outType
);
Parameters
theMenu

The menu whose type to get. 
outType

On exit, the type of the menu. The returned value will be one of the Appearance Manager ThemeMenuType constants: kThemeMenuTypePullDown, kThemeMenuTypePopUp, or kThemeMenuTypeHierarchical. The kThemeMenuTypeInactive bit is never set. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can call this function only when the menu is displayed. If the menu is not currently open, an error is returned. The display type of a menu may vary from one menu tracking session to another; for example, the same menu might be displayed as a pulldown menu and as a popup menu.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h 
GetMenuWidth*/
OSStatus GetMenuType (
   MenuRef theMenu,
   UInt16 * outType
){};



/*SetMenuHeight

Set the height of a menu.

void SetMenuHeight (
   MenuRef menu,
   SInt16 height
);
Parameters
menu

The menu whose height you want to set. 
height

The height of the menu, in pixels. 
Discussion

Calling CalcMenuSize on the menu overwrites the menu height you set with this function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void SetMenuHeight (
   MenuRef menu,
   SInt16 height
){};

/*CalcMenuSize

Recalculates the horizontal and vertical dimensions of a menu.

void CalcMenuSize (
   MenuRef theMenu
);
Parameters
theMenu

The menu whose dimensions need recalculating. 
Discussion

The CalcMenuSize function uses the menu definition function of the specified menu to calculate the dimensions of the menu. In most cases, your application does not need to use the CalcMenuSize function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void CalcMenuSize (
   MenuRef theMenu
){};

/*GetMenuHeight

Obtains the height of a menu, in pixels. 

SInt16 GetMenuHeight (
   MenuRef menu
);
Parameters
menu

The menu whose height you want to obtain. 
Return Value

The height of the menu, in pixels. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

SInt16 GetMenuHeight (
   MenuRef menu
){};



/*IsMenuItemEnabled

Reports whether a given menu or menu item is enabled.

Boolean IsMenuItemEnabled (
   MenuRef menu,
   MenuItemIndex item
);
Parameters
menu

The menu containing the item to be examined. 
item

The item number of the menu item. Pass 0 to specify the menu title and determine whether the menu as a whole is enabled. 
Return Value

Returns true if the menu item is currently enabled; otherwise, false. 
Discussion

Your application can use the IsMenuItemEnabled function to determine whether specific menu items, even those with item numbers greater than 31, are currently enabled and can therefore be selected by the user.

Note that this function ignores the enable state of the menu when returning the enable state of a menu item. For example, if you call IsMenuItemEnabled on an enabled item while its parent menu is disabled, the function still returns true.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
Boolean IsMenuItemEnabled (
   MenuRef menu,
   MenuItemIndex item
){};



/*GetMenuTrackingData

Gets information about the menu currently selected by the user.

OSStatus GetMenuTrackingData (
   MenuRef theMenu,
   MenuTrackingData * outData
);
Parameters
menu

The menu about which to get tracking information. Pass NULL to get information about the most recently opened menu; for example, if the user has selected a menu that contains a submenu, and the submenu is open, then GetMenuTrackingData returns the submenu not its parent menu. 
outData

On exit, contains tracking data about the menu. 
Return Value

A result code. See “Menu Manager Result Codes”. If the menu is not currently open, menuNotFoundErr is returned.
Discussion

You can call this function only during menu tracking. As the standard menu definition automatically handles tracking, you would probably need this function only when writing a custom menu definition.

This function replaces direct access to the pre-Carbon low-memory globals TopMenuItem, AtMenuBottom, MenuDisable, and mbSaveLoc. See the Carbon Porting Notes for MenuDefProcPtr for more information. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetMenuTrackingData (
   MenuRef theMenu,
   MenuTrackingData * outData
){};


/*SetItemIcon

Sets a menu item’s icon or text encoding.

void SetItemIcon (
   MenuRef theMenu,
   short item,
   short iconIndex
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
iconIndex

An integer representing the icon number or text encoding for the specified menu item. If the menu item’s keyboard equivalent field does not contain 0x1C, the SetItemIcon function sets the icon number of the item’s icon to the number defined in this parameter. The icon number you specify should be a value from 1 through 255 (or from 1 through 254 if the item has a small or reduced icon) or 0 if the item does not have an icon.

The Menu Manager adds 256 to the icon number to generate the resource ID of the 'cicn' or 'ICON' resource that describes the icon of the menu item. For example, if you specify 5 as the value of the iconIndex parameter, when the Menu Manager needs to draw the item, it looks for an icon resource with resource ID 261.

If the menu item’s keyboard equivalent field contains 0x1C, the SetItemIcon function sets the text encoding of the menu item to the number defined in the iconIndex parameter. The Menu Manager displays the menu item using the specified text encoding if the corresponding script system is installed.

You can specify 0 in the iconIndex parameter to indicate that the item uses the current system script and does not have an icon number.
Discussion

In most cases, you should use SetMenuItemTextEncoding rather than SetItemIcon to set the menu item’s text encoding.

The SetItemIcon function sets the icon number (for resource-based icons) or text encoding of the specified menu item to the value in the iconIndex parameter. To use handle-based icons, call SetMenuItemIconHandle. Usually you display menu items in the current system script; however, if needed, you can use the SetItemIcon function to set the text encoding of a menu item. For an item’s text encoding to be set, the keyboard equivalent field of the item must contain 0x1C. If the keyboard equivalent field contains any other value, the SetItemIcon function interprets the specified number as the item’s icon number. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void SetItemIcon (
   MenuRef theMenu,
   short item,
   short iconIndex
){};



/*AppendResMenu

Searches all resource files open to your application for a given resource type and appends the names of any resources it finds to a specified menu. 

Not recommended

void AppendResMenu (
   MenuRef theMenu,
   ResType theType
);
Parameters
theMenu

The menu to which to append the names of any resources of a given type that AppendResMenu finds. 
theType

A four-character code that identifies the resource type for which to search. 
Discussion

Unless you must support legacy code, you should not use functions like AppendResMenu ,which assumes that menu items to append are stored in resources.

If you want to insert fonts into a menu, you should call CreateStandardFontMenu instead. 

The AppendResMenu function searches all resource files open to your application for resources of the type defined by the parameter theType. It appends the names of any resources it finds of the given type to the end of the specified menu. AppendResMenu appends the names of found resources in alphabetical order; it does not alphabetize items already in the menu. The AppendResMenu function does not add resources with names that begin with a period (.) or a percent sign (%) to the menu.

AppendResMenu assigns default characteristics to each menu item. Each appended menu item appears in the menu as an enabled item, without an icon or a mark, in the plain character style, and without a keyboard equivalent.

Note that for applications using CarbonLib, you no longer need to call AppendResMenu add resources of type ' DRVR ' to your Apple menu; CarbonLib does this for you automatically. 

If you specify that AppendResMenu append resources of type ' FONT ' or ' FOND ', the Menu Manager performs special processing for any resources it finds that have font numbers greater than 0x4000. If the script system associated with the font name is installed in the system, AppendResMenu stores information in the itemDefinitions array (in the itemIcon and itemCmd fields for that item) in the menu structure. This allows the Menu Manager to display the font name in the correct script. 
Special Considerations

The AppendResMenu function calls the Resource Manager function SetResLoad (specifying true in the load parameter) before returning. The AppendResMenu function reads the resource data of the resources it finds into memory. If your application does not want the Resource Manager to read resource data into memory when your application calls other functions that read resources, you need to call SetResLoad and specify false in the load parameter after AppendResMenu returns.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void AppendResMenu (
   MenuRef theMenu,
   ResType theType
){};


/*InsertMenuItem

Inserts one or more items into a menu previously created. 

Not recommended

void InsertMenuItem (
   MenuRef theMenu,
   ConstStr255Param itemString,
   short afterItem
);
Parameters
theMenu

The menu to which you wish to add the menu item or items. 
itemString

A string that defines the characteristics of the new menu items. Note that in most cases you should store the text of a menu item in a nib file or resource, so that your menu items can be more easily localized. You can specify the contents of the itemString parameter using metacharacters; the function InsertMenuItem accepts the same metacharacters as the AppendMenu function. However, if you specify multiple items, the InsertMenuItem function inserts the items in the reverse of their order in the itemString parameter. 
afterItem

The item number of the menu item after which the new menu items are to be added. Specify 0 in the afterItem parameter to insert the new items before the first menu item; specify the item number of a current menu item to insert the new menu items after it; specify a number greater than or equal to the last item in the menu to append the new items to the end of the menu. 
Discussion

Note that unless you are supporting legacy code, you should use the InsertMenuItemTextWithCFString function instead. 

If you do not define a specific characteristic of a menu item, the InsertMenuItem function assigns the default characteristic to the menu item. If you do not define any characteristic other than the text for a menu item, the InsertMenuItem function inserts the menu item so that it appears in the menu as an enabled item, without an icon or a mark, in the plain character style, and without a keyboard equivalent. 

You can use InsertMenuItem to insert items into a menu regardless of whether the menu is in the current menu list. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void InsertMenuItem (
   MenuRef theMenu,
   ConstStr255Param itemString,
   short afterItem
){};



/*SetMenuTitle

Sets the title of a menu. 

Not Recommended

OSStatus SetMenuTitle (
   MenuRef menu,
   ConstStr255Param title
);
Parameters
menu

The menu whose title you want to set. 
title

A string containing the menu title to set. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Unless you need to support legacy code, you should use the SetMenuTitleWithCFString function instead. 
Availability
Not recommended. Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus SetMenuTitle (
   MenuRef menu,
   ConstStr255Param title
){};

/*ChangeMenuAttributes

Changes the attributes of a menu.

OSStatus ChangeMenuAttributes (
   MenuRef menu,
   MenuAttributes setTheseAttributes,
   MenuAttributes clearTheseAttributes
);
Parameters
menu

The menu whose attributes you want to change. 
setTheseAttributes

The attributes to add to the menu. See “Menu Attribute Constants” for a list of possible values. 
clearTheseAttributes

The attributes to remove from the menu. See “Menu Attribute Constants” for a list of possible values. 
Return Value

A result code. See “Menu Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus ChangeMenuAttributes (
   MenuRef menu,
   MenuAttributes setTheseAttributes,
   MenuAttributes clearTheseAttributes
){};

/*GetMenu

Creates a menu from the specified menu and extended menu resources.

Not recommended

MenuRef GetMenu (
   short resourceID
);
Parameters
resourceID

The resource ID of the menu and extended menu that defines the characteristics of the menu. You typically use the same number for a menu’s resource ID as the number that you specify for the menu ID in the menu resource. 
Return Value

The new menu. You can use the returned menu handle to refer to this menu in most Menu Manager functions. If GetMenu is unable to read the menu or menu definition function from the resource file, GetMenu returns null. See the description of the MenuRef data type.
Discussion

Unless you must support legacy code, you should not use functions like GetMenu that rely on menus stored as resources. Instead, you should define menus in Interface Builder, store them as nib files, and then call the Interface Builder Services function CreateMenuFromNib to create them.

GetMenu reads the menu definition function into memory (if not already present) and stores a handle to the menu definition function in the menu structure. GetMenu does not insert the newly created menu into the current menu list.

You typically use the GetMenu function only when you create submenus; you can create all your pull-down menus at once using the function GetNewMBar, and you can create pop-up menus using the standard pop-up menu button control definition function. 

After reading the 'MENU' resource, GetMenu searches for an extended menu resource and an 'mctb' resource with the same resource ID as the 'MENU' resource. If the specified 'mctb' resource exists, GetMenu uses SetMCEntries to add the entries defined by the resource to the application’s menu color information table. If the 'mctb' resource does not exist, GetMenu uses the default colors specified in the menu bar entry of the application’s menu color information. If neither a menu bar entry nor a 'mctb' resource exists, GetMenu uses the standard colors for the menu.

Storing the definitions of your menus in resources (especially menu titles and menu items) makes your application easier to localize.

After creating a menu with GetMenu or NewMenu , use InsertMenuItem , AppendMenu , or InsertResMenu to add menu items to the menu. To add a menu created by GetMenu to the current menu list, use InsertMenu. To update the menu bar with any new menu titles, use DrawMenuBar.

Menus in a resource must not be purgeable nor should the resource lock bit be set. Do not define a “circular” hierarchical menu—that is, a hierarchical menu in which a submenu has a submenu whose submenu is a hierarchical menu higher in the chain. 
Special Considerations

To release the memory associated with a menu that you created using GetMenu, first call DeleteMenu to remove the menu from the current menu list and to remove any entries for this menu in your application’s menu color information table then call DisposeMenu to dispose of the menu structure.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

In Carbon, the GetMenu function always returns a newly created MenuRef. Prior to Carbon, GetMenu would first check if the menu was already in memory. If so, GetMenu would return the in-memory copy. This behavior is no longer supported.

Carbon does not support custom menu definitions stored in 'MDEF' resources. If you want to specify a custom menu definition for GetMenu, you must compile your definition function directly in your application and then register the function by calling RegisterMenuDefinition. When GetMenu gets a resourceID value that doesn't recognize, it checks a special mapping table to find the pointer that's registered for the resourceID parameter. It then calls that function to implement your menu. 
Declared In
Menus.h*/

MenuRef GetMenu (
   short resourceID
){};

/*GetMenuItemModifiers

Obtains the modifier keys that must be pressed with a character key to select a particular menu item.

OSErr GetMenuItemModifiers (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 * outModifiers
);
Parameters
inMenu

The menu that contains the menu item for which you wish to get the modifier key(s). 
inItem

The menu index of the item. 
outModifiers

A pointer to an unsigned 8-bit value. On return, the bits of the value are set to indicate the modifier keys that can be used in selecting the menu item; see “Modifier Key Mask Constants”. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

See also the function SetMenuItemModifiers. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSErr GetMenuItemModifiers (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 * outModifiers
){};



/*SetMenuItemHierarchicalMenu

Attaches a submenu to a menu item.

OSStatus SetMenuItemHierarchicalMenu (
   MenuRef inMenu,
   MenuItemIndex inItem,
   MenuRef inHierMenu
);
Parameters
inMenu

The parent menu. 
inItem

The parent item. 
inHierMenu

The submenu to attach. Pass NULL to remove an existing submenu. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Using SetMenuItemHierarchicalMenu, it is possible to directly specify the submenu for a menu item without specifying its menu ID. It is not necessary to insert the submenu into the hierarchical portion of the menubar, and it is not necessary for the submenu to have a unique menu ID. Simply use 0 as the menu ID for the submenu, and identify selections from the menu by command ID.

The Menu Manager will increment the reference count of the submenu that you specify, and the submenu’s reference count will be decremented automatically when the parent menu item is deleted or the parent menu is disposed.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus SetMenuItemHierarchicalMenu (
   MenuRef inMenu,
   MenuItemIndex inItem,
   MenuRef inHierMenu
){};





