#include <HIToolbox/HIToolbox.h>

/*NewEventHandlerUPP

Creates an event handler UPP.

EventHandlerUPP NewEventHandlerUPP (
   EventHandlerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your event handler. 
Return Value

The UPP for your event handler.
Discussion

When registering your event handler with InstallEventHandler, you must pass a universal procedure pointer (UPP) to your event handler instead of a standard procedure pointer. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventHandlerUPP NewEventHandlerUPP (
   EventHandlerProcPtr userRoutine){
printf ("NewEventHandlerUPP",userRoutine);
};

/*GetEventKind

Returns the event kind for the specified event.

UInt32 GetEventKind (
   EventRef inEvent
);
Parameters
inEvent

The event in question. 
Return Value

The kind of the event. 
Discussion

Event kind values overlap in different event classes. For example, kEventMouseDown and kEventAppActivated both have the same value (1). The combination of class and kind determines a unique event signature.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
UInt32 GetEventKind (
   EventRef inEvent){
printf ("GetEventKind",inEvent);
};

/*GetEventClass

Returns the class of an event (for example, window, mouse, or keyboard).

UInt32 GetEventClass (
   EventRef inEvent
);
Parameters
inEvent

The event in question. 
Return Value

The class ID of the event. See “Event Class Constants” for more details. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
UInt32 GetEventClass (
   EventRef inEvent){
printf ("GetEventClass",inEvent);
};

/*NewEventLoopTimerUPP

Creates an event loop timer UPP. 

EventLoopTimerUPP NewEventLoopTimerUPP (
   EventLoopTimerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your event timer callback function. 
Return Value

The UPP for your event timer callback function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopTimerUPP NewEventLoopTimerUPP (
   EventLoopTimerProcPtr userRoutine){
printf ("NewEventLoopTimerUPP",userRoutine);
};


/*GetMainEventLoop

Obtains a reference to the main event loop.

EventLoopRef GetMainEventLoop ();
Return Value

An event loop reference. 
Discussion

The main loop is the event loop for the main application thread. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopRef GetMainEventLoop (){
printf ("GetMainEventLoop");
};

/*InstallEventLoopTimer

Installs a timer.

OSStatus InstallEventLoopTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer
);
Parameters
inEventLoop

The event loop to add the timer. 
inFireDelay

The delay before first firing this timer, in seconds. In Mac OS X v10.3 and earlier, the delay must be greater than zero. In Mac OS X v10.4, the delay can be greater than or equal to zero. 

In Mac OS X and CarbonLib 1.5 and later, you may pass kEventDurationForever to stop the timer from firing at all until SetEventLoopTimerNextFireTime is used to start it; in earlier versions of CarbonLib, to achieve the same effect, just pass zero and then immediately call SetEventLoopTimerNextFireTime( timer, (kEventDurationForever ) before returning control to your event loop.
inInterval

The timer interval, in seconds. Pass 0 or (in Mac OS X and CarbonLib 1.5 and later) kEventDurationForever for a one-shot timer. 
inTimerProc

The function to call when the timer fires. 
inTimerData

Data to pass to the timer function when called.
outTimer

A reference to the newly installed timer. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Installs a timer onto the event loop specified. The timer can either fire once or repeatedly at a specified interval depending on the parameters passed to this function. It executes at task level and should not be confused with Time Manager tasks or any other interrupt-level callback. This means you can call toolbox functions, allocate memory, and draw without worrying about consequences. When a timer fires, it calls the callback you specified when the timer was installed.

Timers in general have two uses: as a timeout mechanism and as a periodic task. An everyday example of using a timer for a timeout might be a light that goes out if no motion is detected in a room for 5 minutes. For this, you might install a timer which will fire in 5 minutes. If motion is detected, you would reset the timer fire time and let the clock start over. If no motion is detected for the full 5 minutes, the timer will fire and you could power off the light. A periodic timer is one that fires at regular intervals (say every second or so). You might use such a timer to blink the insertion point in your editor, and so on.

One advantage of timers is that you can install the timer right from the code that wants the time. For example, the standard editable text control can install a timer to blink the cursor when it’s active, meaning that the Control Manager function IdleControls is a no-op for that control and doesn’t need to be called. When the control is inactive, it removes its timer and doesn’t waste CPU time in that state.

Currently, if you do decide to draw when your timer is called, be sure to save and restore the current port so that calling your timer doesn’t inadvertently change the port out from under someone. 

Be sure to dispose of the timer when you no longer need it by calling RemoveEventLoopTimer. Doing so is especially important if your timer calls code that may no longer exist. For example, if a plugin creates a timer that calls back to it, the timer will attempt to call it even after the plugin is removed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus InstallEventLoopTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer){
printf ("InstallEventLoopTimer",inEventLoop,inFireDelay,inInterval,inTimerProc,inTimerData,*outTimer);
};

/*SendEventToEventTarget

Sends an event to the specified event target. 

OSStatus SendEventToEventTarget (
   EventRef inEvent,
   EventTargetRef inTarget
);
Parameters
inEvent

The event to send. 
inTarget

The target to send it to. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

If you are creating your own events, you can dispatch them immediately to an event target by calling this function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/

OSStatus SendEventToEventTarget (
   EventRef inEvent,
   EventTargetRef inTarget){
printf ("SendEventToEventTarget",inEvent,inTarget);
};

/*RemoveEventLoopTimer

Removes the specified timer.

OSStatus RemoveEventLoopTimer (
   EventLoopTimerRef inTimer
);
Parameters
inTimer

The timer to remove. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Removes a timer that was previously installed by a call to InstallEventLoopTimer or InstallEventLoopIdleTimer. You call this function when you are done using a timer. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus RemoveEventLoopTimer (
   EventLoopTimerRef inTimer){
printf ("RemoveEventLoopTimer",inTimer);
};

/*CallNextEventHandler

Calls the next handler in the handler chain.

OSStatus CallNextEventHandler (
   EventHandlerCallRef inCallRef,
   EventRef inEvent
);
Parameters
inCallRef

The event handler call reference passed into your event handler. 
inEvent

The event you want to pass to the next handler. 
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

Calls through to the event handlers below you in the event handler stack of the target to which your handler is bound. You might use this to call through to the default toolbox handling in order to post-process the event. You can only call this routine from within an event handler. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus CallNextEventHandler (
   EventHandlerCallRef inCallRef,
   EventRef inEvent
){
printf ("CallNextEventHandler",inCallRef,inEvent);
};


/*GetCurrentEventQueue

Obtains the current event queue. 

EventQueueRef GetCurrentEventQueue ();
Return Value

An event queue reference. 
Discussion

This function obtains the event queue for the current thread. If the current thread is a cooperative thread, the main event queue is returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventQueueRef GetCurrentEventQueue (){
printf ("GetCurrentEventQueue");
};

/*DisposeEventLoopTimerUPP

Disposes of an event loop timer. 

void DisposeEventLoopTimerUPP (
   EventLoopTimerUPP userUPP
);
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
void DisposeEventLoopTimerUPP (
   EventLoopTimerUPP userUPP){
printf ("DisposeEventLoopTimerUPP",userUPP);
};



/*SendEventToEventTargetWithOptions

Sends an event to the specified event target with propagation options. 

OSStatus SendEventToEventTargetWithOptions (
   EventRef inEvent,
   EventTargetRef inTarget
   OptionBits inOptions
);
Parameters
inEvent

The event to send. 
inTarget

The target to send it to. 
inOptions

Options indicating how the event should be propagated. See “Event Target Propagation Options” for a list of possible values. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function is identical to SendEventToEventTarget except that you can specify how the event is propagated using options. 
Availability
Available in Mac OS X v10.2 and later.
Declared In
CarbonEventsCore.h*/
OSStatus SendEventToEventTargetWithOptions (
   EventRef inEvent,
   EventTargetRef inTarget,
   OptionBits inOptions
){
printf ("SendEventToEventTargetWithOptions",inEvent,inTarget,inOptions);
};


/*SetEventLoopTimerNextFireTime

Sets the next time that the specified timer will fire.

OSStatus SetEventLoopTimerNextFireTime (
   EventLoopTimerRef inTimer,
   EventTimerInterval inNextFire
);
Parameters
inTimer

The timer whose firing time you want to set. 
inNextFire

The interval from the current time to wait until firing the timer again. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function is used to “reset” a timer. It controls the next time the timer fires. This will override any interval you might have set. For example, if you have a timer that fires every second, and you call this function setting the next time to 5 seconds from now, the timer will sleep for 5 seconds, then fire. The timer will then resume its one second interval. This function acts as if you removed the timer and reinstalled it with a new first-fire delay.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus SetEventLoopTimerNextFireTime (
   EventLoopTimerRef inTimer,
   EventTimerInterval inNextFire){
printf ("SetEventLoopTimerNextFireTime",inTimer,inNextFire);
};


/*GetEventParameter

Obtains a parameter from the specified event. 

OSStatus GetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inDesiredType,
   EventParamType * outActualType,
   UInt32 inBufferSize,
   UInt32 * outActualSize,
   void * outData
);
Parameters
inEvent

The event to get the parameter from. 
inName

The symbolic name of the parameter (for example, kEventParamDirectObject). The Carbon Event Manager defines a number of constants defining possible parameters. 
inDesiredType

The desired type of the parameter (for example, typeWindowRef). The Carbon Event Manager automatically uses AppleEvent coercion handlers to convert the data in the event into the desired type, if possible. The Carbon Event Manager defines a number of constants to indicate possible parameter types. Pass typeWildCard to request that the data be returned in its original format. 
outActualType

The actual type of the parameter (can be NULL if you are not interested in receiving this information).
inBufferSize

The size of the output buffer. 
outActualSize

The actual size of the data, or NULL if you don’t want this information.
outData

The pointer to the buffer receiving the parameter data.
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

Events often contain additional useful pieces of data, such as the location of a mouse-down event or the window in which an event occurred. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus GetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inDesiredType,
   EventParamType * outActualType,
   UInt32 inBufferSize,
   UInt32 * outActualSize,
   void * outData){
printf ("GetEventParameter",inEvent,inName,inDesiredType,*outActualType,inBufferSize,*outActualSize,outData);
};

/*RemoveEventTypesFromHandler

Removes events from an installed event handler.

OSStatus RemoveEventTypesFromHandler (
   EventHandlerRef inHandlerRef,
   UInt32 inNumTypes,
   const EventTypeSpec * inList
);
Parameters
inHandlerRef

The event handler to remove the events from. 
inNumTypes

The number of events to remove. 
inList

A pointer to an array of EventTypeSpec structures. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function dynamically change which events you want your handler to respond to. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/

OSStatus RemoveEventTypesFromHandler (
   EventHandlerRef inHandlerRef,
   UInt32 inNumTypes,
   const EventTypeSpec * inList
){
printf ("RemoveEventTypesFromHandler",inHandlerRef,inNumTypes,*inList);
};

/*AddEventTypesToHandler

Adds events to an installed handler.

OSStatus AddEventTypesToHandler (
   EventHandlerRef inHandlerRef,
   UInt32 inNumTypes,
   const EventTypeSpec * inList
);
Parameters
inHandlerRef

The event handler to add events to. 
inNumTypes

The number of events to add. 
inList

A pointer to an array of EventTypeSpec structures. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function to dynamically change which events you want your handler to respond to. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/

OSStatus AddEventTypesToHandler (
   EventHandlerRef inHandlerRef,
   UInt32 inNumTypes,
   const EventTypeSpec * inList
){
printf ("AddEventTypesToHandler",inHandlerRef,inNumTypes,*inList);
};


/*InstallEventHandler

Installs an event handler on a specified event target. 

OSStatus InstallEventHandler (
   EventTargetRef inTarget,
   EventHandlerUPP inHandler,
   UInt32 inNumTypes,
   const EventTypeSpec * inList,
   void * inUserData,
   EventHandlerRef * outRef
);
Parameters
inTarget

The event target to register your handler with. 
inHandler

A pointer to your event handler function. 
inNumTypes

The number of events you are registering for. 
inList

A pointer to an array of EventTypeSpec entries representing the events you are interested in. 
inUserData

The value you pass in this parameter is passed to your event handler function when it is called.
outRef

On return, an event handler reference, which you can use later to remove the handler. You can pass NULL if you don’t want the reference—when the target is disposed, the handler is disposed as well. 
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

After being installed, your handler will be called when an event you registered for is sent to the specified event target. Note that CarbonEvents.h defines several macros which you can use for particular event classes. These macros simply combine the appropriate GetxxxEventTarget call with InstallEventHandler.
InstallApplicationEventHandler
InstallWindowEventHandler
InstallControlEventHandler
InstallMenuEventHandler
InstallHIObjectEventHandler (in Mac OS X v10.2 and later)
HIViewInstallEventHandler (in Mac OS X v10.2 and later)

Be sure to remove the event handler when you no longer need it by callling RemoveEventHandler. Doing so is especially important if the handler calls code that may disappear. For example, if a plugin installs an event handler and is later removed without removing the handler, the system may attempt to call back to the now nonexistent plugin code.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus InstallEventHandler (
   EventTargetRef inTarget,
   EventHandlerUPP inHandler,
   UInt32 inNumTypes,
   const EventTypeSpec * inList,
   void * inUserData,
   EventHandlerRef * outRef){
printf ("InstallEventHandler",inTarget,inHandler,inNumTypes,*inList,inUserData,*outRef);
};


/*CreateEvent

Creates an event.

OSStatus CreateEvent (
   CFAllocatorRef inAllocator,
   UInt32 inClassID,
   UInt32 kind,
   EventTime when,
   EventAttributes flags,
   EventRef * outEvent
);
Parameters
inAllocator

A reference to the desired memory allocator to use to allocate memory for the event. Pass NULL to use the default allocator. See the Base Services documentation for a description of the CFAllocatorRef data type.
inClassID

The event class of the event to create.
kind

The event kind of the event to create. 
when

The time the event occurred. Pass 0 to specify the current event time (as returned by the GetCurrentEventTime function). 
flags

The event attributes to set. Currently you can pass kEventAttributeNone or kEventAttributeUserEvent. 
outEvent

On return, a reference to the newly created event. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function to create your own custom events or to simulate existing events. If you are creating custom events, you must make sure that the event signature (the combination of event class and event kind) does not conflict with any existing events. 
Declared In
CarbonEventsCore.h*/
OSStatus CreateEvent (
   CFAllocatorRef inAllocator,
   UInt32 inClassID,
   UInt32 kind,
   EventTime when,
   EventAttributes flags,
   EventRef * outEvent){
printf ("CreateEvent",inAllocator,inClassID,kind,when,flags,*outEvent);
};


/*SetEventTime

Sets the event time for a given event. 

OSStatus SetEventTime (
   EventRef inEvent,
   EventTime inTime
);
Parameters
inEvent

The event in question. 
inTime

The new time. 
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

This function allows you to set the time of a given event, if you so desire. In general, you would never use this function, except for those special cases where you reuse an event from time to time instead of creating a new event each time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus SetEventTime (
   EventRef inEvent,
   EventTime inTime
){
printf ("SetEventTime",inEvent,inTime);
};


/*GetMainEventQueue

Obtains the main event queue. 

EventQueueRef GetMainEventQueue ();
Return Value

An event queue reference. 
Discussion

The main queue is the event queue for the main application thread. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventQueueRef GetMainEventQueue (){
printf ("GetMainEventQueue");
};


/*RetainEvent

Increments the reference count of an event.

EventRef RetainEvent (
   EventRef inEvent
);
Parameters
inEvent

The event to retain.
Return Value

The event reference you passed in the inEvent parameter. A value of NULL indicates an error condition. 
Discussion

The RetainEvent function increments an event’s reference count by 1. You can use this function to ensure that an event is never disposed of by another event handler. However, if the event system or some other event handler changes the event, those changes are reflected in your reference. To create a separate, unique copy of an event, use CopyEvent instead. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventRef RetainEvent (
   EventRef inEvent
){
printf ("RetainEvent",inEvent);
};

/*InstallEventLoopIdleTimer

Installs a timer that fires only when there is no user activity.

OSStatus InstallEventLoopIdleTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopIdleTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer
);
Parameters
inEventLoop

The event loop to add the timer. 
inFireDelay

The delay before first firing this timer, in seconds. In Mac OS X v10.3 and earlier, this delay must be greater than zero. In Mac OS X v10.4 and later, the delay must be greater than or equal to zero. You cannot pass kEventDurationForever.
inInterval

The timer interval, in seconds. Pass 0 or kEventDurationForever for a one-shot timer. 
inTimerProc

The function to call when the timer fires. 
inTimerData

Data to pass to the timer function when called.
outTimer

A reference to the newly installed timer. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

An idle timer is the same as a standard event timer except that it fires only when no user events are being received. That is, if the system receives no user events for the inFireDelay delay time, the idle timer fires, and will continue to fire at the rate specified by inInterval. If the user begins activity again, the timer stops and resets. For example, you could use an idle timer in a search engine to begin a search 2 seconds after the user stops typing in the search text field. 

The callback function for idle timers takes an additional parameter that tells the callback the user status. See EventLoopIdleTimerProcPtr and “Idle Timer Event Constants” for more information. 

Be sure to dispose of the timer when you no longer need it by calling RemoveEventLoopTimer. Doing so is especially important if your timer calls code that may no longer exist. For example, if a plugin creates a timer that calls back to it, the timer will attempt to call it even after the plugin is removed. 
Availability
Available in Mac OS X v10.2 and later.
Declared In
CarbonEventsCore.h*/
OSStatus InstallEventLoopIdleTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopIdleTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer
){
printf ("InstallEventLoopIdleTimer",inEventLoop,inFireDelay,inInterval,inTimerProc,inTimerData,*outTimer);
};

//work



/*GetCurrentEventLoop

Obtains a reference to the current event loop.

EventLoopRef GetCurrentEventLoop ();
Return Value

An event loop reference. 
Discussion

This function returns the event loop for the current thread. If the current thread is a cooperative thread, the main event loop is returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopRef GetCurrentEventLoop (){};



/*GetCurrentEventTime

Returns the current time since last system startup, in seconds. 

EventTime GetCurrentEventTime ();
Return Value

EventTime. 
Discussion

Returns the current time since last system startup in seconds. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventTime GetCurrentEventTime (){
//TODO
};

/*SetEventParameter

Sets a parameter associated with a particular event. 

OSStatus SetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inType,
   UInt32 inSize,
   const void * inDataPtr
);
Parameters
inEvent

The event to set the data for. 
inName

The symbolic name of the parameter. 
inType

The symbolic type of the parameter. 
inSize

The size of the parameter data. 
inDataPtr

A pointer to the parameter data.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

When creating events, you may want to specify additional event-related information, such as the mouse location or the window in which the event occurred. To set these you call SetEventParameter, specifying the type and value for the desired parameter. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus SetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inType,
   UInt32 inSize,
   const void * inDataPtr){
//TODO
};



/*ReleaseEvent

Releases, and possibly disposes of, the specified event.

void ReleaseEvent (
   EventRef inEvent
);
Parameters
inEvent

The event to release.
Discussion

This function decrements the reference count of an event. If the reference count reaches 0, the event is disposed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
void ReleaseEvent (
   EventRef inEvent){
//TODO
};




/*GetEventTime

Returns the time a specific event occurred. 

EventTime GetEventTime (
   EventRef inEvent
);
Parameters
inEvent

The event in question. 
Return Value

The time the event occurred. 
Discussion

Returns the time the event specified occurred, specified as an EventTime value, which is a floating point number representing seconds since the last system startup. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventTime GetEventTime (
   EventRef inEvent
){};


/*PostEventToQueue

Adds an event to the specified event queue.

OSStatus PostEventToQueue (
   EventQueueRef inQueue,
   EventRef inEvent,
   EventPriority inPriority
);
Parameters
inQueue

The event queue to post the event onto. 
inEvent

The event to post. 
inPriority

The priority of the event. See “Event Priority Constants” for a list of possible constants to pass. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Posts an event to the queue specified and increments its retain count. This automatically wakes up the event loop of the thread the queue belongs to. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus PostEventToQueue (
   EventQueueRef inQueue,
   EventRef inEvent,
   EventPriority inPriority
){};

/*ReceiveNextEvent

Waits for the next event of a specified type.

OSStatus ReceiveNextEvent (
   UInt32 inNumTypes,
   const EventTypeSpec * inList,
   EventTimeout inTimeout,
   Boolean inPullEvent,
   EventRef * outEvent
);
Parameters
inNumTypes

The number of event types to wait for (0 if any event should cause this function to return). 
inList

The list of event types we are waiting for (pass NULL if any event should cause this function to return). 
inTimeout

The time to wait before returning (passing kEventDurationForever is preferred). 
inPullEvent

Pass true for this parameter to remove the next matching event from the queue. 
outEvent

A pointer to the next event that matches the list passed in. If you passed true in the inPullEvent parameter, the event is owned by you, and you should release it when done. 
Return Value

A result indicating whether an event was received, the timeout expired, or the current event loop was quit. See “Carbon Event Manager Result Codes” for possible values. 
Discussion

This function tries to fetch the next event of a specified type. If no events in the event queue match, this function will run the current event loop until an event that matches arrives, or the timeout expires. Except for timers firing, your application is blocked waiting for events to arrive when inside this function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus ReceiveNextEvent (
   UInt32 inNumTypes,
   const EventTypeSpec * inList,
   EventTimeout inTimeout,
   Boolean inPullEvent,
   EventRef * outEvent
){};


/*InstallStandardEventHandler

Installs the standard event handler for the specified target.

OSStatus InstallStandardEventHandler (
   EventTargetRef inTarget
);
Parameters
inTarget

The event target for which you want to install the standard handler. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Currently you can install the standard handler only for window event targets. To install the standard application handler, you must call RunApplicationEventLoop.

Note that events may also have default behaviors or standard definitions which define how and event is handled if you choose not to handle it yourself. Default behavior is the response that occurs whenever you choose not to handle the event, whether or not you have a standard handler installed. Standard definition behavior defines how an event is handled based on that element’s standard definition. For example, the standard menu definition provides some default responses for menu events you do not handle. However if you are using your own custom definition, you cannot assume that these default responses will occur.

You can also install the standard handler for a window event target by calling ChangeWindowAttributes to set the kWindowStandardHandlerAttribute window attribute on the window.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus InstallStandardEventHandler (
   EventTargetRef inTarget
){};




/*DisposeEventHandlerUPP

Disposes of an event handler UPP. 

void DisposeEventHandlerUPP (
   EventHandlerUPP userUPP
);
Parameters
userUPP

The event handler UPP you want to destroy.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/

void DisposeEventHandlerUPP (
   EventHandlerUPP userUPP
){};



/*RemoveEventHandler

Removes the specified event handler.

OSStatus RemoveEventHandler (
   EventHandlerRef inHandlerRef
);
Parameters
inHandlerRef

The handler ref to remove (returned in a call to InstallEventHandler). After you call this function, the handler reference is considered invalid and can no longer be used. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Removes an event handler from the event target to which it was bound. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus RemoveEventHandler (
   EventHandlerRef inHandlerRef
){};


/*GetCFRunLoopFromEventLoop

Obtains a Core Foundation CFRunLoop from an Carbon event loop reference. 

CFTypeRef GetCFRunLoopFromEventLoop (
   EventLoopRef inEventLoop
);

Parameters
inEventLoop

The event loop reference to translate. 
Return Value

A reference to the CFRunLoop. 
Discussion

There isn’t necessarily a one-to-one correspondence between Carbon event loops and Core Foundation event loops, so you should use this function instead of simply calling the Core Foundation function CFRunLoopGetCurrent. 
Availability
Available in Mac OS X v10.1 and later.
Declared In
CarbonEventsCore.h*/
CFTypeRef GetCFRunLoopFromEventLoop (
   EventLoopRef inEventLoop
){};




