#include <HIServices/HIServices.h>

/*PasteboardGetItemIdentifier

Obtains the item identifier for an item in a pasteboard.

OSStatus PasteboardGetItemIdentifier (
PasteboardRef inPasteboard,
UInt32 inIndex,
PasteboardItemID *outItem
Parameters
inPasteboard

The pasteboard containing the data. 
inIndex

The one-based index number of the data item whose identifier you want to obtain.
outItem

On return, outItem points to the item identifier for the data item at index inIndex.
Return Value

A result code. 
Discussion

The item index is one-based to match the convention used by the Drag Manager.
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/
OSStatus PasteboardGetItemIdentifier (
PasteboardRef inPasteboard,
UInt32 inIndex,
PasteboardItemID *outItem){
printf ("PasteboardGetItemIdentifier",inPasteboard,inIndex,*outItem);
};

/*PasteboardCopyItemFlavorData

Obtains data from a pasteboard for the desired flavor.

OSStatus PasteboardCopyItemFlavorData (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFStringRef inFlavorType,
CFDataRef *outData
);
Parameters
inPasteboard

The pasteboard containing the data.
inItem

The identifier for the item whose flavor data you want to obtain. 
inFlavorType

The flavor of the data you want to obtain, specified as a uniform type identifier. 
outData

On return, outData points to the flavor data. You must release this data using CFRelease when you are done using it. 
Return Value

A result code.
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/
OSStatus PasteboardCopyItemFlavorData (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFStringRef inFlavorType,
CFDataRef *outData
){
printf ("PasteboardCopyItemFlavorData",inPasteboard,inItem,inFlavorType,*outData);
};

/*PasteboardGetItemCount

Obtains the number of data items in the specified pasteboard.

OSStatus PasteboardGetItemCount (
   PasteboardRef inPasteboard,
   ItemCount *outItemCount
);
Parameters
inPasteboard

The pasteboard whose items you want to count.
outItemCount

On return, outItemCount points to the number of items in the pasteboard.
Return Value

A result code.
Discussion

You usually call this function before calling PasteboardGetItemIdentifier.
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/
OSStatus PasteboardGetItemCount (
   PasteboardRef inPasteboard,
   ItemCount *outItemCount
){
printf ("PasteboardGetItemCount",inPasteboard,*outItemCount);
};

/*PasteboardCopyItemFlavors

Obtains an array of flavors for a specified item in a pasteboard. 

OSStatus PasteboardCopyItemFlavors (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFArrayRef *outFlavorTypes
);
Parameters
inPasteboard

The pasteboard containing the data.
inItem

The identifier for the item whose flavors you want to obtain. 
outFlavorTypes

On return, outFlavorTypes points to an array of flavors, specified as uniform type identifiers. You must release this array by calling CFRelease when you are done using it. 
Return Value

A result code. 
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/
OSStatus PasteboardCopyItemFlavors (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFArrayRef *outFlavorTypes
){
printf ("PasteboardCopyItemFlavors",inPasteboard,inItem,*outFlavorTypes);
};

/*PasteboardCreate

Creates a reference to the specified global pasteboard.

OSStatus PasteboardCreate (
CFStringRef inName
PasteboardRef *outPasteboard
);
Parameters
inName

The name of the pasteboard to reference. 
outPasteboard

On return, outPasteboard points to the specified pasteboard. 
Return Value

A result code.
Discussion

If the pasteboard you specify does not yet exist, this function creates it. You can use this function to create your own pasteboards to store and pass data. Pasteboard names should have a reverse DNS-style name to ensure uniqueness. 

You can also specify kPasteboardFind to obtain a reference to the Find pasteboard or kPasteboardClipboard for a reference to the standard clipboard. If you pass kPasteboardUniqueName (= NULL) , the system creates a unique pasteboard for your application.

When you are finished with a pasteboard reference, you can call CFRelease to release it. If you do not release the reference, the pasteboard continues to exist even after your application terminates. A subsequently launched application can then find a previously created pasteboard by name and examine the data within it. 
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/

OSStatus PasteboardCreate (
CFStringRef inName,
PasteboardRef *outPasteboard
){
printf ("PasteboardCreate",inName,*outPasteboard);
};

/*PasteboardClear

Clears the contents of the specified pasteboard.

OSStatus PasteboardClear (
PasteboardRef inPasteboard
);
Parameters
inPasteboard

The pasteboard you want to clear.
Return Value

A result code.
Discussion

After calling this function, the application owns the pasteboard and can add data to it. You must call PasteboardClear before modifying a pasteboard. 
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/

OSStatus PasteboardClear (
PasteboardRef inPasteboard
){
printf ("PasteboardClear",inPasteboard);
};

/*PasteboardPutItemFlavor

Adds flavor data or a promise to the specified pasteboard.

OSStatus PasteboardPutItemFlavor (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFStringRef inFlavorType,
CFDataRef inData,
PasteboardFlavorFlags inFlags
);
Parameters
inPasteboard

The pasteboard to which to add flavor data or a promise.
inItem

The identifier for the item to which to add flavor data or a promise.
inFlavorType

The flavor type of the data or promise you are adding, specified as a uniform type identifier. 
inData

The data to add. If you pass kPasteboardPromisedData (= NULL), the data is promised. 
inFlags

A bit field of flags for the specified flavor.
Return Value

A result code. 
Discussion

If you promise data, you must have implemented a promise keeper callback beforehand to deliver the data when asked for it (see PasteboardPromiseKeeperProcPtr for more details). Typically you store promises instead of the actual data when the data requires a large overhead to generate. 

You can call this function multiple times to add multiple flavors to a given item. You should add the flavors in your application’s order of preference or richness. 
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/

OSStatus PasteboardPutItemFlavor (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFStringRef inFlavorType,
CFDataRef inData,
PasteboardFlavorFlags inFlags
){
printf ("PasteboardPutItemFlavor",inPasteboard,inItem,inFlavorType,inData,inFlags);
};

/*PasteboardSynchronize

Synchronizes the local pasteboard reference to reflect the contents of the global pasteboard.

PasteboardSyncFlags PasteboardSynchronize (
PasteboardRef inPasteboard
);
Parameters
inPasteboard

The pasteboard you want to synchronize.
Return Value

A flag indicating what synchronization actions occurred.
Discussion

Calling this function compares the local pasteboard reference with its global pasteboard. If the global pasteboard was modified, it updates the local pasteboard reference to reflect this change. You typically call this function whenever your application becomes active, so that its pasteboard information reflects any changes that occurred while it was in the background. This function has low overhead, so you should call it whenever you suspect a global pasteboard may have been changed.
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/
PasteboardSyncFlags PasteboardSynchronize (
PasteboardRef inPasteboard
){
printf ("PasteboardSynchronizer",inPasteboard);
};

/*PasteboardGetItemFlavorFlags

Obtains the flags for a given flavor. 

OSStatus PasteboardGetItemFlavorFlags (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFStringRef inFlavorType,
PasteboardFlavorFlags *outFlags
);

Parameters
inPasteboard

The pasteboard containing the data. 
inItem

The identifier for the item whose flavor flags you want to obtain.
inFlavorType

The flavor whose flags you want to obtain. 
outFlags

On return, outFlags points to a bit field containing the flavor flags. See “Pasteboard Flavor Flags” for a list of possible values. 
Return Value

A result code. 
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/
OSStatus PasteboardGetItemFlavorFlags (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFStringRef inFlavorType,
PasteboardFlavorFlags *outFlags
){};


/*PasteboardSetPromiseKeeper

Registers the promise keeper callback function for a pasteboard. 

OSStatus PasteboardSetPromiseKeeper (
PasteboardRef inPasteboard,
PasteboardPromiseKeeperProcPtr inPromiseKeeper,
void* inContext
);
Parameters
inPasteboard

The pasteboard to assign the promise keeper callback. If you have multiple pasteboards, you can assign multiple callbacks. 
inPromiseKeeper

A pointer to your promise keeper callback function. See PasteboardPromiseKeeperProcPtr for more information about implementing the callback. 
inContext

A pointer to application-defined data. The value you pass in this parameter is passed to your promise keeper callback function when it is called. 
Return Value

A result code. 
Discussion

You must have registered a promise keeper callback function before promising any data on the specified pasteboard. 
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/
OSStatus PasteboardSetPromiseKeeper (
PasteboardRef inPasteboard,
PasteboardPromiseKeeperProcPtr inPromiseKeeper,
void* inContext
){};


