#include <CoreGraphics/CGDisplayFade.h>


/*CGDisplayFade

Performs a single fade operation. 

CGError CGDisplayFade (
   CGDisplayFadeReservationToken token,
   CGDisplayFadeInterval seconds,
   CGDisplayBlendFraction startBlend,
   CGDisplayBlendFraction endBlend,
   float redBlend,
   float greenBlend,
   float blueBlend,
   boolean_t synchronous
);

Parameters
token

A valid reservation token for the fade hardware, acquired by calling CGAcquireDisplayFadeReservation.
seconds

The desired number of seconds for the fade operation. You should use a value in the interval [0, kCGMaxDisplayReservationInterval]. If the value is 0, the ending blend color is applied immediately.
startBlend

An intensity value in the interval [0, 1] that specifies the alpha component of the desired blend color at the beginning of the fade operation. See “Display Fade Blend Fractions”.
endBlend

An intensity value in the interval [0, 1] that specifies the alpha component of the desired blend color at the end of the fade operation. See “Display Fade Blend Fractions”.
redBlend

An intensity value in the interval [0, 1] that specifies the red component of the desired blend color.
greenBlend

An intensity value in the interval [0, 1] that specifies the green component of the desired blend color.
blueBlend

An intensity value in the interval [0, 1] that specifies the blue component of the desired blend color.
synchronous

Pass true if you want the fade operation to be synchronous; otherwise, pass false. If a fade operation is synchronous, the function does not return until the operation is complete.
Return Value

A result code. See “Quartz Display Services Result Codes”. 
Discussion

Over the fade operation time interval, Quartz interpolates a blending coefficient between the starting and ending values given, applying a nonlinear (sine-based) bias term. Using this coefficient, the video output is blended with the specified color.

The following example shows how to perform a two-second synchronous fade-out to black: CGDisplayFade (
    myToken,
    2.0,                        // 2 seconds
    kCGDisplayBlendNormal,      // starting state
    kCGDisplayBlendSolidColor,  // ending state
    0.0, 0.0, 0.0,              // black
    true                        // wait for completion
);


To perform a two-second asynchronous fade-in from black: CGDisplayFade (
    myToken,
    2.0,                        // 2 seconds
    kCGDisplayBlendSolidColor,  // starting state
    kCGDisplayBlendNormal,      // ending state
    0.0, 0.0, 0.0,              // black
    false                       // don't wait for completion
);


If you specify an asynchronous fade operation, it’s safe to call CGReleaseDisplayFadeReservation immediately after this function returns.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGDisplayFade.h*/
CGError CGDisplayFade (
   CGDisplayFadeReservationToken token,
   CGDisplayFadeInterval seconds,
   CGDisplayBlendFraction startBlend,
   CGDisplayBlendFraction endBlend,
   float redBlend,
   float greenBlend,
   float blueBlend,
   boolean_t synchronous
){};


/*CGReleaseDisplayFadeReservation

Releases a display fade reservation, and unfades the display if needed.

CGError CGReleaseDisplayFadeReservation (
   CGDisplayFadeReservationToken token
);
Parameters
token

The current fade reservation token to be released. On return, the reservation token is no longer valid and should be discarded.
Return Value

A result code. See “Quartz Display Services Result Codes”. 
Discussion

If you call this function while an asynchronous fade operation is running, there are two possible outcomes:
If the ending blend value is kCGDisplayBlendNormal, the fade operation is allowed to run to completion.
If the ending blend value is not kCGDisplayBlendNormal, the fade operation is terminated immediately and the display is returned to normal.

In both cases, the reservation is actually released when the fade operation completes.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGDisplayFade.h*/
CGError CGReleaseDisplayFadeReservation (
   CGDisplayFadeReservationToken token
){};


/*CGAcquireDisplayFadeReservation

Reserves the fade hardware for a specified time interval.

CGError CGAcquireDisplayFadeReservation (
   CGDisplayReservationInterval seconds,
   CGDisplayFadeReservationToken * tokenPtr
);

Parameters
seconds

The desired number of seconds to reserve the fade hardware. An application can specify any value in the interval (0, kCGMaxDisplayReservationInterval].
tokenPtr

A pointer to storage (provided by the caller) for a fade reservation token. On return, the storage contains a new token.
Return Value

Returns kCGErrorNoneAvailable if another fade reservation is in effect. Otherwise, returns kCGErrorSuccess. 
Discussion

Before performing a fade operation, an application must reserve the fade hardware for a specified period of time. Quartz returns a token that represents a new fade reservation. The application uses this token as an argument in subsequent calls to other display fade functions. 

During the fade reservation interval, the application has exclusive rights to use the fade hardware. At the end of the interval, the token becomes invalid and the hardware automatically returns to a normal state. Typically the application calls CGReleaseDisplayFadeReservation to release the fade reservation before it expires.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGDisplayFade.h*/

CGError CGAcquireDisplayFadeReservation (
   CGDisplayReservationInterval seconds,
   CGDisplayFadeReservationToken * tokenPtr
){};

