#include <CoreGraphics/CoreGraphics.h>

/*GAffineTransformIdentity

Specifies the identity transform.

const CGAffineTransform CGAffineTransformIdentity;
Discussion

This constant specifies the following matrix:*/

const CGAffineTransform CGAffineTransformIdentity;

//work
/*CGAffineTransformMake

Returns an affine transformation matrix constructed from values you provide. 

CGAffineTransform CGAffineTransformMake (
   float a,
   float b,
   float c,
   float d,
   float tx,
   float ty
);
Parameters
a

The value at position [1,1] in the matrix.
b

The value at position [1,2] in the matrix.
c

The value at position [2,1] in the matrix.
d

The value at position [2,2] in the matrix.
tx

The value at position [3,1] in the matrix.
ty

The value at position [3,2] in the matrix.
Return Value

A new affine transform matrix constructed from the values you specify.
Discussion

This function creates a CGAffineTransform structure that represents a new affine transformation matrix, which you can use (and reuse, if you want) to transform a coordinate system. The matrix takes the following form:




If you want only to transform an object to be drawn, it is not necessary to construct an affine transform to do so. The most direct way to transform your drawing is by calling the appropriate CGContext function to adjust the current transformation matrix.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/
CGAffineTransform CGAffineTransformMake (
   float a,
   float b,
   float c,
   float d,
   float tx,
   float ty
){};

/*CGAffineTransformScale

Returns an affine transformation matrix constructed by scaling an existing affine transform.

CGAffineTransform CGAffineTransformScale (
   CGAffineTransform t,
   float sx,
   float sy
);
Parameters
t

An existing affine transform. 
sx

The value by which to scale x values of the affine transform.
sy

The value by which to scale y values of the affine transform.
Return Value

A new affine transformation matrix.
Discussion

You use this function to create a new affine transformation matrix by adding scaling values to an existing affine transform. The resulting structure represents a new affine transform, which you can use (and reuse, if you want) to scale a coordinate system. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/
CGAffineTransform CGAffineTransformScale (
   CGAffineTransform t,
   float sx,
   float sy
){};

/*CGAffineTransformRotate

Returns an affine transformation matrix constructed by rotating an existing affine transform.

CGAffineTransform CGAffineTransformRotate (
   CGAffineTransform t,
   float angle
);
Parameters
t

An existing affine transform. 
angle

The angle, in radians, by which to rotate the affine transform.
Return Value

A new affine transformation matrix.
Discussion

You use this function to create a new affine transformation matrix by adding a rotation value to an existing affine transform. The resulting structure represents a new affine transform, which you can use (and reuse, if you want) to rotate a coordinate system. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/

CGAffineTransform CGAffineTransformRotate (
   CGAffineTransform t,
   float angle
){};

/*CGAffineTransformInvert

Returns an affine transformation matrix constructed by inverting an existing affine transform.

CGAffineTransform CGAffineTransformInvert (
   CGAffineTransform t
);
Parameters
t

An existing affine transform. 
Return Value

A new affine transformation matrix. If the affine transform passed in parameter t cannot be inverted, Quartz returns the affine transform unchanged.
Discussion

You can invert a matrix to produce an inverse matrix. Inversion is generally used to provide reverse transformation of points within transformed objects. Given the coordinates (x,y), which have been transformed by a given matrix to new coordinates (x’,y’), transforming the coordinates (x’,y’) by the inverse matrix produces the original coordinates (x,y).
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/
CGAffineTransform CGAffineTransformInvert (
   CGAffineTransform t
){};

/*CGRectApplyAffineTransform

Applies an affine transform to a rectangle.

CGRect CGRectApplyAffineTransform (
CGRect rect,
CGAffineTransform t
);
Parameters
rect

The rectangle whose corner points you want to transform.
t

The affine transform to apply to the rect parameter.
Return Value

The transformed rectangle.
Discussion

Because affine transforms do not preserve rectangles in general, the function CGRectApplyAffineTransform returns the smallest rectangle that contains the transformed corner points of the rect parameter. If the affine transform t consists solely of scaling and translation operations, then the returned rectangle coincides with the rectangle constructed from the four transformed corners.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGAffineTransform.h*/
CGRect CGRectApplyAffineTransform (
CGRect rect,
CGAffineTransform t
){};

/*CGAffineTransformConcat

Returns an affine transformation matrix constructed by combining two existing affine transforms.

CGAffineTransform CGAffineTransformConcat (
   CGAffineTransform t1,
   CGAffineTransform t2
);
Parameters
t1

The first affine transform. 
t2

The second affine transform. This affine transform is concatenated to the first affine transform.
Return Value

A new affine transformation matrix. That is, t’ = t1*t2. 
Discussion

Concatenation combines two affine transformation matrices by multiplying them together. You might perform several concatenations in order to create a single affine transform that contains the cumulative effects of several transformations. 

Note that matrix operations are not commutative—the order in which you concatenate matrices is important. That is, the result of multiplying matrix t1 by matrix t2 does not necessarily equal the result of multiplying matrix t2 by matrix t1. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/
CGAffineTransform CGAffineTransformConcat (
   CGAffineTransform t1,
   CGAffineTransform t2
){};

/*CGAffineTransformMakeScale

Returns an affine transformation matrix constructed from scaling values you provide.

CGAffineTransform CGAffineTransformMakeScale (
   float sx,
   float sy
);
Parameters
sx

The factor by which to scale the x-axis of the coordinate system.
sy

The factor by which to scale the y-axis of the coordinate system.
Return Value

A new affine transformation matrix.
Discussion

This function creates a CGAffineTransform structure, which you can use (and reuse, if you want) to scale a coordinate system. The matrix takes the following form:




These are the resulting equations that Quartz uses to scale the coordinates of a point (x,y):





If you want only to scale an object to be drawn, it is not necessary to construct an affine transform to do so. The most direct way to scale your drawing is by calling the function CGContextScaleCTM. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/
CGAffineTransform CGAffineTransformMakeScale (
   float sx,
   float sy
){};


/*CGAffineTransformMakeRotation

Returns an affine transformation matrix constructed from a rotation value you provide.

CGAffineTransform CGAffineTransformMakeRotation (
   float angle
);CGAffineTransformMakeRotation

Returns an affine transformation matrix constructed from a rotation value you provide.

CGAffineTransform CGAffineTransformMakeRotation (
   float angle
);
Parameters
angle

The angle by which this matrix rotates the coordinate system axes, in radians. A positive value specifies clockwise rotation, a negative value specifies anti-clockwise.
Return Value

A new affine transformation matrix.
Discussion

This function creates a CGAffineTransform structure, which you can use (and reuse, if you want) to rotate a coordinate system. The matrix takes the following form:




These are the resulting equations that Quartz uses to apply the rotation to a point (x, y):




If you want only to rotate an object to be drawn, it is not necessary to construct an affine transform to do so. The most direct way to rotate your drawing is by calling the function CGContextRotateCTM. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h
Parameters
angle

The angle by which this matrix rotates the coordinate system axes, in radians. A positive value specifies clockwise rotation, a negative value specifies anti-clockwise.
Return Value

A new affine transformation matrix.
Discussion

This function creates a CGAffineTransform structure, which you can use (and reuse, if you want) to rotate a coordinate system. The matrix takes the following form:




These are the resulting equations that Quartz uses to apply the rotation to a point (x, y):




If you want only to rotate an object to be drawn, it is not necessary to construct an affine transform to do so. The most direct way to rotate your drawing is by calling the function CGContextRotateCTM. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/
CGAffineTransform CGAffineTransformMakeRotation (
   float angle
){
printf ("CGAffineTransformMakeRotation ",angle);
};

/*CGPointApplyAffineTransform

Returns the point resulting from an affine transformation of an existing point.

CGPoint CGPointApplyAffineTransform (
   CGPoint point,
   CGAffineTransform t
);
Parameters
point

A point that specifies the x- and y-coordinates to transform. 
t

The affine transform to apply. 
Return Value

A new point resulting from applying the specified affine transform to the existing point. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/
CGPoint CGPointApplyAffineTransform (
   CGPoint point,
   CGAffineTransform t
){
printf ("CGPointApplyAffineTransform",point,t);
};

