#include <CoreFoundation/CoreFoundation.h>

/*Boolean Values

CFBoolean evaluates to either true or false values where kCFBooleanTrue is the true, and kCFBooleanFalse is the false value. 

const CFBooleanRef kCFBooleanTrue;
const CFBooleanRef kCFBooleanFalse;
Constants
kCFBooleanTrue

Boolean true value.

Available in Mac OS X v10.0 and later.
kCFBooleanFalse

Boolean false value.

Available in Mac OS X v10.0 and later.*/
const CFBooleanRef kCFBooleanTrue;
 const CFBooleanRef kCFBooleanFalse;


//work


/*CFBooleanGetValue

Returns the value of a CFBoolean object as a standard C type Boolean.

Boolean CFBooleanGetValue (
   CFBooleanRef boolean
);
Parameters
boolean

The boolean to examine. 
Return Value

The value of boolean. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFBooleanGetValue (
   CFBooleanRef boolean
){};

/*CFNumberCreate

Creates a CFNumber object using a specified value.

CFNumberRef CFNumberCreate (
   CFAllocatorRef allocator,
   CFNumberType theType,
   const void *valuePtr
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the default allocator.
theType

A constant that specifies the data type of the value to convert. See Number Types for a list of possible values. 
valuePtr

A pointer to the value for the returned number object.
Return Value

A new number with the value specified by valuePtr. Ownership follows the Create Rule.
Discussion

The theType parameter is not necessarily preserved when creating a new CFNumber object. The CFNumber object will be created using whatever internal storage type the creation function deems appropriate. Use the function CFNumberGetType to find out what type the CFNumber object used to store your value. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFNumberRef CFNumberCreate (
   CFAllocatorRef allocator,
   CFNumberType theType,
   const void *valuePtr
){};

/*CFBooleanGetTypeID

Returns the Core Foundation type identifier for the CFBoolean opaque type.

CFTypeID CFBooleanGetTypeID ();
Return Value

The Core Foundation type identifier for CFBoolean opaque type. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFBooleanGetTypeID (){};


/*CFNumberGetValue

Obtains the value of a CFNumber object cast to a specified type.

Boolean CFNumberGetValue (
   CFNumberRef number,
   CFNumberType theType,
   void *valuePtr
);
Parameters
number

The CFNumber object to examine. 
theType

A constant that specifies the data type to return. See Number Types for a list of possible values. 
valuePtr

On return, contains the value of number.
Return Value

true if the operation was successful, otherwise false. 
Discussion

If the argument type differs from the return type, and the conversion is lossy or the return value is out of range, then this function passes back an approximate value in valuePtr and returns false. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFNumberGetValue (
   CFNumberRef number,
   CFNumberType theType,
   void *valuePtr
){};

/*CFNumberGetTypeID

Returns the type identifier for the CFNumber opaque type.

CFTypeID CFNumberGetTypeID ();
Return Value

The type identifier for the CFNumber opaque type.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

CFTypeID CFNumberGetTypeID (){};


