#import <CoreData/NSFetchRequest.h>
//work
 @implementation  NSFetchRequest 

/*setEntity:

Sets the entity of the receiver.

- (void)setEntity:(NSEntityDescription *)entity
Parameters
entity

The entity of the receiver.
Availability
Available in Mac OS X v10.4 and later.
See Also
– entity*/
- (void)setEntity:(NSEntityDescription *)entity{}

/*setPredicate:

Sets the predicate of the receiver.

- (void)setPredicate:(NSPredicate *)predicate
Parameters
predicate

The predicate of the receiver.
Discussion

If the predicate is empty—for example, if it is an NSAndPredicate object whose array of elements contains no predicates—the receiver has its predicate set to nil. For more about predicates, see Predicates Programming Guide.
Availability
Available in Mac OS X v10.4 and later.
See Also
– predicate*/
- (void)setPredicate:(NSPredicate *)predicate{}


/*setSortDescriptors:

Sets the array of sort descriptors of the receiver.

- (void)setSortDescriptors:(NSArray *)sortDescriptors
Parameters
sortDescriptors

The array of sort descriptors of the receiver. nil specifies no sort descriptors.
Discussion

The sort descriptors specify how the objects returned when the fetch request is issued should be ordered—for example by last name then by first name. The sort descriptors are applied in the order in which they appear in the sortDescriptors array (serially in lowest-array-index-first order).
Availability
Available in Mac OS X v10.4 and later.
See Also
– sortDescriptors*/
- (void)setSortDescriptors:(NSArray *)sortDescriptors{}


/*setAffectedStores:

Sets the array of persistent stores that will be searched by the receiver. 

- (void)setAffectedStores:(NSArray *)stores
Parameters
stores

An array containing identifiers for the stores to be searched when the receiver is executed.
Availability
Available in Mac OS X v10.4 and later.
See Also
– affectedStores*/
- (void)setAffectedStores:(NSArray *)stores{}


/*isAbstract

Returns a Boolean value that indicates whether the receiver represents an abstract entity.

- (BOOL)isAbstract
Return Value

YES if the receiver represents an abstract entity, otherwise NO.
Discussion

An abstract entity might be Shape, with concrete sub-entities such as Rectangle, Triangle, and Circle.
Availability
Available in Mac OS X v10.4 and later.
See Also
– setAbstract:*/
- (BOOL)isAbstract{}

/*affectedStores

Returns an array containing the persistent stores specified for the receiver.

- (NSArray *)affectedStores
Return Value

An array containing the persistent stores specified for the receiver.
Availability
Available in Mac OS X v10.4 and later.
See Also
– setAffectedStores:*/
- (NSArray *)affectedStores{}



/*entity

Returns the entity specified for the receiver.

- (NSEntityDescription *)entity
Return Value

The entity specified for the receiver.
Availability
Available in Mac OS X v10.4 and later.
See Also
– setEntity:*/
- (NSEntityDescription *)entity{}








@end



