#include <CommonPanels/CommonPanels.h>
//work

/*NPickColor

Displays the Color Picker dialog.

OSErr NPickColor (
   NColorPickerInfo * theColorInfo
);
Parameters
theColorInfo

A pointer to a color picker parameter (NColorPickerInfo) data structure. On input, you specify information such as the location of the dialog. On output, the data structure specifies information such as whether the user changed the color. 
Return Value

A result code. See “Color Picker Result Codes”.
Discussion

The NPickColor function displays the standard dialog for color pickers. Use the color picker parameter data structure to specify information to and obtain information from the Color Picker Manager. 
Availability
Available in CarbonLib 1.0 and later when ColorPicker 2.1 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

This call is identical to the unsupported function PickColor , but it replaces the older ColorSync 1.0 data types with new ColorSync 2.x profile references. When filling out the parameter block for a call to the function NPickColor, you must replace all profile handles with profile references. The optional color-changed proc you has also changed; a new data structure NCMColor replaces the CMColor data type and uses profile references.
Declared In
ColorPicker.h*/
OSErr NPickColor (
   NColorPickerInfo * theColorInfo
){};


/*NewUserEventUPP

Creates a universal procedure pointer (UPP) to an event filter callback.

UserEventUPP NewUserEventUPP (
   UserEventProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the UserEventUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
ColorPicker.h*/
UserEventUPP NewUserEventUPP (
   UserEventProcPtr userRoutine
){};


/*PickColor

Requests the user to choose a color from the standard color picker dialog box.

OSErr PickColor (
   ColorPickerInfo * theColorInfo
);
Parameters
theColorInfo

A pointer to the ColorPickerInfo (Old) structure, to specify information to and obtain information from the Color Picker Manager. 
Return Value

A result code. See “Color Picker Result Codes”.
Discussion

The PickColor function displays the standard modal dialog box for color pickers. When the user clicks the OK button, PickColor removes the dialog box and returns true in the newColorChosen field and the user’s selected color in the theColor field of theColorInfo. When the user clicks the Cancel button, PickColor removes the dialog box and returns false in the newColorChosen field. 
Availability
Available in CarbonLib 1.0 and later when ColorPicker 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
ColorPicker.h*/

OSErr PickColor (
   ColorPickerInfo * theColorInfo
){};

/*GetColor

Requests the user to choose a color. This function is obsolete; use the PickColor function instead.

Boolean GetColor (
   Point where,
   ConstStr255Param prompt,
   const RGBColor * inColor,
   RGBColor * outColor
);
Parameters
where

A point defining the location of the upper-left corner of the dialog box. If you set this parameter to (0,0), the dialog box is centered horizontally on the main screen, with one-third of the empty space above the box and two-thirds below, regardless of the screen size. If you set this parameter to (–1,–1), the GetColor function displays the dialog box on the screen supporting the greatest pixel depth. 
prompt

Text for prompting the user to choose a color. This string is displayed in the upper-left corner of the dialog box. 
inColor

A pointer to an RGBColor structure for a color at entry to the picker. This is the original color, which the user may want for comparison. 
outColor

A pointer to an RGBColor structure describing the new color. This is set to the last color that the user picked before clicking OK. On entry, the outColor parameter is treated as undefined, so the output color sample initially matches the input. Although the color being picked may vary widely, the input color sample remains fixed, and clicking the input sample resets the output color sample to match it.
Return Value

True if the user clicks the OK button; false if the user clicks the Cancel button. In either case, the dialog box is removed. 
Discussion

The GetColor function does not support ColorSync 1.0 color matching; however, the PickColor function does. This function was designed for use for version 1.0 of the Color Picker Package and is still supported for backward compatibility. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
ColorPicker.h*/
Boolean GetColor (
   Point where,
   ConstStr255Param prompt,
   const RGBColor * inColor,
   RGBColor * outColor
){};



