#include <CarbonCore/CarbonCore.h>
//work

/*GetIntlResourceTable

Obtains a specific word-selection, line-break, number-parts, untoken, or whitespace table from the appropriate international resource. (Deprecated in Mac OS X v10.4. There is no replacement because this function is no longer needed in Mac OS X.)

void GetIntlResourceTable (
   ScriptCode script,
   short tableCode,
   Handle * itlHandle,
   long * offset,
   long * length
);
Parameters
script

A script code, the value that specifies a particular script system. Constants for all defined script codes are listed in “Meta Script Codes”. 
tableCode

A number that specifies which table is requested. The constants for tableCode are detailed in “Table Selectors”. 
itlHandle

On return, a handle to the string-manipulation ('itl2') or tokens ('itl4') resource containing the table specified in the tableCode parameter. If the script system whose table is requested is not available, GetIntlResourceTable returns a NULL handle. 
offset

On return, a pointer to the offset (in bytes) to the specified table from the beginning of the resource. 
length

On return, a pointer to the size of the table (in bytes).
Discussion

When you provide a script code in the script parameter, and a table code in the tableCode parameter, GetIntlResourceTable returns a handle to the string-manipulation resource or tokens resource containing that table, the offset of the specified table from the beginning of the resource, and the length of the table. 

If you wish to manipulate the contents of the table you have requested, use the size returned in the length parameter to allocate a buffer, and perform a block move of the table’s contents into that buffer. 
Special Considerations

GetIntlResourceTable may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Script.h*/
void GetIntlResourceTable (
   ScriptCode script,
   short tableCode,
   Handle * itlHandle,
   long * offset,
   long * length
){};

/*GetScriptManagerVariable

Retrieves the value of the specified Script Manager variable.

long GetScriptManagerVariable (
   short selector
);
Parameters
selector

A value that specifies a particular Script Manager variable. To specify the Script Manager variable whose value you need, use one of the selector constants listed in “Script Manager Selectors”. 
Return Value

The current value of the specified Script Manager variable or 0 if the selector is invalid. For some valid selectors, 0 may also be a valid return value. For example, when you call GetScriptManagerVariable with a selector value of smRegionCode on a version of Macintosh system software that has been localized for the United States, it returns 0. Although GetScriptManagerVariable always returns a long integer, the actual value may be a long integer, standard integer, or signed byte. If the value is not a long integer, it is stored in the low-order word or byte of the long integer returned by GetScriptManagerVariable; the remaining bytes are set to 0.
Discussion

The Script Manager maintains a set of variables that control general settings of the text environment, including the identity of the system script and the keyboard script, and the settings of the font force flag and the international resources selection flag.

You may want access to the Script Manager variables in order to understand the current environment or to modify it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Script.h*/


long GetScriptManagerVariable (
   short selector
){};

/*CharacterByteType

Identifies a byte in a text buffer as a single-byte character or as the first or second byte of a double-byte character. (Deprecated in Mac OS X v10.4. You should update your application to handle Unicode text. There is no replacement function because Unicode handles encoding in a different manner.)

short CharacterByteType (
   Ptr textBuf,
   short textOffset,
   ScriptCode script
);
Parameters
textBuf

A pointer to a text buffer containing the byte to be identified. 
textOffset

The offset to the byte to be identified. The offset is measured in bytes; the first byte has an offset of 0. 
script

A value that specifies the script system of the text in the buffer. Constants for all defined script codes are listed on “Meta Script Codes”. To specify the font script, pass smCurrentScript in this parameter. 
Return Value

One of three identifications: a single-byte character, the first byte of a double-byte character, or the second byte of a double-byte character. The first byte of a double-byte character—the one at the lower offset in memory—is the high-order byte the second byte of a double-byte character—the one at the higher offset—is the low-order byte. This is the same order in which text is processed and numbers are represented. 
Discussion

The script system associated with the character you wish to examine must be enabled in order for the function to provide useful information. For example, if only the Roman script system is available and you attempt to identify a byte in a run of double-byte characters, the CharacterByteType function returns 0, indicating that the byte is a single-byte character.

For single-byte script systems, the character-type tables reside in the string-manipulation ('itl2') resource and reflect region-specific or language-specific differences in uppercase conventions.

For double-byte script systems, the character-type tables reside in the encoding/rendering ('itl5') resource, not the string-manipulation resource. Whenever you call CharacterByteType, the necessary character-set encoding information is taken from the encoding/rendering resource. You cannot use the GetIntlResource function to access double-byte character-type tables directly.

From byte value alone, it is not possible to distinguish the second byte of a double-byte character from a single-byte character. CharacterByteType differentiates the second byte of a double-byte character from a single-byte character by assuming that the byte at offset 0 is the first byte of a character. With that assumption, it then sequentially identifies the size and starting position of each character in the buffer up to textOffset. 
Special Considerations

If you specify smCurrentScript for the script parameter, the value returned by CharacterByteType can be affected by the state of the font force flag. It is unaffected by the state of the international resources selection flag.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Script.h*/
short CharacterByteType (
   Ptr textBuf,
   short textOffset,
   ScriptCode script
){};

/*GetScriptVariable

Retrieves the value of the specified script variable from the specified script system.

long GetScriptVariable (
   short script,
   short selector
);
Parameters
script

A value that specifies the script system whose variable you are accessing. Use one of the script-code constants listed in “Meta Script Codes”. 
selector

A value that specifies a particular script variable. Use one of the selector constants listed in “Script Variable Selectors”. Valid selector values are defined by each script system.
Return Value

0 if the selector value is invalid or if the specified script system is not installed. For some valid selectors, 0 may also be a valid return value. For example, calling GetScriptVariable with a selector of smScriptLang on a version of Macintosh system software that has been localized for the United States returns 0. Although GetScriptVariable always returns a long integer, the actual value may be a long integer, standard integer, or signed byte. If the value is not a long integer, it is stored in the low-order word or byte of the long integer returned by GetScriptVariable; the remaining bytes are set to 0.
Discussion

Each enabled script system maintains a set of variables that control the current settings of that script system, including the ID numbers of its international resources, its preferred fonts and font sizes, and its primary line direction. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Script.h*/
long GetScriptVariable (
   short script,
   short selector
){};

/*GetSysDirection

Returns the current value of SysDirection, the global variable that determines the system direction (primary line direction). (Deprecated in Mac OS X v10.4. This function does not return anything useful in Mac OS X.)

short GetSysDirection ();
Parameters
Return Value

The current value of SysDirection: 0 if the system direction is left-to-right; -1 ($FFFF) if the system direction is right-to-left. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Script.h*/
short GetSysDirection (){};

/*FontToScript

Translates a font family ID number into its corresponding script code, if that script system is currently enabled. (Deprecated in Mac OS X v10.4. Use ATSFontFamilyGetEncoding instead.)

short FontToScript (
   short fontNumber
);
Parameters
fontNumber

A font family ID number. 
Return Value

A script code. All recognized script codes and their defined constants are listed in “Meta Script Codes”. FontToScript returns only explicit script codes (≥ 0). If fontNumber is in the Roman range and the font force flag is TRUE, the script code returned is that of the system script and the script-forced result flag is set to TRUE. If fontNumber is in the non-Roman range, the state of the font force flag is ignored. If the script system corresponding to fontNumber is not enabled, the script code returned is that of the system script and the script-defaulted result flag is set to TRUE.
Discussion

The information about the script code is subject to two control flags—the font force flag and the international resources selection flag. You can test and set these flags with the GetScriptManagerVariable and SetScriptManagerVariable selectors smFontForce and smIntlForce.

The function starts by initializing two result flags, the script-forced result flag and the script-defaulted result flag, to FALSE. These flags are Script Manager variables, accessed through the GetScriptManagerVariable function selectors smForced and smDefault.

Do not use the function FontToScript to convert resource IDs to scripts codes. 
Special Considerations

FontToScript may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Script.h*/
short FontToScript (
   short fontNumber
){};

/*SetScriptManagerVariable

Sets the specified Script Manager variable to the value of the input parameter.

OSErr SetScriptManagerVariable (
   short selector,
   long param
);
Parameters
selector

A value that specifies a particular Script Manager variable. To specify the Script Manager variable whose value you wish to change, use one of the selector constants listed in “Script Manager Selectors”. 
param

The new value for the specified Script Manager variable.

The actual values to be assigned may be long integers, standard integers, or signed bytes. If the value is other than a long integer, you must store it in the low-order word or byte of the param parameter and set the unused bytes to 0.
Return Value

A result code. See “Script Manager Result Codes”. The value smBadVerb if the selector is not valid. Otherwise, the function returns 0 (noErr).
Discussion

The Script Manager maintains a set of variables that control general settings of the text environment, including the identity of the system script and the keyboard script, and the settings of the font force flag and the international resources selection flag.

You may want access to the Script Manager variables in order to understand the current environment or to modify it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Script.h*/
OSErr SetScriptManagerVariable (
   short selector,
   long param
){};
