#include <CarbonCore/CarbonCore.h>

//work

/*UpTime
AbsoluteTime UpTime (void); 
DESCRIPTION

UpTime returns the time since OS initialization in AbsoluteTime units.
EXECUTION CONTEXT

UpTime may be called from task level, secondary interrupt level, or hardware interrupt level.*/
AbsoluteTime UpTime (void){}; 

/*Time Conversion Routines

The Driver Services Library provides the following conversion routines to convert between Nanoseconds, Duration, and AbsoluteTime units:
Nanoseconds AbsoluteToNanoseconds (AbsoluteTime absoluteTime); 

Nanoseconds DurationToNanoseconds (Duration duration); 

Duration AbsoluteToDuration (AbsoluteTime absoluteTime); 

AbsoluteTime NanosecondsToAbsolute (Nanoseconds nanoseconds); 

AbsoluteTime DurationToAbsolute (Duration duration); 

Duration NanosecondsToDuration (Nanoseconds nanoseconds); 

AbsoluteTime AddAbsoluteToAbsolute(
                     AbsoluteTime absoluteTime1,
                     AbsoluteTime absoluteTime2); 

AbsoluteTime SubAbsoluteFromAbsolute(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime); 

AbsoluteTime AddNanosecondsToAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime); 

AbsoluteTime AddDurationToAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime); 

AbsoluteTime SubNanosecondsFromAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime); 

AbsoluteTime SubDurationFromAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime); 

Nanoseconds AbsoluteDeltaToNanoseconds(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime); 

Duration AbsoluteDeltaToDuration(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime); 

Note

The value of rightAbsoluteTime is usually larger than that of leftAbsoluteTime. However, if you subtract a rightAbsoluteTime value from a leftAbsoluteTime value, the result is 0, not a negative number. 
EXECUTION CONTEXT

The time conversion routines may be called from task level, secondary interrupt level, or hardware interrupt level.*/

Nanoseconds AbsoluteToNanoseconds (AbsoluteTime absoluteTime){}; 

Nanoseconds DurationToNanoseconds (Duration duration){}; 

Duration AbsoluteToDuration (AbsoluteTime absoluteTime){}; 

AbsoluteTime NanosecondsToAbsolute (Nanoseconds nanoseconds){}; 

AbsoluteTime DurationToAbsolute (Duration duration){}; 

Duration NanosecondsToDuration (Nanoseconds nanoseconds){}; 

AbsoluteTime AddAbsoluteToAbsolute(
                     AbsoluteTime absoluteTime1,
                     AbsoluteTime absoluteTime2){}; 

AbsoluteTime SubAbsoluteFromAbsolute(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime){}; 

AbsoluteTime AddNanosecondsToAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime){}; 

AbsoluteTime AddDurationToAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime){}; 

AbsoluteTime SubNanosecondsFromAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime){}; 

AbsoluteTime SubDurationFromAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime){}; 

Nanoseconds AbsoluteDeltaToNanoseconds(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime){}; 

Duration AbsoluteDeltaToDuration(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime){}; 

