#include <CarbonCore/CarbonCore.h>

//work

/*NewCollection

Creates a new, empty collection object.

Collection NewCollection ();
Return Value

A reference to the newly created collection object. The new collection contains no items and has an owner count of 1. The NewCollection function does not return an error code; it returns NULL if it cannot create a new collection object. See the description of the Collection data type.
Discussion

The NewCollection function allocates memory for a new collection object, initializes it, and returns a reference to it. 

To create a copy of an existing collection object, use the CopyCollection function. 
Special Considerations

You are responsible for disposing of collection objects that you create with this function when you no longer need them. To dispose of a collection object, use the DisposeCollection function.
Availability
Available in CarbonLib 1.0 and later when Collections 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Collections.h*/
Collection NewCollection (){};

/*GetCollectionItem

Obtains a copy of the variable-length data associated with a collection item given the item’s collection tag and collection ID.

OSErr GetCollectionItem (
   Collection c,
   CollectionTag tag,
   SInt32 id,
   SInt32 * itemSize,
   void * itemData
);
Parameters
c

A reference to the collection object containing the item whose data you want to retrieve. The behavior of this function is undefined if you do not provide a reference to a valid collection object. 
tag

The collection tag associated with the item whose data you want to retrieve. 
id

The collection ID associated with the item whose data you want to retrieve. 
itemSize

A pointer to an SInt32 value indicating the number of bytes of data you want returned in the itemData parameter. On return, this value indicates the size in bytes of the variable-length data associated with the specified item. You may specify the constant dontWantSize for this parameter to indicate that you want to copy all the specified item’s variable-length data and you do not want to determine the size of this data. You may specify a value for the itemSize parameter that is greater than the actual number of bytes in the specified item’s variable-length data however, this function never returns in the itemData parameter more data than contained in the specified item’s variable-length data.
itemData

A pointer to a block of memory to contain the item’s data. On return, this memory contains a copy of the data associated with the specified item. You may specify the constant dontWantData for this parameter if you do not want a copy of the item’s data. 
Return Value

A result code. See “Result Codes”.
Discussion

If you do not know the size of the item you want to retrieve, you typically call this function twice. The first time you provide a pointer in the itemSize parameter to determine the size of the specified item’s data and you specify dontWantData for the itemData parameter. Then you allocate a memory block large enough to hold a copy of the item’s data. Then you call the function a second time. This time you specify the constant dontWantSize for the itemSize parameter and provide a pointer to the allocated memory block for the itemData parameter. The function then copies the data into the allocated block of memory.

To retrieve the data associated with a collection item given its collection index (rather than its collection tag and ID), use the GetIndexedCollectionItem function. 
Availability
Available in CarbonLib 1.0 and later when Collections 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Collections.h*/
OSErr GetCollectionItem (
   Collection c,
   CollectionTag tag,
   SInt32 id,
   SInt32 * itemSize,
   void * itemData
){};

/*DisposeCollection

Disposes of a collection object.

void DisposeCollection (
   Collection c
);
Parameters
c

A reference to the collection object you want to dispose of. The behavior of this function is undefined if you do not provide a reference to a valid collection object. 
Discussion

The DisposeCollection function decrements the owner count of the collection object referenced by the c parameter. If the resulting owner count is 0, this function releases the memory occupied by the collection object, and the collection object reference contained in the c parameter becomes invalid.

To create a new collection object, use the NewCollection function.

To increment the owner count of a collection object, use the CloneCollection function. To determine the owner count of an existing collection object, use the CountCollectionOwners function 
Availability
Available in CarbonLib 1.0 and later when Collections 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Collections.h*/
void DisposeCollection (
   Collection c
){};


