#include <AudioToolbox/AudioToolbox.h>

/*ExtAudioFileDispose


Close the file and dispose the object. 
extern OSStatus ExtAudioFileDispose(
    ExtAudioFileRef inExtAudioFile) ;  
Parameters
inExtAudioFile
The extended audio file object.
Return Value

An OSStatus error code. 

Discussion 

Closes the file and deletes the object. If no frames were written to an ExtAudioFile allocated by ExtAudioFileCreateNew, the output file is deleted. 
Availability
Introduced in Mac OS X v10.4.*/
OSStatus ExtAudioFileDispose(
    ExtAudioFileRef inExtAudioFile){
printf ("ExtAudioFileDispose",inExtAudioFile);
} ;  


/*ExtAudioFileWriteAsync


Perform an asynchronous sequential write.
extern OSStatus ExtAudioFileWriteAsync(
    ExtAudioFileRef inExtAudioFile, 
    UInt32 inNumberFrames, 
    const AudioBufferList *ioData) ;  
Parameters
inExtAudioFile
The extended audio file object.
inNumberFrames
The number of frames to write.
ioData
The buffer(s) from which audio data is written to the file.
Return Value

An OSStatus error code. 

Discussion 

Writes the provided buffer list to an internal ring buffer and notifies an internal thread to perform the write at a later time. The first time this is called, allocations may be performed. You can call this with 0 frames and null buffer in a non-time-critical context to initialize the asynchronous mechanism. Once initialized, subsequent calls are very efficient and do not take locks; thus this may be used to write to a file from a realtime thread. 

The client must not mix synchronous and asynchronous writes to the same file. 

Pending writes are not guaranteed to be flushed to disk until ExtAudioFileDispose is called. 

N.B. Errors may occur after this call has returned. Such errors may be returned from subsequent calls to this function. 
Availability
Introduced in Mac OS X v10.4.*/
extern OSStatus ExtAudioFileWriteAsync(
    ExtAudioFileRef inExtAudioFile, 
    UInt32 inNumberFrames, 
    const AudioBufferList *ioData) {
printf ("ExtAudioFileWriteAsync",inExtAudioFile,inNumberFrames,*ioData);
};  


/*ExtAudioFileCreateNew


Create a new audio file. 
extern OSStatus ExtAudioFileCreateNew(
    const FSRef *inParentDir, 
    CFStringRef inFileName, 
    AudioFileTypeID inFileType, 
    const AudioStreamBasicDescription *inStreamDesc, 
    const AudioChannelLayout *inChannelLayout, 
    ExtAudioFileRef *outExtAudioFile) ;  
Parameters
inParentDir
The directory in which to create the new file.
inFileName
The name of the new file.
inFileType
The type of file to create. This is a constant from AudioToolbox/AudioFile.h, e.g. kAudioFileAIFFType. Note that this is not an HFSTypeCode.
inStreamDesc
The format of the audio data to be written to the file.
inChannelLayout
The channel layout of the audio data. If non-null, this must be consistent with the number of channels specified by inStreamDesc.
outExtAudioFile
On exit, a newly-allocated ExtAudioAudioFileRef.
Return Value

An OSStatus error code. 

Discussion 

Creates a new audio file. 

If the file to be created is in an encoded format, it is permissible for the sample rate in inStreamDesc to be 0, since in all cases, the file's encoding AudioConverter may produce audio at a different sample rate than the source. The file will be created with the audio format actually produced by the encoder. 
Availability
Introduced in Mac OS X v10.4.*/
extern OSStatus ExtAudioFileCreateNew(
    const FSRef *inParentDir, 
    CFStringRef inFileName, 
    AudioFileTypeID inFileType, 
    const AudioStreamBasicDescription *inStreamDesc, 
    const AudioChannelLayout *inChannelLayout, 
    ExtAudioFileRef *outExtAudioFile) {
printf ("ExtAudioFileCreateNew",*inParentDir,inFileName,inFileType,*inStreamDesc,*inChannelLayout,*outExtAudioFile);
};

/*ExtAudioFileSetProperty


Set a property value.
extern OSStatus ExtAudioFileSetProperty(
    ExtAudioFileRef inExtAudioFile, 
    ExtAudioFilePropertyID inPropertyID, 
    UInt32 inPropertyDataSize, 
    const void *inPropertyData) ;  
Parameters
inExtAudioFile
The extended audio file object.
inPropertyID
The property being set.
inPropertyDataSize
The size of the property data, in bytes.
inPropertyData
Points to the property's new value.
Return Value

An OSStatus error code. 

Availability
Introduced in Mac OS X v10.4.*/
OSStatus ExtAudioFileSetProperty(
    ExtAudioFileRef inExtAudioFile, 
    ExtAudioFilePropertyID inPropertyID, 
    UInt32 inPropertyDataSize, 
    const void *inPropertyData){
printf ("ExtAudioFileSetProperty",inExtAudioFile,inPropertyID,inPropertyDataSize,inPropertyData);
} ;  


/*ExtAudioFileGetProperty


Get a property value.
extern OSStatus ExtAudioFileGetProperty(
    ExtAudioFileRef inExtAudioFile, 
    ExtAudioFilePropertyID inPropertyID, 
    UInt32 *ioPropertyDataSize, 
    void *outPropertyData) ;  
Parameters
inExtAudioFile
The extended audio file object.
inPropertyID
The property being fetched.
ioPropertyDataSize
On entry, the size (in bytes) of the memory pointed to by outPropertyData. On exit, the actual size of the property data returned.
outPropertyData
The value of the property is copied to the memory this points to.
Return Value

An OSStatus error code. 

Availability
Introduced in Mac OS X v10.4.*/
OSStatus ExtAudioFileGetProperty(
    ExtAudioFileRef inExtAudioFile,
    ExtAudioFilePropertyID inPropertyID,
    UInt32 *ioPropertyDataSize,
    void *outPropertyData){
printf ("ExtAudioFileGetProperty",inExtAudioFile,inPropertyID,*ioPropertyDataSize,outPropertyData);
} ;



