#ifndef _WINGDI_
#define _WINGDI_
#ifndef NOGDI

#ifdef __cplusplus
extern "C" {
#endif

#include <Wine/pshpack2.h>
#include <Wine/poppack.h>

#define CCHDEVICENAME 32
#define CCHFORMNAME   32
#define HORZRES           8
#define VERTRES           10
#define SRCCOPY         0xcc0020

#define RGB(r,g,b)          ((COLORREF)((BYTE)(r) | ((BYTE)(g) << 8) | ((BYTE)(b) << 16)))

typedef struct
{
    INT    cbSize;
    LPCSTR   lpszDocName;
    LPCSTR   lpszOutput;
    LPCSTR   lpszDatatype;
    DWORD    fwType;
} DOCINFOA, *LPDOCINFOA;

DECL_WINELIB_TYPE_AW(DOCINFO)

typedef struct
{
    BYTE   dmDeviceName[CCHDEVICENAME];
    WORD   dmSpecVersion;
    WORD   dmDriverVersion;
    WORD   dmSize;
    WORD   dmDriverExtra;
    DWORD  dmFields;
    union {
      struct {
	short  dmOrientation;
	short  dmPaperSize;
	short  dmPaperLength;
	short  dmPaperWidth;
      } DUMMYSTRUCTNAME1;
      POINTL dmPosition;
    } DUMMYUNIONNAME1;
    short  dmScale;
    short  dmCopies;
    short  dmDefaultSource;
    short  dmPrintQuality;
    short  dmColor;
    short  dmDuplex;
    short  dmYResolution;
    short  dmTTOption;
    short  dmCollate;
    BYTE   dmFormName[CCHFORMNAME];
    WORD   dmLogPixels;
    DWORD  dmBitsPerPel;
    DWORD  dmPelsWidth;
    DWORD  dmPelsHeight;
    DWORD  dmDisplayFlags;
    DWORD  dmDisplayFrequency;
    DWORD  dmICMMethod;
    DWORD  dmICMIntent;
    DWORD  dmMediaType;
    DWORD  dmDitherType;
    DWORD  dmReserved1;
    DWORD  dmReserved2;
    DWORD  dmPanningWidth;
    DWORD  dmPanningHeight;
} DEVMODEA, *PDEVMODEA, *LPDEVMODEA;




//func
INT  WINAPI GetDeviceCaps(HDC,INT);
#define     StartDoc WINELIB_NAME_AW(StartDoc)
INT       WINAPI StartDocA(HDC,const DOCINFOA*);
INT       WINAPI StartPage(HDC);
INT       WINAPI EndPage(HDC);
INT       WINAPI EndDoc(HDC);
BOOL      WINAPI DeleteDC(HDC);

#define     CreateDC WINELIB_NAME_AW(CreateDC)
HDC       WINAPI CreateDCA(LPCSTR,LPCSTR,LPCSTR,const DEVMODEA*);

HBRUSH    WINAPI CreateSolidBrush(COLORREF);

BOOL      WINAPI StretchBlt(HDC,INT,INT,INT,INT,HDC,INT,
                                INT,INT,INT,DWORD);

BOOL      WINAPI DeleteObject(HGDIOBJ);

BOOL      WINAPI GdiFlush(void);

HGDIOBJ   WINAPI SelectObject(HDC,HGDIOBJ);

#ifdef __cplusplus
}
#endif

#endif /* !NOGDI */
#endif /* _WINGDI_ */

