#ifndef QD3DCAMERA_H
#define QD3DCAMERA_H

#ifndef  QD3D_H
#include <QD3D.h>
#endif

#include <HYS/QD3DCamera.h>


#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Camera View Port Structure

You use a camera view port structure to get or set information about the view port of a camera. A camera's view port defines the rectangular portion of the view plane that is to be mapped into the area specified by the current draw context. The default settings for a view port describe the entire view plane, where the origin (-1.0, 1.0) is the upper-left corner and the width and height of the plane are both 2.0. A camera view port structure is defined by the TQ3CameraViewPort data type.
typedef struct TQ3CameraViewPort {
    TQ3Point2D                          origin;
    float                               width;
    float                               height;
} TQ3CameraViewPort;
origin 
The origin of the view port. The values of the x and y fields of this point should be between -1.0 and 1.0.
width 
The width of the view port. The value in this field should be greater than 0.0 and less than 2.0.
height 
The height of the view port. The value in this field should be greater than 0.0 and less than 2.0.*/
typedef struct TQ3CameraViewPort {
    TQ3Point2D                          origin;
    float                               width;
    float                               height;
} TQ3CameraViewPort;


/*Camera Range Structure

You use a camera range structure to get or set the hither and yon clipping planes for a camera. A camera range structure is defined by the TQ3CameraRange data type.
typedef struct TQ3CameraRange {
    float                               hither;
    float                               yon;
} TQ3CameraRange;
hither 
The distance (measured along the camera vector) from the camera's location to the near clipping plane. The value in this field should always be greater than 0.
yon 
The distance (measured along the camera vector) from the camera's location to the far clipping plane. The value in this field should always be greater than the value in the hither field.*/

typedef struct TQ3CameraRange {
    float                               hither;
    float                               yon;
} TQ3CameraRange;


/*A world coordinate system defines the relative positions and sizes of geometric objects. When an object is rendered in a view, the view's camera specifies yet another coordinate system, the camera coordinate system (or camera space ). A camera coordinate system is defined by the camera placement structure associated with the camera, which is defined like this: 
typedef struct TQ3CameraPlacement {
    TQ3Point3D                          cameraLocation;
    TQ3Point3D                          pointOfInterest;
    TQ3Vector3D                         upVector;
} TQ3CameraPlacement;

See the chapter "Camera Objects" for complete information about the camera placeme*/
typedef struct TQ3CameraPlacement {
    TQ3Point3D                          cameraLocation;
    TQ3Point3D                          pointOfInterest;
    TQ3Vector3D                         upVector;
} TQ3CameraPlacement;


/*Camera Data Structure

You use a camera data structure to get or set basic information about a camera of any kind. A camera data structure is defined by the TQ3CameraData data type.
typedef struct TQ3CameraData {
    TQ3CameraPlacement                  placement;
    TQ3CameraRange                      range;
    TQ3CameraViewPort                   viewPort;
} TQ3CameraData;
placement 
A camera placement structure that specifies the current placement and orientation of the camera.
range 
A camera range structure that specifies the current hither and yon clipping planes for the camera.
viewPort 
A camera view port structure that specifies the current view port of the camera.*/
typedef struct TQ3CameraData {
    TQ3CameraPlacement                  placement;
    TQ3CameraRange                      range;
    TQ3CameraViewPort                   viewPort;
} TQ3CameraData;


#ifdef __cplusplus
}
#endif

#endif