#ifndef PALETTES_H
#define PALETTES_H

#ifndef QUICKDRAW_H
#include <QD/Quickdraw.h>
#endif



#include <AvailabilityMacros.h>
//#include <HYS/QD/Palettes.h>
#include <APPLE/QD/Palettes.h>
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Update Constants

Constants used to determine whether a window is updated based on various changes to the color environment.

enum {
   pmNoUpdates = 0x8000,
   pmBkUpdates = 0xA000,
   pmFgUpdates = 0xC000,
   pmAllUpdates = 0xE000
};
Constants
pmNoUpdates

Do not update the window when its color environment changes. 

Available in Mac OS X v10.0 and later.
pmBkUpdates

Update the window only when it is not the active window. 

Available in Mac OS X v10.0 and later.
pmFgUpdates

Update the window only when it is the active window.

Available in Mac OS X v10.0 and later.
pmAllUpdates

Update the window whenever its color environment changes.

Available in Mac OS X v10.0 and later.
Discussion

You use these constants in the nCUpdates parameter of the NSetPalette function and the updates parameter of the SetPaletteUpdates function*/
enum {
   pmNoUpdates = 0x8000,
   pmBkUpdates = 0xA000,
   pmFgUpdates = 0xC000,
   pmAllUpdates = 0xE000
};

/*Usage Constants

Constants used to determine how the Palette Manager uses a specific palette color.

enum {
   pmCourteous = 0,
   pmDithered = 0x0001,
   pmTolerant = 0x0002,
   pmAnimated = 0x0004,
   pmExplicit = 0x0008,
   pmWhite = 0x0010,
   pmBlack = 0x0020,
   pmInhibitG2 = 0x0100,
   pmInhibitC2 = 0x0200,
   pmInhibitG4 = 0x0400,
   pmInhibitC4 = 0x0800,
   pmInhibitG8 = 0x1000,
   pmInhibitC8 = 0x2000
};
Constants
pmCourteous

The color accepts whatever value the Color Manager determines to be the closest match currently available in the device color table.

Available in Mac OS X v10.0 and later.
pmDithered

[description forthcoming]

Available in Mac OS X v10.0 and later.
pmTolerant

The color accepts the Color Manager's choices on an indexed device.

Available in Mac OS X v10.0 and later.
pmAnimated

The color is used for special color animation effects.

Available in Mac OS X v10.0 and later.
pmExplicit

The color specifies an index value rather than an RGB color and always generates the corresponding entry from the device's color table.

Available in Mac OS X v10.0 and later.
pmWhite

Assign color to white on a 1-bit device.

Available in Mac OS X v10.0 and later.
pmBlack

Assign color to black on a 1-bit device.

Available in Mac OS X v10.0 and later.
pmInhibitG2

Inhibit on 2-bit grayscale device.

Available in Mac OS X v10.0 and later.
pmInhibitC2

Inhibit on 2-bit color device.

Available in Mac OS X v10.0 and later.
pmInhibitG4

Inhibit on 4-bit grayscale device.

Available in Mac OS X v10.0 and later.
pmInhibitC4

Inhibit on 4-bit color device.

Available in Mac OS X v10.0 and later.
pmInhibitG8

Inhibit on 8-bit grayscale device.

Available in Mac OS X v10.0 and later.
pmInhibitC8

Inhibit on 8-bit color device.

Available in Mac OS X v10.0 and later.
Discussion

You can logically AND these constants in certain combinations to specify the value of ciUsage in a ColorInfo record.

The inhibit constants are used to indicate that a graphics device should be prevented from displaying the color at specified pixel depths. They are always used in combination with other usage constants.*/
enum {
   pmCourteous = 0,
   pmDithered = 0x0001,
   pmTolerant = 0x0002,
   pmAnimated = 0x0004,
   pmExplicit = 0x0008,
   pmWhite = 0x0010,
   pmBlack = 0x0020,
   pmInhibitG2 = 0x0100,
   pmInhibitC2 = 0x0200,
   pmInhibitG4 = 0x0400,
   pmInhibitC4 = 0x0800,
   pmInhibitG8 = 0x1000,
   pmInhibitC8 = 0x2000
};

/*ColorInfo

Specifies color information for each color in a palette.

struct ColorInfo {
   RGBColor ciRGB;
   short ciUsage;
   short ciTolerance;
   short ciDataFields[3];
};
typedef struct ColorInfo ColorInfo;
typedef ColorInfo * ColorInfoPtr;
Fields
ciRGB

An RGB color value, which is defined by the RGBColor structure. It contains three fields that contain integer values for defining, respectively, the red, green, and blue values of the color. 
ciUsage

One or more of the usage constants, specifying how this entry is to be used. The ciUsage field can contain any of the Usage Constants.
ciTolerance

An integer expressing the range in RGB space within which the red, green, and blue values must fall to satisfy this entry. A tolerance value of $0000 means that only an exact match is acceptable. Values of $0xxx other than $0000 are reserved and should not be used in applications.
ciDataFields

Private fields.
Discussion

Each color information structure in a palette comprises an RGB color value, information describing how the color is to be used, a tolerance value for colors that need only be approximated, and private fields. You should not create and modify the public fields directly; instead, use Palette Manager functions such as SetEntryColor and SetEntryUsage.
Availability
Available in Mac OS X v10.0 and later.*/
struct ColorInfo {
   RGBColor ciRGB;
   short ciUsage;
   short ciTolerance;
   short ciDataFields[3];
};
typedef struct ColorInfo ColorInfo;
typedef ColorInfo * ColorInfoPtr;

/*Palette

Represents a set of colors optimized for use on display devices with a limited number of colors.

struct Palette {
   short pmEntries;
   short pmDataFields[7];
   ColorInfo pmInfo[1];
};
typedef struct Palette Palette;
typedef Palette * PalettePtr;
Fields
pmEntries

The number of ColorInfo structures in the pmInfo array.
pmDataFields

Private fields used by the Palette Manager.
pmInfo

An array of ColorInfo structures. 
Discussion

A palette structure contains a header and a collection of color information structures, one for each color in the palette.
Availability
Available in Mac OS X v10.0 and later*/
struct Palette {
   short pmEntries;
   short pmDataFields[7];
   ColorInfo pmInfo[1];
};
typedef struct Palette Palette;
typedef Palette * PalettePtr;
#include <APPLE/QD/Palettes_E.h>

/*Data Types
struct Palette {
   short pmEntries;       // entries in pmTable //
   short pmDataFields[7];// private fields //
   ColorInfo pmInfo[1];
};
typedef struct Palette Palette;
typedef Palette /PalettePtr, **PaletteHandle;
struct ColorInfo {
   RGBColor ciRGB;        // true RGB values //
   short ciUsage;         // color usage //
   short ciTolerance;     // tolerance value //
   short ciDataFields[3]; // private fields //
};
typedef struct ColorInfo ColorInfo;*/

typedef Palette *PalettePtr, **PaletteHandle;


//function

/*SetPalette

Associates a palette with a window. (Deprecated in Mac OS X v10.4. There is no replacement; 8-bit graphics mode is not supported by the Mac OS X GUI.)

Not recommended.

void SetPalette (
   WindowRef dstWindow,
   PaletteHandle srcPalette,
   Boolean cUpdates
);
Parameters
dstWindow

A pointer to the window to which you want to assign a new palette. 
srcPalette

A handle to the palette you want to assign. 
cUpdates

A Boolean value in which your application specifies whether the window is to receive updates as a result of changes to the color environment. Specify TRUE if you want the window to be updated, even if the window is not the frontmost window. When a window is the frontmost window, changes to its palette cause it to get an update event regardless of how the cUpdates parameter is set. 
Discussion

You can use the NSetPalette function, which does the same thing as SetPalette, when you need greater flexibility in setting criteria for updates. The nCUpdates parameter for the NSetPalette function includes the option of turning off updates when the window is the frontmost window.

Use the NSetPalette function to associate a palette with a window but with additional options as to when an update event is triggered by changes to the color environment. 

Use the GetNewPalette function or the NewPalette function to create a new palette. To dispose of a palette, use the DisposePalette function. 
Special Considerations

For applications running in Mac OS X, the Palette Manager is no longer relevant because display devices always support direct color (pixel depth of 16 or 32 bits). The palette-based graphics model only works in 256-color (8-bit pseudocolor) modes of operation, which are not supported for the Mac OS X GUI.

There is some support for palettes in Quartz Services; see Quartz Display Services Reference.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Palettes.h*/
void SetPalette (
   WindowRef dstWindow,
   PaletteHandle srcPalette,
   Boolean cUpdates
);

/*GetGray

Determines the best intermediate color between two colors on a given graphics device. (Deprecated in Mac OS X v10.4. There is no replacement; 8-bit graphics mode is not supported by the Mac OS X GUI.)

Boolean GetGray (
   GDHandle device,
   const RGBColor * backGround,
   RGBColor * foreGround
);
Parameters
device

A handle to the graphics device for which an intermediate color or gray is needed. 
backGround

The RGBColor structure for one of the two colors for which you want an intermediate color. 
foreGround

On input, the RGBColor structure for the other of the two colors; upon completion, the best intermediate color between these two.
Return Value

If no gray is available (or if no distinguishable third color is available), the foreGround parameter is unchanged, and the function returns FALSE. If at least one gray or intermediate color is available, it is returned in the foreGround parameter, and the function returns TRUE. 
Discussion

The GetGray function determines the midpoint values for the red, green, and blue values of the two colors you specify in the backGround and foreGround parameters.

You can also use GetGray to return the best gray. For example, when dimming an object, supply black and white as the two colors, and GetGray returns the best available gray that lies between them. 
Special Considerations

For applications running in Mac OS X, the Palette Manager is no longer relevant because display devices always support direct color (pixel depth of 16 or 32 bits). The palette-based graphics model only works in 256-color (8-bit pseudocolor) modes of operation, which are not supported for the Mac OS X GUI.

There is some support for palettes in Quartz Services; see Quartz Display Services Reference.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Palettes.h*/
Boolean GetGray (
   GDHandle device,
   const RGBColor * backGround,
   RGBColor * foreGround
);

/*Palette2CTab

Copies the colors of a palette into a color table. (Deprecated in Mac OS X v10.4. There is no replacement; 8-bit graphics mode is not supported by the Mac OS X GUI.)

Not recommended.

void Palette2CTab (
   PaletteHandle srcPalette,
   CTabHandle dstCTab
);
Parameters
srcPalette

A handle to the palette whose colors are to be used. 
dstCTab

A handle to the color table to receive the colors. 
Discussion

The Palette2CTab function copies all of the colors from an existing palette structure into an existing color-table structure. If the structures are not the same size, then Palette2CTab resizes the color-table structure to match the number of entries in the palette structure. If either the palette handle or the color-table handle is NULL, Palette2CTab does nothing. 
Special Considerations

For applications running in Mac OS X, the Palette Manager is no longer relevant because display devices always support direct color (pixel depth of 16 or 32 bits). The palette-based graphics model only works in 256-color (8-bit pseudocolor) modes of operation, which are not supported for the Mac OS X GUI.

There is some support for palettes in Quartz Services; see Quartz Display Services Reference.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Palettes.h*/
void Palette2CTab (
   PaletteHandle srcPalette,
   CTabHandle dstCTab
);

/*AnimatePalette

Changes the colors of a series of palette entries; it is similar to the AnimateEntry function, but it acts upon a range of entries. (Deprecated. There is no replacement; 8-bit graphics mode is not supported by the Mac OS X GUI.)

Not recommended.

void AnimatePalette (
   WindowRef dstWindow,
   CTabHandle srcCTab,
   short srcIndex,
   short dstEntry,
   short dstLength
);
Parameters
dstWindow

A pointer to the window whose palette colors are to be changed. 
srcCTab

A handle to the color table containing the new colors. 
srcIndex

The source color table entry at which copying starts. 
dstEntry

The palette entry at which copying starts.
dstLength

The number of palette entries to be changed.
Discussion

The AnimatePalette function changes the colors of a series of palette entries. Beginning at the index specified by the srcIndex parameter (which has a minimum value of 0), the number of entries specified in dstLength are copied from the source color table to the destination window’s palette, beginning at the entry specified in the dstEntry parameter. If the source color table specified in srcCTab is not sufficiently large to accommodate the request, AnimatePalette modifies as many entries as possible and leaves the remaining entries unchanged. 
Special Considerations

For applications running in Mac OS X, the Palette Manager is no longer relevant because display devices always support direct color (pixel depth of 16 or 32 bits). The palette-based graphics model only works in 256-color (8-bit pseudocolor) modes of operation, which are not supported for the Mac OS X GUI.

There is some support for palettes in Quartz Services; see Quartz Display Services Reference.
Declared In
Palettes.h*/
void AnimatePalette (
   WindowRef dstWindow,
   CTabHandle srcCTab,
   short srcIndex,
   short dstEntry,
   short dstLength
);

/*SetEntryColor

Changes the color of a palette entry. (Deprecated in Mac OS X v10.4. There is no replacement; 8-bit graphics mode is not supported by the Mac OS X GUI.)

Not recommended.

void SetEntryColor (
   PaletteHandle dstPalette,
   short dstEntry,
   const RGBColor * srcRGB
);
Parameters
dstPalette

The palette whose entry color is to be changed. 
dstEntry

The palette entry to be changed. 
srcRGB

A pointer to the new RGB color value. 
Discussion

SetEntryColor marks the entry as having changed, but it does not change the color environment. That change occurs upon the next call to ActivatePalette. SetEntryColor marks modified entries such that the palette is updated, even though no update is required by a change in the color environment. 
Special Considerations

For applications running in Mac OS X, the Palette Manager is no longer relevant because display devices always support direct color (pixel depth of 16 or 32 bits). The palette-based graphics model only works in 256-color (8-bit pseudocolor) modes of operation, which are not supported for the Mac OS X GUI.

There is some support for palettes in Quartz Services; see Quartz Display Services Reference.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Palettes.h*/
void SetEntryColor (
   PaletteHandle dstPalette,
   short dstEntry,
   const RGBColor * srcRGB
);

/*NewPalette

Allocates a new palette from colors in the color table. (Deprecated in Mac OS X v10.4. There is no replacement; 8-bit graphics mode is not supported by the Mac OS X GUI.)

Not recommended.

PaletteHandle NewPalette (
   short entries,
   CTabHandle srcColors,
   short srcUsage,
   short srcTolerance
);
Parameters
entries

The number of ColorInfo structures to be created in the new palette. 
srcColors

A handle to the color table from which the colors are to be obtained. If no color table is provided (srcColors = NULL), then all colors in the palette are set to black (red, green, and blue equal to $0000). 
srcUsage

The usage value to be assigned each ColorInfo structure in the palette.
srcTolerance

The tolerance value to be assigned each ColorInfo structure in the palette.
Return Value

A handle to the new palette. 
Discussion

The NewPalette function fills the palette with as many RGB values from the color table as it has or can fit.

To attach a palette to a window after creating it, use the SetPalette function. To change the entries in a palette after creating it, use the SetEntryColor and SetEntryUsage functions. 
Special Considerations

For applications running in Mac OS X, the Palette Manager is no longer relevant because display devices always support direct color (pixel depth of 16 or 32 bits). The palette-based graphics model only works in 256-color (8-bit pseudocolor) modes of operation, which are not supported for the Mac OS X GUI.

There is some support for palettes in Quartz Services; see Quartz Display Services Reference.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Palettes.h*/
PaletteHandle NewPalette (
   short entries,
   CTabHandle srcColors,
   short srcUsage,
   short srcTolerance
);

/*GetEntryColor

Obtains the color of a palette entry. (Deprecated in Mac OS X v10.4. There is no replacement; 8-bit graphics mode is not supported by the Mac OS X GUI.)

Not recommended.

void GetEntryColor (
   PaletteHandle srcPalette,
   short srcEntry,
   RGBColor * dstRGB
);
Parameters
srcPalette

A handle to the palette to be accessed. 
srcEntry

The palette entry whose color is desired. 
dstRGB

A pointer to an RGB color structure to receive the palette color. 
Discussion

You can modify the entry’s color using the SetEntryColor function. 
Special Considerations

For applications running in Mac OS X, the Palette Manager is no longer relevant because display devices always support direct color (pixel depth of 16 or 32 bits). The palette-based graphics model only works in 256-color (8-bit pseudocolor) modes of operation, which are not supported for the Mac OS X GUI.

There is some support for palettes in Quartz Services; see Quartz Display Services Reference.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Palettes.h*/
void GetEntryColor (
   PaletteHandle srcPalette,
   short srcEntry,
   RGBColor * dstRGB
);

/*PmForeColor

Sets the foreground color field of the current graphics port to a palette color. (Deprecated in Mac OS X v10.4. There is no replacement; 8-bit graphics mode is not supported by the Mac OS X GUI.)

Not recommended.

void PmForeColor (
   short dstEntry
);
Parameters
dstEntry

The palette entry whose color is to be used as the foreground color. 
Discussion

The PmForeColor function sets the current color graphics port’s rgbFgColor field to match the color in the entry specified by the dstEntry parameter of the palette associated with the current window structure. For courteous and tolerant entries, PmForeColor calls the RGBForeColor function using the RGB color of the palette entry. For animated colors, PmForeColor selects the recorded device index previously reserved for animation (if still present) and installs it in the color graphics port. The RGB foreground color field is set to the value from the palette entry. For explicit colors, PmForeColor places the value 

dstEntry modulo (maxIndex +1) 

into the color graphics port, where maxIndex is the largest index available in a device’s color table. When multiple devices with different depths are present, the value of maxIndex varies appropriately for each device. 
Special Considerations

For applications running in Mac OS X, the Palette Manager is no longer relevant because display devices always support direct color (pixel depth of 16 or 32 bits). The palette-based graphics model only works in 256-color (8-bit pseudocolor) modes of operation, which are not supported for the Mac OS X GUI.

There is some support for palettes in Quartz Services; see Quartz Display Services Reference.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Palettes.h*/
void PmForeColor (
   short dstEntry
);

/*NSetPalette

Associates a new palette with a window. (Deprecated in Mac OS X v10.4. There is no replacement; 8-bit graphics mode is not supported by the Mac OS X GUI.)

Not recommended.

void NSetPalette (
   WindowRef dstWindow,
   PaletteHandle srcPalette,
   short nCUpdates
);
Parameters
dstWindow

A pointer to the window to which you want to assign a new palette. 
srcPalette

A handle to the palette you want to assign. 
nCUpdates

An integer value in which you specify whether the window is to receive updates as a result of various changes to the color environment. See “Update Constants” for a description of the update options. 
Discussion

NSetPalette changes the palette associated with the window specified in the dstWindow parameter to the palette specified by srcPalette. NSetPalette also records whether the window is to receive updates as a result of changes to its color environment. The update constants, which you pass to the nCUpdates parameter, determine when the window is updated. 

This function is identical to the SetPalette function except that the nCUpdates parameter is an integer rather than a Boolean value, so that a variety of conditions can trigger an update event.

Use the SetPalette function if you do not need the flexibility that NSetPalette provides for update events. 

Use the GetNewPalette function or the NewPalette function to create a new palette. To dispose of a palette, use the DisposePalette function. 
Special Considerations

For applications running in Mac OS X, the Palette Manager is no longer relevant because display devices always support direct color (pixel depth of 16 or 32 bits). The palette-based graphics model only works in 256-color (8-bit pseudocolor) modes of operation, which are not supported for the Mac OS X GUI.

There is some support for palettes in Quartz Services; see Quartz Display Services Reference.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Palettes.h*/
void NSetPalette (
   WindowRef dstWindow,
   PaletteHandle srcPalette,
   short nCUpdates
);

/*SetDepth

Changes the pixel depth of a video device. (Deprecated in Mac OS X v10.4. There is no replacement; 8-bit graphics mode is not supported by the Mac OS X GUI.)

OSErr SetDepth (
   GDHandle gd,
   short depth,
   short whichFlags,
   short flags
);
Parameters
gd

A handle to the GDevice structure of the video device whose pixel depth you wish to change. 
depth

The mode ID returned by the HasDepth function indicating that the video device supports the desired pixel depth. Alternatively, you can pass the desired pixel depth directly in this parameter, although you should use the HasDepth function to ensure that the device supports this depth. 
whichFlags

The gdDevType constant, which represents a bit in the gdFlags field of the GDevice structure. (If this bit is set to 0 in the GDevice structure, the video device is black and white; if the bit is set to 1, the device supports color.
flags

The value 0 or 1. If you pass 0 in this parameter, the SetDepth function changes the video device to black and white; if you pass 1 in this parameter, SetDepth changes the video device to color.
Return Value

Returns zero if successful, or it returns a nonzero value if it cannot impose the desired depth and display mode on the requested device.
Discussion

The SetDepth function does not change the 'scrn' resource; when the system is restarted, the original depth for this device is restored. 

The Monitors control panel is the user interface for changing the pixel depth, color capabilities, and positions of video devices. Since the user can control the capabilities of the video device, your application should be flexible: although it may have a preferred pixel depth, your application should do its best to accommodate less than ideal conditions.

Use SetDepth only if your application can run on devices of a particular pixel depth and is unable to adapt to any other depth. Your application should display a dialog box that offers the user a choice between changing to that depth or canceling display of the image before your application uses SetDepth. Such a dialog box saves the user the trouble of going to the Monitors control panel before returning to your application. 
Special Considerations

For applications running in Mac OS X, the Palette Manager is no longer relevant because display devices always support direct color (pixel depth of 16 or 32 bits). The palette-based graphics model only works in 256-color (8-bit pseudocolor) modes of operation, which are not supported for the Mac OS X GUI.

There is some support for palettes in Quartz Services; see Quartz Display Services Reference.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Palettes.h*/
OSErr SetDepth (
   GDHandle gd,
   short depth,
   short whichFlags,
   short flags
);

/*GetPalette

Obtains a window’s palette. (Deprecated in Mac OS X v10.4. There is no replacement; 8-bit graphics mode is not supported by the Mac OS X GUI.)

Not recommended.

PaletteHandle GetPalette (
   WindowRef srcWindow
);
Parameters
srcWindow

A pointer to the window for which you want the associated palette. 
Return Value

A handle to the palette associated with the window specified in the srcWindow parameter or NULL if the window has no associated palette or is not a color window. 
Discussion

Normally, the GetPalette function does not allocate memory, with one exception. When your application calls GetPalette to get a copy of the default application palette, the Palette Manager looks at the AppPalette global variable. If AppPalette is NULL, GetPalette makes a copy of the default system palette and returns a handle to this copy.

You request the default palette as follows:

myPaletteHndl = GetPalette ((WindowPtr) -1); 
Special Considerations

For applications running in Mac OS X, the Palette Manager is no longer relevant because display devices always support direct color (pixel depth of 16 or 32 bits). The palette-based graphics model only works in 256-color (8-bit pseudocolor) modes of operation, which are not supported for the Mac OS X GUI.

There is some support for palettes in Quartz Services; see Quartz Display Services Reference.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Palettes.h*/
PaletteHandle GetPalette (
   WindowRef srcWindow
);

/*HasDepth

Determines whether a video device supports a specific pixel depth. (Deprecated in Mac OS X v10.4. There is no replacement; 8-bit graphics mode is not supported by the Mac OS X GUI.)

short HasDepth (
   GDHandle gd,
   short depth,
   short whichFlags,
   short flags
);
Parameters
gd

A handle to the GDevice structure of the video device. 
depth

The pixel depth for which you’re testing. 
whichFlags

The gdDevType constant, which represents a bit in the gdFlags field of the GDevice structure. If this bit is set to 0 in the GDevice structure, the video device is black and white; if the bit is set to 1, the device supports color.
flags

The value 0 or 1. If you pass 0 in this parameter, the HasDepth function tests whether the video device is black and white. If you pass 1 in this parameter, HasDepth tests whether the video device supports color.
Return Value

Returns 0 if the device does not support the depth you specify in the depth parameter or the display mode you specify in the flags parameter. Any other value indicates that the device supports the specified depth and display mode. The function result contains the mode ID that QuickDraw passes to the video driver to set its pixel depth and to specify color or black and white. You can pass this mode ID in the depth parameter for the SetDepth function to set the graphics device to the pixel depth and display mode for which you tested.
Special Considerations

For applications running in Mac OS X, the Palette Manager is no longer relevant because display devices always support direct color (pixel depth of 16 or 32 bits). The palette-based graphics model only works in 256-color (8-bit pseudocolor) modes of operation, which are not supported for the Mac OS X GUI.

There is some support for palettes in Quartz Services; see Quartz Display Services Reference.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Palettes.h*/

short HasDepth (
   GDHandle gd,
   short depth,
   short whichFlags,
   short flags
);

#ifdef __cplusplus
}
#endif
#endif