#ifndef ATSUNICODEFLATTENING_H
#define ATSUNICODEFLATTENING_H

#ifndef  ATSUNICODETYPES_H
#include <QD/ATSUnicodeTypes.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Flattened Data Version Numbers

Specify versions of the 'ustl' specification.

enum {
   kATSFlatDataUstlVersion0      = 0,
   kATSFlatDataUstlVersion1      = 1,
   kATSFlatDataUstlVersion2      = 2,
   kATSFlatDataUstlCurrentVersion = kATSFlatDataUstlVersion2};
Constants
kATSFlatDataUstlVersion0

Specifies version 0. This version is obsolete.

Available in Mac OS X v10.2 and later.
kATSFlatDataUstlVersion1

Specifies version 1. This version is obsolete.

Available in Mac OS X v10.2 and later.
kATSFlatDataUstlVersion2

Specifies version 2.

Available in Mac OS X v10.2 and later.
kATSFlatDataUstlCurrentVersion

Specifies the current version.

Available in Mac OS X v10.2 and later.
Discussion

The ATSUI functions ATSUFlattenStyleRunsToStream and ATSUUnflattenStyleRunsFromStream operate on data that conform to version 2 of the 'ustl' specification*/
enum {
   kATSFlatDataUstlVersion0      = 0,
   kATSFlatDataUstlVersion1      = 1,
   kATSFlatDataUstlVersion2      = 2,
   kATSFlatDataUstlCurrentVersion = kATSFlatDataUstlVersion2
};

/*ATSUFontVariationAxis

Represents a stylistic attribute and the range of values that the font can use to express this attribute.

typedef FourCharCode ATSUFontVariationAxis;
Discussion

Font variations allow your application to produce a range of type styles algorithmically. You can obtain a a variation axis and its maximum, minimum, and default values for a font by calling the function ATSUGetIndFontVariation. For a complete discussion of font variations, see Inside Mac OS X: Rendering Unicode Text With ATSUI.
Availability
Available in Mac OS X v10.0 and later.*/
typedef FourCharCode ATSUFontVariationAxis;

/*Unflattened Style Run Data Options

Specify options to use when unflattening ATSUI style run data.

typedef UInt32 ATSUUnflattenStyleRunOptions;
enum {
   kATSUUnflattenOptionNoOptionsMask = 0x00000000
};
Constants
kATSUUnflattenOptionNoOptionsMask

Specifies that no options are to be used.
Discussion

Additional options may be added in the future.*/
typedef UInt32 ATSUUnflattenStyleRunOptions;
#define kATSUUnFlattenOptionNoOptionsMask kATSUUnflattenOptionNoOptionsMask
enum {
   kATSUUnflattenOptionNoOptionsMask = 0x00000000
};


/*Flattened Style Run Data Options

Specify options to use when flattening ATSUI style run data.

typedef UInt32 ATSUFlattenStyleRunOptions;
enum {
   kATSUFlattenOptionNoOptionsMask = 0x00000000
};
Constants
kATSUFlattenOptionNoOptionsMask

Specifies that no options are to be used.

Available in Mac OS X v10.2 and later.
Discussion

Additional options may be added in the future.*/
typedef UInt32 ATSUFlattenStyleRunOptions;
enum {
   kATSUFlattenOptionNoOptionsMask = 0x00000000
};


/*Flattened Data Format Selectors

Specify the format to use when flattening or unflattening data.

typedef UInt32 ATSUFlattenedDataStreamFormat;
enum {
   kATSUDataStreamUnicodeStyledText = 'ustl'
};
Constants
kATSUDataStreamUnicodeStyledText

Specifies to use the 'ustl' data specification when flattening or unflattening data.

Available in Mac OS X v10.2 and later.*/
typedef UInt32 ATSUFlattenedDataStreamFormat;
enum {
   kATSUDataStreamUnicodeStyledText = 'ustl'
};


/*ATSUStyleRunInfo

Contains information for a style run. 

struct ATSUStyleRunInfo {
   UniCharCount        runLength;
   ItemCount           styleObjectIndex;
};
typedef struct ATSUStyleRunInfo         ATSUStyleRunInfo;
Fields
runLength

The length of the style run.
styleObjectIndex

An index into an array of unique style objects.
Discussion

This structure is used by the function ATSUUnflattenStyleRunsFromStream to return style run information.
Availability
Available in Mac OS X v10.2 and later.*/
struct ATSUStyleRunInfo {
   UniCharCount        runLength;
   ItemCount           styleObjectIndex;
};
typedef struct ATSUStyleRunInfo         ATSUStyleRunInfo;

/*ATSFlatDataStyleRunDataHeader

Contains the number of style runs and style run information for the style run data block.

struct ATSFlatDataStyleRunDataHeader {
   ItemCount           numberOfStyleRuns;
   ATSUStyleRunInfo    styleRunArray[1];
};
typedef struct ATSFlatDataStyleRunDataHeader ATSFlatDataStyleRunDataHeader;
Fields
numberOfStyleRuns

The number of style run data structures stored in this block.
styleRunArray[1]

The first entry in a array of ATSUStyleRunInfo structures. There should be numberOfStyleRuns entries in this array. 
Discussion

The ATSFlatDataStyleRunDataHeader structure precedes style run data structures. The offsetToStyleRuns field in the ATSFlatDataMainHeaderBlock specifies the offset to the structure ATSFlatDataStyleRunDataHeader.*/

struct ATSFlatDataStyleRunDataHeader {
   ItemCount           numberOfStyleRuns;
   ATSUStyleRunInfo    styleRunArray[1];
};
typedef struct ATSFlatDataStyleRunDataHeader ATSFlatDataStyleRunDataHeader;

/*ATSFlatDataMainHeaderBlock

Contains the 'ustl' data structure version and size and provides offsets to the text layout, style run, and style list data blocks.

struct ATSFlatDataMainHeaderBlock {
   UInt32              version;
   ByteCount           sizeOfDataBlock;
   ByteCount           offsetToTextLayouts;
   ByteCount           offsetToStyleRuns;
   ByteCount           offsetToStyleList;
};
typedef struct ATSFlatDataMainHeaderBlock ATSFlatDataMainHeaderBlock;
Fields
version

The version number of the 'ustl' data structure. You must make sure this number is the first item in the data block, otherwise the data may not be readable by code written to parse earlier versions of 'ustl' data. 
sizeOfDataBlock

The total size of the data in bytes, including the four bytes needed for the version number.
offsetToTextlayouts

The offset from the beginning of the data block to the flattened text layout data. You can set this value to 0 if there is no text layout data. This value specifies the offset to the ATSFlatDataTextLayoutDataHeader structure.
offsetToStyleRuns

The offset from the beginning of the data to the flattened style run data. You can set this value to 0 if there is no flattened style run data. This value specifies the offset to the ATSFlatDataStyleRunDataHeader structure.
offsetToStyleList

The offset to the flattened style list data. You can set this value to 0 if there is no flattened style list data. This value specifies the offset to the ATSFlatDataStyleListHeader structure.
Discussion

The structure ATSFlatDataMainHeaderBlock is Block 1 of the 'ustl' data structure. This structure contains information about the rest of the 'ustl' data structure and provides offsets to each of the other three data blocks. Figure 1 illustrates the main header structure.*/
struct ATSFlatDataMainHeaderBlock {
   UInt32              version;
   ByteCount           sizeOfDataBlock;
   ByteCount           offsetToTextLayouts;
   ByteCount           offsetToStyleRuns;
   ByteCount           offsetToStyleList;
};
typedef struct ATSFlatDataMainHeaderBlock ATSFlatDataMainHeaderBlock;

/*ATSFlatDataStyleListStyleDataHeader

Contains size information and the number of attributes, features, and variations for the style list data block.

struct ATSFlatDataStyleListStyleDataHeader {
   ByteCount           sizeOfStyleInfo;
   ItemCount           numberOfSetAttributes;
   ItemCount           numberOfSetFeatures;
   ItemCount           numberOfSetVariations;
};
typedef struct ATSFlatDataStyleListStyleDataHeader ATSFlatDataStyleListStyleDataHeader;
Fields
sizeOfStyleInfo

The size of the flattened style object. This value should include the four bytes for this field (sizeOfStyleInfo) and any padding bytes you add to end of the structure to maintain the required 4-byte alignment. 
numberOfSetAttributes

The number of attributes in the flattened style object. You should have at least one attribute for the font data, although you can set this value to 0 if you do not want to specify font data.
numberOfSetFeatures

The number of font features in the flattened style object. You can set this value to 0 if there are no font features in the style object.
numberOfSetVariations

The number of font variations in the flattened style object. You can set this value to 0 if there are no font variations in the style object.
Discussion

The ATSFlatDataStyleListStyleDataHeader structure forms the beginning of an individually flattened ATSUStyle object. This structure precedes the following data: 
If the value numberOfSetAttributes is non-zero, there must be an array of ATSUAttributeInfo structures immediately following the ATSFlatDataStyleListStyleDataHeader structure to store the style attributes. This is a variable-size array. The number of ATSUAttributeInfo structures must be equal to the value numberOfSetAttributes, one structure for each attribute. 

If the value numberOfSetAttributes is zero, you do not need an array of ATSUAttributeInfo structures.
If the value numberOfSetFeatures is non-zero, there must be an array of ATSFlatDataStyleListFeatureData structures. These structures must appear immediately following the ATSUAttributeInfo array above (if there is such an array). The number of ATSFlatDataStyleListFeatureData structures must be equal to the value numberOfSetFeatures, one structure for each feature. 

If the value numberOfSetFeatures is zero, you do not need an array of ATSFlatDataStyleListFeatureData structures.
If the value numberOfSetVariations is non-zero, there must be an array of ATSFlatDataStyleListVariationData structures immediately following the ATSFlatDataStyleListFeatureData array (if there is such an array). The number of ATSFlatDataStyleListVariationData structures must be equal to the value numberOfSetVariations, one structure for each variation. 

This is a Block 4 structure. Block 4 structures store flattened ATSUStyle objects and are currently used by the ATSUI style run flattening and parsing functions, ATSUFlattenStyleRunsToStream and ATSUUnflattenStyleRunsFromStream.
Availability
Available in Mac OS X v10.2 and later.*/
struct ATSFlatDataStyleListStyleDataHeader {
   ByteCount           sizeOfStyleInfo;
   ItemCount           numberOfSetAttributes;
   ItemCount           numberOfSetFeatures;
   ItemCount           numberOfSetVariations;
};
typedef struct ATSFlatDataStyleListStyleDataHeader ATSFlatDataStyleListStyleDataHeader;

/*ATSFlatDataStyleListHeader

Contains the number of styles and the first item in the style list style data header.

struct ATSFlatDataStyleListHeader {
   ItemCount           numberOfStyles;
   ATSFlatDataStyleListStyleDataHeader  styleDataArray[1];
};
typedef struct ATSFlatDataStyleListHeader ATSFlatDataStyleListHeader;
Fields
numberOfStyles

The number of flattened style objects in this block.
styleDataArray[1]

The first item in an array of ATSFlatDataStyleListStyleDataHeader structures. There should be numberOfStyles entries in this array. Note that the data stored in these structures can be of variable sizes.
Discussion

The ATSFlatDataStyleListHeader structure is the main header for Block 4. The offsetToStyleList field in the ATSFlatDataMainHeaderBlock specifies the offset to the structure ATSFlatDataStyleListHeader.*/
struct ATSFlatDataStyleListHeader {
   ItemCount           numberOfStyles;
   ATSFlatDataStyleListStyleDataHeader  styleDataArray[1];
};
typedef struct ATSFlatDataStyleListHeader ATSFlatDataStyleListHeader;

//function

/*ATSUFlattenStyleRunsToStream

Flattens ATSUI style-run data so that it can be saved to disk or passed (through the pasteboard) to another application. 

extern OSStatus ATSUFlattenStyleRunsToStream(
   ATSUFlattenedDataStreamFormat   iStreamFormat,
   ATSUFlattenStyleRunOptions      iFlattenOptions,
   ItemCount                       iNumberOfRunInfo,
   const ATSUStyleRunInfo          iRunInfoArray[],
   ItemCount                       iNumberOfStyleObjects,
   const ATSUStyle                 iStyleArray[],
   ByteCount                       iStreamBufferSize,
   void *                          oStreamBuffer,
   ByteCount *                     oActualStreamBufferSize
)
Parameters
iStreamFormat

The format of the flattened data. There is only one format supported at this time, 'ustl' so you must pass the constant kATSUDataStreamUnicodeStyledText.
iFlattenOptions

The options you want to use to flatten the data. There are no options supported at this time, so you must pass the constant kATSUFlattenOptionsNoOptionsMask.
iNumberOfRunInfo

The number of style run information structures passed in the iRunInfoArray parameter. If you pass 0, ATSUI assumes there is only one style for the entire text block passed in the oStreamBuffer parameter. The flattened data format passed to the iStreamFormat parameter must support the use of one style.
iRunInfoArray[]

An array of ATSUStyleRunInfo structures that describes the style runs to be flattened. This array must contain iNumberOfRunInfo entries. An ATSUStyleRunInfo structure contains an index into an array of unique ATSUI style objects (ATSUStyle) and the length of the run to which the style object applies. Each index in the ATSUStyleRunInfo structure must reference a valid ATSUStyle object passed in the iStyleArray parameter. You can pass NULL, only if iNumberOfRunInfo is set to zero.
iNumberOfStyleObjects

The number of ATSUStyle objects in the array passed to the iStyleArray parameter. You must pass a value that is greater than 0.
iStyleArray[]

An array of ATSUStyle objects to be flattened. You cannot pass NULL.
iStreamBufferSize

The size of the stream buffer, pointed to by the oStreamBuffer parameter. You can pass 0 only if the iStreamBufferSize parameter is set to NULL. If you are uncertain of the size of the array, see the Discussion.
oStreamBuffer

On input, a pointer to the data you want to flatten. On return, points to the flattened data. If you pass NULL for this parameter, no data is flattened. Instead, the size of the buffer is calculated by ATSUI and returned in oActualStreamSize parameter. See the Discussion for more details. You are responsible for allocating the text buffer passed in the oStreamBuffer parameter.
oActualStreamBufferSize

On return, the size of the data written to the oStreamBuffer parameter. You can pass NULL only if the oStreamBuffer parameter is not NULL.
Return Value

A result code. See “ATSUI Result Codes”. This function can also return paramErr if you pass invalid values for any of the parameters.
Discussion

The function ATSUFlattenStyleRunsToStream takes an array of ATSUStyle objects and style run information and flattens the data to the specified format. The style runs must all reference the same block of Unicode text (usually passed separately as text in the 'utxt' format). The style runs must also be in ascending order relative to the text in the text block.

Typically you use the function ATSUFlattenStyleRunsFromStream by calling it twice, as follows:
Provide appropriate values for the iStreamFormat, iFlattenOptions, iNumberOfRunInfo, iRunInfoArray, iNumberOfStyleObjects, and iStyleArray parameters. Set iStreamBufferSize to 0, oStreamBuffer to NULL, and pass a valid reference to a ByteCount variable in the oActualStreamBufferSize parameter. Call the function ATSUFlattenStyleRunsToStream. On return, oActualStreamBufferSize points to the size needed for the buffer.
Allocate an appropriately-sized buffer for the oStreamBuffer parameter and then call the function ATSUFlattenStyleRunsToStream a second time.
Availability
Available in Mac OS X v10.2 and later.
Declared In
ATSUnicodeFlattening.h*/
extern OSStatus ATSUFlattenStyleRunsToStream(
   ATSUFlattenedDataStreamFormat   iStreamFormat,
   ATSUFlattenStyleRunOptions      iFlattenOptions,
   ItemCount                       iNumberOfRunInfo,
   const ATSUStyleRunInfo          iRunInfoArray[],
   ItemCount                       iNumberOfStyleObjects,
   const ATSUStyle                 iStyleArray[],
   ByteCount                       iStreamBufferSize,
   void *                          oStreamBuffer,
   ByteCount *                     oActualStreamBufferSize
);

/*ATSUUnflattenStyleRunsFromStream

Unflattens previously-flattened ATSUI style run data so that it can be read from disk or accepted (through the pasteboard) from another application.

extern OSStatus ATSUUnflattenStyleRunsFromStream(
   ATSUFlattenedDataStreamFormat   iStreamFormat,
   ATSUUnflattenStyleRunOptions    iUnflattenOptions,
   ByteCount                       iStreamBufferSize,
   const void *                    iStreamBuffer,
   ItemCount                       iNumberOfRunInfo,
   ItemCount                       iNumberOfStyleObjects,
   ATSUStyleRunInfo                oRunInfoArray[],
   ATSUStyle                       oStyleArray[],
   ItemCount *                     oActualNumberOfRunInfo,
   ItemCount *                     oActualNumberOfStyleObjects
);
Parameters
iStreamFormat

The format of the flattened data. There is only one format supported at this time ('ustl') so you must pass the constant kATSUDataStreamUnicodeStyledText.
iUnflattenOptions

The options you want to use to unflatten the data. There are no options supported at this time, so you must pass the constant kATSUUnflattenOptionsNoOptionsMask.
iStreamBufferSize

The size of the buffer pointed to by the iStreamBuffer parameter. You must pass a value greater than 0.
iStreamBuffer

A pointer to the buffer that contains the flattened data. The data must be of the format specified by the iStreamFormat parameter and must be of size specified by the iStreamBufferSize parameter. You cannot pass NULL.
iNumberOfRunInfo

The number of style run information structures passed in the iRunInfoArray parameter. If you are uncertain of the number of style run information structures, see the Discussion.
iNumberOfStyleObjects

The number of ATSUStyle objects in the array passed into the iStyleArray parameter. If you are uncertain of the number of ATSUStyle objects, see the Discussion.
oRunInfoArray[]

On return, points to an array of style run information structures. Each structure contains a style run length and index into the oStyleArray array. If you are uncertain of how much memory to allocate for this array, see the Discussion. You are responsible for disposing of the array when you no longer need it.
oStyleArray[]

On return, a pointer to an array of the unique ATSUI style objects (ATSUStyle) obtained from the flattened data. The indices returned in the array oRunInfoArray are indices into this array. If you are uncertain of how much memory to allocate for this array, see the Discussion. You are responsible for disposing of the array and the ATSUI style objects in the array when you no longer need the array.
oActualNumberOfRunInfo

On return, points to the actual number of ATSUStyleRunInfo structures obtained from the flattened data. The actual number of structures is the number of entries added to the array oRunInfoArray. You can pass NULL if you to not want to obtain this value.
oActualNumberOfStyleObjects

On return, points to the actual number of unique ATSUI style objects (ATSUStyle) obtained from the flattened data. The actual number is the number of entries added to the oStyleArray array. You can pass NULL if you do no want to obtain this value.
Return Value

A result code. See “ATSUI Result Codes”. This function can also return paramErr if you pass invalid values for any of the parameters.
Discussion

The function ATSUUnflattenStyleRunsFromStream extracts the ATSUI style run information from previously-flattened data. The style objects and style run information structures are returned in two separate arrays—the array oStyleArray and the array oRunInfoArray. These arrays are not parallel. Each ATSUStyle object in the oStyleArray is a unique ATSUStyle object. To figure out which ATSUStyle object belongs to which text run, the caller must parse the array of ATSUStyleRunInfo structures. These structures contain the style run lengths and an index into the oStyleArray. 

Typically you use the function ATSUUnflattenStyleRunsFromStream by calling it twice, as follows:
Provide appropriate values for the iStreamFormat, iUnflattenOptions, and iStreamBuffer parameters. Pass 0 for the iNumberOfRunInfo and iNumberOfStyleObjects parameters, NULL for the oRunInfoArray and oStyleArray, parameters and valid ItemCount references for the oActualNumberOfRunInfo and oActualNumberOfStyleObjects parameters. On return, oActualNumberOfRunInfo and oActualNumberOfStyleObjects point to the sizes needed to allocate these arrays.
Allocate appropriately-sized arrays of ATSUStyleRunInfo data structures and ATSUStyle objects. Call the function ATSUUnflattenStyleRunsFromStream a second time, passing the newly allocated arrays in the oRunInfoArray and oStyleArray parameters, with the iNumberOfRunInfo and iNumberOfStyleObjects parameters set to the values you obtained from the first call.
Availability
Available in Mac OS X v10.2 and later.
Declared In
ATSUnicodeFlattening.h*/
extern OSStatus ATSUUnflattenStyleRunsFromStream(
   ATSUFlattenedDataStreamFormat   iStreamFormat,
   ATSUUnflattenStyleRunOptions    iUnflattenOptions,
   ByteCount                       iStreamBufferSize,
   const void *                    iStreamBuffer,
   ItemCount                       iNumberOfRunInfo,
   ItemCount                       iNumberOfStyleObjects,
   ATSUStyleRunInfo                oRunInfoArray[],
   ATSUStyle                       oStyleArray[],
   ItemCount *                     oActualNumberOfRunInfo,
   ItemCount *                     oActualNumberOfStyleObjects
);

#ifdef __cplusplus
}
#endif

#endif