#ifndef PMAPPLICATION_H
#define PMAPPLICATION_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef DIALOGS_H
#include <HIToolbox/Dialogs.h>
#endif


//#include <PrintCore/PrintCore.h>//hys

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*PMSheetDoneProcPtr

Defines a pointer to a sheet-done function that the Carbon Printing Manager calls when the user dismisses a printing dialog presented as a sheet.

typedef void (*PMSheetDoneProcPtr) (
   PMPrintSession printSession,
   WindowRef documentWindow,
   Boolean accepted
);

You would declare your sheet-done function like this if you were to name it MyPrintSheetDoneCallback:

void MyPrintSheetDoneCallback (
   PMPrintSession printSession,
   WindowRef documentWindow,
   Boolean accepted
);
Parameters
printSession

The printing session object for the dialog.
documentWindow

The document window to which the sheet is attached.
accepted

A Boolean value indicating whether the user accepted (true) or cancelled (false) the dialog.
Discussion

You pass a universal procedure pointer to your sheet-done function as a parameter to the function PMSessionUseSheets. The Carbon Printing Manager calls your sheet-done function when the user dismisses the printing dialog. Your sheet-done function should check to see if the dialog is accepted and, depending on whether the Page Setup or Print dialog is being shown, take appropriate action.

To provide a pointer to your sheet-done function, you create a universal procedure pointer (UPP) of type PMSheetDoneUPP, using the function NewPMSheetDoneUPP. You can do so with code similar to the following:PMSheetDoneUPP gMyPrintSheetDoneUPP;
gMyPrintSheetDoneUPP = NewPMSheetDoneUPP (&MyPrintSheetDoneProc);


You should declare your universal procedure pointer as a global variable to allow for multiple windows, each with a dialog available at one time.

When your print job is completed, you should use the function DisposePMSheetDoneUPP function to dispose of the universal procedure pointer associated with your sheet-done function. However, if you plan to use the same sheet-done function in subsequent print jobs, you can reuse the same UPP, rather than dispose of it and later create a new UPP.

The sheet-done function does not have a parameter for application-supplied data. Instead, you can attach any data your application needs to the window as a property using the Window Manager function SetWindowProperty and retrieve the data using the function GetWindowProperty.*/


typedef void (*PMSheetDoneProcPtr) (
   PMPrintSession printSession,
   WindowRef documentWindow,
   Boolean accepted
);


/*PMSheetDoneUPP

A type that defines a universal procedure pointer to a sheet-done callback function.

typedef PMSheetDoneProcPtr PMSheetDoneUPP;
Discussion

For more information, see the description of the PMSheetDoneProcPtr callback function.*/
typedef PMSheetDoneProcPtr PMSheetDoneUPP;



//function


/*PMSessionPageSetupDialog

Displays the Page Setup dialog and records the user’s selections in a page format object.

OSStatus PMSessionPageSetupDialog (
   PMPrintSession printSession,
   PMPageFormat pageFormat,
   Boolean *accepted
);
Parameters
printSession

The printing session for which you want to display the dialog.
pageFormat

The page format object in which the user’s selections are recorded.
accepted

A pointer to your Boolean variable. On return, true if the user clicks the OK button, or false if the user clicks Cancel. If you are using a sheet dialog, you should ignore the value returned in this parameter.
Return Value

A result code. See “Carbon Printing Manager Result Codes”.
Discussion

You must call this function between the creation and release of a printing session. See the function PMCreateSession. Before you call the function PMSessionPageSetupDialog you should call the function PMSessionValidatePageFormat to make sure page format settings are updated and valid. You should call the function PMSessionPageSetupDialog outside the scope of your print loop.

The Page Setup dialog shows the current settings contained in the page format object. If the user changes these settings and clicks the OK button, the page format object is updated by the printing system with the user’s selections. If the user clicks the Cancel button, the page format object is returned unchanged.
Availability
Available in Mac OS X v10.0 and later.
Declared In
PMApplication.h */
OSStatus PMSessionPageSetupDialog (
   PMPrintSession printSession,
   PMPageFormat pageFormat,
   Boolean *accepted
);

/*PMSessionPrintDialog

Displays the Print dialog and records the user’s selections in a print settings object.

OSStatus PMSessionPrintDialog (
   PMPrintSession printSession,
   PMPrintSettings printSettings,
   PMPageFormat constPageFormat,
   Boolean *accepted
);
Parameters
printSession

The printing session for which you want to display the dialog.
printSettings

The print settings object in which the user’s selections are recorded.
constPageFormat

The page format for the specified printing session.
accepted

A pointer to your Boolean variable. On return, true if the user clicks the Print button, or false if the user clicks Cancel. If you are using a sheet dialog, you should ignore the value of this parameter.
Return Value

A result code. See “Carbon Printing Manager Result Codes”.
Discussion

You must call this function between the creation and release of a printing session. See the function PMCreateSession. Before you call the function PMSessionPrintDialog you should call the function PMSessionValidatePrintSettings to make sure print settings are updated and valid. You should call the function PMSessionPrintDialog outside the scope of your print loop.

The Print dialog shows the current settings in the print settings object. If the user changes these settings and clicks the Print or Preview buttons, the print settings object is updated by the printing system with the user’s selections. If the user clicks the Cancel button, the print settings object is returned unchanged.
Availability
Available in Mac OS X v10.0 and later.
Declared In
PMApplication.h*/
OSStatus PMSessionPrintDialog (
   PMPrintSession printSession,
   PMPrintSettings printSettings,
   PMPageFormat constPageFormat,
   Boolean *accepted
);

/*PMSessionBeginDocument

Begins a print job that, by default, draws into a QuickDraw graphics port.

OSStatus PMSessionBeginDocument (
   PMPrintSession printSession,
   PMPrintSettings printSettings,
   PMPageFormat pageFormat
);
Parameters
printSession

The printing session that provides a context for the new print job.
printSettings

The print settings to use for the new print job.
pageFormat

The page format to use for the new print job.
Return Value

A result code. See “Carbon Printing Manager Result Codes”.
Discussion

The function PMSessionBeginDocument starts a print job and should be called within your application’s print loop. This function is similar to the function PMSessionBeginDocumentNoDialog except that the printing status dialog is displayed.

You must call this function between the creation and release of a printing session. See the function PMCreateSession. If you present a printing dialog before you call PMSessionBeginDocument, you should use the same PMPrintSession object you used to present the dialog.

Before you call PMSessionBeginDocument, you should call PMSessionValidatePrintSettings and PMSessionValidatePageFormat to make sure the specified print settings and page format objects are updated and valid. After you call PMSessionBeginDocument, if you call a function that changes the specified print settings or page format object, the change is ignored for the current print job.

This function must be called before its corresponding End function (PMSessionEndDocument). If the function PMSessionBeginDocument function returns noErr, you must later call the End function, even if errors occur within the scope of the Begin and End functions.

The printing system automatically handles printing multiple copies. Your application does not need to perform any tasks other than specifying the number of copies in the printing session.
Special Considerations

In Mac OS X v10.4 and later, Apple recommends using the function PMSessionBeginCGDocument instead of this function. QuickDraw is deprecated and your application should be using Quartz 2D for its rendering.
Availability
Available in Mac OS X v10.0 and later.
Declared In
PMApplication.h*/
OSStatus PMSessionBeginDocument (
   PMPrintSession printSession,
   PMPrintSettings printSettings,
   PMPageFormat pageFormat
);

/*PMSessionBeginPage

Starts a new page for printing in the specified printing session.

OSStatus PMSessionBeginPage (
   PMPrintSession printSession,
   PMPageFormat pageFormat,
   const PMRect *pageFrame
);
Parameters
printSession

The printing session that provides a context for the print job.
pageFormat

The page format you are using for the print job.
pageFrame

You should pass NULL, as this parameter is currently unsupported.
Return Value

A result code. See “Carbon Printing Manager Result Codes”. Returns kPMCancel if the user cancels the print job.
Discussion

You must call this function between the creation and release of a printing session. See the function PMCreateSession. You must call the functions PMSessionBeginPage and PMSessionEndPage within the scope of calls to the Begin print job function (PMSessionBeginCGDocument or PMSessionBeginDocument) and the End print job function (PMSessionEndDocument).

You should call the function PMSessionError immediately before you call PMSessionBeginPage. If PMSessionError returns an error, then you should not call the function PMSessionBeginPage. Because PMSessionBeginPage also initializes the printing graphics context, your application should not make assumptions about the state of the context (for example, the current font) between successive pages. After each call to PMSessionBeginPage, your application should call PMSessionGetCGGraphicsContext or PMSessionGetGraphicsContext to obtain the current printing context. If that context is a QuickDraw context, set the drawing port to this context by calling the QuickDraw SetPort function.

If the function PMSessionBeginPage returns noErr, you must later call the function PMSessionEndPage, even if errors occur within the scope of PMSessionBeginPage and PMSessionEndPage.

The printing system automatically handles printing multiple copies. Your application does not need to perform any tasks other than specifying the number of copies in the printing session.
Availability
Available in Mac OS X v10.0 and later.
Declared In
PMApplication.h*/
OSStatus PMSessionBeginPage (
   PMPrintSession printSession,
   PMPageFormat pageFormat,
   const PMRect *pageFrame
);

/*PMSessionEndPage

Indicates the end of drawing the current page for the specified printing session.

OSStatus PMSessionEndPage (
   PMPrintSession printSession
);
Parameters
printSession

The printing session that provides a context for the print job.
Return Value

A result code. See “Carbon Printing Manager Result Codes”.
Discussion

You must call this function between the creation and release of a printing session. See the function PMCreateSession. You must call the functions PMSessionBeginPage and PMSessionEndPage within the scope of calls to the Begin print job function (PMSessionBeginCGDocument or PMSessionBeginDocument) and the End print job function (PMSessionEndDocument).

If the function PMSessionBeginPage returns noErr, you must later call the function PMSessionEndPage, even if errors occur within the scope of PMSessionBeginPage and PMSessionEndPage. You should not call PMSessionEndPage if PMSessionBeginPage returns an error.
Availability
Available in Mac OS X v10.0 and later.
Declared In
PMApplication.h*/
OSStatus PMSessionEndPage (
   PMPrintSession printSession
);

/*PMSessionUseSheets

Specifies that a printing dialog should be displayed as a sheet and specifies a function to call when the user dismisses the printing dialog.

OSStatus PMSessionUseSheets (
   PMPrintSession printSession,
   WindowRef documentWindow,
   PMSheetDoneUPP sheetDoneProc
);
Parameters
printSession

The printing session in which the sheet dialog is presented.
documentWindow

The window to which the sheet dialog should be attached.
sheetDoneProc

A universal procedure pointer to your sheet-done function. The printing system calls this function when the user dismisses the dialog. Your sheet-done function is defined by the callback type PMSheetDoneProcPtr.
Return Value

A result code. See “Carbon Printing Manager Result Codes”.
Discussion

You must call this function between the creation and release of a printing session. See the function PMCreateSession.

When a printing dialog is displayed as a sheet, calls to the functions PMSessionPageSetupDialog and PMSessionPrintDialog return control immediately to your application, with the value of the accepted parameter undefined. The printing dialog sheet continues to be displayed until the user dismisses the dialog, at which time the printing system calls your sheet-done function. The page format and print settings objects associated with the dialog should not be used or changed until the sheet-done function is called.

Calling PMSessionUseSheets for a custom dialog created using the AppendDITL method has no effect; these types of custom dialogs cannot be displayed as sheets. You must create a printing dialog extension to display custom elements in a sheet. See the document Extending Printing Dialogs for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
PMApplication.h*/

OSStatus PMSessionUseSheets (
   PMPrintSession printSession,
   WindowRef documentWindow,
   PMSheetDoneUPP sheetDoneProc
);

/*NewPMSheetDoneUPP

Creates a new universal procedure pointer (UPP) to a sheet-done callback.

PMSheetDoneUPP NewPMSheetDoneUPP (
   PMSheetDoneProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your sheet-done callback.
Return Value

On return, a UPP to the sheet-done callback. 
Discussion

See the callback PMSheetDoneProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
PMApplication.h*/

PMSheetDoneUPP NewPMSheetDoneUPP (
   PMSheetDoneProcPtr userRoutine
);


/*PMSessionEndDocument

Ends a print job started by calling the function PMSessionBeginCGDocument or PMSessionBeginDocument.

OSStatus PMSessionEndDocument (
   PMPrintSession printSession
);
Parameters
printSession

The current printing session. On return, the printing session is no longer valid; however, you must still call the function PMRelease to release the object.
Return Value

A result code. See “Carbon Printing Manager Result Codes”.
Discussion

You must call this function between the creation and release of a printing session. See the function PMCreateSession. The function PMSessionEndDocument is used to end a print job, and it should be called within your application’s print loop after the call to PMSessionEndPage and before releasing the printing session.

This function must be called after its corresponding Begin function (PMSessionBeginCGDocument or PMSessionBeginDocument). If the Begin function returns noErr, the function PMSessionEndDocument must be called, even if errors occur within the scope of the Begin and End functions. You should not call PMSessionEndDocument if the Begin function returns an error.
Availability
Available in Mac OS X v10.0 and later.
Declared In
PMApplication.h*/
OSStatus PMSessionEndDocument (
   PMPrintSession printSession
);

/*PMBeginDocument

Establishes a graphics context for imaging a document. This context is an opaque grafPort. (Deprecated in Mac OS X v10.4. Use PMSessionBeginCGDocument or PMSessionBeginDocument instead.)

OSStatus PMBeginDocument (
   PMPrintSettings printSettings,
   PMPageFormat pageFormat,
   PMPrintContext *printContext
);
Parameters
printSettings

A PMPrintSettings object. 
pageFormat

A PMPageFormat object. 
printContext

On return, an initialized PMPrintContext object. 
Return Value

A result code. See “Carbon Printing Manager Result Codes”.
Discussion

Valid within a PMBegin/PMEnd block. You must balance a call to PMBeginDocument with a call to PMEndDocument. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
PMApplication.h*/

OSStatus PMBeginDocument (
   PMPrintSettings printSettings,
   PMPageFormat pageFormat,
   PMPrintContext *printContext
);

/*PMBeginPage

Initializes a scaling rectangle for printing a page. (Deprecated in Mac OS X v10.4. Use PMSessionBeginPage instead.)

OSStatus PMBeginPage (
   PMPrintContext printContext,
   const PMRect *pageFrame
);
Parameters
printContext

A PMPrintContext object. 
pageFrame

A pointer to a bounding rectangle for drawing the page. This value is usually obtained from the function PMGetAdjustedRect, but if no scaling is needed, pass NULL. In Mac OS X, this parameter is ignored.
Return Value

A result code. See “Carbon Printing Manager Result Codes”.
Discussion

Valid after calling PMBegin and PMBeginDocument.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
PMApplication.h*/

OSStatus PMBeginPage (
   PMPrintContext printContext,
   const PMRect *pageFrame
);

/*PMPageSetupDialog

Displays the Page Setup dialog and records the user’s selections in a PMPageFormat object. (Deprecated in Mac OS X v10.4. Use PMSessionPageSetupDialog instead.)

OSStatus PMPageSetupDialog (
   PMPageFormat pageFormat,
   Boolean *accepted
);
Parameters
pageFormat

A PMPageFormat object.
accepted

Returns true if the user clicks the OK button, or false if the user clicks Cancel. 
Return Value

A result code. See “Carbon Printing Manager Result Codes”.
Discussion

Valid after calling PMBegin and creating a page format object. Never call PMPageSetupDialog between the pages of a document.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
PMApplication.h*/

OSStatus PMPageSetupDialog (
   PMPageFormat pageFormat,
   Boolean *accepted
);

/*PMPrintDialog

Displays the Print dialog and records the user’s selections in a PMPrintSettings object. (Deprecated in Mac OS X v10.4. Use PMSessionPrintDialog instead.)

OSStatus PMPrintDialog (
   PMPrintSettings printSettings,
   PMPageFormat constPageFormat,
   Boolean *accepted
);
Parameters
printSettings

A PMPrintSettings object. 
constPageFormat

A PMPageFormat object. 
accepted

Returns true if the user clicks the OK button, or false if the user clicks Cancel. 
Return Value

A result code. See “Carbon Printing Manager Result Codes”.
Discussion

Valid after calling PMBegin and creating a page format and print settings object.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
PMApplication.h*/

OSStatus PMPrintDialog (
   PMPrintSettings printSettings,
   PMPageFormat constPageFormat,
   Boolean *accepted
);


/*PMEndPage

Finishes printing the current page. (Deprecated in Mac OS X v10.4. Use PMSessionEndPage instead.)

OSStatus PMEndPage (
   PMPrintContext printContext
);
Parameters
printContext

A PMPrintContext object. 
Return Value

A result code. See “Carbon Printing Manager Result Codes”.
Discussion

Valid after calling PMBegin, PMBeginDocument, and PMBeginPage.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
PMApplication.h*/

OSStatus PMEndPage (
   PMPrintContext printContext
);

/*PMEndDocument

Closes the context created for imaging a document. (Deprecated in Mac OS X v10.4. Use PMSessionEndDocument instead.)

OSStatus PMEndDocument (
   PMPrintContext printContext
);
Parameters
printContext

On return, an invalidated PMPrintContext object. 
Return Value

A result code. See “Carbon Printing Manager Result Codes”.
Discussion

Valid after calling PMBegin and PMBeginDocument. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
PMApplication.h*/;
OSStatus PMEndDocument (
   PMPrintContext printContext
);


/*PMSessionBeginCGDocument

Begins a print job that draws into a Quartz graphics context.

OSStatus PMSessionBeginCGDocument (
   PMPrintSession printSession,
   PMPrintSettings printSettings,
   PMPageFormat pageFormat
);
Parameters
printSession

The printing session that provides a context for the new print job.
printSettings

The print settings to use for the new print job.
pageFormat

The page format to use for the new print job.
Return Value

A result code. See “Carbon Printing Manager Result Codes”.
Discussion

This function starts a print job that draws directly into a Quartz graphics context and should be called within your application’s print loop. This function is similar to the function PMSessionBeginCGDocumentNoDialog except that the printing status dialog is displayed.

You must call this function between the creation and release of a printing session. See the function PMCreateSession. If you present a printing dialog before you call this function, when calling this function you should use the same PMPrintSession object you used to present the dialog.

Before you call PMSessionBeginCGDocument, you should call PMSessionValidatePrintSettings and PMSessionValidatePageFormat to make sure the specified print settings and page format objects are updated and valid. After you call PMSessionBeginCGDocument, if you call a function that changes the specified print settings or page format object, the change is ignored for the current print job.

During the print job, the caller cannot obtain a Quickdraw graphics port for the printing session but can only obtain a Quartz graphics context. As a result, this function should be used in conjunction with PMSessionGetCGGraphicsContext instead of PMSessionGetGraphicsContext.

This function must be called before its corresponding End function (PMSessionEndDocument). If the function PMSessionBeginCGDocument returns noErr, you must later call the End function, even if errors occur within the scope of the Begin and End functions.

The printing system automatically handles printing multiple copies. Your application does not need to perform any tasks other than specifying the number of copies in the printing session.
Availability
Available in Mac OS X v10.4 and later.
Declared In
PMApplication.h*/
OSStatus PMSessionBeginCGDocument (
   PMPrintSession printSession,
   PMPrintSettings printSettings,
   PMPageFormat pageFormat
);

/*PMSessionBeginCGDocumentNoDialog

Begins a print job that draws into a Quartz graphics context and suppresses the printing status dialog.

OSStatus PMSessionBeginCGDocumentNoDialog (
   PMPrintSession printSession,
   PMPrintSettings printSettings,
   PMPageFormat pageFormat
);
Parameters
printSession

The printing session that provides a context for the new print job.
printSettings

The print settings to use for the new print job.
pageFormat

The page format to use for the new print job.
Return Value

A result code. See “Carbon Printing Manager Result Codes”.
Discussion

This function starts a print job that draws directly into a Quartz graphics context and should be called within your application’s print loop. This function is similar to the function PMSessionBeginCGDocument except that the printing status dialog is suppressed.

You must call PMSessionBeginCGDocumentNoDialog between the creation and release of a printing session. See the function PMCreateSession. If you present a printing dialog before you call PMSessionBeginCGDocumentNoDialog, when calling this function you should use the same PMPrintSession object you used to present the dialog.

Before you call PMSessionBeginCGDocumentNoDialog, you should call PMSessionValidatePrintSettings and PMSessionValidatePageFormat to make sure the specified print settings and page format objects are updated and valid. After you call PMSessionBeginCGDocumentNoDialog, if you call a function that changes the specified print settings or page format object, the change is ignored for the current print job.

During the print job, the caller cannot obtain a Quickdraw graphics port for the printing session but can only obtain a Quartz graphics context. As a result, this function should be used in conjunction with PMSessionGetCGGraphicsContext instead of PMSessionGetGraphicsContext.

This function must be called before its corresponding End function (PMSessionEndDocumentNoDialog). If the function PMSessionBeginCGDocumentNoDialog returns noErr, you must later call the End function, even if errors occur within the scope of the Begin and End functions.

The printing system automatically handles printing multiple copies. Your application does not need to perform any tasks other than specifying the number of copies in the printing session.
Availability
Available in Mac OS X v10.4 and later.
Declared In
PMApplication.h*/
OSStatus PMSessionBeginCGDocumentNoDialog (
   PMPrintSession printSession,
   PMPrintSettings printSettings,
   PMPageFormat pageFormat
);

#ifdef __cplusplus
}
#endif

#endif