
@class PDFDestination, PDFOutline, PDFPage, PDFSelection, PDFDocumentPrivateVars;

/*PDFDocumentDidBeginFindNotification

Posted when the beginFindString:withOptions: or findString:withOptions: method begins finding.

The notification object is the PDFDocument object itself.
Availability
Available in Mac OS X v10.4 and later.*/
extern NSString *PDFDocumentDidBeginFindNotification;

/*PDFDocumentDidEndFindNotification

Posted when the beginFindString:withOptions: or findString:withOptions: method returns.

The beginFindString:withOptions: method returns immediately, so this notification is posted when the “find” operation is finished.

You can use this notification to know when to close or hide a progress bar.

The notification object is the PDFDocument object itself.

Availability
Available in Mac OS X v10.4 and later.*/
extern NSString *PDFDocumentDidEndFindNotification;

@interface PDFDocument : NSObject

/*pageAtIndex:

Gets the page at the specified index number.

- (PDFPage *)pageAtIndex:(unsigned int)index
Discussion

Indexes are zero based. Raises an exception if index is out of bounds.
Availability
Available in Mac OS X v10.4 and later.
See Also
– pageCount
– indexForPage:
– insertPage:atIndex:
– removePageAtIndex:
– exchangePageAtIndex:withPageAtIndex:*/
- (PDFPage *)pageAtIndex:(unsigned int)index;

/*pageCount

Gets the number of pages in the document.

- (unsigned int)pageCount
Availability
Available in Mac OS X v10.4 and later.
See Also
– pageAtIndex:
– indexForPage:
– insertPage:atIndex:
– removePageAtIndex:
– exchangePageAtIndex:withPageAtIndex:*/
- (unsigned int)pageCount;

/*findString:fromSelection:withOptions:

Synchronously finds the next occurance of a string after the specified selection (or before the selection if you specified NSBackwardsSearch as a search option. 

- (PDFSelection *)findString:(NSString *)string fromSelection:PDFSelection *selectionwithOptions:(int)options
Discussion

Matches are returned as a PDFSelection object. If the search reaches the end (or beginning) of the document without any hits, this method returns NULL.

If you pass NULL for the selection, this method begins searching from the beginning of the document (or the end, if you specified NSBackwardsSearch).

You can use this method to implement “Find Again” behavior . For options, refer to Searching and Comparing Strings.
Availability
Available in Mac OS X v10.4 and later.
See Also
– isFinding
– findString:withOptions:*/

- (PDFSelection *) findString: (NSString *) string fromSelection: (PDFSelection *) selection 
		withOptions: (int) options;

/*outlineRoot

Gets the root PDFOutline object for the PDF document.

- (PDFOutline *)outlineRoot
Discussion

Returns NULL if there is no root outline object. The root outline is the nonvisible top-level container for outline items. 
Availability
Available in Mac OS X v10.4 and later.
See Also
– outlineItemForSelection:*/
- (PDFOutline *)outlineRoot;

/*isLocked

Returns a logical value indicating whether the PDF document is locked.

- (BOOL)isLocked
Discussion

Only encrypted documents can be locked. Encrypted documents whose password is the empty string are unlocked automatically upon opening, because PDF Kit tries the empty string as a password if none is supplied. Use the setPassword: method to unlock a document using a password.
Availability
Available in Mac OS X v10.4 and later.
See Also
– isEncrypted
– setPassword:
– allowsPrinting
– allowsCopying*/
- (BOOL)isLocked;

/*setDelegate:

Establishes anObject as the delegate for the PDFDocument object.

- (void)setDelegate:(id)anObject
Availability
Available in Mac OS X v10.4 and later.
See Also
– delegate
– didMatchString:*/
- (void)setDelegate:(id)anObject;

/*outlineItemForSelection:

Gets the most likely parent PDFOutline object for selection.

- (PDFOutline *)outlineItemForSelection:(PDFSelection *)selection
Discussion

A selection can span multiple outline items. This method considers only the point representing the first character of the selection.

Typically, outlines represent structural items such as chapters. You can use this method to identify the chapter that a selection falls within.
Availability
Available in Mac OS X v10.4 and later.
See Also
– outlineRoot*/
- (PDFOutline *)outlineItemForSelection:(PDFSelection *)selection;

/*indexForPage:

Gets the index number for the specified page.

- (unsigned int)indexForPage:(PDFPage *)page
Discussion

Indexes are zero-based. Raises an exception and returns NSNotFound if page is not found.
Availability
Available in Mac OS X v10.4 and later.
See Also
– pageCount
– pageAtIndex:
– insertPage:atIndex:
– removePageAtIndex:
– exchangePageAtIndex:withPageAtIndex:*/
- (unsigned int)indexForPage:(PDFPage *)page;

/*writeToURL:

Writes the document to a location specified as url.

- (BOOL)writeToURL:(NSURL *)url
Availability
Available in Mac OS X v10.4 and later.
See Also
– dataRepresentation
– writeToFile:
– writeToFile:withOptions:
– writeToURL:withOptions:*/
- (BOOL)writeToURL:(NSURL *)url;

/*documentURL

Returns the URL for the document.

- (NSURL *) documentURL
Discussion

This method may return NULL if the document was created from NSData.
Availability
Available in Mac OS X v10.4 and later.*/

- (NSURL *) documentURL;

/*isFinding

Returns a logical value indicating whether an asynchronous Find operation is in progress.

- (BOOL)isFinding
Availability
Available in Mac OS X v10.4 and later.
See Also
– beginFindString:withOptions:
– cancelFindString*/
- (BOOL)isFinding;

/*cancelFindString

Cancels a search initiated with beginFindString:withOptions:.

- (void)cancelFindString
Availability
Available in Mac OS X v10.4 and later.
See Also
– findString:withOptions:
– beginFindString:withOptions:
– isFinding*/

- (void)cancelFindString;

/*beginFindString:withOptions:

Asynchronously finds all instances of the specified string in the document.

- (void)beginFindString:(NSString *)string withOptions:(int)options
Discussion

This method returns immediately. It causes notifications to be issued when searching begins and ends, on each search hit, and when the search proceeds to a new page. For options, refer to Searching and Comparing Strings.
Availability
Available in Mac OS X v10.4 and later.
See Also
– findString:withOptions:
– isFinding
– cancelFindString*/
- (void)beginFindString:(NSString *)string withOptions:(int)options;

@end



@interface NSObject(PDFDocumentNotifications)
@end

@interface NSObject(PDFDocumentDelegate)
@end
