#ifndef  MDITEM_H
#define  MDITEM_H

#include <CoreFoundation/CFString.h>
#include <CoreFoundation/CFDictionary.h>
#include <CoreFoundation/CFArray.h>

/*MDItemRef

A reference to a MDItem object.

typedef struct __MDItem *MDItemRef;
Availability
Available in Mac OS X v10.4 and later.
Declared In
MDItem.h*/
typedef struct __MDItem *MDItemRef;

/*Image Metadata Attribute Keys

Metadata attribute keys that are common to image files.

const CFStringRef kMDItemPixelHeight;
const CFStringRef kMDItemPixelWidth;
const CFStringRef kMDItemColorSpace;
const CFStringRef kMDItemBitsPerSample;
const CFStringRef kMDItemFlashOnOff;
const CFStringRef kMDItemFocalLength;
const CFStringRef kMDItemAcquisitionMake;
const CFStringRef kMDItemAcquisitionModel;
const CFStringRef kMDItemISOSpeed;
const CFStringRef kMDItemOrientation;
const CFStringRef kMDItemLayerNames;
const CFStringRef kMDItemWhiteBalance;
const CFStringRef kMDItemAperture;
const CFStringRef kMDItemProfileName;
const CFStringRef kMDItemResolutionWidthDPI;
const CFStringRef kMDItemResolutionHeightDPI;
const CFStringRef kMDItemExposureMode;
const CFStringRef kMDItemExposureTimeSeconds;
const CFStringRef kMDItemEXIFVersion;
const CFStringRef kMDItemAlbum;
const CFStringRef kMDItemHasAlphaChannel;
const CFStringRef kMDItemRedEyeOnOff;
const CFStringRef kMDItemMeteringMode;
const CFStringRef kMDItemMaxAperture;
const CFStringRef kMDItemFNumber;
const CFStringRef kMDItemExposureProgram;
const CFStringRef kMDItemExposureTimeString;
Constants
kMDItemPixelHeight

The height, in pixels, of the contents. For example, the image height or the video frame height. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemPixelWidth

The width, in pixels, of the contents. For example, the image width or the video frame width. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemColorSpace

The color space model used by the document contents. For example, “RGB”, “CMYK”, “YUV”, or “YCbCr”. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemBitsPerSample

The number of bits per sample. For example, the bit depth of an image (8-bit, 16-bit etc...) or the bit depth per audio sample of uncompressed audio data (8, 16, 24, 32, 64, etc..). A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemFlashOnOff

Indicates if a camera flash was used. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemFocalLength

The actual focal length of the lens, in millimeters. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemAcquisitionMake

The manufacturer of the device used to aquire the document contents. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemAcquisitionModel

The model of the device used to aquire the document contents. For example, 100, 200, 400, etc. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemISOSpeed

The ISO speed used to aquire the document contents. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemOrientation

The orientation of the document contents. Possible values are 0 (landscape) and 1 (portrait). A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemLayerNames

The names of the layers in the file. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemWhiteBalance

The white balance setting used to aquire the document contents. Possible values are 0 (auto white balance) and 1 (manual). A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemAperture

The aperature setting used to aqure the document contents. This unit is the APEX value. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemProfileName

The name of the color profile used by the document contents. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemResolutionWidthDPI

Resolution width, in DPI, of this image. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemResolutionHeightDPI

Resolution height, in DPI, of this image. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemExposureMode

The exposure mode used to aquire the document contents. Possible values are 0 (auto exposure), 1 (manual exposure) and 2 (auto bracket). A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemExposureTimeSeconds

The exposure time, in seconds, used to aquire the document contents. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemEXIFVersion

The version of the EXIF header used to generate the metadata. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemAlbum

The title for a collection of media. This is analagous to a record album, or photo album. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemHasAlphaChannel

Indicates if this image file has an alpha channel. A CFBoolean.

Available in Mac OS X v10.4 and later.
kMDItemRedEyeOnOff

Indicates if red-eye reduction was used to take the picture. Possible values are 0 (no red-eye reduction mode or unknown) and 1 (red-eye reduction used). A CFBoolean.

Available in Mac OS X v10.4 and later.
kMDItemMeteringMode

The metering mode used to take the image. Possible values are: Unknown, Average, CenterWeightedAverage, Spot, MultiSpot, Pattern, and Partial. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemMaxAperture

The smallest f-number of the lens. The unit is the APEX?? value. Ordinarily it is given in the range of 00.00 to 99.99. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemFNumber

The diameter of the diaphragm aperture in terms of the effective focal length of the lens.

Available in Mac OS X v10.4 and later.
kMDItemExposureProgram

The class of the exposure program used by the camera to set exposure when the image is taken. Possible values include: Manual, Normal, and Aperture priority.

Available in Mac OS X v10.4 and later.
kMDItemExposureTimeString

The time of the exposure. A CFString.

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
MDItem.h*/
extern const CFStringRef kMDItemPixelHeight;
extern const CFStringRef kMDItemPixelWidth;
extern const  CFStringRef kMDItemColorSpace;
extern const CFStringRef kMDItemBitsPerSample;
extern const CFStringRef kMDItemFlashOnOff;
extern const CFStringRef kMDItemFocalLength;
extern const CFStringRef kMDItemAcquisitionMake;
extern const CFStringRef kMDItemAcquisitionModel;
extern const CFStringRef kMDItemISOSpeed;
extern const CFStringRef kMDItemOrientation;
extern const CFStringRef kMDItemLayerNames;
extern const CFStringRef kMDItemWhiteBalance;
extern const CFStringRef kMDItemAperture;
extern const CFStringRef kMDItemProfileName;
extern const CFStringRef kMDItemResolutionWidthDPI;
extern const CFStringRef kMDItemResolutionHeightDPI;
extern const CFStringRef kMDItemExposureMode;
extern const CFStringRef kMDItemExposureTimeSeconds;
extern const CFStringRef kMDItemEXIFVersion;
extern const CFStringRef kMDItemAlbum;
extern const CFStringRef kMDItemHasAlphaChannel;
extern const  CFStringRef kMDItemRedEyeOnOff;
extern const CFStringRef kMDItemMeteringMode;
extern const CFStringRef kMDItemMaxAperture;
extern const CFStringRef kMDItemFNumber;
extern const CFStringRef kMDItemExposureProgram;
extern const CFStringRef kMDItemExposureTimeString;


/*File System Metadata Attribute Keys

Metadata attribute keys that describe the file system attributes for a file.

const CFStringRef kMDItemDisplayName;
const CFStringRef kMDItemFSContentChangeDate;
const CFStringRef kMDItemFSCreationDate;
const CFStringRef kMDItemFSExists;
const CFStringRef kMDItemFSInvisible;
const CFStringRef kMDItemFSIsExtensionHidden;
const CFStringRef kMDItemFSIsReadable;
const CFStringRef kMDItemFSIsWriteable;
const CFStringRef kMDItemFSLabel;
const CFStringRef kMDItemFSName;
const CFStringRef kMDItemFSNodeCount;
const CFStringRef kMDItemFSOwnerGroupID;
const CFStringRef kMDItemFSOwnerUserID;
const CFStringRef kMDItemFSSize;
const CFStringRef kMDItemPath;
Constants
kMDItemDisplayName

The localized version of the file name. This is the localized version of the LaunchServices call LSCopyDisplayNameForURL()/LSCopyDisplayNameForRef(). A CFString.

Available in Mac OS X v10.4 and later.
kMDItemFSContentChangeDate

The date the file contents last changed. A CFDate.

Available in Mac OS X v10.4 and later.
kMDItemFSCreationDate

The date and time that the file was created. A CFDate.

Available in Mac OS X v10.4 and later.
kMDItemFSExists

This attribute is deprecated and was never implemented.

Deprecated in Mac OS X v10.4.
kMDItemFSInvisible

Indicates whether the file is invisible. A CFBoolean.

Available in Mac OS X v10.4 and later.
kMDItemFSIsExtensionHidden

Indicates whether the file extension of the file is hidden. A CFBoolean.

Available in Mac OS X v10.4 and later.
kMDItemFSIsReadable

This attribute is deprecated and was never implemented.

Deprecated in Mac OS X v10.4.
kMDItemFSIsWriteable

This attribute is deprecated and was never implemented.

Deprecated in Mac OS X v10.4.
kMDItemFSLabel

Index of the Finder label of the file. Possible values are 0 through 7. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemFSName

The file name of the item. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemFSNodeCount

Number of files in a directory. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemFSOwnerGroupID

The group ID of the owner of the file. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemFSOwnerUserID

The user ID of the owner of the file. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemFSSize

The size, in bytes, of the file on disk. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemPath

The complete path to the file. A CFString.

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
MDItem.h*/
extern const CFStringRef kMDItemDisplayName;
extern const CFStringRef kMDItemFSContentChangeDate;
extern const CFStringRef kMDItemFSCreationDate;
extern const CFStringRef kMDItemFSExists;
extern const CFStringRef kMDItemFSInvisible;
extern const CFStringRef kMDItemFSIsExtensionHidden;
extern const CFStringRef kMDItemFSIsReadable;
extern const CFStringRef kMDItemFSIsWriteable;
extern const CFStringRef kMDItemFSLabel;
extern const CFStringRef kMDItemFSName;
extern const CFStringRef kMDItemFSNodeCount;
extern const CFStringRef kMDItemFSOwnerGroupID;
extern const CFStringRef kMDItemFSOwnerUserID;
extern const CFStringRef kMDItemFSSize;
extern const CFStringRef kMDItemPath;


/*Common Metadata Attribute Keys

Metadata attribute keys that are common to many file types.

const CFStringRef kMDItemAttributeChangeDate;
const CFStringRef kMDItemAudiences;
const CFStringRef kMDItemAuthors;
const CFStringRef kMDItemCity;
const CFStringRef kMDItemComment;
const CFStringRef kMDItemContactKeywords;
const CFStringRef kMDItemContentCreationDate;
const CFStringRef kMDItemContentModificationDate;
const CFStringRef kMDItemContentType;
const CFStringRef kMDItemContributors;
const CFStringRef kMDItemCopyright;
const CFStringRef kMDItemCountry;
const CFStringRef kMDItemCoverage;
const CFStringRef kMDItemCreator;
const CFStringRef kMDItemDescription;
const CFStringRef kMDItemDueDate;
const CFStringRef kMDItemDurationSeconds;
const CFStringRef kMDItemEmailAddresses;
const CFStringRef kMDItemEncodingApplications;
const CFStringRef kMDItemFinderComment;
const CFStringRef kMDItemFonts;
const CFStringRef kMDItemHeadline;
const CFStringRef kMDItemIdentifier;
const CFStringRef kMDItemInstantMessageAddresses;
const CFStringRef kMDItemInstructions;
const CFStringRef kMDItemKeywords;
const CFStringRef kMDItemKind;
const CFStringRef kMDItemLanguages;
const CFStringRef kMDItemLastUsedDate;
const CFStringRef kMDItemNumberOfPages;
const CFStringRef kMDItemOrganizations;
const CFStringRef kMDItemPageHeight;
const CFStringRef kMDItemPageWidth;
const CFStringRef kMDItemPhoneNumbers;
const CFStringRef kMDItemProjects;
const CFStringRef kMDItemPublishers;
const CFStringRef kMDItemRecipients;
const CFStringRef kMDItemRights;
const CFStringRef kMDItemSecurityMethod;
const CFStringRef kMDItemStarRating;
const CFStringRef kMDItemStateOrProvince;
const CFStringRef kMDItemTextContent;
const CFStringRef kMDItemTitle;
const CFStringRef kMDItemVersion;
const CFStringRef kMDItemWhereFroms;
Constants
kMDItemAttributeChangeDate

The date and time of the last change made to a metadata attribute. A CFDate.

Available in Mac OS X v10.4 and later.
kMDItemAudiences

The audience for which the file is intended. The audience may be determined by the creator or the publisher or by a third party. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemAuthors

The author, or authors, of the contents of the file. The order of the authors is preserved, but does not represent the main author or relative importance of the authors. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemCity

Identifies city of origin according to guidelines established by the provider. For example, "New York", "Cupertino", or "Toronto". A CFString.

Available in Mac OS X v10.4 and later.
kMDItemComment

A comment related to the file. This differs from the Finder comment, kMDItemFinderComment. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemContactKeywords

A list of contacts that are associated with this document, not including the authors. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemContentCreationDate

The date that the contents of the file were created. This is different than the file creation date. Its can be used to store when the file contents were first created, or first modified. A CFDate.

Available in Mac OS X v10.4 and later.
kMDItemContentModificationDate

The date and time that the contents of the file were last modified. This is not necessarily the file modification date. A CFDate.

Available in Mac OS X v10.4 and later.
kMDItemContentType

The UTI pedigree of a file. For example, a jpeg image file will have a value of public.jpeg/public.image/public.data. The value of this attribute is set by the MDImporter. Changes to this value are lost when the file attributes are next imported. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemContributors

The entities responsible for making contributions to the content of the resource. Examples of a contributor include a person, an organization or a service. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemCopyright

The copyright owner of the file contents. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemCountry

The full, publishable name of the country or primary location where the intellectual property of the item was created, according to guidelines of the provider. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemCoverage

The extent or scope of the content of the resource. Coverage will typically include spatial location (a place name or geographic co-ordinates), temporal period (a period label, date, or date range) or jurisdiction (such as a named administrative entity). Recommended best practice is to select a value from a controlled vocabulary, and that, where appropriate, named places or time periods be used in preference to numeric identifiers such as sets of co-ordinates or date ranges. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemCreator

Application used to create the document content (e.g. "Word", "AppleWorks", etc.). A CFString.

Available in Mac OS X v10.4 and later.
kMDItemDescription

A description of the content of the resource. The description may include an abstract, table of contents, reference to a graphical representation of content or a free-text account of the content. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemDueDate

Date this item is due. A CFDate.

Available in Mac OS X v10.4 and later.
kMDItemDurationSeconds

The duration, in seconds, of the content of file. A value of 10.5 represents media that is 10 and 1/2 seconds long. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemEmailAddresses

Email addresses related to this item. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemEncodingApplications

Application used to convert the original content into it's current form. For example, a PDF file might have an encoding application set to "Distiller". A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemFinderComment

Finder comments for this file. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemFonts

Fonts used in this item. You should store the font's full name, the postscript name, or the font family name, based on the available information. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemHeadline

A publishable entry providing a synopsis of the contents of the file. For example, "Apple Introduces the iPod Photo". A CFString.

Available in Mac OS X v10.4 and later.
kMDItemIdentifier

A formal identifier used to reference the resource within a given context. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemInstantMessageAddresses

Instant message addresses related to this item. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemInstructions

Editorial instructions concerning the use of the item, such as embargoes and warnings. For example, "Second of four stories". A CFString.

Available in Mac OS X v10.4 and later.
kMDItemKeywords

Keywords associated with this file. For example, “Birthday”, “Important”, etc. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemKind

A description of the kind of item this file represents. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemLanguages

Indicates the languages of the intellectual content of the resource. Recommended best practice for the values of the Language element is defined by RFC 3066. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemLastUsedDate

The date and time that the file was last used. This value is updated automatically by LaunchServices everytime a file is opened by double clicking, or by asking LaunchServices to open a file. A CFDate.

Available in Mac OS X v10.4 and later.
kMDItemNumberOfPages

Number of pages in the document. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemOrganizations

The company or organization that created the document. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemPageHeight

Height of the document page, in points (72 points per inch). For PDF files this indicates the height of the first page only. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemPageWidth

Width of the document page, in points (72 points per inch). For PDF files this indicates the width of the first page only. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemPhoneNumbers

Phone numbers related to this item. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemProjects

The list of projects that this file is part of. For example, if you were working on a movie all of the files could be marked as belonging to the project “My Movie”. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemPublishers

The entity responsible for making the resource available. For example, a person, an organization, or a service. Typically, the name of a publisher should be used to indicate the entity. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemRecipients

Recipients of this item. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemRights

Provides a link to information about rights held in and over the resource. Contains a rights management statement for the resource, or reference a service providing such information. Rights information often encompasses Intellectual Property Rights (IPR), Copyright, and various Property Rights. If this attribute is absent, no assumptions can be made about the status of these and other rights with respect to the resource. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemSecurityMethod

The security or encryption method used for the file. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemStarRating

User rating of this item. For example, the stars rating of an iTunes track. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemStateOrProvince

Identifies the province or state of origin according to guidelines established by the provider. For example, "CA", "Ontario", or "Sussex". A CFString.

Available in Mac OS X v10.4 and later.
kMDItemTextContent

Contains a text representation of the content of the document. Data in multiple fields should be combined using a whitespace character as a separator. An application's Spotlight importer provides the content of this attribute. Applications can search for values in this attribute, but are not able to read the content of this attribute directly. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemTitle

The title of the file. For example, this could be the title of a document, the name of an song, or the subject of an email message. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemVersion

The version number of this file. A CFString

Available in Mac OS X v10.4 and later.
kMDItemWhereFroms

Describes where the file was obtained from. For example, a downloaded file may refer to the URL, files received by email may indicate the sender’s email address, message subject, etc. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
MDItem.h*/
extern const CFStringRef kMDItemAttributeChangeDate;
extern const CFStringRef kMDItemAudiences;
extern const CFStringRef kMDItemAuthors;
extern const CFStringRef kMDItemCity;
extern const CFStringRef kMDItemComment;
extern const CFStringRef kMDItemContactKeywords;
extern const CFStringRef kMDItemContentCreationDate;
extern const CFStringRef kMDItemContentModificationDate;
extern const CFStringRef kMDItemContentType;
extern const CFStringRef kMDItemContributors;
extern const CFStringRef kMDItemCopyright;
extern const CFStringRef kMDItemCountry;
extern const CFStringRef kMDItemCoverage;
extern const CFStringRef kMDItemCreator;
extern const CFStringRef kMDItemDescription;
extern const CFStringRef kMDItemDueDate;
extern const CFStringRef kMDItemDurationSeconds;
extern const CFStringRef kMDItemEmailAddresses;
extern const CFStringRef kMDItemEncodingApplications;
extern const CFStringRef kMDItemFinderComment;
extern const CFStringRef kMDItemFonts;
extern const CFStringRef kMDItemHeadline;
extern const CFStringRef kMDItemIdentifier;
extern const CFStringRef kMDItemInstantMessageAddresses;
extern const CFStringRef kMDItemInstructions;
extern const CFStringRef kMDItemKeywords;
extern const CFStringRef kMDItemKind;
extern const CFStringRef kMDItemLanguages;
extern const CFStringRef kMDItemLastUsedDate;
extern const CFStringRef kMDItemNumberOfPages;
extern const CFStringRef kMDItemOrganizations;
extern const CFStringRef kMDItemPageHeight;
extern const CFStringRef kMDItemPageWidth;
extern const CFStringRef kMDItemPhoneNumbers;
extern const CFStringRef kMDItemProjects;
extern const CFStringRef kMDItemPublishers;
extern const CFStringRef kMDItemRecipients;
extern const CFStringRef kMDItemRights;
extern const CFStringRef kMDItemSecurityMethod;
extern const CFStringRef kMDItemStarRating;
extern const CFStringRef kMDItemStateOrProvince;
extern const CFStringRef kMDItemTextContent;
extern const CFStringRef kMDItemTitle;
extern const CFStringRef kMDItemVersion;
extern const CFStringRef kMDItemWhereFroms;

//func

/*MDItemCreate

Creates an MDItem object for a file at the specified path.

MDItemRef MDItemCreate (
CFAllocatorRef allocator,
CFStringRef path
);
Parameters
allocator

The CFAllocator object to be used to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
path

A path to the file from which to create the MDItem. The path must exist.
Return Value

An MDItem object or NULL if there was a problem creating the object. 
Discussion

Returns a metadata item for the given path. MDItemRefs are uniqued and can be compared using == or CFEqual.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
MDItem.h*/
MDItemRef MDItemCreate (
CFAllocatorRef allocator,
CFStringRef path
);

/*MDItemCopyAttributeNames

Returns an array containing the attribute names existing in the metadata item.

CFArrayRef MDItemCopyAttributeNames (
MDItemRef item
);
Parameters
item

The item to be queried.
Return Value

A CFArray of CFString attribute names, or NULL on failure.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
MDItem.h*/
CFArrayRef MDItemCopyAttributeNames (
MDItemRef item
);

/*MDItemCopyAttributes

Returns the values of the specified attributes in the metadata item.

CFDictionaryRef MDItemCopyAttributes (
MDItemRef item,
CFArrayRef names
);
Parameters
item

The item to be queried.
names

A CFArray containing the names of the requested attributes.
Return Value

A CFDictionary containing keys for the requested attribute names, and the corresponding values. If an attribute does not exist, or the attribute is unreadable, there will be no key-value pair for it in the dictionary. Returns NULL on failure.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
MDItem.h*/
CFDictionaryRef MDItemCopyAttributes (
MDItemRef item,
CFArrayRef names
);

/*MDItemCopyAttribute

Returns the value of the specified attribute in the metadata item.

CFTypeRef MDItemCopyAttribute (
MDItemRef item,
CFStringRef name
)
Parameters
item

The item to be queried.
name

The name of the requested attribute.
Return Value

A CFTypeRef, or NULL if there was a failure reading the attribute or the attribute does not exist.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
MDItem.h*/
CFTypeRef MDItemCopyAttribute (
MDItemRef item,
CFStringRef name
);


#endif 

