#ifndef _IOMEMORYDESCRIPTOR_H
#define _IOMEMORYDESCRIPTOR_H

#include <sys/cdefs.h>

#include <IOKit/IOTypes.h>
#include <libkern/c++/OSContainers.h>
#include <mach/memory_object_types.h>

class IOMemoryDescriptor : public OSObject
{

public:

/*writeBytes


Copies data to the memory descriptor's buffer from the specified buffer. 
public

virtual IOByteCount writeBytes(
    IOByteCount offset, 
    const void *bytes,
    IOByteCount withLength); 
Parameters
offset
A byte offset into the memory descriptor's memory.
bytes
The caller supplied buffer to copy the data from.
withLength
The length of the data to copy.
Return Value

The number of bytes copied, zero will be returned if the specified offset is beyond the length of the descriptor. 
Discussion 

This method copies data to the memory descriptor's memory at the given offset, from the caller's buffer.*/
virtual IOByteCount writeBytes(
    IOByteCount offset, 
    const void *bytes,
    IOByteCount withLeng);

/*getLength


Accessor to get the length of the memory descriptor (over all its ranges). 
public

virtual IOByteCount getLength() const; 
Return Value

The byte count. 
Discussion 

This method returns the total length of the memory described by the descriptor, ie. the sum of its ranges' lengths.*/
virtual IOByteCount getLength() const; 

};

class IOGeneralMemoryDescriptor : public IOMemoryDescriptor{
};


#endif