#ifndef CGCOLOR_H
#define CGCOLOR_H

#include <CoreGraphics/CGBase.h>
#include <CoreGraphics/CGColorSpace.h>
#include <CoreGraphics/CGPattern.h>

/*CGColorRef

An opaque type that represents a color used in Quartz 2D drawing.

typedef struct CGColor *CGColorRef;
Discussion

CGColor is the fundamental data type used internally by Quartz to represent colors. CGColor objects. and the functions that operate on them, provide a fast and convenient way of managing and setting colors directly, especially colors that are reused (such as black for text).

In Mac OS X version 10.3 and later, CGColorRef is derived from CFTypeRef and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X v10.3 and later.*/
typedef struct CGColor *CGColorRef;

/*CGColorCreate

Creates a Quartz color using a list of intensity values (including alpha) and an associated color space.

CGColorRef CGColorCreate (
   CGColorSpaceRef colorspace,
   const float components[]
);
Parameters
colorspace

A color space for the new color. Quartz retains this object; upon return, you may safely release it.
components

An array of intensity values describing the color. The array should contain n+1 values that correspond to the n color components in the specified color space, followed by the alpha component. Each component value should be in the range appropriate for the color space. Values outside this range will be clamped to the nearest correct value.
Return Value

A new Quartz color. You are responsible for releasing this object using CGColorRelease.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CGColor.h*/
CGColorRef CGColorCreate (
   CGColorSpaceRef colorspace,
   const float components[]
);


#endif